/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.ClusterSpecifierPlugin;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.RouteLookupServiceClusterSpecifierPlugin;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class ClusterSpecifierPluginRegistry {
    private static ClusterSpecifierPluginRegistry instance;
    private final Map<String, ClusterSpecifierPlugin> supportedPlugins = new HashMap<String, ClusterSpecifierPlugin>();

    private ClusterSpecifierPluginRegistry() {
    }

    static synchronized ClusterSpecifierPluginRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = ClusterSpecifierPluginRegistry.newRegistry().register(RouteLookupServiceClusterSpecifierPlugin.INSTANCE);
        }
        return instance;
    }

    private static ClusterSpecifierPluginRegistry newRegistry() {
        return new ClusterSpecifierPluginRegistry();
    }

    private ClusterSpecifierPluginRegistry register(ClusterSpecifierPlugin ... plugins) {
        for (ClusterSpecifierPlugin plugin : plugins) {
            for (String typeUrl : plugin.typeUrls()) {
                this.supportedPlugins.put(typeUrl, plugin);
            }
        }
        return this;
    }

    @Nullable
    ClusterSpecifierPlugin get(String typeUrl) {
        return this.supportedPlugins.get(typeUrl);
    }
}

