/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ExponentialBackoffPolicy;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.SharedResourceHolder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.TimeProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Bootstrapper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.BootstrapperImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsClient;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsClientImpl;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsInitializationException;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsNameResolverProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.security.TlsContextManagerImpl;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedXdsClientPoolProvider
implements XdsNameResolverProvider.XdsClientPoolFactory {
    private final Bootstrapper bootstrapper;
    private final Object lock = new Object();
    private final AtomicReference<Map<String, ?>> bootstrapOverride = new AtomicReference();
    private volatile ObjectPool<XdsClient> xdsClientPool;

    SharedXdsClientPoolProvider() {
        this(new BootstrapperImpl());
    }

    @VisibleForTesting
    SharedXdsClientPoolProvider(Bootstrapper bootstrapper) {
        this.bootstrapper = Preconditions.checkNotNull(bootstrapper, "bootstrapper");
    }

    static SharedXdsClientPoolProvider getDefaultProvider() {
        return SharedXdsClientPoolProviderHolder.instance;
    }

    @Override
    public void setBootstrapOverride(Map<String, ?> bootstrap) {
        this.bootstrapOverride.set(bootstrap);
    }

    @Override
    @Nullable
    public ObjectPool<XdsClient> get() {
        return this.xdsClientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectPool<XdsClient> getOrCreate() throws XdsInitializationException {
        RefCountedXdsClientObjectPool ref = this.xdsClientPool;
        if (ref == null) {
            Object object = this.lock;
            synchronized (object) {
                ref = this.xdsClientPool;
                if (ref == null) {
                    Map<String, ?> rawBootstrap = this.bootstrapOverride.get();
                    Bootstrapper.BootstrapInfo bootstrapInfo = rawBootstrap != null ? this.bootstrapper.bootstrap(rawBootstrap) : this.bootstrapper.bootstrap();
                    if (bootstrapInfo.servers().isEmpty()) {
                        throw new XdsInitializationException("No xDS server provided");
                    }
                    ref = this.xdsClientPool = new RefCountedXdsClientObjectPool(bootstrapInfo);
                }
            }
        }
        return ref;
    }

    @ThreadSafe
    @VisibleForTesting
    static class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private final Context context = Context.ROOT;
        private final Bootstrapper.BootstrapInfo bootstrapInfo;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private ScheduledExecutorService scheduler;
        @GuardedBy(value="lock")
        private XdsClient xdsClient;
        @GuardedBy(value="lock")
        private int refCount;

        @VisibleForTesting
        RefCountedXdsClientObjectPool(Bootstrapper.BootstrapInfo bootstrapInfo) {
            this.bootstrapInfo = Preconditions.checkNotNull(bootstrapInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XdsClient getObject() {
            Object object = this.lock;
            synchronized (object) {
                if (this.refCount == 0) {
                    this.scheduler = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
                    this.xdsClient = new XdsClientImpl(XdsClientImpl.XdsChannelFactory.DEFAULT_XDS_CHANNEL_FACTORY, this.bootstrapInfo, this.context, this.scheduler, new ExponentialBackoffPolicy.Provider(), GrpcUtil.STOPWATCH_SUPPLIER, TimeProvider.SYSTEM_TIME_PROVIDER, new TlsContextManagerImpl(this.bootstrapInfo));
                }
                ++this.refCount;
                return this.xdsClient;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XdsClient returnObject(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.xdsClient.shutdown();
                    this.xdsClient = null;
                    this.scheduler = SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.scheduler);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        XdsClient getXdsClientForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.xdsClient;
            }
        }
    }

    private static class SharedXdsClientPoolProviderHolder {
        private static final SharedXdsClientPoolProvider instance = new SharedXdsClientPoolProvider();

        private SharedXdsClientPoolProviderHolder() {
        }
    }
}

