/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.ByteStreams;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ServiceConstants;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

class GoogleCloudStorageClientWriteChannel
extends BaseAbstractGoogleAsyncWriteChannel<Boolean> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final StorageResourceId resourceId;
    private WritableByteChannel writableByteChannel;
    private final BlobWriteSession blobWriteSession;
    private boolean uploadSucceeded = false;

    public GoogleCloudStorageClientWriteChannel(Storage storage, GoogleCloudStorageOptions storageOptions, StorageResourceId resourceId, CreateObjectOptions createOptions, ExecutorService uploadThreadPool) throws IOException {
        super(uploadThreadPool, storageOptions.getWriteChannelOptions());
        this.resourceId = resourceId;
        this.blobWriteSession = GoogleCloudStorageClientWriteChannel.getBlobWriteSession(storage, resourceId, createOptions, storageOptions);
        this.writableByteChannel = this.blobWriteSession.open();
    }

    @Override
    public void startUpload(InputStream pipeSource) throws IOException {
        try {
            this.uploadOperation = this.threadPool.submit(new UploadOperation(pipeSource, this.resourceId));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to start upload for '%s'", this.resourceId), e);
        }
    }

    private static BlobInfo getBlobInfo(StorageResourceId resourceId, CreateObjectOptions createOptions) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(resourceId.getBucketName(), resourceId.getObjectName(), resourceId.getGenerationId())).setContentType(createOptions.getContentType()).setContentEncoding(createOptions.getContentEncoding()).setMetadata(GoogleCloudStorageImpl.encodeMetadata(createOptions.getMetadata())).build();
        return blobInfo;
    }

    private static BlobWriteSession getBlobWriteSession(Storage storage, StorageResourceId resourceId, CreateObjectOptions createOptions, GoogleCloudStorageOptions storageOptions) {
        return storage.blobWriteSession(GoogleCloudStorageClientWriteChannel.getBlobInfo(resourceId, createOptions), GoogleCloudStorageClientWriteChannel.generateWriteOptions(createOptions, storageOptions));
    }

    private static Storage.BlobWriteOption[] generateWriteOptions(CreateObjectOptions createOptions, GoogleCloudStorageOptions storageOptions) {
        ArrayList<Storage.BlobWriteOption> blobWriteOptions = new ArrayList<Storage.BlobWriteOption>();
        blobWriteOptions.add(Storage.BlobWriteOption.disableGzipContent());
        blobWriteOptions.add(Storage.BlobWriteOption.generationMatch());
        if (createOptions.getKmsKeyName() != null) {
            blobWriteOptions.add(Storage.BlobWriteOption.kmsKeyName(createOptions.getKmsKeyName()));
        }
        if (storageOptions.getWriteChannelOptions().isGrpcChecksumsEnabled()) {
            blobWriteOptions.add(Storage.BlobWriteOption.crc32cMatch());
        }
        if (storageOptions.getEncryptionKey() != null) {
            blobWriteOptions.add(Storage.BlobWriteOption.encryptionKey(storageOptions.getEncryptionKey().value()));
        }
        return blobWriteOptions.toArray(new Storage.BlobWriteOption[blobWriteOptions.size()]);
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.isOpen()) {
                return;
            }
            super.close();
            this.writableByteChannel.close();
        }
        catch (Exception e) {
            throw new IOException(String.format("Upload failed for '%s'", this.resourceId), e);
        }
        finally {
            this.writableByteChannel = null;
        }
    }

    @Override
    public void handleResponse(Boolean response) {
        this.uploadSucceeded = response;
    }

    @Override
    protected String getResourceString() {
        return this.resourceId.toString();
    }

    public boolean isUploadSuccessful() {
        return this.uploadSucceeded;
    }

    private int writeInternal(ByteBuffer byteBuffer) throws IOException {
        int bytesWritten = this.writableByteChannel.write(byteBuffer);
        ((GoogleLogger.Api)logger.atFinest()).log("%d bytes were written out of provided buffer of capacity %d, for resourceId %s", bytesWritten, byteBuffer.limit(), this.resourceId);
        return bytesWritten;
    }

    private class UploadOperation
    implements Callable<Boolean> {
        private final InputStream pipeSource;
        private final StorageResourceId resourceId;
        private final int MAX_BYTES_PER_MESSAGE = ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber();

        UploadOperation(@Nonnull InputStream pipeSource, StorageResourceId resourceId) {
            this.resourceId = resourceId;
            this.pipeSource = pipeSource;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean call() throws Exception {
            ((GoogleLogger.Api)logger.atFiner()).log("Starting upload for resource %s", this.resourceId);
            try (InputStream ignore = this.pipeSource;){
                boolean lastChunk = false;
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.MAX_BYTES_PER_MESSAGE);
                while (!lastChunk) {
                    int remainingCapacity = byteBuffer.remaining();
                    ByteString data = ByteString.readFrom(ByteStreams.limit(this.pipeSource, remainingCapacity), remainingCapacity);
                    if (data.size() < remainingCapacity) {
                        lastChunk = true;
                    }
                    byteBuffer.put(data.toByteArray());
                    ((Buffer)byteBuffer).flip();
                    GoogleCloudStorageClientWriteChannel.this.writeInternal(byteBuffer);
                    if (lastChunk) continue;
                    byteBuffer.compact();
                }
                if (lastChunk && byteBuffer.hasRemaining()) {
                    while (byteBuffer.hasRemaining()) {
                        GoogleCloudStorageClientWriteChannel.this.writeInternal(byteBuffer);
                    }
                }
                ((GoogleLogger.Api)logger.atFiner()).log("Uploaded all chunks for resource %s", this.resourceId);
                Boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new IOException(String.format("Error occurred while uploading resource %s", this.resourceId), e);
            }
        }
    }
}

