/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.ByteArrayContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.jackson2.JacksonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.BackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Data;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.ExponentialBackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.StorageRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Buckets;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.ComposeRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.Objects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.RewriteResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.BatchHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CloudMonitoringMetricsRecorder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.EventLoggingHttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.MetricsRecorder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.NoOpMetricsRecorder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageRequestFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageRequestToAccessBoundaryConverter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.authorization.StorageRequestAuthorizer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryBoundedBackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.CacheBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.CacheLoader;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.LoadingCache;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Iterables;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Lists;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Maps;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Sets;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GoogleCloudStorageImpl
implements GoogleCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final int MAXIMUM_PRECONDITION_FAILURES_IN_DELETE = 4;
    private static final String USER_PROJECT_FIELD_NAME = "userProject";
    private static final CreateObjectOptions EMPTY_OBJECT_CREATE_OPTIONS = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setEnsureEmptyObjectsMetadataMatch(false).build();
    static final String OBJECT_FIELDS = String.join((CharSequence)",", "bucket", "name", "timeCreated", "updated", "generation", "metageneration", "size", "contentType", "contentEncoding", "md5Hash", "crc32c", "metadata");
    private static final String LIST_OBJECT_FIELDS_FORMAT = "items(%s),prefixes,nextPageToken";
    private final MetricsRecorder metricsRecorder;
    private final LoadingCache<String, Boolean> autoBuckets = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(1L)).build(new CacheLoader<String, Boolean>(){
        final List<String> iamPermissions = ImmutableList.of("storage.buckets.get");

        @Override
        public Boolean load(String bucketName) throws Exception {
            try {
                GoogleCloudStorageImpl.this.storage.buckets().testIamPermissions(bucketName, this.iamPermissions).executeUnparsed().disconnect();
            }
            catch (IOException e) {
                return GoogleCloudStorageImpl.this.errorExtractor.userProjectMissing(e);
            }
            return false;
        }
    });
    @VisibleForTesting
    Storage storage;
    @VisibleForTesting
    StorageRequestFactory storageRequestFactory;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcs-async-channel-pool-%d").setDaemon(true).build());
    private ExecutorService manualBatchingThreadPool = this.createManualBatchingThreadPool();
    private ApiErrorExtractor errorExtractor = ApiErrorExtractor.INSTANCE;
    private final ClientRequestHelper<StorageObject> clientRequestHelper = new ClientRequestHelper();
    private BatchHelper.Factory batchFactory = new BatchHelper.Factory();
    private final HttpRequestInitializer httpRequestInitializer;
    private final GoogleCloudStorageOptions storageOptions;
    private final Sleeper sleeper = Sleeper.DEFAULT;
    private final BackOffFactory backOffFactory = BackOffFactory.DEFAULT;
    private RetryDeterminer<IOException> rateLimitedRetryDeterminer = this.errorExtractor::rateLimited;
    private final StorageRequestAuthorizer storageRequestAuthorizer;
    private final Function<List<AccessBoundary>, String> downscopedAccessTokenFn;

    static String encodeMetadataValues(byte[] bytes) {
        return bytes == null ? Data.NULL_STRING : BaseEncoding.base64().encode(bytes);
    }

    private static byte[] decodeMetadataValues(String value) {
        try {
            return BaseEncoding.base64().decode(value);
        }
        catch (IllegalArgumentException iae) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(iae)).log("Failed to parse base64 encoded attribute value %s - %s", (Object)value, (Object)iae);
            return null;
        }
    }

    public static void validateCopyArguments(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames, GoogleCloudStorage googleCloudStorage) throws IOException {
        Preconditions.checkArgument(srcObjectNames != null, "srcObjectNames must not be null");
        Preconditions.checkArgument(dstObjectNames != null, "dstObjectNames must not be null");
        Preconditions.checkArgument(srcObjectNames.size() == dstObjectNames.size(), "Must supply same number of elements in srcObjects and dstObjects");
        HashMap<StorageResourceId, StorageResourceId> srcToDestObjectsMap = new HashMap<StorageResourceId, StorageResourceId>(srcObjectNames.size());
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            srcToDestObjectsMap.put(new StorageResourceId(srcBucketName, srcObjectNames.get(i)), new StorageResourceId(dstBucketName, dstObjectNames.get(i)));
        }
        GoogleCloudStorageImpl.validateCopyArguments(srcToDestObjectsMap, googleCloudStorage);
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Credential credential) throws IOException {
        this(options, credential, null);
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        this(options, GoogleCloudStorageImpl.createStorage(options, new RetryHttpInitializer(credential, options.toRetryHttpInitializerOptions())), null, credential, downscopedAccessTokenFn);
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, HttpRequestInitializer httpRequestInitializer) throws IOException {
        this(options, httpRequestInitializer, null);
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, HttpRequestInitializer httpRequestInitializer, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        this(options, GoogleCloudStorageImpl.createStorage(options, httpRequestInitializer), null, GoogleCloudStorageImpl.tryGetCredentialsFromRequestInitializer(httpRequestInitializer), downscopedAccessTokenFn);
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Storage storage) {
        this(options, storage, null, null);
        GoogleCloudStorageImpl.warnIfTracingEnabled(options.isTraceLogEnabled());
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Storage storage, Credentials credentials) {
        this(options, storage, credentials, null);
        GoogleCloudStorageImpl.warnIfTracingEnabled(options.isTraceLogEnabled());
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Storage storage, Credentials credentials, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        this(options, storage, credentials, null, downscopedAccessTokenFn);
        GoogleCloudStorageImpl.warnIfTracingEnabled(options.isTraceLogEnabled());
    }

    private GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Storage storage, Credentials credentials, Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        ((GoogleLogger.Api)logger.atFiner()).log("GCS(options: %s)", options);
        this.storageOptions = Preconditions.checkNotNull(options, "options must not be null");
        this.storageOptions.throwIfNotValid();
        this.storage = Preconditions.checkNotNull(storage, "storage must not be null");
        this.storageRequestFactory = new StorageRequestFactory(storage);
        this.httpRequestInitializer = this.storage.getRequestFactory().getInitializer();
        this.metricsRecorder = GoogleCloudStorageImpl.getMetricsRecorder(options, credential, this.httpRequestInitializer);
        this.storageRequestAuthorizer = GoogleCloudStorageImpl.initializeStorageRequestAuthorizer(this.storageOptions);
        this.downscopedAccessTokenFn = downscopedAccessTokenFn;
    }

    private static MetricsRecorder getMetricsRecorder(GoogleCloudStorageOptions options, Credential credential, HttpRequestInitializer httpRequestInitializer) {
        if (GoogleCloudStorageOptions.MetricsSink.CLOUD_MONITORING != options.getMetricsSink()) {
            return new NoOpMetricsRecorder();
        }
        Credential theCredential = credential;
        if (theCredential == null) {
            theCredential = ((RetryHttpInitializer)httpRequestInitializer).getCredential();
        }
        return CloudMonitoringMetricsRecorder.create(options.getProjectId(), new CredentialAdapter(theCredential));
    }

    private static Credential tryGetCredentialsFromRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
        if (httpRequestInitializer instanceof RetryHttpInitializer) {
            return ((RetryHttpInitializer)httpRequestInitializer).getCredential();
        }
        return null;
    }

    private static void warnIfTracingEnabled(boolean traceLogEnabled) {
        if (traceLogEnabled) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(10, TimeUnit.MINUTES)).log("JSON API request tracing is not happening since the caller is using a lower level API");
        }
    }

    private static Storage createStorage(GoogleCloudStorageOptions options, HttpRequestInitializer httpRequestInitializer) throws IOException {
        HttpTransport httpTransport = HttpTransportFactory.createHttpTransport(options.getTransportType(), options.getProxyAddress(), options.getProxyUsername(), options.getProxyPassword(), Duration.ofMillis(options.getHttpRequestReadTimeout()));
        HttpRequestInitializer requestInitializer = httpRequestInitializer;
        if (options.isTraceLogEnabled()) {
            requestInitializer = new ChainingHttpRequestInitializer(httpRequestInitializer, new EventLoggingHttpRequestInitializer(options.getTraceLogTimeThreshold(), options.getTraceLogExcludeProperties()));
        }
        return new Storage.Builder(httpTransport, JSON_FACTORY, requestInitializer).setRootUrl(options.getStorageRootUrl()).setServicePath(options.getStorageServicePath()).setApplicationName(options.getAppName()).build();
    }

    @VisibleForTesting
    static StorageRequestAuthorizer initializeStorageRequestAuthorizer(GoogleCloudStorageOptions options) {
        return options.getAuthorizationHandlerImplClass() == null ? null : new StorageRequestAuthorizer(options.getAuthorizationHandlerImplClass(), options.getAuthorizationHandlerProperties());
    }

    private ExecutorService createManualBatchingThreadPool() {
        ThreadPoolExecutor service = new ThreadPoolExecutor(10, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("gcs-manual-batching-pool-%d").setDaemon(true).build());
        service.allowCoreThreadTimeOut(true);
        return service;
    }

    @VisibleForTesting
    void setBackgroundTasksThreadPool(ExecutorService backgroundTasksThreadPool) {
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
    }

    @VisibleForTesting
    void setErrorExtractor(ApiErrorExtractor errorExtractor) {
        this.errorExtractor = errorExtractor;
        this.rateLimitedRetryDeterminer = errorExtractor::rateLimited;
    }

    @VisibleForTesting
    void setBatchFactory(BatchHelper.Factory batchFactory) {
        this.batchFactory = batchFactory;
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.storageOptions;
    }

    @Override
    public WritableByteChannel create(final StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        Optional<Long> writeGeneration = resourceId.hasGenerationId() ? Optional.of(resourceId.getGenerationId()) : Optional.of(this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        ObjectWriteConditions writeConditions = ObjectWriteConditions.builder().setContentGenerationMatch(writeGeneration.orElse(null)).build();
        GoogleCloudStorageWriteChannel channel = new GoogleCloudStorageWriteChannel(this.storage, this.clientRequestHelper, this.backgroundTasksThreadPool, this.storageOptions.getWriteChannelOptions(), resourceId, options, writeConditions){

            @Override
            public Storage.Objects.Insert createRequest(InputStreamContent inputStream) throws IOException {
                return GoogleCloudStorageImpl.this.initializeRequest(super.createRequest(inputStream), resourceId.getBucketName());
            }
        };
        channel.initialize();
        return channel;
    }

    @Override
    public void createBucket(String bucketName, CreateBucketOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createBucket(%s)", bucketName);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Preconditions.checkNotNull(options, "options must not be null");
        Preconditions.checkNotNull(this.storageOptions.getProjectId(), "projectId must not be null");
        Bucket bucket = new Bucket().setName(bucketName).setLocation(options.getLocation()).setStorageClass(options.getStorageClass());
        if (options.getTtl() != null) {
            Bucket.Lifecycle.Rule lifecycleRule = new Bucket.Lifecycle.Rule().setAction(new Bucket.Lifecycle.Rule.Action().setType("Delete")).setCondition(new Bucket.Lifecycle.Rule.Condition().setAge(Math.toIntExact(options.getTtl().toDays())));
            bucket.setLifecycle(new Bucket.Lifecycle().setRule(ImmutableList.of(lifecycleRule)));
        }
        Storage.Buckets.Insert insertBucket = this.initializeRequest(this.storage.buckets().insert(this.storageOptions.getProjectId(), bucket), bucketName);
        try {
            ResilientOperation.retry(insertBucket::execute, this.backOffFactory.newBackOff(), this.rateLimitedRetryDeterminer, IOException.class, this.sleeper);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to create bucket", e);
        }
        catch (IOException e) {
            if (ApiErrorExtractor.INSTANCE.itemAlreadyExists(e)) {
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("Bucket '%s' already exists.", bucketName)).initCause(e);
            }
            throw e;
        }
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
        try {
            insertObject.execute();
        }
        catch (IOException e) {
            if (this.canIgnoreExceptionForEmptyObject(e, resourceId, options)) {
                ((GoogleLogger.Api)logger.atInfo()).log("Ignoring exception of type %s; verified object already exists with desired state.", e.getClass().getSimpleName());
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).log("Ignored exception while creating empty object");
            }
            if (ApiErrorExtractor.INSTANCE.itemAlreadyExists(e)) {
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("Object '%s' already exists.", resourceId)).initCause(e);
            }
            throw e;
        }
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createEmptyObject(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        this.createEmptyObject(resourceId, EMPTY_OBJECT_CREATE_OPTIONS);
    }

    public void updateMetadata(GoogleCloudStorageItemInfo itemInfo, Map<String, byte[]> metadata) throws IOException {
        StorageResourceId resourceId = itemInfo.getResourceId();
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject ID, got %s", (Object)resourceId);
        StorageObject storageObject = new StorageObject().setMetadata(GoogleCloudStorageImpl.encodeMetadata(metadata));
        Storage.Objects.Patch patchObject = this.initializeRequest(this.storage.objects().patch(resourceId.getBucketName(), resourceId.getObjectName(), storageObject), resourceId.getBucketName()).setIfMetagenerationMatch(itemInfo.getMetaGeneration());
        patchObject.execute();
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createEmptyObjects(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return;
        }
        if (resourceIds.size() == 1) {
            this.createEmptyObject(Iterables.getOnlyElement(resourceIds), options);
            return;
        }
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject names only, got: '%s'", (Object)resourceId);
        }
        Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        CountDownLatch latch = new CountDownLatch(resourceIds.size());
        for (StorageResourceId resourceId : resourceIds) {
            Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
            this.manualBatchingThreadPool.execute(() -> {
                try {
                    insertObject.execute();
                    ((GoogleLogger.Api)logger.atFiner()).log("Successfully inserted %s", resourceId);
                }
                catch (IOException ioe) {
                    boolean canIgnoreException = false;
                    try {
                        canIgnoreException = this.canIgnoreExceptionForEmptyObject(ioe, resourceId, options);
                    }
                    catch (Exception e) {
                        innerExceptions.add(new IOException("Error re-fetching after rate-limit error: " + resourceId, e));
                    }
                    if (canIgnoreException) {
                        ((GoogleLogger.Api)logger.atInfo()).log("Ignoring exception of type %s; verified object already exists with desired state.", ioe.getClass().getSimpleName());
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(ioe)).log("Ignored exception while creating empty object");
                    } else {
                        innerExceptions.add(new IOException("Error inserting " + resourceId, ioe));
                    }
                }
                catch (Exception e) {
                    innerExceptions.add(new IOException("Error inserting " + resourceId, e));
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to create empty objects", ie);
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.createEmptyObjects(resourceIds, EMPTY_OBJECT_CREATE_OPTIONS);
    }

    @Override
    public SeekableByteChannel open(final StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        GoogleCloudStorageItemInfo info;
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        if (readOptions.getFastFailOnNotFound()) {
            info = this.getItemInfo(resourceId);
            if (!info.exists()) {
                throw GoogleCloudStorageExceptions.createFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName(), null);
            }
        } else {
            info = null;
        }
        return new GoogleCloudStorageReadChannel(this.storage, resourceId, this.errorExtractor, this.clientRequestHelper, readOptions){

            @Override
            @Nullable
            protected GoogleCloudStorageItemInfo getInitialMetadata() {
                return info;
            }

            @Override
            protected Storage.Objects.Get createDataRequest() throws IOException {
                return GoogleCloudStorageImpl.this.initializeRequest(super.createDataRequest(), resourceId.getBucketName());
            }

            @Override
            protected Storage.Objects.Get createMetadataRequest() throws IOException {
                return GoogleCloudStorageImpl.this.initializeRequest(super.createMetadataRequest(), resourceId.getBucketName());
            }
        };
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("deleteBuckets(%s)", bucketNames);
        for (String bucketName : bucketNames) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (String bucketName : bucketNames) {
            Storage.Buckets.Delete deleteBucket = this.initializeRequest(this.storage.buckets().delete(bucketName), bucketName);
            try {
                ResilientOperation.retry(deleteBucket::execute, this.backOffFactory.newBackOff(), this.rateLimitedRetryDeterminer, IOException.class, this.sleeper);
            }
            catch (IOException e) {
                innerExceptions.add(this.errorExtractor.itemNotFound(e) ? GoogleCloudStorageExceptions.createFileNotFoundException(bucketName, null, e) : new IOException(String.format("Error deleting '%s' bucket", bucketName), e));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Failed to delete buckets", e);
            }
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    public void deleteObject(StorageResourceId resourceId, long metaGeneration) throws IOException {
        String bucketName = resourceId.getBucketName();
        Storage.Objects.Delete deleteObject = this.initializeRequest(this.storage.objects().delete(bucketName, resourceId.getObjectName()), bucketName).setIfMetagenerationMatch(metaGeneration);
        deleteObject.execute();
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("deleteObjects(%s)", fullObjectNames);
        if (fullObjectNames.isEmpty()) {
            return;
        }
        for (StorageResourceId fullObjectName : fullObjectNames) {
            Preconditions.checkArgument(fullObjectName.isStorageObject(), "Expected full StorageObject names only, got: %s", (Object)fullObjectName);
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.storage, this.storageOptions.getMaxRequestsPerBatch(), fullObjectNames.size(), this.storageOptions.getBatchThreads());
        for (StorageResourceId fullObjectName : fullObjectNames) {
            this.queueSingleObjectDelete(fullObjectName, innerExceptions, batchHelper, 1);
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private JsonBatchCallback<Void> getDeletionCallback(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchHelper batchHelper, final int attempt, final long generation) {
        return new JsonBatchCallback<Void>(){

            @Override
            public void onSuccess(Void obj, HttpHeaders responseHeaders) {
                ((GoogleLogger.Api)logger.atFiner()).log("Successfully deleted %s at generation %s", (Object)resourceId, generation);
            }

            @Override
            public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) throws IOException {
                GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Delete object '%s' not found:%n%s", (Object)resourceId, (Object)jsonError);
                } else if (GoogleCloudStorageImpl.this.errorExtractor.preconditionNotMet(cause) && attempt <= 4) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Precondition not met while deleting '%s' at generation %s. Attempt %s. Retrying:%n%s", resourceId, generation, attempt, jsonError);
                    GoogleCloudStorageImpl.this.queueSingleObjectDelete(resourceId, innerExceptions, batchHelper, attempt + 1);
                } else {
                    innerExceptions.add(new IOException(String.format("Error deleting '%s', stage 2 with generation %s", resourceId, generation), cause));
                }
            }
        };
    }

    private void queueSingleObjectDelete(final StorageResourceId resourceId, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final BatchHelper batchHelper, final int attempt) throws IOException {
        final String bucketName = resourceId.getBucketName();
        final String objectName = resourceId.getObjectName();
        if (resourceId.hasGenerationId()) {
            long generationId = resourceId.getGenerationId();
            Storage.Objects.Delete deleteObject = this.initializeRequest(this.storage.objects().delete(bucketName, objectName), bucketName).setIfGenerationMatch(generationId);
            batchHelper.queue(deleteObject, this.getDeletionCallback(resourceId, innerExceptions, batchHelper, attempt, generationId));
        } else {
            Storage.Objects.Get getObject = this.initializeRequest(this.storageRequestFactory.objectsGetMetadata(bucketName, objectName), bucketName).setFields("generation");
            batchHelper.queue(getObject, new JsonBatchCallback<StorageObject>(){

                @Override
                public void onSuccess(StorageObject storageObject, HttpHeaders httpHeaders) throws IOException {
                    Long generation = Preconditions.checkNotNull(storageObject.getGeneration(), "generation can not be null");
                    Storage.Objects.Delete deleteObject = GoogleCloudStorageImpl.this.initializeRequest(GoogleCloudStorageImpl.this.storage.objects().delete(bucketName, objectName), bucketName).setIfGenerationMatch(generation);
                    batchHelper.queue(deleteObject, GoogleCloudStorageImpl.this.getDeletionCallback(resourceId, innerExceptions, batchHelper, attempt, generation));
                }

                @Override
                public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                    GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                        ((GoogleLogger.Api)logger.atFiner()).log("deleteObjects(%s): get not found:%n%s", (Object)resourceId, (Object)jsonError);
                    } else {
                        innerExceptions.add(new IOException(String.format("Error deleting '%s', stage 1", resourceId), cause));
                    }
                }
            });
        }
    }

    public static void validateCopyArguments(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap, GoogleCloudStorage gcsImpl) throws IOException {
        Preconditions.checkNotNull(sourceToDestinationObjectsMap, "srcObjects must not be null");
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        HashMap<StorageResourceId, GoogleCloudStorageItemInfo> bucketInfoCache = new HashMap<StorageResourceId, GoogleCloudStorageItemInfo>();
        for (Map.Entry<StorageResourceId, StorageResourceId> entry : sourceToDestinationObjectsMap.entrySet()) {
            String dstBucketName;
            StorageResourceId source = entry.getKey();
            StorageResourceId destination = entry.getValue();
            String srcBucketName = source.getBucketName();
            if (!srcBucketName.equals(dstBucketName = destination.getBucketName())) {
                StorageResourceId srcBucketResourceId = new StorageResourceId(srcBucketName);
                GoogleCloudStorageItemInfo srcBucketInfo = GoogleCloudStorageImpl.getGoogleCloudStorageItemInfo(gcsImpl, bucketInfoCache, srcBucketResourceId);
                if (!srcBucketInfo.exists()) {
                    throw new FileNotFoundException("Bucket not found: " + srcBucketName);
                }
                StorageResourceId dstBucketResourceId = new StorageResourceId(dstBucketName);
                GoogleCloudStorageItemInfo dstBucketInfo = GoogleCloudStorageImpl.getGoogleCloudStorageItemInfo(gcsImpl, bucketInfoCache, dstBucketResourceId);
                if (!dstBucketInfo.exists()) {
                    throw new FileNotFoundException("Bucket not found: " + dstBucketName);
                }
                if (!gcsImpl.getOptions().isCopyWithRewriteEnabled()) {
                    if (!srcBucketInfo.getLocation().equals(dstBucketInfo.getLocation())) {
                        throw new UnsupportedOperationException("This operation is not supported across two different storage locations.");
                    }
                    if (!srcBucketInfo.getStorageClass().equals(dstBucketInfo.getStorageClass())) {
                        throw new UnsupportedOperationException("This operation is not supported across two different storage classes.");
                    }
                }
            }
            Preconditions.checkArgument(!Strings.isNullOrEmpty(source.getObjectName()), "srcObjectName must not be null or empty");
            Preconditions.checkArgument(!Strings.isNullOrEmpty(destination.getObjectName()), "dstObjectName must not be null or empty");
            if (!srcBucketName.equals(dstBucketName) || !source.getObjectName().equals(destination.getObjectName())) continue;
            throw new IllegalArgumentException(String.format("Copy destination must be different from source for %s.", StringPaths.fromComponents(srcBucketName, source.getObjectName())));
        }
    }

    private static GoogleCloudStorageItemInfo getGoogleCloudStorageItemInfo(GoogleCloudStorage gcsImpl, Map<StorageResourceId, GoogleCloudStorageItemInfo> bucketInfoCache, StorageResourceId resourceId) throws IOException {
        GoogleCloudStorageItemInfo storageItemInfo = bucketInfoCache.get(resourceId);
        if (storageItemInfo != null) {
            return storageItemInfo;
        }
        storageItemInfo = gcsImpl.getItemInfo(resourceId);
        bucketInfoCache.put(resourceId, storageItemInfo);
        return storageItemInfo;
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        Preconditions.checkArgument(srcObjectNames != null, "srcObjectNames must not be null");
        Preconditions.checkArgument(dstObjectNames != null, "dstObjectNames must not be null");
        Preconditions.checkArgument(srcObjectNames.size() == dstObjectNames.size(), "Must supply same number of elements in srcObjects and dstObjects");
        HashMap<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap = new HashMap<StorageResourceId, StorageResourceId>(srcObjectNames.size());
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            sourceToDestinationObjectsMap.put(new StorageResourceId(srcBucketName, srcObjectNames.get(i)), new StorageResourceId(dstBucketName, dstObjectNames.get(i)));
        }
        this.copy(sourceToDestinationObjectsMap);
    }

    @Override
    public void copy(Map<StorageResourceId, StorageResourceId> sourceToDestinationObjectsMap) throws IOException {
        GoogleCloudStorageImpl.validateCopyArguments(sourceToDestinationObjectsMap, this);
        if (sourceToDestinationObjectsMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions = ConcurrentHashMap.newKeySet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.storage, this.storageOptions.getMaxRequestsPerBatch(), sourceToDestinationObjectsMap.size(), this.storageOptions.getBatchThreads());
        for (Map.Entry<StorageResourceId, StorageResourceId> entry : sourceToDestinationObjectsMap.entrySet()) {
            StorageResourceId srcObject = entry.getKey();
            StorageResourceId dstObject = entry.getValue();
            if (this.storageOptions.isCopyWithRewriteEnabled()) {
                this.rewriteInternal(batchHelper, innerExceptions, srcObject.getBucketName(), srcObject.getObjectName(), dstObject.getBucketName(), dstObject.getObjectName());
                continue;
            }
            this.copyInternal(batchHelper, innerExceptions, srcObject.getBucketName(), srcObject.getObjectName(), dstObject.getGenerationId(), dstObject.getBucketName(), dstObject.getObjectName());
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void rewriteInternal(final BatchHelper batchHelper, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final String srcBucketName, final String srcObjectName, final String dstBucketName, final String dstObjectName) throws IOException {
        Storage.Objects.Rewrite rewriteObject = this.initializeRequest(this.storage.objects().rewrite(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null), srcBucketName);
        if (this.storageOptions.getMaxBytesRewrittenPerCall() > 0L) {
            rewriteObject.setMaxBytesRewrittenPerCall(this.storageOptions.getMaxBytesRewrittenPerCall());
        }
        batchHelper.queue(rewriteObject, new JsonBatchCallback<RewriteResponse>(){

            @Override
            public void onSuccess(RewriteResponse rewriteResponse, HttpHeaders responseHeaders) {
                String srcString = StringPaths.fromComponents(srcBucketName, srcObjectName);
                String dstString = StringPaths.fromComponents(dstBucketName, dstObjectName);
                if (rewriteResponse.getDone().booleanValue()) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Successfully copied %s to %s", (Object)srcString, (Object)dstString);
                } else {
                    ((GoogleLogger.Api)logger.atFiner()).log("Copy (%s to %s) did not complete. Resuming...", (Object)srcString, (Object)dstString);
                    try {
                        Storage.Objects.Rewrite rewriteObjectWithToken = GoogleCloudStorageImpl.this.initializeRequest(GoogleCloudStorageImpl.this.storage.objects().rewrite(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null), srcBucketName);
                        if (GoogleCloudStorageImpl.this.storageOptions.getMaxBytesRewrittenPerCall() > 0L) {
                            rewriteObjectWithToken.setMaxBytesRewrittenPerCall(GoogleCloudStorageImpl.this.storageOptions.getMaxBytesRewrittenPerCall());
                        }
                        rewriteObjectWithToken.setRewriteToken(rewriteResponse.getRewriteToken());
                        batchHelper.queue(rewriteObjectWithToken, this);
                    }
                    catch (IOException e) {
                        innerExceptions.add(e);
                    }
                }
            }

            @Override
            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                GoogleCloudStorageImpl.this.onCopyFailure(innerExceptions, e, responseHeaders, srcBucketName, srcObjectName);
            }
        });
    }

    private void copyInternal(BatchHelper batchHelper, final ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, final String srcBucketName, final String srcObjectName, long dstContentGeneration, final String dstBucketName, final String dstObjectName) throws IOException {
        Storage.Objects.Copy copy = this.storage.objects().copy(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null);
        if (dstContentGeneration != -1L) {
            copy.setIfGenerationMatch(dstContentGeneration);
        }
        Storage.Objects.Copy copyObject = this.initializeRequest(copy, srcBucketName);
        batchHelper.queue(copyObject, new JsonBatchCallback<StorageObject>(){

            @Override
            public void onSuccess(StorageObject copyResponse, HttpHeaders responseHeaders) {
                String srcString = StringPaths.fromComponents(srcBucketName, srcObjectName);
                String dstString = StringPaths.fromComponents(dstBucketName, dstObjectName);
                ((GoogleLogger.Api)logger.atFiner()).log("Successfully copied %s to %s", (Object)srcString, (Object)dstString);
            }

            @Override
            public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                GoogleCloudStorageImpl.this.onCopyFailure(innerExceptions, jsonError, responseHeaders, srcBucketName, srcObjectName);
            }
        });
    }

    private void onCopyFailure(ConcurrentHashMap.KeySetView<IOException, Boolean> innerExceptions, GoogleJsonError jsonError, HttpHeaders responseHeaders, String srcBucketName, String srcObjectName) {
        GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
        innerExceptions.add(this.errorExtractor.itemNotFound(cause) ? GoogleCloudStorageExceptions.createFileNotFoundException(srcBucketName, srcObjectName, cause) : new IOException(String.format("Error copying '%s'", StringPaths.fromComponents(srcBucketName, srcObjectName)), cause));
    }

    private List<Bucket> listBucketsInternal() throws IOException {
        Buckets items;
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketsInternal()");
        Preconditions.checkNotNull(this.storageOptions.getProjectId(), "projectId must not be null");
        ArrayList<Bucket> allBuckets = new ArrayList<Bucket>();
        Storage.Buckets.List listBucket = this.initializeRequest(this.storage.buckets().list(this.storageOptions.getProjectId()), null);
        listBucket.setMaxResults(this.storageOptions.getMaxListItemsPerCall());
        String pageToken = null;
        do {
            List<Bucket> buckets;
            if (pageToken != null) {
                ((GoogleLogger.Api)logger.atFiner()).log("listBucketsInternal: next page %s", pageToken);
                listBucket.setPageToken(pageToken);
            }
            if ((buckets = (items = (Buckets)listBucket.execute()).getItems()) == null) continue;
            ((GoogleLogger.Api)logger.atFiner()).log("listed %s items", buckets.size());
            allBuckets.addAll(buckets);
        } while ((pageToken = items.getNextPageToken()) != null);
        return allBuckets;
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketNames()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<String> bucketNames = new ArrayList<String>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketNames.add(bucket.getName());
        }
        return bucketNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listBucketInfo()");
        List<Bucket> allBuckets = this.listBucketsInternal();
        ArrayList<GoogleCloudStorageItemInfo> bucketInfos = new ArrayList<GoogleCloudStorageItemInfo>(allBuckets.size());
        for (Bucket bucket : allBuckets) {
            bucketInfos.add(GoogleCloudStorageImpl.createItemInfoForBucket(new StorageResourceId(bucket.getName()), bucket));
        }
        return bucketInfos;
    }

    private Storage.Objects.Insert prepareEmptyInsert(StorageResourceId resourceId, CreateObjectOptions createObjectOptions) throws IOException {
        Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(createObjectOptions.getMetadata());
        StorageObject object = new StorageObject().setName(resourceId.getObjectName()).setMetadata(rewrittenMetadata).setContentEncoding(createObjectOptions.getContentEncoding());
        ByteArrayContent emptyContent = new ByteArrayContent(createObjectOptions.getContentType(), new byte[0]);
        Storage.Objects.Insert insertObject = this.initializeRequest(this.storage.objects().insert(resourceId.getBucketName(), object, emptyContent), resourceId.getBucketName());
        insertObject.setDisableGZipContent(true);
        this.clientRequestHelper.setDirectUploadEnabled(insertObject, true);
        if (resourceId.hasGenerationId()) {
            insertObject.setIfGenerationMatch(resourceId.getGenerationId());
        } else if (resourceId.isDirectory() || !createObjectOptions.isOverwriteExisting()) {
            insertObject.setIfGenerationMatch(0L);
        }
        return insertObject;
    }

    private void listStorageObjectsAndPrefixes(String bucketName, String objectNamePrefix, ListObjectOptions listOptions, boolean includeTrailingDelimiter, List<StorageObject> listedObjects, List<String> listedPrefixes) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listStorageObjectsAndPrefixes(%s, %s, %s, %s)", bucketName, objectNamePrefix, listOptions, includeTrailingDelimiter);
        Preconditions.checkArgument(listedObjects != null && listedObjects.isEmpty(), "Must provide a non-null empty container for listedObjects.");
        Preconditions.checkArgument(listedPrefixes != null && listedPrefixes.isEmpty(), "Must provide a non-null empty container for listedPrefixes.");
        long maxResults = listOptions.getMaxResults() > 0L ? listOptions.getMaxResults() + (long)(listOptions.isIncludePrefix() ? 0 : 1) : listOptions.getMaxResults();
        Storage.Objects.List listObject = this.createListRequest(bucketName, objectNamePrefix, listOptions.getFields(), listOptions.getDelimiter(), includeTrailingDelimiter, maxResults);
        String pageToken = null;
        do {
            if (pageToken == null) continue;
            ((GoogleLogger.Api)logger.atFiner()).log("listStorageObjectsAndPrefixes: next page %s", pageToken);
            listObject.setPageToken(pageToken);
        } while ((pageToken = this.listStorageObjectsAndPrefixesPage(listObject, listOptions, listedObjects, listedPrefixes)) != null && GoogleCloudStorageImpl.getMaxRemainingResults(listOptions.getMaxResults(), listedPrefixes, listedObjects) > 0L);
    }

    private String listStorageObjectsAndPrefixesPage(Storage.Objects.List listObject, ListObjectOptions listOptions, List<StorageObject> listedObjects, List<String> listedPrefixes) throws IOException {
        List<StorageObject> objects;
        Objects items;
        ((GoogleLogger.Api)logger.atFiner()).log("listStorageObjectsAndPrefixesPage(%s, %s)", (Object)listObject, (Object)listOptions);
        Preconditions.checkNotNull(listedObjects, "Must provide a non-null container for listedObjects.");
        Preconditions.checkNotNull(listedPrefixes, "Must provide a non-null container for listedPrefixes.");
        LinkedHashSet<String> prefixes = new LinkedHashSet<String>(listedPrefixes);
        try {
            items = (Objects)listObject.execute();
        }
        catch (IOException e) {
            String resource = StringPaths.fromComponents(listObject.getBucket(), listObject.getPrefix());
            if (this.errorExtractor.itemNotFound(e)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log("listStorageObjectsAndPrefixesPage(%s, %s): item not found", (Object)resource, (Object)listOptions);
                return null;
            }
            throw new IOException("Error listing " + resource, e);
        }
        List<String> pagePrefixes = items.getPrefixes();
        if (pagePrefixes != null) {
            ((GoogleLogger.Api)logger.atFiner()).log("listStorageObjectsAndPrefixesPage(%s, %s): listed %s prefixes", listObject, listOptions, pagePrefixes.size());
            long maxRemainingResults = GoogleCloudStorageImpl.getMaxRemainingResults(listOptions.getMaxResults(), prefixes, listedObjects);
            long maxPrefixes = Math.min(maxRemainingResults, (long)pagePrefixes.size());
            prefixes.addAll(pagePrefixes.subList(0, (int)maxPrefixes));
        }
        if ((objects = items.getItems()) != null) {
            ((GoogleLogger.Api)logger.atFiner()).log("listStorageObjectsAndPrefixesPage(%s, %s): listed %d objects", listObject, listOptions, objects.size());
            String objectNamePrefix = listObject.getPrefix();
            boolean objectPrefixEndsWithDelimiter = !Strings.isNullOrEmpty(objectNamePrefix) && objectNamePrefix.endsWith("/");
            long maxRemainingResults = GoogleCloudStorageImpl.getMaxRemainingResults(listOptions.getMaxResults(), prefixes, listedObjects);
            for (StorageObject object : objects) {
                if (!objectPrefixEndsWithDelimiter || !object.getName().equals(objectNamePrefix)) {
                    if (prefixes.remove(object.getName())) {
                        listedObjects.add(object);
                        continue;
                    }
                    if (maxRemainingResults <= 0L) continue;
                    listedObjects.add(object);
                    --maxRemainingResults;
                    continue;
                }
                if (!listOptions.isIncludePrefix() || !object.getName().equals(objectNamePrefix)) continue;
                Preconditions.checkState(listedObjects.isEmpty(), "prefix object should be the first object in the result");
                listedObjects.add(object);
            }
        }
        listedPrefixes.clear();
        listedPrefixes.addAll(prefixes);
        return items.getNextPageToken();
    }

    private Storage.Objects.List createListRequest(String bucketName, String objectNamePrefix, String objectFields, String delimiter, boolean includeTrailingDelimiter, long maxResults) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createListRequest(%s, %s, %s, %s, %d)", bucketName, objectNamePrefix, delimiter, includeTrailingDelimiter, maxResults);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Storage.Objects.List listObject = this.initializeRequest(this.storage.objects().list(bucketName).setPrefix(Strings.emptyToNull(objectNamePrefix)), bucketName);
        if (delimiter != null) {
            listObject.setDelimiter(delimiter);
            listObject.setIncludeTrailingDelimiter(includeTrailingDelimiter);
        }
        listObject.setMaxResults(maxResults <= 0L || maxResults >= this.storageOptions.getMaxListItemsPerCall() ? this.storageOptions.getMaxListItemsPerCall() : maxResults);
        if (!Strings.isNullOrEmpty(objectFields)) {
            listObject.setFields(String.format(LIST_OBJECT_FIELDS_FORMAT, objectFields));
        }
        return listObject;
    }

    private static long getMaxRemainingResults(long maxResults, Collection<String> prefixes, List<StorageObject> objects) {
        if (maxResults <= 0L) {
            return Long.MAX_VALUE;
        }
        long numResults = (long)prefixes.size() + (long)objects.size();
        return maxResults - numResults;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, ListObjectOptions listOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listObjectInfo(%s, %s, %s)", bucketName, objectNamePrefix, listOptions);
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        this.listStorageObjectsAndPrefixes(bucketName, objectNamePrefix, listOptions, true, listedObjects, listedPrefixes);
        return this.getGoogleCloudStorageItemInfos(bucketName, objectNamePrefix, listOptions, listedPrefixes, listedObjects);
    }

    @Override
    public GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, ListObjectOptions listOptions, String pageToken) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listObjectInfoPage(%s, %s, %s, %s)", bucketName, objectNamePrefix, listOptions, pageToken);
        Preconditions.checkArgument(listOptions.getMaxResults() == -1L, "maxResults should be unlimited for 'listObjectInfoPage' call, but was %s", listOptions.getMaxResults());
        Storage.Objects.List listObject = this.createListRequest(bucketName, objectNamePrefix, listOptions.getFields(), listOptions.getDelimiter(), true, listOptions.getMaxResults());
        if (pageToken != null) {
            ((GoogleLogger.Api)logger.atFiner()).log("listObjectInfoPage: next page %s", pageToken);
            listObject.setPageToken(pageToken);
        }
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        String nextPageToken = this.listStorageObjectsAndPrefixesPage(listObject, listOptions, listedObjects, listedPrefixes);
        List<GoogleCloudStorageItemInfo> objectInfos = this.getGoogleCloudStorageItemInfos(bucketName, objectNamePrefix, listOptions, listedPrefixes, listedObjects);
        return new GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo>(objectInfos, nextPageToken);
    }

    private List<GoogleCloudStorageItemInfo> getGoogleCloudStorageItemInfos(String bucketName, String objectNamePrefix, ListObjectOptions listOptions, List<String> listedPrefixes, List<StorageObject> listedObjects) {
        ArrayList<GoogleCloudStorageItemInfo> objectInfos = new ArrayList<GoogleCloudStorageItemInfo>(listedPrefixes.size() + listedObjects.size() + 1);
        if (!(!listOptions.isIncludePrefix() || objectNamePrefix == null || listOptions.getDelimiter() == null || listedPrefixes.isEmpty() && listedObjects.isEmpty() || !listedObjects.isEmpty() && listedObjects.get(0).getName().equals(objectNamePrefix))) {
            objectInfos.add(GoogleCloudStorageItemInfo.createInferredDirectory(new StorageResourceId(bucketName, objectNamePrefix)));
        }
        for (StorageObject obj : listedObjects) {
            objectInfos.add(GoogleCloudStorageImpl.createItemInfoForStorageObject(obj));
        }
        this.handlePrefixes(bucketName, listedPrefixes, objectInfos);
        objectInfos.sort(Comparator.comparing(GoogleCloudStorageItemInfo::getObjectName));
        return objectInfos;
    }

    private void handlePrefixes(String bucketName, List<String> prefixes, List<GoogleCloudStorageItemInfo> objectInfos) {
        for (String prefix : prefixes) {
            objectInfos.add(GoogleCloudStorageItemInfo.createInferredDirectory(new StorageResourceId(bucketName, prefix)));
        }
    }

    public static GoogleCloudStorageItemInfo createItemInfoForBucket(StorageResourceId resourceId, Bucket bucket) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        Preconditions.checkArgument(bucket != null, "bucket must not be null");
        Preconditions.checkArgument(resourceId.isBucket(), "resourceId must be a Bucket. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument(resourceId.getBucketName().equals(bucket.getName()), "resourceId.getBucketName() must equal bucket.getName(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)bucket.getName());
        return GoogleCloudStorageItemInfo.createBucket(resourceId, bucket.getTimeCreated().getValue(), bucket.getUpdated().getValue(), bucket.getLocation(), bucket.getStorageClass());
    }

    public static GoogleCloudStorageItemInfo createItemInfoForStorageObject(StorageObject object) {
        Preconditions.checkNotNull(object, "object must not be null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(object.getBucket()), "object must have a bucket: %s", (Object)object);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(object.getName()), "object must have a name: %s", (Object)object);
        return GoogleCloudStorageImpl.createItemInfoForStorageObject(new StorageResourceId(object.getBucket(), object.getName()), object);
    }

    public static GoogleCloudStorageItemInfo createItemInfoForStorageObject(StorageResourceId resourceId, StorageObject object) {
        Preconditions.checkArgument(resourceId != null, "resourceId must not be null");
        Preconditions.checkArgument(object != null, "object must not be null");
        Preconditions.checkArgument(resourceId.isStorageObject(), "resourceId must be a StorageObject. resourceId: %s", (Object)resourceId);
        Preconditions.checkArgument(resourceId.getBucketName().equals(object.getBucket()), "resourceId.getBucketName() must equal object.getBucket(): '%s' vs '%s'", (Object)resourceId.getBucketName(), (Object)object.getBucket());
        Preconditions.checkArgument(resourceId.getObjectName().equals(object.getName()), "resourceId.getObjectName() must equal object.getName(): '%s' vs '%s'", (Object)resourceId.getObjectName(), (Object)object.getName());
        Map<String, byte[]> decodedMetadata = object.getMetadata() == null ? null : GoogleCloudStorageImpl.decodeMetadata(object.getMetadata());
        byte[] md5Hash = null;
        byte[] crc32c = null;
        if (!Strings.isNullOrEmpty(object.getCrc32c())) {
            crc32c = BaseEncoding.base64().decode(object.getCrc32c());
        }
        if (!Strings.isNullOrEmpty(object.getMd5Hash())) {
            md5Hash = BaseEncoding.base64().decode(object.getMd5Hash());
        }
        return GoogleCloudStorageItemInfo.createObject(resourceId, object.getTimeCreated() == null ? 0L : object.getTimeCreated().getValue(), object.getUpdated() == null ? 0L : object.getUpdated().getValue(), object.getSize() == null ? 0L : object.getSize().longValue(), object.getContentType(), object.getContentEncoding(), decodedMetadata, object.getGeneration() == null ? 0L : object.getGeneration(), object.getMetageneration() == null ? 0L : object.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    @VisibleForTesting
    static Map<String, String> encodeMetadata(Map<String, byte[]> metadata) {
        return Maps.transformValues(metadata, GoogleCloudStorageImpl::encodeMetadataValues);
    }

    @VisibleForTesting
    static Map<String, byte[]> decodeMetadata(Map<String, String> metadata) {
        return Maps.transformValues(metadata, GoogleCloudStorageImpl::decodeMetadataValues);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos(%s)", resourceIds);
        if (resourceIds.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        final ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos = new ConcurrentHashMap<StorageResourceId, GoogleCloudStorageItemInfo>();
        final Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.storage, this.storageOptions.getMaxRequestsPerBatch(), resourceIds.size(), this.storageOptions.getBatchThreads());
        for (final StorageResourceId resourceId : resourceIds) {
            if (resourceId.isRoot()) {
                itemInfos.put(resourceId, GoogleCloudStorageItemInfo.ROOT_INFO);
                continue;
            }
            if (resourceId.isBucket()) {
                batchHelper.queue(this.initializeRequest(this.storage.buckets().get(resourceId.getBucketName()), resourceId.getBucketName()), new JsonBatchCallback<Bucket>(){

                    @Override
                    public void onSuccess(Bucket bucket, HttpHeaders responseHeaders) {
                        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: Successfully fetched bucket: %s for resourceId: %s", (Object)bucket, (Object)resourceId);
                        itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket));
                    }

                    @Override
                    public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                        GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                        if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                            ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: bucket '%s' not found:%n%s", (Object)resourceId.getBucketName(), (Object)jsonError);
                            itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                        } else {
                            innerExceptions.add(new IOException(String.format("Error getting '%s' bucket", resourceId.getBucketName()), cause));
                        }
                    }
                });
                continue;
            }
            String bucketName = resourceId.getBucketName();
            String objectName = resourceId.getObjectName();
            batchHelper.queue(this.initializeRequest(this.storageRequestFactory.objectsGetMetadata(bucketName, objectName), bucketName).setFields(OBJECT_FIELDS), new JsonBatchCallback<StorageObject>(){

                @Override
                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: Successfully fetched object '%s' for resourceId '%s'", (Object)obj, (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                @Override
                public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                    GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfos: object '%s' not found:%n%s", (Object)resourceId, (Object)jsonError);
                        itemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                    } else {
                        innerExceptions.add(new IOException(String.format("Error getting '%s' object", resourceId), cause));
                    }
                }
            });
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkState(itemInfos.containsKey(resourceId), "Somehow missing resourceId '%s' from map: %s", (Object)resourceId, itemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)itemInfos.get(resourceId));
        }
        Preconditions.checkState(sortedItemInfos.size() == resourceIds.size(), "sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, ids: %s", (Object)sortedItemInfos.size(), (Object)resourceIds.size(), sortedItemInfos, resourceIds);
        return sortedItemInfos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("updateItems(%s)", itemInfoList);
        if (itemInfoList.isEmpty()) {
            return new ArrayList<GoogleCloudStorageItemInfo>();
        }
        final ConcurrentHashMap resultItemInfos = new ConcurrentHashMap();
        final Set<IOException> innerExceptions = Sets.newConcurrentHashSet();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.storage, this.storageOptions.getMaxRequestsPerBatch(), itemInfoList.size(), this.storageOptions.getBatchThreads());
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkArgument(!itemInfo.getStorageResourceId().isBucket() && !itemInfo.getStorageResourceId().isRoot(), "Buckets and GCS Root resources are not supported for updateItems");
        }
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            final StorageResourceId resourceId = itemInfo.getStorageResourceId();
            String bucketName = resourceId.getBucketName();
            String objectName = resourceId.getObjectName();
            Map<String, byte[]> originalMetadata = itemInfo.getMetadata();
            Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(originalMetadata);
            Storage.Objects.Patch patch = this.initializeRequest(this.storage.objects().patch(bucketName, objectName, new StorageObject().setMetadata(rewrittenMetadata)), bucketName);
            batchHelper.queue(patch, new JsonBatchCallback<StorageObject>(){

                @Override
                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    ((GoogleLogger.Api)logger.atFiner()).log("updateItems: Successfully updated object '%s' for resourceId '%s'", (Object)obj, (Object)resourceId);
                    resultItemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                @Override
                public void onFailure(GoogleJsonError jsonError, HttpHeaders responseHeaders) {
                    GoogleJsonResponseException cause = GoogleCloudStorageExceptions.createJsonResponseException(jsonError, responseHeaders);
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(cause)) {
                        ((GoogleLogger.Api)logger.atFiner()).log("updateItems: object not found %s:%n%s", (Object)resourceId, (Object)jsonError);
                        resultItemInfos.put(resourceId, GoogleCloudStorageItemInfo.createNotFound(resourceId));
                    } else {
                        innerExceptions.add(new IOException(String.format("Error updating '%s' object", resourceId), cause));
                    }
                }
            });
        }
        batchHelper.flush();
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkState(resultItemInfos.containsKey(itemInfo.getStorageResourceId()), "Missing resourceId '%s' from map: %s", (Object)itemInfo.getStorageResourceId(), resultItemInfos);
            sortedItemInfos.add((GoogleCloudStorageItemInfo)resultItemInfos.get(itemInfo.getStorageResourceId()));
        }
        Preconditions.checkState(sortedItemInfos.size() == itemInfoList.size(), "sortedItemInfos.size() (%s) != resourceIds.size() (%s). infos: %s, updateItemInfos: %s", (Object)sortedItemInfos.size(), (Object)itemInfoList.size(), sortedItemInfos, itemInfoList);
        return sortedItemInfos;
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfo(%s)", resourceId);
        if (resourceId.isRoot()) {
            return GoogleCloudStorageItemInfo.ROOT_INFO;
        }
        GoogleCloudStorageItemInfo itemInfo = null;
        if (resourceId.isBucket()) {
            Bucket bucket = this.getBucket(resourceId.getBucketName());
            if (bucket != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket);
            }
        } else {
            StorageObject object = this.getObject(resourceId);
            if (object != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, object);
            }
        }
        if (itemInfo == null) {
            itemInfo = GoogleCloudStorageItemInfo.createNotFound(resourceId);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("getItemInfo: %s", itemInfo);
        return itemInfo;
    }

    @Override
    public void close() {
        ((GoogleLogger.Api)logger.atFiner()).log("close()");
        try {
            this.backgroundTasksThreadPool.shutdown();
            this.manualBatchingThreadPool.shutdown();
        }
        finally {
            this.backgroundTasksThreadPool = null;
            this.manualBatchingThreadPool = null;
        }
    }

    private Bucket getBucket(String bucketName) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getBucket(%s)", bucketName);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucketName), "bucketName must not be null or empty");
        Storage.Buckets.Get getBucket = this.initializeRequest(this.storage.buckets().get(bucketName), bucketName);
        try {
            return (Bucket)getBucket.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log("getBucket(%s): not found", bucketName);
                return null;
            }
            throw new IOException("Error accessing Bucket " + bucketName, e);
        }
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState(generation != 0L, "Generation should not be 0 for an existing item");
            return generation;
        }
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private StorageObject getObject(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getObject(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        Storage.Objects.Get getObject = this.initializeRequest(this.storageRequestFactory.objectsGetMetadata(bucketName, objectName), bucketName).setFields(OBJECT_FIELDS);
        try {
            return (StorageObject)getObject.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log("getObject(%s): not found", resourceId);
                return null;
            }
            throw new IOException("Error accessing " + resourceId, e);
        }
    }

    private boolean canIgnoreExceptionForEmptyObject(IOException exceptionOnCreate, StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        if (this.errorExtractor.rateLimited(exceptionOnCreate) || this.errorExtractor.internalServerError(exceptionOnCreate) || resourceId.isDirectory() && this.errorExtractor.preconditionNotMet(exceptionOnCreate)) {
            GoogleCloudStorageItemInfo existingInfo;
            int maxWaitMillis = this.storageOptions.getMaxWaitMillisForEmptyObjectCreation();
            BackOff backOff = maxWaitMillis > 0 ? new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(maxWaitMillis).setMaxIntervalMillis(500).setInitialIntervalMillis(100).setMultiplier(1.5).setRandomizationFactor(0.15).build() : BackOff.STOP_BACKOFF;
            long nextSleep = 0L;
            do {
                if (nextSleep > 0L) {
                    try {
                        this.sleeper.sleep(nextSleep);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        nextSleep = -1L;
                    }
                }
                existingInfo = this.getItemInfo(resourceId);
                long l = nextSleep = nextSleep == -1L ? -1L : backOff.nextBackOffMillis();
            } while (!existingInfo.exists() && nextSleep != -1L);
            if (existingInfo.exists() && existingInfo.getSize() == 0L) {
                if (options.isEnsureEmptyObjectsMetadataMatch()) {
                    return existingInfo.metadataEquals(options.getMetadata());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("compose(%s, %s, %s, %s)", bucketName, sources, destination, contentType);
        List<StorageResourceId> sourceIds = Lists.transform(sources, objectName -> new StorageResourceId(bucketName, (String)objectName));
        StorageResourceId destinationId = new StorageResourceId(bucketName, destination);
        CreateObjectOptions options = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setContentType(contentType).setEnsureEmptyObjectsMetadataMatch(false).build();
        this.composeObjects(sourceIds, destinationId, options);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("composeObjects(%s, %s, %s)", sources, destination, options);
        for (StorageResourceId inputId : sources) {
            if (destination.getBucketName().equals(inputId.getBucketName())) continue;
            throw new IOException(String.format("Bucket doesn't match for source '%s' and destination '%s'!", inputId, destination));
        }
        List<ComposeRequest.SourceObjects> sourceObjects = Lists.transform(sources, input -> new ComposeRequest.SourceObjects().setName(input.getObjectName()));
        Storage.Objects.Compose compose = this.initializeRequest(this.storage.objects().compose(destination.getBucketName(), destination.getObjectName(), new ComposeRequest().setSourceObjects(sourceObjects).setDestination(new StorageObject().setContentType(options.getContentType()).setContentEncoding(options.getContentEncoding()).setMetadata(GoogleCloudStorageImpl.encodeMetadata(options.getMetadata())))), destination.getBucketName());
        compose.setIfGenerationMatch(destination.hasGenerationId() ? destination.getGenerationId() : this.getWriteGeneration(destination, true));
        GoogleCloudStorageItemInfo compositeInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(destination, (StorageObject)compose.execute());
        ((GoogleLogger.Api)logger.atFiner()).log("composeObjects() done, returning: %s", compositeInfo);
        return compositeInfo;
    }

    @VisibleForTesting
    <RequestT extends StorageRequest<?>> RequestT initializeRequest(RequestT request, String bucketName) throws IOException {
        if (this.downscopedAccessTokenFn != null) {
            List<AccessBoundary> accessBoundaries = StorageRequestToAccessBoundaryConverter.fromStorageObjectRequest(request);
            String token = this.downscopedAccessTokenFn.apply(accessBoundaries);
            request.getRequestHeaders().setAuthorization("Bearer " + token);
        }
        if (this.storageRequestAuthorizer != null) {
            this.storageRequestAuthorizer.authorize(request);
        }
        return this.configureRequest(request, bucketName);
    }

    <RequestT extends StorageRequest<?>> RequestT configureRequest(RequestT request, String bucketName) {
        this.setRequesterPaysProject(request, bucketName);
        if (request instanceof Storage.Objects.Get || request instanceof Storage.Objects.Insert) {
            this.setEncryptionHeaders(request);
        }
        if (request instanceof Storage.Objects.Rewrite || request instanceof Storage.Objects.Copy) {
            this.setEncryptionHeaders(request);
            this.setDecryptionHeaders(request);
        }
        return request;
    }

    private <RequestT extends StorageRequest<?>> void setEncryptionHeaders(RequestT request) {
        if (this.storageOptions.getEncryptionKey() == null) {
            return;
        }
        request.getRequestHeaders().set("x-goog-encryption-algorithm", Preconditions.checkNotNull(this.storageOptions.getEncryptionAlgorithm(), "encryption algorithm must not be null")).set("x-goog-encryption-key", Preconditions.checkNotNull(this.storageOptions.getEncryptionKey(), "encryption key must not be null").value()).set("x-goog-encryption-key-sha256", Preconditions.checkNotNull(this.storageOptions.getEncryptionKeyHash(), "encryption key hash must not be null").value());
    }

    private <RequestT extends StorageRequest<?>> void setDecryptionHeaders(RequestT request) {
        if (this.storageOptions.getEncryptionKey() == null) {
            return;
        }
        request.getRequestHeaders().set("x-goog-copy-source-encryption-algorithm", Preconditions.checkNotNull(this.storageOptions.getEncryptionAlgorithm(), "encryption algorithm must not be null")).set("x-goog-copy-source-encryption-key", Preconditions.checkNotNull(this.storageOptions.getEncryptionKey(), "encryption key must not be null").value()).set("x-goog-copy-source-encryption-key-sha256", Preconditions.checkNotNull(this.storageOptions.getEncryptionKeyHash(), "encryption key hash must not be null").value());
    }

    private <RequestT extends StorageRequest<?>> void setRequesterPaysProject(RequestT request, String bucketName) {
        if (this.requesterShouldPay(bucketName)) {
            GoogleCloudStorageImpl.setUserProject(request, this.storageOptions.getRequesterPaysOptions().getProjectId());
        }
    }

    private boolean requesterShouldPay(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        switch (this.storageOptions.getRequesterPaysOptions().getMode()) {
            case ENABLED: {
                return true;
            }
            case CUSTOM: {
                return this.storageOptions.getRequesterPaysOptions().getBuckets().contains(bucketName);
            }
            case AUTO: {
                return this.autoBuckets.getUnchecked(bucketName);
            }
        }
        return false;
    }

    private static <RequestT extends StorageRequest<?>> void setUserProject(RequestT request, String projectId) {
        Field userProjectField = request.getClassInfo().getField(USER_PROJECT_FIELD_NAME);
        if (userProjectField != null) {
            request.set(USER_PROJECT_FIELD_NAME, projectId);
        }
    }

    public static interface BackOffFactory {
        public static final BackOffFactory DEFAULT = () -> new RetryBoundedBackOff(new ExponentialBackOff(), 10);

        public BackOff newBackOff();
    }
}

