/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.BetaApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferToDiskThenUpload;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.DefaultBlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.JournalingBlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

@BetaApi
public final class BlobWriteSessionConfigs {
    private BlobWriteSessionConfigs() {
    }

    @BetaApi
    public static DefaultBlobWriteSessionConfig getDefault() {
        return new DefaultBlobWriteSessionConfig(0x1000000);
    }

    @BetaApi
    public static BlobWriteSessionConfig bufferToTempDirThenUpload() throws IOException {
        return BlobWriteSessionConfigs.bufferToDiskThenUpload(Paths.get(System.getProperty("java.io.tmpdir"), "google-cloud-storage"));
    }

    @BetaApi
    public static BufferToDiskThenUpload bufferToDiskThenUpload(Path path) throws IOException {
        return BlobWriteSessionConfigs.bufferToDiskThenUpload(ImmutableList.of(path));
    }

    @BetaApi
    public static BufferToDiskThenUpload bufferToDiskThenUpload(Collection<Path> paths) throws IOException {
        return new BufferToDiskThenUpload(ImmutableList.copyOf(paths), false);
    }

    @BetaApi
    public static JournalingBlobWriteSessionConfig journaling(Collection<Path> paths) {
        return new JournalingBlobWriteSessionConfig(ImmutableList.copyOf(paths), false);
    }

    @BetaApi
    public static ParallelCompositeUploadBlobWriteSessionConfig parallelCompositeUpload() {
        return ParallelCompositeUploadBlobWriteSessionConfig.withDefaults();
    }
}

