/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFutures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.BetaApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.RecoveryFile;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.RecoveryFileManager;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageInternal;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ThroughputMovingWindow;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ThroughputSink;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.WritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.stream.Collector;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@BetaApi
@Immutable
public final class BufferToDiskThenUpload
extends BlobWriteSessionConfig {
    private static final long serialVersionUID = 9059242302276891867L;
    private transient @MonotonicNonNull ImmutableList<Path> paths;
    private final boolean includeLoggingSink;
    private volatile @MonotonicNonNull ArrayList<String> absolutePaths;

    @InternalApi
    BufferToDiskThenUpload(ImmutableList<Path> paths, boolean includeLoggingSink) throws IOException {
        this.paths = paths;
        this.includeLoggingSink = includeLoggingSink;
    }

    @InternalApi
    @VisibleForTesting
    BufferToDiskThenUpload withIncludeLoggingSink() throws IOException {
        return new BufferToDiskThenUpload(this.paths, true);
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        Duration window = Duration.ofMinutes(10L);
        RecoveryFileManager recoveryFileManager = RecoveryFileManager.of(this.paths, this.getRecoverVolumeSinkFactory(clock, window));
        ThroughputSink gcs = ThroughputSink.windowed(ThroughputMovingWindow.of(window), clock);
        gcs = this.includeLoggingSink ? ThroughputSink.tee(ThroughputSink.logged("gcs", clock), gcs) : gcs;
        return new Factory(recoveryFileManager, clock, gcs);
    }

    private RecoveryFileManager.RecoveryVolumeSinkFactory getRecoverVolumeSinkFactory(Clock clock, Duration window) {
        return path -> {
            ThroughputSink windowed = ThroughputSink.windowed(ThroughputMovingWindow.of(window), clock);
            if (this.includeLoggingSink) {
                return ThroughputSink.tee(ThroughputSink.logged(path.toAbsolutePath().toString(), clock), windowed);
            }
            return windowed;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.absolutePaths == null) {
            BufferToDiskThenUpload bufferToDiskThenUpload = this;
            synchronized (bufferToDiskThenUpload) {
                if (this.absolutePaths == null) {
                    this.absolutePaths = this.paths.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collector.of(ArrayList::new, ArrayList::add, (left, right) -> {
                        left.addAll(right);
                        return left;
                    }, new Collector.Characteristics[0]));
                }
            }
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.paths = this.absolutePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
    }

    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private final RecoveryFileManager recoveryFileManager;
        private final Clock clock;
        private final ThroughputSink gcs;

        private Factory(RecoveryFileManager recoveryFileManager, Clock clock, ThroughputSink gcs) {
            this.recoveryFileManager = recoveryFileManager;
            this.clock = clock;
            this.gcs = gcs;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal storage, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, Conversions.Decoder<WriteObjectResponse, BlobInfo> d) {
            return new WriteToFileThenUpload(storage, info, opts, this.recoveryFileManager.newRecoveryFile(info));
        }

        private final class WriteToFileThenUpload
        implements WritableByteChannelSession<WritableByteChannel, BlobInfo> {
            private final StorageInternal storage;
            private final BlobInfo info;
            private final UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts;
            private final RecoveryFile rf;
            private final SettableApiFuture<BlobInfo> result;

            private WriteToFileThenUpload(StorageInternal storage, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, RecoveryFile rf) {
                this.info = info;
                this.opts = opts;
                this.rf = rf;
                this.storage = storage;
                this.result = SettableApiFuture.create();
            }

            @Override
            public ApiFuture<WritableByteChannel> openAsync() {
                try {
                    ApiFuture<WritableByteChannel> f = ApiFutures.immediateFuture(this.rf.writer());
                    return ApiFutures.transform(f, x$0 -> new Flusher((WritableByteChannel)x$0), MoreExecutors.directExecutor());
                }
                catch (IOException e) {
                    throw StorageException.coalesce(e);
                }
            }

            @Override
            public ApiFuture<BlobInfo> getResult() {
                return this.result;
            }

            private final class Flusher
            implements WritableByteChannel {
                private final WritableByteChannel delegate;

                private Flusher(WritableByteChannel delegate) {
                    this.delegate = delegate;
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    return this.delegate.write(src);
                }

                @Override
                public boolean isOpen() {
                    return this.delegate.isOpen();
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    try (RecoveryFile rf = WriteToFileThenUpload.this.rf;){
                        Path path = rf.getPath();
                        long size = Files.size(path);
                        ThroughputSink.computeThroughput(Factory.this.clock, Factory.this.gcs, size, () -> {
                            BlobInfo blob = WriteToFileThenUpload.this.storage.internalCreateFrom(path, WriteToFileThenUpload.this.info, WriteToFileThenUpload.this.opts);
                            WriteToFileThenUpload.this.result.set(blob);
                        });
                    }
                    catch (StorageException | IOException e) {
                        WriteToFileThenUpload.this.result.setException(e);
                        throw e;
                    }
                }
            }
        }
    }
}

