/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFutures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferHandle;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.DefaultBufferedWritableByteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GapicUnbufferedWritableByteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Hasher;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.RecoveryFile;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableWrite;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.SyncAndUploadUnbufferedWritableByteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.WriteCtx;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.WriteFlushStrategy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.QueryWriteStatusRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.QueryWriteStatusResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectResponse;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

final class GapicWritableByteChannelSessionBuilder {
    private static final int DEFAULT_BUFFER_CAPACITY = 0x1000000;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private Hasher hasher;
    private ByteStringStrategy byteStringStrategy;

    GapicWritableByteChannelSessionBuilder(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write) {
        this.write = write;
        this.hasher = Hasher.noop();
        this.byteStringStrategy = ByteStringStrategy.copy();
    }

    GapicWritableByteChannelSessionBuilder setHasher(Hasher hasher) {
        this.hasher = Objects.requireNonNull(hasher, "hasher must be non null");
        return this;
    }

    GapicWritableByteChannelSessionBuilder setByteStringStrategy(ByteStringStrategy byteStringStrategy) {
        this.byteStringStrategy = Objects.requireNonNull(byteStringStrategy, "byteStringStrategy must be non null");
        return this;
    }

    DirectUploadBuilder direct() {
        return new DirectUploadBuilder();
    }

    ResumableUploadBuilder resumable() {
        return new ResumableUploadBuilder();
    }

    JournalingResumableUploadBuilder journaling() {
        return new JournalingResumableUploadBuilder();
    }

    private <StartT, RequestFactoryT extends WriteCtx.WriteObjectRequestBuilderFactory> BiFunction<StartT, SettableApiFuture<WriteObjectResponse>, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel> bindFunction(WriteFlushStrategy.FlusherFactory flusherFactory, Function<StartT, RequestFactoryT> f) {
        ByteStringStrategy boundStrategy = this.byteStringStrategy;
        Hasher boundHasher = this.hasher;
        return (start, resultFuture) -> new GapicUnbufferedWritableByteChannel<WriteCtx.WriteObjectRequestBuilderFactory>((SettableApiFuture<WriteObjectResponse>)resultFuture, new ChunkSegmenter(boundHasher, boundStrategy, 0x200000), (WriteCtx.WriteObjectRequestBuilderFactory)f.apply(start), flusherFactory);
    }

    final class DirectUploadBuilder {
        DirectUploadBuilder() {
        }

        UnbufferedDirectUploadBuilder unbuffered() {
            return new UnbufferedDirectUploadBuilder();
        }

        BufferedDirectUploadBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x1000000));
        }

        BufferedDirectUploadBuilder buffered(ByteBuffer byteBuffer) {
            return this.buffered(BufferHandle.handleOf(byteBuffer));
        }

        BufferedDirectUploadBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedDirectUploadBuilder(bufferHandle);
        }

        final class UnbufferedDirectUploadBuilder {
            private WriteObjectRequest req;

            UnbufferedDirectUploadBuilder() {
            }

            UnbufferedDirectUploadBuilder setRequest(WriteObjectRequest req) {
                this.req = Objects.requireNonNull(req, "req must be non null");
                return this;
            }

            UnbufferedWritableByteChannelSession<WriteObjectResponse> build() {
                return new ChannelSession.UnbufferedWriteSession(ApiFutures.immediateFuture(Objects.requireNonNull(this.req, "req must be non null")), GapicWritableByteChannelSessionBuilder.this.bindFunction(WriteFlushStrategy.fsyncOnClose(GapicWritableByteChannelSessionBuilder.this.write), WriteCtx.WriteObjectRequestBuilderFactory::simple).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }

        final class BufferedDirectUploadBuilder {
            private final BufferHandle bufferHandle;
            private WriteObjectRequest req;

            BufferedDirectUploadBuilder(BufferHandle bufferHandle) {
                this.bufferHandle = bufferHandle;
            }

            BufferedDirectUploadBuilder setRequest(WriteObjectRequest req) {
                this.req = Objects.requireNonNull(req, "req must be non null");
                return this;
            }

            BufferedWritableByteChannelSession<WriteObjectResponse> build() {
                return new ChannelSession.BufferedWriteSession(ApiFutures.immediateFuture(Objects.requireNonNull(this.req, "req must be non null")), GapicWritableByteChannelSessionBuilder.this.bindFunction(WriteFlushStrategy.fsyncOnClose(GapicWritableByteChannelSessionBuilder.this.write), WriteCtx.WriteObjectRequestBuilderFactory::simple).andThen(c -> new DefaultBufferedWritableByteChannel(this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }
    }

    final class ResumableUploadBuilder {
        private Retrying.RetryingDependencies deps = Retrying.RetryingDependencies.attemptOnce();
        private ResultRetryAlgorithm<?> alg = Retrying.neverRetry();
        private boolean fsyncEvery = true;

        ResumableUploadBuilder() {
        }

        ResumableUploadBuilder withRetryConfig(Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg) {
            this.deps = Objects.requireNonNull(deps, "deps must be non null");
            this.alg = Objects.requireNonNull(alg, "alg must be non null");
            return this;
        }

        @InternalApi
        ResumableUploadBuilder setFsyncEvery(boolean fsyncEvery) {
            this.fsyncEvery = fsyncEvery;
            return this;
        }

        UnbufferedResumableUploadBuilder unbuffered() {
            return new UnbufferedResumableUploadBuilder();
        }

        BufferedResumableUploadBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x1000000));
        }

        BufferedResumableUploadBuilder buffered(ByteBuffer byteBuffer) {
            return this.buffered(BufferHandle.handleOf(byteBuffer));
        }

        BufferedResumableUploadBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedResumableUploadBuilder(bufferHandle);
        }

        final class UnbufferedResumableUploadBuilder {
            private ApiFuture<ResumableWrite> start;

            UnbufferedResumableUploadBuilder() {
            }

            UnbufferedResumableUploadBuilder setStartAsync(ApiFuture<ResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            UnbufferedWritableByteChannelSession<WriteObjectResponse> build() {
                return new ChannelSession.UnbufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), GapicWritableByteChannelSessionBuilder.this.bindFunction(ResumableUploadBuilder.this.fsyncEvery ? WriteFlushStrategy.fsyncEveryFlush(GapicWritableByteChannelSessionBuilder.this.write, ResumableUploadBuilder.this.deps, ResumableUploadBuilder.this.alg, Retrying::newCallContext) : WriteFlushStrategy.fsyncOnClose(GapicWritableByteChannelSessionBuilder.this.write), ResumableWrite::identity).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }

        final class BufferedResumableUploadBuilder {
            private final BufferHandle bufferHandle;
            private ApiFuture<ResumableWrite> start;

            BufferedResumableUploadBuilder(BufferHandle bufferHandle) {
                this.bufferHandle = bufferHandle;
            }

            BufferedResumableUploadBuilder setStartAsync(ApiFuture<ResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            BufferedWritableByteChannelSession<WriteObjectResponse> build() {
                return new ChannelSession.BufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), GapicWritableByteChannelSessionBuilder.this.bindFunction(ResumableUploadBuilder.this.fsyncEvery ? WriteFlushStrategy.fsyncEveryFlush(GapicWritableByteChannelSessionBuilder.this.write, ResumableUploadBuilder.this.deps, ResumableUploadBuilder.this.alg, Retrying::newCallContext) : WriteFlushStrategy.fsyncOnClose(GapicWritableByteChannelSessionBuilder.this.write), ResumableWrite::identity).andThen(c -> new DefaultBufferedWritableByteChannel(this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }
    }

    final class JournalingResumableUploadBuilder {
        private Retrying.RetryingDependencies deps = Retrying.RetryingDependencies.attemptOnce();
        private ResultRetryAlgorithm<?> alg = Retrying.neverRetry();
        private BufferHandle bufferHandle;
        private BufferHandle recoveryBuffer;
        private RecoveryFile recoveryFile;
        private UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> query;

        JournalingResumableUploadBuilder() {
        }

        JournalingResumableUploadBuilder withRetryConfig(Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> query) {
            this.deps = Objects.requireNonNull(deps, "deps must be non null");
            this.alg = Objects.requireNonNull(alg, "alg must be non null");
            this.query = Objects.requireNonNull(query, "query must be non null");
            return this;
        }

        JournalingResumableUploadBuilder withBuffer(BufferHandle bufferHandle) {
            this.bufferHandle = Objects.requireNonNull(bufferHandle, "bufferHandle must be non null");
            return this;
        }

        JournalingResumableUploadBuilder withRecoveryBuffer(BufferHandle bufferHandle) {
            this.recoveryBuffer = Objects.requireNonNull(bufferHandle, "bufferHandle must be non null");
            return this;
        }

        JournalingResumableUploadBuilder withRecoveryFile(RecoveryFile recoveryFile) {
            this.recoveryFile = Objects.requireNonNull(recoveryFile, "recoveryFile must be non null");
            return this;
        }

        BuildableJournalingResumableUploadBuilder setStartAsync(ApiFuture<WriteCtx<ResumableWrite>> start) {
            Objects.requireNonNull(start, "start must be non null");
            return new BuildableJournalingResumableUploadBuilder(start);
        }

        final class BuildableJournalingResumableUploadBuilder {
            private final ApiFuture<WriteCtx<ResumableWrite>> start;

            private BuildableJournalingResumableUploadBuilder(ApiFuture<WriteCtx<ResumableWrite>> start) {
                this.start = start;
            }

            BufferedWritableByteChannelSession<WriteObjectResponse> build() {
                return new ChannelSession.BufferedWriteSession<WriteCtx<ResumableWrite>, WriteObjectResponse>(Objects.requireNonNull(this.start, "start must be non null"), this.bindFunction().andThen(c -> new DefaultBufferedWritableByteChannel(JournalingResumableUploadBuilder.this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }

            private BiFunction<WriteCtx<ResumableWrite>, SettableApiFuture<WriteObjectResponse>, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel> bindFunction() {
                Retrying.RetryingDependencies deps = JournalingResumableUploadBuilder.this.deps;
                ResultRetryAlgorithm alg = JournalingResumableUploadBuilder.this.alg;
                BufferHandle recoveryBuffer = JournalingResumableUploadBuilder.this.recoveryBuffer;
                RecoveryFile recoveryFile = JournalingResumableUploadBuilder.this.recoveryFile;
                UnaryCallable query = JournalingResumableUploadBuilder.this.query;
                ByteStringStrategy boundStrategy = GapicWritableByteChannelSessionBuilder.this.byteStringStrategy;
                Hasher boundHasher = GapicWritableByteChannelSessionBuilder.this.hasher;
                return (writeCtx, resultFuture) -> new SyncAndUploadUnbufferedWritableByteChannel(GapicWritableByteChannelSessionBuilder.this.write, query, (SettableApiFuture<WriteObjectResponse>)resultFuture, new ChunkSegmenter(boundHasher, boundStrategy, 0x200000), deps, alg, (WriteCtx<ResumableWrite>)writeCtx, recoveryFile, recoveryBuffer);
            }
        }
    }
}

