/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.InternalLogId;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ServiceConfigUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.util.MultiChildLoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.ClusterManagerLoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsNameResolver;
import java.util.HashMap;
import java.util.Map;

class ClusterManagerLoadBalancer
extends MultiChildLoadBalancer {
    private final XdsLogger logger;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        super(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("cluster_manager-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    protected Map<Object, ServiceConfigUtil.PolicySelection> getPolicySelectionMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<Object, ServiceConfigUtil.PolicySelection> newChildPolicies = new HashMap<Object, ServiceConfigUtil.PolicySelection>(config.childPolicies);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", newChildPolicies.keySet());
        return newChildPolicies;
    }

    @Override
    protected LoadBalancer.SubchannelPicker getSubchannelPicker(final Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        return new LoadBalancer.SubchannelPicker(){

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                String clusterName = args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                LoadBalancer.SubchannelPicker childPicker = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                if (childPicker == null) {
                    return LoadBalancer.PickResult.withError(Status.UNAVAILABLE.withDescription("CDS encountered error: unable to find available subchannel for cluster " + clusterName));
                }
                return childPicker.pickSubchannel(args);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("pickers", childPickers).toString();
            }
        };
    }
}

