/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.fs.gcs.CoopLockFsck;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationType;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecord;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecords;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecordsDao;
import com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.gcsio.cooplock.DeleteOperation;
import com.google.cloud.hadoop.gcsio.cooplock.RenameOperation;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoopLockRepairIntegrationTest {
    private static final Gson GSON = CoopLockRecordsDao.createGson();
    private static final Duration COOP_LOCK_TIMEOUT = Duration.ofSeconds(30L);
    private static final String OPERATION_FILENAME_PATTERN_FORMAT = "[0-9]{8}T[0-9]{6}\\.[0-9]{3}Z_%s_[a-z0-9\\-]+";
    private static GoogleCloudStorageOptions gcsOptions;
    private static RetryHttpInitializer httpRequestInitializer;
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsfsIHelper;

    @BeforeClass
    public static void before() throws Throwable {
        Credential credential = (Credential)Preconditions.checkNotNull((Object)GoogleCloudStorageTestHelper.getCredential(), (Object)"credential must not be null");
        gcsOptions = GoogleCloudStorageTestHelper.getStandardOptionBuilder().build();
        httpRequestInitializer = new RetryHttpInitializer(credential, gcsOptions.toRetryHttpInitializerOptions());
        GoogleCloudStorageFileSystem gcsfs = new GoogleCloudStorageFileSystem(credential, GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(true).setCloudStorageOptions(gcsOptions).build());
        gcsfsIHelper = new GoogleCloudStorageFileSystemIntegrationHelper(gcsfs);
        gcsfsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() throws Throwable {
        gcsfsIHelper.afterAllTests();
        GoogleCloudStorageFileSystem gcsfs = CoopLockRepairIntegrationTest.gcsfsIHelper.gcsfs;
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + CoopLockRepairIntegrationTest.gcsfsIHelper.sharedBucketName1))).isFalse();
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + CoopLockRepairIntegrationTest.gcsfsIHelper.sharedBucketName2))).isFalse();
    }

    @Test
    public void emptyArgs() {
        String[] args = new String[]{};
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CoopLockFsck.main((String[])args));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"No arguments are specified");
    }

    @Test
    public void helpCommand() throws Exception {
        CoopLockFsck.main((String[])new String[]{"--help"});
    }

    @Test
    public void validRepairCommand_withoutBucketParameter() {
        String[] args = new String[]{"--check"};
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CoopLockFsck.main((String[])args));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"2 arguments should be specified");
    }

    @Test
    public void validRepairCommand_withoutBucketAndOperationIdParameters() {
        String[] args = new String[]{"--rollBack"};
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CoopLockFsck.main((String[])args));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"3 arguments should be specified");
    }

    @Test
    public void validRepairCommand_withoutOperationIdParameter() {
        String[] args = new String[]{"--rollForward", "gs://bucket"};
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CoopLockFsck.main((String[])args));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"3 arguments should be specified");
    }

    @Test
    public void validRepairCommand_withInvalidBucketParameter() {
        String[] args = new String[]{"--rollBack", "bucket", "operation-id"};
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CoopLockFsck.main((String[])args));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"bucket parameter should have 'gs://' scheme");
    }

    @Test
    public void invalidRepairCommand_withValidParameter() {
        String[] args = new String[]{"--invalidCommand", "gs://bucket", "operation-id"};
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CoopLockFsck.main((String[])args));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Unknown --invalidCommand command");
    }

    @Test
    public void noOperations_checkSucceeds() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-no-op-check-succeeds");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        fsck.run(new String[]{"--check", "gs://" + bucketName});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve("_lock/"))).isFalse();
    }

    @Test
    public void failedDirectoryDelete_checkSucceeds() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-delete-check-failed");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        CoopLockRepairIntegrationTest.failDeleteOperation(gcsFsOptions, bucketName, dirUri);
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        fsck.run(new String[]{"--check", "gs://" + bucketName});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(3);
        Truth8.assertThat(CoopLockRepairIntegrationTest.matchFile(lockFiles, "all\\.lock")).isNotNull();
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI lockFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.lock").get();
        URI logFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).setLockExpiration(null)).isEqualTo((Object)new DeleteOperation().setLockExpiration(null).setResource(dirUri.toString()));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(dirUri.resolve(fileName) + "\n" + dirUri + "\n"));
    }

    @Test
    public void failedDirectoryDelete_noLockFile_checkSucceeds() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        CoopLockRepairIntegrationTest.failDeleteOperation(gcsFsOptions, bucketName, dirUri);
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        List lockFile = (List)gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).filter(p -> !p.toString().endsWith("/all.lock") && p.toString().endsWith(".lock")).collect(ImmutableList.toImmutableList());
        gcsFs.delete((URI)Iterables.getOnlyElement((Iterable)lockFile), false);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        fsck.run(new String[]{"--check", "gs://" + bucketName});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        Truth8.assertThat(CoopLockRepairIntegrationTest.matchFile(lockFiles, "all\\.lock")).isNotNull();
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI logFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log").get();
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(dirUri.resolve(fileName) + "\n" + dirUri + "\n"));
    }

    @Test
    public void failedDirectoryDelete_noLogFile_checkSucceeds() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        CoopLockRepairIntegrationTest.failDeleteOperation(gcsFsOptions, bucketName, dirUri);
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        List logFile = (List)gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).filter(p -> p.toString().endsWith(".log")).collect(ImmutableList.toImmutableList());
        gcsFs.delete((URI)Iterables.getOnlyElement((Iterable)logFile), false);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        fsck.run(new String[]{"--check", "gs://" + bucketName});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        Truth8.assertThat(CoopLockRepairIntegrationTest.matchFile(lockFiles, "all\\.lock")).isNotNull();
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        Truth8.assertThat(CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log")).isEmpty();
    }

    @Test
    public void failedDirectoryDelete_rollForward_withWrongId_fails() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-delete-fwd-fail-bad-id");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        CoopLockRepairIntegrationTest.failDeleteOperation(gcsFsOptions, bucketName, dirUri);
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> fsck.run(new String[]{"--rollForward", "gs://" + bucketName, "wrong-op-id"}));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"wrong-op-id operation not found");
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(3);
        Truth8.assertThat(CoopLockRepairIntegrationTest.matchFile(lockFiles, "all\\.lock")).isNotNull();
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI lockFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.lock").get();
        URI logFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).setLockExpiration(null)).isEqualTo((Object)new DeleteOperation().setLockExpiration(null).setResource(dirUri.toString()));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(dirUri.resolve(fileName) + "\n" + dirUri + "\n"));
    }

    @Test
    public void failedDirectoryDelete_rollForward_withCorrectId_succeeds() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-delete-fwd-fail-id");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        CoopLockRepairIntegrationTest.failDeleteOperation(gcsFsOptions, bucketName, dirUri);
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        FileInfo lockInfo = gcsFs.getFileInfo(bucketUri.resolve("_lock/all.lock"));
        String locks = new String((byte[])lockInfo.getAttributes().get("lock"), StandardCharsets.UTF_8);
        CoopLockRecords lockRecords = (CoopLockRecords)GSON.fromJson(locks, CoopLockRecords.class);
        String operationId = ((CoopLockRecord)Iterables.getOnlyElement((Iterable)lockRecords.getLocks())).getOperationId();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        Uninterruptibles.sleepUninterruptibly((Duration)COOP_LOCK_TIMEOUT);
        fsck.run(new String[]{"--rollForward", "gs://" + bucketName, operationId});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isFalse();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI lockFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.lock").get();
        URI logFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).setLockExpiration(null)).isEqualTo((Object)new DeleteOperation().setLockExpiration(null).setResource(dirUri.toString()));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(dirUri.resolve(fileName) + "\n" + dirUri + "\n"));
    }

    @Test
    public void successfulDirectoryDelete_rollForward() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        gcsFs.delete(dirUri, true);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isFalse();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        fsck.run(new String[]{"--rollForward", "gs://" + bucketName, "all"});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isFalse();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI lockFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.lock").get();
        URI logFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).setLockExpiration(null)).isEqualTo((Object)new DeleteOperation().setLockExpiration(null).setResource(dirUri.toString()));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(dirUri.resolve(fileName) + "\n" + dirUri + "\n"));
    }

    @Test
    public void failedDirectoryRename_noLogFile_successfullyRepaired() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirName = "rename_" + UUID.randomUUID();
        String fileName = "file";
        URI srcDirUri = bucketUri.resolve(dirName + "_src/");
        URI dstDirUri = bucketUri.resolve(dirName + "_dst/");
        gcsfsIHelper.writeTextFile(bucketName, srcDirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        CoopLockRepairIntegrationTest.failRenameOperation(srcDirUri, dstDirUri, gcsFsOptions, r -> "POST".equals(r.getRequestMethod()) && r.getUrl().toString().contains(".log") && !r.getUrl().toString().contains("all.log"));
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri.resolve(fileName))).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri.resolve(fileName))).isFalse();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        Uninterruptibles.sleepUninterruptibly((Duration)COOP_LOCK_TIMEOUT);
        fsck.run(new String[]{"--rollBack", "gs://" + bucketName, "all"});
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri.resolve(fileName))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri.resolve(fileName))).isTrue();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(1);
        String filenameFormat = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.RENAME);
        URI lockFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenameFormat + "\\.lock").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((RenameOperation)GSON.fromJson(lockContent, RenameOperation.class)).setLockExpiration(null)).isEqualTo((Object)new RenameOperation().setLockExpiration(null).setSrcResource(srcDirUri.toString()).setDstResource(dstDirUri.toString()).setCopySucceeded(false));
        Truth8.assertThat(CoopLockRepairIntegrationTest.matchFile(lockFiles, filenameFormat + "\\.log")).isEmpty();
    }

    @Test
    public void failedDirectoryRename_successfullyRolledForward_afterFailedCopy() throws Exception {
        CoopLockRepairIntegrationTest.failedDirectoryRename_successfullyRepaired("--rollForward", true);
    }

    @Test
    public void failedDirectoryRename_successfullyRolledBack_afterFailedCopy() throws Exception {
        CoopLockRepairIntegrationTest.failedDirectoryRename_successfullyRepaired("--rollBack", true);
    }

    @Test
    public void failedDirectoryRename_successfullyRolledForward_afterFailedDelete() throws Exception {
        CoopLockRepairIntegrationTest.failedDirectoryRename_successfullyRepaired("--rollForward", false);
    }

    @Test
    public void failedDirectoryRename_successfullyRolledBack_afterFailedDelete() throws Exception {
        CoopLockRepairIntegrationTest.failedDirectoryRename_successfullyRepaired("--rollBack", false);
    }

    private static void failedDirectoryRename_successfullyRepaired(String command, boolean failCopy) throws Exception {
        String commandSuffix = Ascii.toLowerCase((String)command).replace("--roll", "");
        String bucketName = gcsfsIHelper.createUniqueBucket(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirName = "rename_" + UUID.randomUUID();
        String fileName = "file";
        URI srcDirUri = bucketUri.resolve(dirName + "_src/");
        URI dstDirUri = bucketUri.resolve(dirName + "_dst/");
        gcsfsIHelper.writeTextFile(bucketName, srcDirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        Predicate<HttpRequest> failPredicate = failCopy ? r -> "POST".equals(r.getRequestMethod()) && r.getUrl().toString().contains("/copyTo/") : r -> "DELETE".equals(r.getRequestMethod()) && r.getUrl().toString().contains("/b/" + bucketName + "/o/");
        CoopLockRepairIntegrationTest.failRenameOperation(srcDirUri, dstDirUri, gcsFsOptions, failPredicate);
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri.resolve(fileName))).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri.resolve(fileName))).isEqualTo((Object)(!failCopy ? 1 : 0));
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        Uninterruptibles.sleepUninterruptibly((Duration)COOP_LOCK_TIMEOUT);
        fsck.run(new String[]{command, "gs://" + bucketName, "all"});
        URI deletedDirUri = "--rollForward".equals(command) ? srcDirUri : dstDirUri;
        URI repairedDirUri = "--rollForward".equals(command) ? dstDirUri : srcDirUri;
        Truth.assertThat((Boolean)gcsFs.exists(deletedDirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(deletedDirUri.resolve(fileName))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(repairedDirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(repairedDirUri.resolve(fileName))).isTrue();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        String filenameFormat = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.RENAME);
        URI lockFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenameFormat + "\\.lock").get();
        URI logFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenameFormat + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((RenameOperation)GSON.fromJson(lockContent, RenameOperation.class)).setLockExpiration(null)).isEqualTo((Object)new RenameOperation().setLockExpiration(null).setSrcResource(srcDirUri.toString()).setDstResource(dstDirUri.toString()).setCopySucceeded("--rollForward".equals(command)));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)String.format("{\"src\":\"%s\",\"dst\":\"%s\"}\n", srcDirUri.resolve(fileName), dstDirUri.resolve(fileName)));
    }

    private static void failRenameOperation(URI srcDirUri, URI dstDirUri, GoogleCloudStorageFileSystemOptions options, Predicate<HttpRequest> failPredicate) throws IOException {
        HttpRequestInitializer failingRequestInitializer = CoopLockRepairIntegrationTest.newFailingRequestInitializer(failPredicate);
        GoogleCloudStorageFileSystem failingGcsFs = CoopLockRepairIntegrationTest.newGcsFs(options, failingRequestInitializer);
        Exception e = (Exception)Assert.assertThrows(Exception.class, () -> failingGcsFs.rename(srcDirUri, dstDirUri));
        Truth.assertThat((Throwable)e).hasCauseThat().hasCauseThat().hasMessageThat().endsWith("Injected failure");
    }

    @Test
    public void failedDirectoryDelete_successfullyRolledForward() throws Exception {
        CoopLockRepairIntegrationTest.failedDirectoryDelete_successfullyRepaired("--rollForward");
    }

    @Test
    public void failedDirectoryDelete_successfullyRolledBack() throws Exception {
        CoopLockRepairIntegrationTest.failedDirectoryDelete_successfullyRepaired("--rollBack");
    }

    private static void failedDirectoryDelete_successfullyRepaired(String command) throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-delete-" + Ascii.toLowerCase((String)command).replace("--roll", "") + "-failed");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockRepairIntegrationTest.newGcsFsOptions();
        CoopLockRepairIntegrationTest.failDeleteOperation(gcsFsOptions, bucketName, dirUri);
        GoogleCloudStorageFileSystem gcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isTrue();
        CoopLockFsck fsck = new CoopLockFsck();
        fsck.setConf(CoopLockRepairIntegrationTest.getTestConfiguration());
        Uninterruptibles.sleepUninterruptibly((Duration)COOP_LOCK_TIMEOUT);
        fsck.run(new String[]{command, "gs://" + bucketName, "all"});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isEqualTo((Object)(!"--rollForward".equals(command) ? 1 : 0));
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isEqualTo((Object)(!"--rollForward".equals(command) ? 1 : 0));
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize("--rollForward".equals(command) ? 2 : 3);
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI lockFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.lock").get();
        URI logFileUri = CoopLockRepairIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).setLockExpiration(null)).isEqualTo((Object)new DeleteOperation().setLockExpiration(null).setResource(dirUri.toString()));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(dirUri.resolve(fileName) + "\n" + dirUri + "\n"));
    }

    private static void failDeleteOperation(GoogleCloudStorageFileSystemOptions gcsFsOptions, String bucketName, URI dirUri) throws Exception {
        HttpRequestInitializer failingRequestInitializer = CoopLockRepairIntegrationTest.newFailingRequestInitializer(request -> "DELETE".equals(request.getRequestMethod()) && request.getUrl().toString().contains("/b/" + bucketName + "/o/"));
        GoogleCloudStorageFileSystem failingGcsFs = CoopLockRepairIntegrationTest.newGcsFs(gcsFsOptions, failingRequestInitializer);
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> failingGcsFs.delete(dirUri, true));
        Truth.assertThat((Throwable)e).hasCauseThat().hasCauseThat().hasMessageThat().endsWith("Injected failure");
    }

    private static HttpRequestInitializer newFailingRequestInitializer(Predicate<HttpRequest> failurePredicate) {
        return request -> {
            httpRequestInitializer.initialize(request);
            HttpExecuteInterceptor executeInterceptor = (HttpExecuteInterceptor)Preconditions.checkNotNull((Object)request.getInterceptor());
            request.setInterceptor(interceptedRequest -> {
                executeInterceptor.intercept(interceptedRequest);
                if (failurePredicate.test(interceptedRequest)) {
                    throw new RuntimeException("Injected failure");
                }
            });
        };
    }

    private static Configuration getTestConfiguration() {
        Configuration conf = new Configuration();
        conf.set("fs.gs.impl", GoogleHadoopFileSystem.class.getName());
        conf.setBoolean("fs.gs" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), true);
        conf.setLong(GoogleHadoopFileSystemConfiguration.GCS_COOPERATIVE_LOCKING_EXPIRATION_TIMEOUT_MS.getKey(), COOP_LOCK_TIMEOUT.toMillis());
        TestConfiguration testConf = TestConfiguration.getInstance();
        conf.set(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey(), testConf.getProjectId());
        if (testConf.getServiceAccount() != null && testConf.getPrivateKeyFile() != null) {
            conf.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX.getKey(), testConf.getServiceAccount());
            conf.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX.getKey(), testConf.getPrivateKeyFile());
        }
        return conf;
    }

    private static Optional<URI> matchFile(List<URI> files, String pattern) {
        return files.stream().filter(f -> f.toString().matches("^gs://.*/" + pattern + "$")).findAny();
    }

    private static GoogleCloudStorageFileSystemOptions newGcsFsOptions() {
        CooperativeLockingOptions coopLockOptions = CooperativeLockingOptions.builder().setLockExpirationTimeoutMilli(COOP_LOCK_TIMEOUT.toMillis()).build();
        return GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(gcsOptions.toBuilder().setCooperativeLockingOptions(coopLockOptions).build()).setCooperativeLockingEnabled(true).build();
    }

    private static GoogleCloudStorageFileSystem newGcsFs(GoogleCloudStorageFileSystemOptions gcsFsOptions, HttpRequestInitializer requestInitializer) throws IOException {
        return new GoogleCloudStorageFileSystem(o -> new GoogleCloudStorageImpl(o, requestInitializer), gcsFsOptions);
    }
}

