/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.cloud.hadoop.fs.gcs.GhfsStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestHelper;
import com.google.cloud.hadoop.fs.gcs.TestUtils;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageStatistics;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;

public class GoogleCloudStorageStatisticsTest {
    private GoogleJsonResponseException accessDenied;
    private GoogleJsonResponseException statusOk;
    private GoogleHadoopFileSystem myGhfs;
    private final ApiErrorExtractor errorExtractor = ApiErrorExtractor.INSTANCE;

    @Before
    public void setUp() throws Exception {
        this.myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        this.accessDenied = GoogleCloudStorageStatisticsTest.googleJsonResponseException(403, "Forbidden", "Forbidden");
        this.statusOk = GoogleCloudStorageStatisticsTest.googleJsonResponseException(200, "A reason", "ok");
    }

    @Test
    public void gcs_request_count_status_metrics() throws Exception {
        GhfsStorageStatistics stats = TestUtils.getStorageStatistics();
        this.mockStatusCode(429);
        TestUtils.verifyCounter(stats, GoogleCloudStorageStatistics.GCS_REQUEST_COUNT, 1);
    }

    @Test
    public void gcs_client_429_status_metrics() throws Exception {
        GhfsStorageStatistics stats = TestUtils.getStorageStatistics();
        this.mockStatusCode(429);
        TestUtils.verifyCounterNotZero(stats, GoogleCloudStorageStatistics.GCS_CLIENT_RATE_LIMIT_COUNT);
    }

    @Test
    public void testAccessDenied() {
        GhfsStorageStatistics stats = TestUtils.getStorageStatistics();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied((IOException)this.accessDenied)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied(new IOException((Throwable)this.accessDenied))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied(new IOException(new IOException((Throwable)this.accessDenied)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied((IOException)this.statusOk)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied(new IOException((Throwable)this.statusOk))).isFalse();
        TestUtils.verifyCounterNotZero(stats, GoogleCloudStorageStatistics.GCS_CLIENT_SIDE_ERROR_COUNT);
    }

    @Test
    public void isClientError_GoogleJsonErrorWithStatusBadGatewayReturnFalse() throws IOException {
        GhfsStorageStatistics stats = TestUtils.getStorageStatistics();
        GoogleJsonResponseException withJsonError = GoogleCloudStorageStatisticsTest.googleJsonResponseException(502, "Bad gateway", "Bad gateway", "Bad gateway");
        Truth.assertThat((Boolean)this.errorExtractor.clientError((IOException)withJsonError)).isFalse();
        TestUtils.verifyCounterNotZero(stats, GoogleCloudStorageStatistics.GCS_SERVER_SIDE_ERROR_COUNT);
    }

    private static GoogleJsonResponseException googleJsonResponseException(int httpStatus, String reason, String message) throws IOException {
        return GoogleCloudStorageStatisticsTest.googleJsonResponseException(httpStatus, reason, message, message);
    }

    private static GoogleJsonResponseException googleJsonResponseException(int httpStatus, String reason, String message, String httpStatusString) throws IOException {
        GoogleJsonError.ErrorInfo errorInfo = new GoogleJsonError.ErrorInfo();
        errorInfo.setReason(reason);
        errorInfo.setMessage(message);
        return GoogleCloudStorageStatisticsTest.googleJsonResponseException(httpStatus, errorInfo, httpStatusString);
    }

    private static GoogleJsonResponseException googleJsonResponseException(int status, final GoogleJsonError.ErrorInfo errorInfo, String httpStatusString) throws IOException {
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        MockHttpTransport transport = new MockHttpTransport((JsonFactory)jsonFactory, status, httpStatusString){
            final /* synthetic */ JsonFactory val$jsonFactory;
            final /* synthetic */ int val$status;
            final /* synthetic */ String val$httpStatusString;
            {
                this.val$jsonFactory = jsonFactory;
                this.val$status = n;
                this.val$httpStatusString = string;
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                errorInfo.setFactory(this.val$jsonFactory);
                GoogleJsonError jsonError = new GoogleJsonError();
                jsonError.setCode(this.val$status);
                jsonError.setErrors(Collections.singletonList(errorInfo));
                jsonError.setMessage(this.val$httpStatusString);
                jsonError.setFactory(this.val$jsonFactory);
                GenericJson errorResponse = new GenericJson();
                errorResponse.set("error", (Object)jsonError);
                errorResponse.setFactory(this.val$jsonFactory);
                return new MockLowLevelHttpRequest().setResponse(new MockLowLevelHttpResponse().setContent(errorResponse.toPrettyString()).setContentType("application/json; charset=UTF-8").setStatusCode(this.val$status));
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        return GoogleJsonResponseException.from((JsonFactory)jsonFactory, (HttpResponse)response);
    }

    private void mockStatusCode(int statusCode) throws IOException {
        RetryHttpInitializer retryHttpInitializer = new RetryHttpInitializer(null, RetryHttpInitializerOptions.builder().setDefaultUserAgent("foo-user-agent").setHttpHeaders((Map)ImmutableMap.of((Object)"header-key", (Object)"header-value")).setMaxRequestRetries(5).setConnectTimeout(Duration.ofSeconds(5L)).setReadTimeout(Duration.ofSeconds(5L)).build());
        HttpRequestFactory requestFactory = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)statusCode), MockHttpTransportHelper.emptyResponse((int)200)}).createRequestFactory((HttpRequestInitializer)retryHttpInitializer);
        HttpRequest req = requestFactory.buildGetRequest(new GenericUrl("http://fake-url.com"));
        HttpResponse res = req.execute();
    }
}

