/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFSInputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.fs.gcs.TestUtils;
import com.google.cloud.hadoop.gcsio.AssertingLogHandler;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.fs.FileSystem;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFSInputStreamIntegrationTest {
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsFsIHelper;
    private final String testContent = "test content";
    private final byte[] expected = Arrays.copyOf("test content".getBytes(StandardCharsets.UTF_8), 2);
    private AssertingLogHandler assertingHandler = new AssertingLogHandler();
    private Logger grpcTracingLogger;

    @BeforeClass
    public static void beforeClass() throws Exception {
        gcsFsIHelper = GoogleCloudStorageFileSystemIntegrationHelper.create();
        gcsFsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() {
        gcsFsIHelper.afterAllTests();
    }

    @Before
    public void setup() {
        this.grpcTracingLogger = Logger.getLogger(GoogleHadoopFSInputStream.class.getName());
        this.grpcTracingLogger.setUseParentHandlers(false);
        this.grpcTracingLogger.addHandler((Handler)this.assertingHandler);
        this.grpcTracingLogger.setLevel(Level.FINE);
    }

    @After
    public void cleanUp() {
        this.grpcTracingLogger.removeHandler((Handler)this.assertingHandler);
    }

    @Test
    public void seek_illegalArgument() throws Exception {
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), "seek_illegalArgument");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        gcsFsIHelper.writeTextFile(path, "test content");
        GoogleHadoopFSInputStream in = GoogleHadoopFSInputStreamIntegrationTest.createGhfsInputStream(ghfs, path);
        Throwable exception = Assert.assertThrows(EOFException.class, () -> in.seek((long)"test content".length()));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Invalid seek offset");
        this.assertingHandler.assertLogCount(0);
    }

    @Test
    public void read_singleBytes() throws Exception {
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), "read_singleBytes");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        GhfsStorageStatistics stats = TestUtils.getStorageStatistics();
        gcsFsIHelper.writeTextFile(path, "test content");
        byte[] value = new byte[2];
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setTraceLogEnabled(true).build();
        FileSystem.Statistics statistics = new FileSystem.Statistics(ghfs.getScheme());
        try (GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream((GoogleHadoopFileSystemBase)ghfs, path, options, statistics);){
            Truth.assertThat((Integer)in.read(value, 0, 1)).isEqualTo((Object)1);
            Truth.assertThat((Integer)statistics.getReadOps()).isEqualTo((Object)1);
            this.assertingHandler.assertLogCount(1);
            Map logRecord = this.assertingHandler.getLogRecord("method", (Object)"gcsFSRead");
            Truth.assertThat((Map)logRecord).isNotNull();
            Truth.assertThat(logRecord.get("bytesRead")).isEqualTo((Object)1);
            Truth.assertThat(logRecord.get("position")).isEqualTo((Object)0);
            Truth.assertThat(logRecord.get("durationNs")).isNotNull();
            Truth.assertThat(logRecord.get("gcsPath")).isNotNull();
            this.assertingHandler.flush();
            Truth.assertThat((Integer)in.read(1L, value, 1, 1)).isEqualTo((Object)1);
            this.assertingHandler.assertLogCount(4);
            logRecord = this.assertingHandler.getLogRecord("method", (Object)"gcsFSReadPositional");
            Truth.assertThat((Map)logRecord).isNotNull();
            Truth.assertThat(logRecord.get("bytesRead")).isEqualTo((Object)1);
            Truth.assertThat(logRecord.get("position")).isEqualTo((Object)1);
            Truth.assertThat(logRecord.get("durationNs")).isNotNull();
            Truth.assertThat(logRecord.get("gcsPath")).isNotNull();
            logRecord = this.assertingHandler.getLogRecord("method", (Object)"gcsFSSeek");
            Truth.assertThat((Map)logRecord).isNotNull();
            Truth.assertThat(logRecord.get("position")).isEqualTo((Object)1);
            Truth.assertThat(logRecord.get("durationNs")).isNotNull();
            logRecord = this.assertingHandler.getLogRecord("method", (Object)"gcsFSRead");
            Truth.assertThat((Map)logRecord).isNotNull();
            Truth.assertThat(logRecord.get("bytesRead")).isEqualTo((Object)1);
            Truth.assertThat(logRecord.get("durationNs")).isNotNull();
            Truth.assertThat((Integer)statistics.getReadOps()).isEqualTo((Object)2);
        }
        Truth.assertThat((byte[])value).isEqualTo((Object)this.expected);
    }

    @Test
    public void testAvailable() throws Exception {
        GoogleHadoopFSInputStream in;
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), "testAvailable");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        gcsFsIHelper.writeTextFile(path, "test content");
        try (GoogleHadoopFSInputStream ignore = in = GoogleHadoopFSInputStreamIntegrationTest.createGhfsInputStream(ghfs, path);){
            Truth.assertThat((Integer)in.available()).isEqualTo((Object)0);
        }
        Assert.assertThrows(ClosedChannelException.class, () -> ((GoogleHadoopFSInputStream)in).available());
    }

    @Test
    public void testTracingTimeBasedFiltering() throws Exception {
        URI path = this.createFileWithTestContentAndGetPath("read_singleBytes");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        byte[] value = new byte[2];
        int highThreshold = 100000;
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setTraceLogEnabled(true).setTraceLogTimeThreshold((long)highThreshold).build();
        FileSystem.Statistics statistics = new FileSystem.Statistics(ghfs.getScheme());
        try (GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream((GoogleHadoopFileSystemBase)ghfs, path, options, statistics);){
            Truth.assertThat((Integer)in.read(value, 0, 1)).isEqualTo((Object)1);
            Truth.assertThat((Integer)statistics.getReadOps()).isEqualTo((Object)1);
            this.assertingHandler.assertLogCount(0);
            Truth.assertThat((Integer)in.read(1L, value, 1, 1)).isEqualTo((Object)1);
            Truth.assertThat((Integer)statistics.getReadOps()).isEqualTo((Object)2);
        }
        Truth.assertThat((byte[])value).isEqualTo((Object)this.expected);
    }

    @Test
    public void testTracingLogPropertyFiltering() throws Exception {
        URI path = this.createFileWithTestContentAndGetPath("read_singleBytes");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        byte[] value = new byte[2];
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setTraceLogEnabled(true).setTraceLogTimeThreshold(0L).setTraceLogExcludeProperties(ImmutableSet.of((Object)"durationns")).build();
        FileSystem.Statistics statistics = new FileSystem.Statistics(ghfs.getScheme());
        try (GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream((GoogleHadoopFileSystemBase)ghfs, path, options, statistics);){
            Truth.assertThat((Integer)in.read(value, 0, 1)).isEqualTo((Object)1);
            Truth.assertThat((Integer)statistics.getReadOps()).isEqualTo((Object)1);
            this.assertingHandler.assertLogCount(1);
            Map logRecord = this.assertingHandler.getLogRecord("method", (Object)"gcsFSRead");
            Truth.assertThat((Map)logRecord).isNotNull();
            Truth.assertThat(logRecord.get("bytesRead")).isEqualTo((Object)1);
            Truth.assertThat(logRecord.get("position")).isEqualTo((Object)0);
            Truth.assertThat(logRecord.get("durationNs")).isNull();
            Truth.assertThat(logRecord.get("gcsPath")).isNotNull();
        }
    }

    @Test
    public void operation_durationMetric_tests() throws Exception {
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), "seek_illegalArgument");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        GhfsStorageStatistics stats = TestUtils.getStorageStatistics();
        String testContent = "test content";
        gcsFsIHelper.writeTextFile(path, testContent);
        byte[] value = new byte[2];
        byte[] expected = Arrays.copyOf(testContent.getBytes(StandardCharsets.UTF_8), 2);
        GoogleHadoopFSInputStream in = GoogleHadoopFSInputStreamIntegrationTest.createGhfsInputStream(ghfs, path);
        Truth.assertThat((Integer)in.read(value, 0, 1)).isEqualTo((Object)1);
        Truth.assertThat((Integer)in.read(1L, value, 1, 1)).isEqualTo((Object)1);
        Truth.assertThat((byte[])value).isEqualTo((Object)expected);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_OPERATIONS, 0);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_BACKWARD_OPERATIONS, 2);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_READ_OPERATIONS, 0);
        in.seek(0L);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_READ_SEEK_OPERATIONS, 0);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_READ_SEEK_OPERATIONS, 0);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_READ_OPERATIONS, 0);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_BACKWARD_OPERATIONS, 3);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_BYTES_BACKWARDS, 2);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_FORWARD_OPERATIONS, 0);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_BYTES_SKIPPED, 0);
        int expectedSeek = 5;
        in.seek((long)expectedSeek);
        in.close();
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_FORWARD_OPERATIONS, 1);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_SEEK_BYTES_SKIPPED, expectedSeek);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_BYTES, 2);
        TestUtils.verifyCounter(stats, GhfsStatistic.STREAM_READ_OPERATIONS_INCOMPLETE, 0);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_READ_CLOSE_OPERATIONS, 1);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_READ_SEEK_OPERATIONS, 4);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_READ_OPERATIONS, 2);
    }

    private URI createFileWithTestContentAndGetPath(String fileName) throws IOException {
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), fileName);
        gcsFsIHelper.writeTextFile(path, "test content");
        return path;
    }

    private static GoogleHadoopFSInputStream createGhfsInputStream(GoogleHadoopFileSystem ghfs, URI path) throws IOException {
        GoogleCloudStorageReadOptions options = ghfs.getGcsFs().getOptions().getCloudStorageOptions().getReadChannelOptions();
        return new GoogleHadoopFSInputStream((GoogleHadoopFileSystemBase)ghfs, path, options, new FileSystem.Statistics(ghfs.getScheme()));
    }
}

