/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.HadoopConfigurationProperty;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.gcsio.authorization.FakeAuthorizationHandler;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.util.testing.HadoopConfigurationUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFileSystemConfigurationTest {
    private static final Map<String, Object> expectedDefaultConfiguration = new HashMap<String, Object>(){
        {
            this.put("fs.gs.application.name.suffix", "");
            this.put("fs.gs.authorization.handler.impl", null);
            this.put("fs.gs.authorization.handler.properties.", ImmutableMap.of());
            this.put("fs.gs.batch.threads", 15);
            this.put("fs.gs.block.size", 0x4000000L);
            this.put("fs.gs.bucket.delete.enable", false);
            this.put("fs.gs.checksum.type", GoogleHadoopFileSystemBase.GcsFileChecksumType.NONE);
            this.put("fs.gs.client.type", GoogleCloudStorageFileSystemOptions.ClientType.HTTP_API_CLIENT);
            this.put("fs.gs.cooperative.locking.enable", false);
            this.put("fs.gs.cooperative.locking.expiration.timeout.ms", 120000L);
            this.put("fs.gs.cooperative.locking.max.concurrent.operations", 20);
            this.put("fs.gs.copy.with.rewrite.enable", true);
            this.put("fs.gs.create.items.conflict.check.enable", true);
            this.put("fs.gs.delegation.token.binding", null);
            this.put("fs.gs.encryption.algorithm", null);
            this.put("fs.gs.encryption.key.hash", null);
            this.put("fs.gs.encryption.key", null);
            this.put("fs.gs.glob.algorithm", GoogleHadoopFileSystemBase.GlobAlgorithm.CONCURRENT);
            this.put("fs.gs.grpc.checksums.enable", false);
            this.put("fs.gs.grpc.enable", false);
            this.put("fs.gs.grpc.checkinterval.timeout.ms", 1000L);
            this.put("fs.gs.grpc.read.metadata.timeout.ms", 60000L);
            this.put("fs.gs.grpc.read.timeout.ms", 3600000L);
            this.put("fs.gs.grpc.read.message.timeout.ms", 3000L);
            this.put("fs.gs.grpc.read.zerocopy.enable", true);
            this.put("fs.gs.grpc.directpath.enable", true);
            this.put("fs.gs.grpc.server.address", "storage.googleapis.com");
            this.put("fs.gs.grpc.trafficdirector.enable", true);
            this.put("fs.gs.grpc.write.buffered.requests", 20L);
            this.put("fs.gs.grpc.write.timeout.ms", 600000L);
            this.put("fs.gs.grpc.write.message.timeout.ms", 3000L);
            this.put("fs.gs.hierarchical.namespace.folders.enable", false);
            this.put("fs.gs.http.connect-timeout", 20000);
            this.put("fs.gs.http.max.retry", 10);
            this.put("fs.gs.http.read-timeout", 20000);
            this.put("fs.gs.implicit.dir.repair.enable", true);
            this.put("fs.gs.inputstream.fadvise", GoogleCloudStorageReadOptions.Fadvise.AUTO);
            this.put("fs.gs.inputstream.fast.fail.on.not.found.enable", true);
            this.put("fs.gs.inputstream.inplace.seek.limit", 0x800000L);
            this.put("fs.gs.inputstream.min.range.request.size", 0x200000);
            this.put("fs.gs.inputstream.support.gzip.encoding.enable", false);
            this.put("fs.gs.io.buffersize.write", 0x4000000);
            this.put("fs.gs.lazy.init.enable", false);
            this.put("fs.gs.list.max.items.per.call", 5000L);
            this.put("fs.gs.marker.file.pattern", null);
            this.put("fs.gs.max.requests.per.batch", 15L);
            this.put("fs.gs.max.wait.for.empty.object.creation.ms", 3000);
            this.put("fs.gs.metrics.sink", GoogleCloudStorageOptions.MetricsSink.NONE);
            this.put("fs.gs.outputstream.buffer.size", 0x800000);
            this.put("fs.gs.outputstream.direct.upload.enable", false);
            this.put("fs.gs.outputstream.pipe.buffer.size", 0x100000);
            this.put("fs.gs.outputstream.pipe.type", AsyncWriteChannelOptions.PipeType.IO_STREAM_PIPE);
            this.put("fs.gs.outputstream.sync.min.interval.ms", 0);
            this.put("fs.gs.outputstream.type", GoogleHadoopFileSystemBase.OutputStreamType.BASIC);
            this.put("fs.gs.outputstream.upload.cache.size", 0);
            this.put("fs.gs.outputstream.upload.chunk.size", 0x4000000);
            this.put("fs.gs.performance.cache.enable", false);
            this.put("fs.gs.performance.cache.max.entry.age.ms", 5000L);
            this.put("fs.gs.project.id", null);
            this.put("fs.gs.reported.permissions", "700");
            this.put("fs.gs.requester.pays.buckets", ImmutableList.of());
            this.put("fs.gs.requester.pays.mode", RequesterPaysOptions.RequesterPaysMode.DISABLED);
            this.put("fs.gs.requester.pays.project.id", null);
            this.put("fs.gs.rewrite.max.bytes.per.call", 0x20000000L);
            this.put("fs.gs.status.parallel.enable", true);
            this.put("fs.gs.storage.http.headers.", ImmutableMap.of());
            this.put("fs.gs.storage.root.url", "https://storage.googleapis.com/");
            this.put("fs.gs.storage.service.path", "storage/v1/");
            this.put("fs.gs.tracelog.enable", false);
            this.put("fs.gs.operation.tracelog.enable", false);
            this.put("fs.gs.working.dir", "/");
            this.put("fs.gs.tracelog.time.filter.threshold.ms", 0L);
            this.put("fs.gs.tracelog.exclude.properties", ImmutableList.of());
            this.put("fs.gs.client.upload.type", AsyncWriteChannelOptions.UploadType.CHUNK_UPLOAD);
            this.put("fs.gs.write.temporary.dirs", ImmutableSet.of());
            this.put("fs.gs.write.parallel.composite.upload.buffer.count", 1);
            this.put("fs.gs.write.parallel.composite.upload.buffer.capacity", 0x2000000);
            this.put("fs.gs.write.parallel.composite.upload.part.file.cleanup.type", AsyncWriteChannelOptions.PartFileCleanupType.ALWAYS);
            this.put("fs.gs.write.parallel.composite.upload.part.file.name.prefix", "");
        }
    };

    @Test
    public void testProxyProperties_throwsExceptionWhenMissingProxyAddress() {
        HadoopConfigurationProperty gcsProxyUsername = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_USERNAME_SUFFIX.getKey(), (Object)"proxy-user", new String[0]);
        HadoopConfigurationProperty gcsProxyPassword = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_PASSWORD_SUFFIX.getKey(), (Object)"proxy-pass", new String[0]);
        Configuration config = new Configuration();
        config.set(gcsProxyUsername.getKey(), (String)gcsProxyUsername.getDefault());
        config.set(gcsProxyPassword.getKey(), (String)gcsProxyPassword.getDefault());
        GoogleCloudStorageOptions.Builder optionsBuilder = GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder((Configuration)config);
        Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleCloudStorageOptions.Builder)optionsBuilder).build());
    }

    @Test
    public void testProxyPropertiesAll() {
        HadoopConfigurationProperty gcsProxyUsername = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_USERNAME_SUFFIX.getKey(), (Object)"proxy-user", new String[0]);
        HadoopConfigurationProperty gcsProxyPassword = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_PASSWORD_SUFFIX.getKey(), (Object)"proxy-pass", new String[0]);
        HadoopConfigurationProperty gcsProxyAddress = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_ADDRESS_SUFFIX.getKey(), (Object)"proxy-address", new String[0]);
        Configuration config = new Configuration();
        config.set(gcsProxyUsername.getKey(), (String)gcsProxyUsername.getDefault());
        config.set(gcsProxyPassword.getKey(), (String)gcsProxyPassword.getDefault());
        config.set(gcsProxyAddress.getKey(), (String)gcsProxyAddress.getDefault());
        GoogleCloudStorageFileSystemOptions options = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder((Configuration)config).build();
        Truth.assertThat((Object)options.getCloudStorageOptions().getProxyUsername()).isNotNull();
        Truth.assertThat((String)options.getCloudStorageOptions().getProxyUsername().value()).isEqualTo((Object)"proxy-user");
        Truth.assertThat((String)options.getCloudStorageOptions().getProxyUsername().toString()).isEqualTo((Object)"<redacted>");
        Truth.assertThat((Object)options.getCloudStorageOptions().getProxyPassword()).isNotNull();
        Truth.assertThat((String)options.getCloudStorageOptions().getProxyPassword().value()).isEqualTo((Object)"proxy-pass");
        Truth.assertThat((String)options.getCloudStorageOptions().getProxyPassword().toString()).isEqualTo((Object)"<redacted>");
        Truth.assertThat((String)options.getCloudStorageOptions().getProxyAddress()).isEqualTo((Object)"proxy-address");
    }

    @Test
    public void testDeprecatedKeys_throwsExceptionWhenDeprecatedKeyIsUsed() {
        HadoopConfigurationProperty gcsProxyAddress = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_ADDRESS_SUFFIX.getKey(), (Object)"proxy-address", new String[]{"fs.gs.proxy.deprecated.address"});
        HadoopConfigurationProperty gcsProxyUsername = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_USERNAME_SUFFIX.getKey(), (Object)1234, new String[]{"fs.gs.proxy.deprecated.user"});
        HadoopConfigurationProperty gcsProxyPassword = new HadoopConfigurationProperty("fs.gs" + HadoopCredentialConfiguration.PROXY_PASSWORD_SUFFIX.getKey(), (Object)"proxy-pass", new String[]{"fs.gs.proxy.deprecated.pass"});
        Configuration config = new Configuration();
        config.set(gcsProxyAddress.getKey(), (String)gcsProxyAddress.getDefault());
        config.setInt(gcsProxyUsername.getKey(), ((Integer)gcsProxyUsername.getDefault()).intValue());
        config.set("fs.gs.proxy.deprecated.pass", (String)gcsProxyPassword.getDefault());
        String userPass = gcsProxyPassword.getPassword(config);
        Truth.assertThat((String)userPass).isEqualTo((Object)"proxy-pass");
        GoogleCloudStorageOptions.Builder optionsBuilder = GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder((Configuration)config);
        Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleCloudStorageOptions.Builder)optionsBuilder).build());
    }

    @Test
    public void testHttpHeadersProperties_singleHeader() {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.GCS_HTTP_HEADERS.getKey() + "header-key", "val=ue");
        GoogleCloudStorageFileSystemOptions options = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder((Configuration)config).build();
        Truth.assertThat((Map)options.getCloudStorageOptions().getHttpRequestHeaders()).containsExactly((Object)"header-key", (Object)"val=ue", new Object[0]);
    }

    @Test
    public void testHttpHeadersProperties_multipleHeaders() {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.GCS_HTTP_HEADERS.getKey() + "test-header", "test-VAL");
        config.set(GoogleHadoopFileSystemConfiguration.GCS_HTTP_HEADERS.getKey() + "key-in-header", "+G2Ap33m5NVOgmXznSGTEvG0I=");
        GoogleCloudStorageFileSystemOptions options = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder((Configuration)config).build();
        Truth.assertThat((Map)options.getCloudStorageOptions().getHttpRequestHeaders()).containsExactly((Object)"test-header", (Object)"test-VAL", new Object[]{"key-in-header", "+G2Ap33m5NVOgmXznSGTEvG0I="});
    }

    @Test
    public void testEncryptionProperties() {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.GCS_ENCRYPTION_ALGORITHM.getKey(), "AES256");
        config.set(GoogleHadoopFileSystemConfiguration.GCS_ENCRYPTION_KEY.getKey(), "+G2Ap33m5NVOgmXznSGTEvG0I=");
        config.set(GoogleHadoopFileSystemConfiguration.GCS_ENCRYPTION_KEY_HASH.getKey(), "LpH4y6BkG/1B+n3FwORpdoyQ=");
        GoogleCloudStorageFileSystemOptions options = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder((Configuration)config).build();
        Truth.assertThat((String)options.getCloudStorageOptions().getEncryptionAlgorithm()).isEqualTo((Object)"AES256");
        Truth.assertThat((Object)options.getCloudStorageOptions().getEncryptionKey()).isNotNull();
        Truth.assertThat((String)options.getCloudStorageOptions().getEncryptionKey().toString()).isEqualTo((Object)"<redacted>");
        Truth.assertThat((String)options.getCloudStorageOptions().getEncryptionKey().value()).isEqualTo((Object)"+G2Ap33m5NVOgmXznSGTEvG0I=");
        Truth.assertThat((Object)options.getCloudStorageOptions().getEncryptionKeyHash()).isNotNull();
        Truth.assertThat((String)options.getCloudStorageOptions().getEncryptionKeyHash().toString()).isEqualTo((Object)"<redacted>");
        Truth.assertThat((String)options.getCloudStorageOptions().getEncryptionKeyHash().value()).isEqualTo((Object)"LpH4y6BkG/1B+n3FwORpdoyQ=");
    }

    @Test
    public void defaultPropertiesValues() {
        Truth.assertThat((Map)HadoopConfigurationUtils.getDefaultProperties(GoogleHadoopFileSystemConfiguration.class)).containsExactlyEntriesIn(expectedDefaultConfiguration);
    }

    @Test
    public void customPropertiesValues() {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.GCS_ROOT_URL.getKey(), "https://unit-test-storage.googleapis.com/");
        config.set(GoogleHadoopFileSystemConfiguration.GCS_SERVICE_PATH.getKey(), "storage/dev_v1/");
        GoogleCloudStorageOptions options = GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder((Configuration)config).build();
        Truth.assertThat((String)options.getStorageRootUrl()).isEqualTo((Object)"https://unit-test-storage.googleapis.com/");
        Truth.assertThat((String)options.getStorageServicePath()).isEqualTo((Object)"storage/dev_v1/");
    }

    @Test
    public void testImpersonationIdentifier() {
        Configuration config = new Configuration();
        config.set("fs.gs" + HadoopCredentialConfiguration.USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + "test-user", "test-service-account1");
        config.set("fs.gs" + HadoopCredentialConfiguration.GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + "test-grp", "test-service-account2");
        Truth.assertThat((Map)HadoopCredentialConfiguration.USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.withPrefixes((List)ImmutableList.of((Object)"fs.gs")).getPropsWithPrefix(config)).containsExactly((Object)"test-user", (Object)"test-service-account1", new Object[0]);
        Truth.assertThat((Map)HadoopCredentialConfiguration.GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.withPrefixes((List)ImmutableList.of((Object)"fs.gs")).getPropsWithPrefix(config)).containsExactly((Object)"test-grp", (Object)"test-service-account2", new Object[0]);
    }

    @Test
    public void testGetAuthorizationHandler() {
        Configuration config = new Configuration();
        config.setClass(GoogleHadoopFileSystemConfiguration.GCS_AUTHORIZATION_HANDLER_IMPL.getKey(), FakeAuthorizationHandler.class, AuthorizationHandler.class);
        GoogleCloudStorageOptions options = GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder((Configuration)config).build();
        Class handler = options.getAuthorizationHandlerImplClass();
        Truth.assertThat((Class)handler).isAssignableTo(AuthorizationHandler.class);
        Truth.assertThat((Class)handler).isEqualTo(FakeAuthorizationHandler.class);
    }

    @Test
    public void testAuthorizationHandlerClassNotFound() {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.GCS_AUTHORIZATION_HANDLER_IMPL.getKey(), "test.class.not.exist");
        Assert.assertThrows(RuntimeException.class, () -> GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder((Configuration)config).build());
    }

    @Test
    public void testGrpcConfiguration() {
        Configuration config = new Configuration();
        long grpcCheckIntervalTimeout = 5L;
        long grpcReadTimeout = 10L;
        long grpcReadMetadataTimeout = 15L;
        long grpcReadMessageTimeout = 10L;
        long grpcWriteTimeout = 20L;
        long grpcWriteMessageTimeout = 25L;
        long grpcUploadBufferedRequests = 30L;
        boolean directPathEnabled = true;
        boolean trafficDirectorEnabled = true;
        boolean grpcEnabled = true;
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_ENABLE.getKey(), String.valueOf(grpcEnabled));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_READ_TIMEOUT_MS.getKey(), String.valueOf(grpcReadTimeout));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_READ_METADATA_TIMEOUT_MS.getKey(), String.valueOf(grpcReadMetadataTimeout));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_WRITE_TIMEOUT_MS.getKey(), String.valueOf(grpcWriteTimeout));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_UPLOAD_BUFFERED_REQUESTS.getKey(), String.valueOf(grpcUploadBufferedRequests));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_DIRECTPATH_ENABLE.getKey(), String.valueOf(directPathEnabled));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_TRAFFICDIRECTOR_ENABLE.getKey(), String.valueOf(trafficDirectorEnabled));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_CHECK_INTERVAL_TIMEOUT_MS.getKey(), String.valueOf(grpcCheckIntervalTimeout));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_READ_MESSAGE_TIMEOUT_MS.getKey(), String.valueOf(grpcReadMessageTimeout));
        config.set(GoogleHadoopFileSystemConfiguration.GCS_GRPC_WRITE_MESSAGE_TIMEOUT_MS.getKey(), String.valueOf(grpcWriteMessageTimeout));
        GoogleCloudStorageOptions options = GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder((Configuration)config).build();
        Truth.assertThat((Long)options.getReadChannelOptions().getGrpcReadTimeoutMillis()).isEqualTo((Object)grpcReadTimeout);
        Truth.assertThat((Long)options.getReadChannelOptions().getGrpcReadMetadataTimeoutMillis()).isEqualTo((Object)grpcReadMetadataTimeout);
        Truth.assertThat((Long)options.getWriteChannelOptions().getGrpcWriteTimeout()).isEqualTo((Object)grpcWriteTimeout);
        Truth.assertThat((Long)options.getWriteChannelOptions().getNumberOfBufferedRequests()).isEqualTo((Object)grpcUploadBufferedRequests);
        Truth.assertThat((Boolean)options.isDirectPathPreferred()).isEqualTo((Object)directPathEnabled);
        Truth.assertThat((Boolean)options.isGrpcEnabled()).isEqualTo((Object)grpcEnabled);
        Truth.assertThat((Long)options.getGrpcMessageTimeoutCheckInterval()).isEqualTo((Object)grpcCheckIntervalTimeout);
        Truth.assertThat((Long)options.getReadChannelOptions().getGrpcReadMessageTimeoutMillis()).isEqualTo((Object)grpcReadMessageTimeout);
        Truth.assertThat((Long)options.getWriteChannelOptions().getGrpcWriteMessageTimeoutMillis()).isEqualTo((Object)grpcWriteMessageTimeout);
    }
}

