/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.auth.GcsDelegationTokens;
import com.google.cloud.hadoop.fs.gcs.auth.TestDelegationTokenBindingImpl;
import com.google.cloud.hadoop.fs.gcs.auth.TestTokenIdentifierImpl;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFileSystemDelegationTokensTest {
    @Test
    public void testDelegationTokenBinding() throws IOException {
        URI initUri = new Path("gs://test/").toUri();
        Text expectedKind = TestTokenIdentifierImpl.KIND;
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem();
        fs.initialize(initUri, this.loadConfig());
        Token dt = fs.getDelegationToken(null);
        Truth.assertWithMessage((String)"Expected a delegation token").that((Object)dt).isNotNull();
        Truth.assertWithMessage((String)"Unexpected delegation token service").that(dt.getService().toString()).isEqualTo((Object)"gs://test");
        Truth.assertWithMessage((String)"Unexpected delegation token kind").that((Comparable)dt.getKind()).isEqualTo((Object)expectedKind);
        TokenIdentifier decoded = dt.decodeIdentifier();
        Truth.assertWithMessage((String)"Failed to decode token identifier").that((Object)decoded).isNotNull();
        Truth.assertWithMessage((String)"Unexpected delegation token identifier type").that((Object)decoded).isInstanceOf(TestTokenIdentifierImpl.class);
        DelegationTokenIdentifier identifier = (DelegationTokenIdentifier)decoded;
        Truth.assertWithMessage((String)"Unexpected delegation token identifier kind").that((Comparable)identifier.getKind()).isEqualTo((Object)expectedKind);
    }

    @Test
    public void testTokensInitializationWhenConfigurationIsMissing_throwsRuntimeException() throws IOException {
        Configuration config = new Configuration();
        GcsDelegationTokens delegationTokens = new GcsDelegationTokens();
        Assert.assertThrows(IllegalStateException.class, () -> delegationTokens.init(config));
    }

    @Test
    public void testTokensInitializationWhenFsIsMissing_throwsRuntimeException() throws IOException {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.DELEGATION_TOKEN_BINDING_CLASS.getKey(), TestDelegationTokenBindingImpl.class.getName());
        GcsDelegationTokens delegationTokens = new GcsDelegationTokens();
        Assert.assertThrows(RuntimeException.class, () -> delegationTokens.init(config));
    }

    @Test
    public void testAccessTokensProvidersValidation() throws IOException {
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem();
        fs.initialize(new Path("gs://test/").toUri(), this.loadConfig());
        Token dt = fs.getDelegationToken("current-user");
        Assert.assertThrows((String)"GCP Delegation tokens has already been bound/deployed", IllegalStateException.class, () -> fs.delegationTokens.bindToAnyDelegationToken());
        Token boundDT = fs.delegationTokens.getBoundDT();
        Assert.assertThrows((String)"GCP Delegation tokens has already been bound/deployed", IllegalStateException.class, () -> fs.delegationTokens.bindToDelegationToken(boundDT));
        Token dt1 = fs.getDelegationToken("current-user");
        Truth.assertWithMessage((String)"Tokens should be the same").that((Object)dt1).isEqualTo((Object)dt);
    }

    @Test
    public void testTokenAuthValue() throws IOException {
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem();
        fs.initialize(new Path("gs://test/").toUri(), this.loadConfig());
        AccessTokenProvider tokenProvider = fs.delegationTokens.getAccessTokenProvider();
        AccessTokenProvider.AccessToken token = tokenProvider.getAccessToken();
        Truth.assertThat((String)token.getToken()).isEqualTo((Object)"qWDAWFA3WWFAWFAWFAW3FAWF3AWF3WFAF33GR5G5");
    }

    private Configuration loadConfig() {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey(), "test_project");
        config.setLong(GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getKey(), 1024L);
        config.set(GoogleHadoopFileSystemConfiguration.DELEGATION_TOKEN_BINDING_CLASS.getKey(), TestDelegationTokenBindingImpl.class.getName());
        config.set("test.token.value", "qWDAWFA3WWFAWFAWFAW3FAWF3AWF3WFAF33GR5G5");
        return config;
    }
}

