/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

public final class GoogleHadoopFileSystemIntegrationHelper {
    private static final String ENV_VAR_MSG_FMT = "Environment variable %s should be set";

    public static GoogleHadoopFileSystem createGhfs(URI path, Configuration config) throws Exception {
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        ghfs.initialize(path, config);
        return ghfs;
    }

    public static Configuration getTestConfig() {
        Configuration config = new Configuration();
        config.setBoolean(GoogleHadoopFileSystemConfiguration.GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.getKey(), true);
        config.setBoolean(GoogleHadoopFileSystemConfiguration.GCE_BUCKET_DELETE_ENABLE.getKey(), true);
        TestConfiguration testConf = TestConfiguration.getInstance();
        String projectId = (String)Preconditions.checkNotNull((Object)testConf.getProjectId(), (String)ENV_VAR_MSG_FMT, (Object)"GCS_TEST_PROJECT_ID");
        config.set(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey(), projectId);
        if (testConf.getServiceAccount() != null && testConf.getPrivateKeyFile() != null) {
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX.getKey(), testConf.getServiceAccount());
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX.getKey(), testConf.getPrivateKeyFile());
        }
        config.setBoolean("fs.gs.grpc.directpath.enable", testConf.isDirectPathPreferred());
        return config;
    }

    private GoogleHadoopFileSystemIntegrationHelper() {
    }
}

