/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemTestBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.testing.TestingAccessTokenProvider;
import com.google.common.base.Charsets;
import com.google.common.truth.Truth;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Test;

public abstract class GoogleHadoopFileSystemTestBase
extends HadoopFileSystemTestBase {
    protected static Configuration loadConfig() {
        return GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
    }

    protected static Configuration loadConfig(GoogleCloudStorageFileSystemOptions.ClientType storageClientType) {
        Configuration config = GoogleHadoopFileSystemTestBase.loadConfig();
        config.setEnum("fs.gs.client.type", (Enum)storageClientType);
        return config;
    }

    protected static Configuration loadConfig(Configuration config, GoogleCloudStorageFileSystemOptions.ClientType storageClientType) {
        Configuration newConfig = new Configuration(config);
        newConfig.setBoolean("fs.gs.implicit.dir.repair.enable", true);
        newConfig.setBoolean("fs.gs.bucket.delete.enable", true);
        newConfig.setBoolean("fs.gs.hierarchical.namespace.folders.enable", true);
        newConfig.setEnum("fs.gs.client.type", (Enum)storageClientType);
        return newConfig;
    }

    @Test
    public abstract void testCheckPathSuccess();

    @Test
    public abstract void testCheckPathFailure();

    @Test
    public abstract void testInitializeSuccess() throws IOException, URISyntaxException;

    @Test
    public abstract void testInitializeWithWorkingDirectory() throws Exception;

    @Test
    public abstract void testConfigureBucketsSuccess() throws URISyntaxException, IOException;

    @Test
    public abstract void testConfigureBucketsWithRootBucketButNoSystemBucket() throws IOException;

    @Test
    public abstract void testConfigureBucketsWithNeitherRootBucketNorSystemBucket() throws IOException;

    @Test
    public void testGetGcsPath() throws URISyntaxException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)this.ghfs;
        URI gcsPath = new URI("gs://" + myghfs.getUri().getAuthority() + "/dir/obj");
        Truth.assertThat((Comparable)myghfs.getGcsPath(new Path(gcsPath))).isEqualTo((Object)gcsPath);
        Truth.assertThat((Comparable)myghfs.getGcsPath(new Path("/buck^et", "object"))).isEqualTo((Object)new URI("gs://" + myghfs.getUri().getAuthority() + "/buck%5Eet/object"));
    }

    @Test
    public void testConfig() {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)this.ghfs;
        GoogleCloudStorageOptions cloudStorageOptions = myghfs.getGcsFs().getOptions().getCloudStorageOptions();
        Truth.assertThat((Long)cloudStorageOptions.getReadChannelOptions().getInplaceSeekLimit()).isEqualTo(GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.getDefault());
        Truth.assertThat((Long)myghfs.getDefaultBlockSize()).isEqualTo(GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault());
    }

    @Test
    public void testGetCanonicalServiceName() {
        Truth.assertThat((String)this.ghfs.getCanonicalServiceName()).isNull();
    }

    @Test
    public void testImplicitDirectory() throws IOException {
        String bucketName = this.sharedBucketName1;
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)this.ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        URI seedUri = this.getTempFilePath();
        Path parentPath = this.ghfsHelper.castAsHadoopPath(seedUri);
        URI parentUri = myghfs.getGcsPath(parentPath);
        Path subdirPath = new Path(parentPath, "foo-subdir");
        URI subdirUri = myghfs.getGcsPath(subdirPath);
        Path leafPath = new Path(subdirPath, "bar-subdir");
        URI leafUri = myghfs.getGcsPath(leafPath);
        gcsfs.mkdir(leafUri);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, leafUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, subdirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, parentUri, true);
        this.ghfsHelper.clearBucket(bucketName);
    }

    @Test
    public void testRepairDirectory_afterFileDelete() throws IOException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)this.ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        URI seedUri = this.getTempFilePath();
        Path dirPath = this.ghfsHelper.castAsHadoopPath(seedUri);
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path emptyObject = new Path(dirPath, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        gcsfs.delete(objUri, false);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        this.ghfsHelper.clearBucket(resource.getBucketName());
    }

    @Test
    public void testRepairDirectory_afterSubdirectoryDelete() throws IOException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)this.ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        URI seedUri = this.getTempFilePath();
        Path dirPath = this.ghfsHelper.castAsHadoopPath(seedUri);
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path subDir = new Path(dirPath, "subdir");
        URI subdirUri = myghfs.getGcsPath(subDir);
        Path emptyObject = new Path(subDir, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, subdirUri, true);
        gcsfs.delete(subdirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        this.ghfsHelper.clearBucket(resource.getBucketName());
    }

    @Test
    public void testRepairDirectory_afterFileRename() throws IOException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)this.ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        URI seedUri = this.getTempFilePath();
        Path dirPath = this.ghfsHelper.castAsHadoopPath(seedUri);
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path emptyObject = new Path(dirPath, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        gcsfs.rename(objUri, objUri.resolve(".."));
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        this.ghfsHelper.clearBucket(resource.getBucketName());
    }

    @Test
    public void testRepairDirectory_afterSubdirectoryRename() throws IOException {
        String bucketName = this.sharedBucketName1;
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)this.ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        Path dirPath = this.ghfsHelper.castAsHadoopPath(this.getTempFilePath());
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path subDir = new Path(dirPath, "subdir");
        URI subdirUri = myghfs.getGcsPath(subDir);
        Path emptyObject = new Path(subDir, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, subdirUri, true);
        gcsfs.rename(subdirUri, dirUri.resolve("."));
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        this.ghfsHelper.clearBucket(bucketName);
    }

    private static void assertDirectory(GoogleCloudStorageFileSystem gcsfs, URI path, boolean exists) throws IOException {
        Truth.assertWithMessage((String)"Expected to %s: %s", (Object[])new Object[]{exists ? "exist" : "not exist", path}).that(Boolean.valueOf(gcsfs.exists(path))).isEqualTo((Object)exists);
        if (exists) {
            Truth.assertWithMessage((String)"Expected to be a directory: %s", (Object[])new Object[]{path}).that(Boolean.valueOf(gcsfs.getFileInfo(path).isDirectory())).isTrue();
        } else {
            Truth.assertWithMessage((String)"Expected to have requested ID: %s", (Object[])new Object[]{path}).that((Comparable)gcsfs.getFileInfo(path).getPath()).isEqualTo((Object)path);
        }
    }

    @Test
    public void testMakeQualifiedNotRoot() {
        GoogleHadoopFileSystemBase myGhfs = (GoogleHadoopFileSystemBase)this.ghfs;
        Path fsRootPath = myGhfs.getFileSystemRoot();
        URI fsRootUri = fsRootPath.toUri();
        String fsRoot = fsRootPath.toString();
        String workingParent = fsRoot + "working/";
        String workingDir = workingParent + "dir";
        myGhfs.setWorkingDirectory(new Path(workingDir));
        HashMap<String, String> qualifiedPaths = new HashMap<String, String>();
        qualifiedPaths.put("/", fsRoot);
        qualifiedPaths.put("/foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(".", workingDir);
        qualifiedPaths.put("foo", workingDir + "/foo");
        qualifiedPaths.put("foo/bar", workingDir + "/foo/bar");
        qualifiedPaths.put(fsRoot, fsRoot);
        qualifiedPaths.put(fsRoot + "foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("/foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("foo/../foo", workingDir + "/foo");
        qualifiedPaths.put("foo/bar/../../foo/bar", workingDir + "/foo/bar");
        qualifiedPaths.put(fsRoot + "foo/../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("..", workingParent);
        qualifiedPaths.put("../..", fsRoot);
        qualifiedPaths.put("../foo", workingParent + "/foo");
        qualifiedPaths.put("../foo/bar", workingParent + "/foo/bar");
        qualifiedPaths.put("../foo/../foo", workingParent + "/foo");
        qualifiedPaths.put("../foo/bar/../../foo/bar", workingParent + "/foo/bar");
        qualifiedPaths.put(workingDir + "/../foo/../foo", workingParent + "/foo");
        qualifiedPaths.put(workingDir + "/../foo/bar/../../foo/bar", workingParent + "/foo/bar");
        qualifiedPaths.put(fsRoot + "..foo/bar", fsRoot + "..foo/bar");
        qualifiedPaths.put("..foo/bar", workingDir + "/..foo/bar");
        qualifiedPaths.put("/..", fsRoot);
        qualifiedPaths.put("/../../..", fsRoot);
        qualifiedPaths.put("/../foo/", fsRoot + "foo");
        qualifiedPaths.put("/../../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../../..", fsRoot);
        qualifiedPaths.put(fsRoot + "..", fsRoot);
        qualifiedPaths.put(fsRoot + "../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../../../foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("../../../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        if (fsRootUri.getAuthority() != null) {
            qualifiedPaths.put(fsRoot.substring(0, fsRoot.length() - 1), fsRoot);
        }
        for (String unqualifiedString : qualifiedPaths.keySet()) {
            Path unqualifiedPath = new Path(unqualifiedString);
            Path qualifiedPath = new Path((String)qualifiedPaths.get(unqualifiedString));
            Truth.assertThat((Comparable)qualifiedPath).isEqualTo((Object)myGhfs.makeQualified(unqualifiedPath));
        }
    }

    @Test
    public void testMakeQualifiedRoot() {
        GoogleHadoopFileSystemBase myGhfs = (GoogleHadoopFileSystemBase)this.ghfs;
        myGhfs.setWorkingDirectory(myGhfs.getFileSystemRoot());
        Path fsRootPath = myGhfs.getFileSystemRoot();
        URI fsRootUri = fsRootPath.toUri();
        String fsRoot = fsRootPath.toString();
        HashMap<String, String> qualifiedPaths = new HashMap<String, String>();
        qualifiedPaths.put("/", fsRoot);
        qualifiedPaths.put("/foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(".", fsRoot);
        qualifiedPaths.put("foo", fsRoot + "foo");
        qualifiedPaths.put("foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot, fsRoot);
        qualifiedPaths.put(fsRoot + "foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("/foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "foo/../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "..foo/bar", fsRoot + "..foo/bar");
        qualifiedPaths.put("..foo/bar", fsRoot + "..foo/bar");
        qualifiedPaths.put("/..", fsRoot);
        qualifiedPaths.put("/../../..", fsRoot);
        qualifiedPaths.put("/../foo/", fsRoot + "foo");
        qualifiedPaths.put("/../../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("..", fsRoot);
        qualifiedPaths.put("../..", fsRoot);
        qualifiedPaths.put("../foo", fsRoot + "foo");
        qualifiedPaths.put("../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "..", fsRoot);
        qualifiedPaths.put(fsRoot + "../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../../../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "../foo/../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "foo/../../../../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar/../../../../../foo/bar", fsRoot + "foo/bar");
        if (fsRootUri.getAuthority() != null) {
            qualifiedPaths.put(fsRoot.substring(0, fsRoot.length() - 1), fsRoot);
        }
        for (String unqualifiedString : qualifiedPaths.keySet()) {
            Path unqualifiedPath = new Path(unqualifiedString);
            Path qualifiedPath = new Path((String)qualifiedPaths.get(unqualifiedString));
            Truth.assertThat((Comparable)qualifiedPath).isEqualTo((Object)myGhfs.makeQualified(unqualifiedPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void provideCoverageForUnmodifiedMethods() throws IOException {
        URI tempFileUri = this.getTempFilePath();
        Path tempFilePath = this.ghfsHelper.castAsHadoopPath(tempFileUri);
        Path tempDirPath = tempFilePath.getParent();
        String text = "Hello World!";
        this.ghfsHelper.writeFile(tempFilePath, text, 1, false);
        URI tempFileUri2 = this.getTempFilePath();
        Path tempFilePath2 = this.ghfsHelper.castAsHadoopPath(tempFileUri2);
        File localTempFile = File.createTempFile("ghfs-test-", null);
        Path localTempFilePath = new Path(localTempFile.getPath());
        Path localTempDirPath = localTempFilePath.getParent();
        try {
            this.ghfs.deleteOnExit(tempFilePath);
            this.ghfs.getContentSummary(tempFilePath);
            this.ghfs.getDelegationToken("foo");
            this.ghfs.copyFromLocalFile(false, true, localTempFilePath, tempDirPath);
            this.ghfs.copyFromLocalFile(false, true, new Path[]{localTempFilePath}, tempDirPath);
            localTempFile.delete();
            this.ghfs.copyToLocalFile(true, tempFilePath, localTempDirPath);
            File localCopiedFile = new File(localTempDirPath.toString(), tempFilePath.getName());
            localCopiedFile.delete();
            Path localOutputPath = this.ghfs.startLocalOutput(tempFilePath2, localTempFilePath);
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(localOutputPath.toString(), new String[0]), Charsets.UTF_8, new OpenOption[0]);){
                writer.write(text);
            }
            this.ghfs.completeLocalOutput(tempFilePath2, localOutputPath);
            this.ghfs.getUsed();
            this.ghfs.setVerifyChecksum(false);
            this.ghfs.getFileChecksum(tempFilePath2);
            this.ghfs.setPermission(tempFilePath2, FsPermission.getDefault());
            try {
                this.ghfs.setOwner(tempFilePath2, "foo-user", "foo-group");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ghfs.setTimes(tempFilePath2, 0L, 0L);
        }
        finally {
            if (localTempFile.exists()) {
                localTempFile.delete();
            }
        }
    }

    @Test
    public void testInvalidCredentialFromAccessTokenProvider() throws Exception {
        Configuration config = new Configuration();
        config.set("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class.getName());
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        ghfs.initialize(gsUri, config);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> ghfs.exists(new Path("gs://")));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"Invalid Credentials");
    }
}

