/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestBase;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class GoogleHadoopFileSystemXAttrsIntegrationTest {
    private FileSystem ghfs;
    private HadoopFileSystemIntegrationHelper ghfsHelper;
    private GoogleCloudStorageFileSystemIntegrationHelper gcsiHelper;
    private FileSystemDescriptor ghfsFileSystemDescriptor;
    private final GoogleCloudStorageTestHelper.TestBucketHelper bucketHelper = new GoogleCloudStorageTestHelper.TestBucketHelper("dataproc-gcs-gcsio");
    private String bucketName;

    @Before
    public void before() throws Exception {
        GoogleHadoopFileSystem testInstance = new GoogleHadoopFileSystem();
        this.ghfs = testInstance;
        this.ghfsFileSystemDescriptor = testInstance;
        URI initUri = new URI("gs://" + this.bucketHelper.getUniqueBucketName("init"));
        this.ghfs.initialize(initUri, GoogleHadoopFileSystemTestBase.loadConfig());
        this.gcsiHelper = new GoogleCloudStorageFileSystemIntegrationHelper(((GoogleHadoopFileSystem)this.ghfs).getGcsFs());
        this.ghfs.mkdirs(new Path(this.ghfs.getUri()));
        this.ghfsHelper = new HadoopFileSystemIntegrationHelper(this.ghfs, this.ghfsFileSystemDescriptor);
        this.gcsiHelper.beforeAllTests();
        this.bucketName = this.gcsiHelper.sharedBucketName1;
    }

    @After
    public void after() throws IOException {
        if (this.ghfs != null) {
            GoogleCloudStorageFileSystem gcsfs;
            if (this.gcsiHelper != null) {
                this.gcsiHelper.afterAllTests();
                this.gcsiHelper = null;
            }
            if ((gcsfs = ((GoogleHadoopFileSystem)this.ghfs).getGcsFs()) != null) {
                gcsfs.close();
            }
            try {
                this.ghfs.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
            this.ghfs = null;
        }
    }

    public URI getTempFilePath() {
        return this.gcsiHelper.getPath(this.bucketName, "file-" + UUID.randomUUID());
    }

    @Test
    public void getXAttr_nonExistentAttr() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-get-xattr", 1, false);
        this.ghfs.setXAttr(filePath, "test-xattr-some", "test-xattr-value".getBytes(StandardCharsets.UTF_8));
        Truth.assertThat((byte[])this.ghfs.getXAttr(filePath, "test-xattr-non-existent")).isNull();
        Truth.assertThat((Map)this.ghfs.getXAttrs(filePath, (List)ImmutableList.of((Object)"test-xattr-non-existent"))).isEmpty();
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void getXAttr_returnEmptyMapOnEmptyNames() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-get-xattr", 1, false);
        Map xAttrs = this.ghfs.getXAttrs(filePath, new ArrayList());
        Truth.assertThat((Map)xAttrs).isEmpty();
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void getXAttr_nonGhfsMetadata() throws Exception {
        GoogleCloudStorageFileSystem gcsFs = ((GoogleHadoopFileSystem)this.ghfs).getGcsFs();
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-get-xattr-extra", 1, false);
        UpdatableItemInfo updateInfo = new UpdatableItemInfo(StorageResourceId.fromStringPath((String)filePath.toString()), (Map)ImmutableMap.of((Object)"non-ghfs-xattr-key", (Object)"non-ghfs-xattr-value".getBytes(StandardCharsets.UTF_8)));
        gcsFs.getGcs().updateItems((List)ImmutableList.of((Object)updateInfo));
        this.ghfs.setXAttr(filePath, "test-xattr-some", "test-xattr-value".getBytes(StandardCharsets.UTF_8));
        Truth.assertThat(GoogleHadoopFileSystemXAttrsIntegrationTest.toStringValuesMap(gcsFs.getFileInfo(filePath.toUri()).getAttributes())).containsExactly((Object)"non-ghfs-xattr-key", (Object)"non-ghfs-xattr-value", new Object[]{"GHFS_XATTR_test-xattr-some", "test-xattr-value"});
        Truth.assertThat(GoogleHadoopFileSystemXAttrsIntegrationTest.toStringValuesMap(this.ghfs.getXAttrs(filePath))).containsExactly((Object)"test-xattr-some", (Object)"test-xattr-value", new Object[0]);
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void setXAttr() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-set-xattr", 1, false);
        this.ghfs.setXAttr(filePath, "test-xattr-some", "test-xattr-value".getBytes(StandardCharsets.UTF_8));
        this.ghfs.setXAttr(filePath, "test-xattr-null", null);
        this.ghfs.setXAttr(filePath, "test-xattr-empty", new byte[0]);
        Truth.assertThat((Iterable)this.ghfs.listXAttrs(filePath)).containsExactly(new Object[]{"test-xattr-some", "test-xattr-null", "test-xattr-empty"});
        Truth.assertThat((byte[])this.ghfs.getXAttr(filePath, "test-xattr-some")).isEqualTo((Object)"test-xattr-value".getBytes(StandardCharsets.UTF_8));
        Truth.assertThat((byte[])this.ghfs.getXAttr(filePath, "test-xattr-null")).isEmpty();
        Truth.assertThat((byte[])this.ghfs.getXAttr(filePath, "test-xattr-empty")).isEmpty();
        Truth.assertThat(GoogleHadoopFileSystemXAttrsIntegrationTest.toStringValuesMap(this.ghfs.getXAttrs(filePath))).containsExactly((Object)"test-xattr-some", (Object)"test-xattr-value", new Object[]{"test-xattr-null", "", "test-xattr-empty", ""});
        Truth.assertThat(GoogleHadoopFileSystemXAttrsIntegrationTest.toStringValuesMap(this.ghfs.getXAttrs(filePath, (List)ImmutableList.of((Object)"test-xattr-empty", (Object)"test-xattr-some", (Object)"test-xattr-null")))).containsExactly((Object)"test-xattr-some", (Object)"test-xattr-value", new Object[]{"test-xattr-null", "", "test-xattr-empty", ""});
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void setXAttr_throwsExceptionOnNullFlags() {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.ghfs.setXAttr(filePath, "test-key", "val".getBytes(StandardCharsets.UTF_8), null));
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)"flags should not be null or empty");
    }

    @Test
    public void setXAttr_throwsExceptionOnEmptyFlags() {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        EnumSet<XAttrSetFlag> emptyFlags = EnumSet.noneOf(XAttrSetFlag.class);
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.ghfs.setXAttr(filePath, "test-key", "val".getBytes(StandardCharsets.UTF_8), emptyFlags));
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)"flags should not be null or empty");
    }

    @Test
    public void setXAttr_replace() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-set-xattr-replace", 1, false);
        this.ghfs.setXAttr(filePath, "test-xattr-some", "test-xattr-value".getBytes(StandardCharsets.UTF_8));
        Truth.assertThat((byte[])this.ghfs.getXAttr(filePath, "test-xattr-some")).isEqualTo((Object)"test-xattr-value".getBytes(StandardCharsets.UTF_8));
        this.ghfs.setXAttr(filePath, "test-xattr-some", "test-xattr-value-new".getBytes(StandardCharsets.UTF_8));
        Truth.assertThat((byte[])this.ghfs.getXAttr(filePath, "test-xattr-some")).isEqualTo((Object)"test-xattr-value-new".getBytes(StandardCharsets.UTF_8));
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void setXAttr_create_fail() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-set-xattr-create-fail", 1, false);
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.ghfs.setXAttr(filePath, "test-key", "val".getBytes(StandardCharsets.UTF_8), EnumSet.of(XAttrSetFlag.REPLACE)));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("CREATE flag must be set to create XAttr");
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void setXAttr_replace_fail() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-set-xattr-replace-fail", 1, false);
        this.ghfs.setXAttr(filePath, "test-key", "value".getBytes(StandardCharsets.UTF_8));
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.ghfs.setXAttr(filePath, "test-key", "new".getBytes(StandardCharsets.UTF_8), EnumSet.of(XAttrSetFlag.CREATE)));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("REPLACE flag must be set to update XAttr");
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void setXAttr_throwsExceptionOnFlagsNull() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-set-xattr-create-fail", 1, false);
        Throwable e = Assert.assertThrows(IllegalArgumentException.class, () -> this.ghfs.setXAttr(filePath, "test-key", "val".getBytes(StandardCharsets.UTF_8), null));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("flags should not be null or empty");
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void removeXAttr() throws Exception {
        URI fileUri = this.getTempFilePath();
        Path filePath = this.ghfsHelper.castAsHadoopPath(fileUri);
        this.ghfsHelper.writeFile(filePath, "obj-test-remove-xattr", 1, false);
        this.ghfs.setXAttr(filePath, "test-xattr-some", "test-xattr-value-1".getBytes(StandardCharsets.UTF_8));
        this.ghfs.setXAttr(filePath, "test-xattr-to-remove", "test-xattr-value-2".getBytes(StandardCharsets.UTF_8));
        Truth.assertThat(GoogleHadoopFileSystemXAttrsIntegrationTest.toStringValuesMap(this.ghfs.getXAttrs(filePath))).containsExactly((Object)"test-xattr-some", (Object)"test-xattr-value-1", new Object[]{"test-xattr-to-remove", "test-xattr-value-2"});
        this.ghfs.removeXAttr(filePath, "test-xattr-to-remove");
        Truth.assertThat((byte[])this.ghfs.getXAttr(filePath, "test-xattr-to-remove")).isNull();
        Truth.assertThat(GoogleHadoopFileSystemXAttrsIntegrationTest.toStringValuesMap(this.ghfs.getXAttrs(filePath))).containsExactly((Object)"test-xattr-some", (Object)"test-xattr-value-1", new Object[0]);
        Truth.assertThat((Boolean)this.ghfs.delete(filePath, true)).isTrue();
    }

    private static Map<String, String> toStringValuesMap(Map<String, byte[]> map) {
        return map.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), e.getValue() == null ? null : new String((byte[])e.getValue(), StandardCharsets.UTF_8))).collect(HashMap::new, (m, e) -> {
            String cfr_ignored_0 = (String)m.put(e.getKey(), e.getValue());
        }, Map::putAll);
    }
}

