/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.fs.gcs.TestUtils;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.truth.Truth;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GoogleHadoopOutputStreamIntegrationTest {
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsFsIHelper;
    private final GoogleHadoopFileSystemBase.OutputStreamType outputStreamType;
    private final AsyncWriteChannelOptions.PipeType pipeType;

    @BeforeClass
    public static void beforeClass() throws Exception {
        gcsFsIHelper = GoogleCloudStorageFileSystemIntegrationHelper.create();
        gcsFsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() {
        gcsFsIHelper.afterAllTests();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConstructorArguments() {
        return Arrays.asList({GoogleHadoopFileSystemBase.OutputStreamType.BASIC, AsyncWriteChannelOptions.PipeType.IO_STREAM_PIPE}, {GoogleHadoopFileSystemBase.OutputStreamType.BASIC, AsyncWriteChannelOptions.PipeType.NIO_CHANNEL_PIPE}, {GoogleHadoopFileSystemBase.OutputStreamType.FLUSHABLE_COMPOSITE, AsyncWriteChannelOptions.PipeType.IO_STREAM_PIPE}, {GoogleHadoopFileSystemBase.OutputStreamType.SYNCABLE_COMPOSITE, AsyncWriteChannelOptions.PipeType.IO_STREAM_PIPE});
    }

    public GoogleHadoopOutputStreamIntegrationTest(GoogleHadoopFileSystemBase.OutputStreamType outputStreamType, AsyncWriteChannelOptions.PipeType pipeType) {
        this.outputStreamType = outputStreamType;
        this.pipeType = pipeType;
    }

    private Configuration getTestConfig() {
        Configuration conf = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        conf.setEnum(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.getKey(), (Enum)this.outputStreamType);
        conf.setEnum(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_PIPE_TYPE.getKey(), (Enum)this.pipeType);
        return conf;
    }

    @Test
    public void write_withZeroBufferSize() throws Exception {
        URI testFile = gcsFsIHelper.getUniqueObjectUri("GHFSOutputStream_write_withZeroBufferSize");
        Configuration config = this.getTestConfig();
        config.setInt(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_BUFFER_SIZE.getKey(), 0);
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(testFile, config);
        AsyncWriteChannelOptions writeOptions = ghfs.getGcsFs().getOptions().getCloudStorageOptions().getWriteChannelOptions();
        Truth.assertThat((Integer)writeOptions.getBufferSize()).isEqualTo((Object)0);
        try (GoogleHadoopOutputStream out = new GoogleHadoopOutputStream((GoogleHadoopFileSystemBase)ghfs, testFile, new FileSystem.Statistics(ghfs.getScheme()), CreateFileOptions.DEFAULT_OVERWRITE);){
            out.write(1);
        }
        FileStatus fileStatus = ghfs.getFileStatus(ghfs.getHadoopPath(testFile));
        Truth.assertThat((Long)fileStatus.getLen()).isEqualTo((Object)1);
    }

    @Test
    public void time_statistics() throws Exception {
        URI testFile = gcsFsIHelper.getUniqueObjectUri("GHFSOutputStream_time_statistics");
        Configuration config = this.getTestConfig();
        config.setInt(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_BUFFER_SIZE.getKey(), 0);
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(testFile, config);
        GhfsStorageStatistics stats = TestUtils.getStorageStatistics();
        FileSystem.Statistics statistics = new FileSystem.Statistics(ghfs.getScheme());
        GoogleHadoopOutputStream fout = new GoogleHadoopOutputStream((GoogleHadoopFileSystemBase)ghfs, testFile, statistics, CreateFileOptions.DEFAULT_OVERWRITE);
        byte[] data1 = new byte[]{15, 14, 14, 13};
        byte[] data2 = new byte[]{11, 13, 14, 14, 15};
        fout.write(data1, 0, data1.length);
        fout.write(data2, 0, data2.length);
        fout.close();
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_WRITE_CLOSE_OPERATIONS, 1);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_WRITE_OPERATIONS, 2);
        TestUtils.verifyDurationMetric(stats, GhfsStatistic.STREAM_WRITE_BYTES, data1.length + data2.length);
    }
}

