/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import com.google.common.base.Strings;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class HadoopFileSystemIntegrationHelper
extends GoogleCloudStorageFileSystemIntegrationHelper {
    FileSystem ghfs;
    FileSystemDescriptor ghfsFileSystemDescriptor;
    FileSystemStatistics statistics = FileSystemStatistics.IGNORE;

    public HadoopFileSystemIntegrationHelper(FileSystem hfs, FileSystemDescriptor ghfsFileSystemDescriptor) throws IOException {
        super(new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).build()));
        this.ghfs = hfs;
        this.ghfsFileSystemDescriptor = ghfsFileSystemDescriptor;
    }

    public void setIgnoreStatistics() {
        this.statistics = FileSystemStatistics.IGNORE;
    }

    protected boolean rename(URI src, URI dst) throws IOException {
        Path srcHadoopPath = this.castAsHadoopPath(src);
        Path dstHadoopPath = this.castAsHadoopPath(dst);
        return this.ghfs.rename(srcHadoopPath, dstHadoopPath);
    }

    protected boolean delete(URI path, boolean recursive) throws IOException {
        Path hadoopPath = this.castAsHadoopPath(path);
        if (recursive) {
            return this.ghfs.delete(hadoopPath);
        }
        return this.ghfs.delete(hadoopPath, recursive);
    }

    protected void delete(String bucketName) throws IOException {
        Path path = this.createSchemeCompatibleHadoopPath(bucketName, null);
        this.ghfs.delete(path, false);
    }

    public void afterAllTests() {
        try {
            this.ghfs.delete(new Path(this.ghfs.getUri()), true);
            super.afterAllTests();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception while cleaning up the root %s", this.ghfs.getUri()), e);
        }
    }

    protected void delete(String bucketName, String objectName) throws IOException {
        Path path = this.createSchemeCompatibleHadoopPath(bucketName, objectName);
        this.ghfs.delete(path, false);
    }

    protected boolean mkdirs(URI path) throws IOException {
        Path hadoopPath = this.castAsHadoopPath(path);
        return this.ghfs.mkdirs(hadoopPath);
    }

    protected boolean exists(URI path) throws IOException {
        Path hadoopPath = this.castAsHadoopPath(path);
        try {
            this.ghfs.getFileStatus(hadoopPath);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    protected boolean isDirectory(URI path) throws IOException {
        Path hadoopPath = this.castAsHadoopPath(path);
        try {
            FileStatus status = this.ghfs.getFileStatus(hadoopPath);
            return status.isDir();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    protected SeekableByteChannel open(String bucketName, String objectName) throws IOException {
        return null;
    }

    protected WritableByteChannel create(URI path, CreateFileOptions options) throws IOException {
        return null;
    }

    public String readTextFile(String bucketName, String objectName) throws IOException {
        Path hadoopPath = this.createSchemeCompatibleHadoopPath(bucketName, objectName);
        return this.readTextFile(hadoopPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readTextFile(Path hadoopPath) throws IOException {
        FSDataInputStream readStream = null;
        byte[] readBuffer = new byte[1024];
        StringBuilder returnBuffer = new StringBuilder();
        try {
            readStream = this.ghfs.open(hadoopPath);
            int numBytesRead = readStream.read(readBuffer);
            while (numBytesRead > 0) {
                returnBuffer.append(new String(readBuffer, 0, numBytesRead, StandardCharsets.UTF_8));
                numBytesRead = readStream.read(readBuffer);
            }
        }
        finally {
            if (readStream != null) {
                readStream.close();
            }
        }
        return returnBuffer.toString();
    }

    protected String readTextFile(String bucketName, String objectName, int offset, int len, boolean checkOverflow) throws IOException {
        Path hadoopPath = this.createSchemeCompatibleHadoopPath(bucketName, objectName);
        return this.readTextFile(hadoopPath, offset, len, checkOverflow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readTextFile(Path hadoopPath, int offset, int len, boolean checkOverflow) throws IOException {
        String text = null;
        FSDataInputStream readStream = null;
        long fileSystemBytesRead = 0L;
        FileSystem.Statistics stats = FileSystem.getStatistics((String)this.ghfsFileSystemDescriptor.getScheme(), this.ghfs.getClass());
        if (stats != null) {
            fileSystemBytesRead = stats.getBytesRead();
        }
        try {
            int bufferSize = len;
            byte[] readBuffer = new byte[bufferSize += checkOverflow ? 1 : 0];
            readStream = this.ghfs.open(hadoopPath);
            int numBytesRead = offset > 0 ? readStream.read((long)offset, readBuffer, 0, bufferSize) : readStream.read(readBuffer);
            Truth.assertThat((Integer)numBytesRead).isEqualTo((Object)len);
            text = new String(readBuffer, 0, numBytesRead, StandardCharsets.UTF_8);
        }
        finally {
            if (readStream != null) {
                readStream.close();
            }
        }
        stats = FileSystem.getStatistics((String)this.ghfsFileSystemDescriptor.getScheme(), this.ghfs.getClass());
        Truth.assertThat((Object)stats).isNotNull();
        long endFileSystemBytesRead = stats.getBytesRead();
        int bytesReadStats = (int)(endFileSystemBytesRead - fileSystemBytesRead);
        if (this.statistics == FileSystemStatistics.EXACT) {
            Truth.assertWithMessage((String)"FS statistics mismatch fetched from class '%s'", (Object[])new Object[]{this.ghfs.getClass()}).that(Integer.valueOf(bytesReadStats)).isEqualTo((Object)len);
        } else if (this.statistics == FileSystemStatistics.GREATER_OR_EQUAL) {
            Truth.assertWithMessage((String)"Expected %d <= %d", (Object[])new Object[]{len, bytesReadStats}).that(Boolean.valueOf(len <= bytesReadStats)).isTrue();
        } else if (this.statistics == FileSystemStatistics.NONE) {
            Truth.assertWithMessage((String)"FS statistics expected to be 0").that(Long.valueOf(fileSystemBytesRead)).isEqualTo((Object)0);
            Truth.assertWithMessage((String)"FS statistics expected to be 0").that(Long.valueOf(endFileSystemBytesRead)).isEqualTo((Object)0);
        } else if (this.statistics == FileSystemStatistics.IGNORE) {
            // empty if block
        }
        return text;
    }

    protected void mkdir(String bucketName, String objectName) throws IOException {
        Path path = this.createSchemeCompatibleHadoopPath(bucketName, objectName);
        this.ghfs.mkdirs(path);
    }

    protected void mkdir(String bucketName) throws IOException {
        Path path = this.createSchemeCompatibleHadoopPath(bucketName, null);
        this.ghfs.mkdirs(path);
    }

    protected void clearBucket(String bucketName) throws IOException {
        Path hadoopPath = this.createSchemeCompatibleHadoopPath(bucketName, null);
        FileStatus[] statusList = null;
        try {
            statusList = this.ghfs.listStatus(hadoopPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (statusList != null) {
            for (FileStatus status : statusList) {
                if (this.ghfs.delete(status.getPath(), true)) continue;
                System.err.println(String.format("Failed to delete path: '%s'", status.getPath()));
            }
        }
    }

    protected Path createSchemeCompatibleHadoopPath(String bucketName, String objectName) {
        return this.createSchemeCompatibleHadoopPath(this.getPath(bucketName, objectName));
    }

    protected Path createSchemeCompatibleHadoopPath(URI path) {
        return this.castAsHadoopPath(path);
    }

    protected Path castAsHadoopPath(URI gcsPath) {
        String authority = gcsPath.getAuthority();
        String childPath = gcsPath.getRawPath();
        if (childPath != null && childPath.startsWith("/")) {
            childPath = childPath.substring(1);
        }
        if (Strings.isNullOrEmpty((String)childPath)) {
            return Strings.isNullOrEmpty((String)authority) ? this.ghfsFileSystemDescriptor.getFileSystemRoot() : new Path(this.ghfsFileSystemDescriptor.getFileSystemRoot(), authority);
        }
        return Strings.isNullOrEmpty((String)authority) ? new Path(this.ghfsFileSystemDescriptor.getFileSystemRoot(), childPath) : new Path(this.ghfsFileSystemDescriptor.getFileSystemRoot(), new Path(authority, childPath));
    }

    protected FileStatus[] listStatus(Path hadoopPath) throws IOException {
        return this.ghfs.listStatus(hadoopPath);
    }

    protected int writeFile(URI path, byte[] buffer, int numWrites) throws IOException {
        Path hadoopPath = this.createSchemeCompatibleHadoopPath(path);
        return this.writeFile(hadoopPath, buffer, numWrites, true);
    }

    public int writeFile(Path hadoopPath, String text, int numWrites, boolean overwrite) throws IOException {
        return this.writeFile(hadoopPath, text.getBytes(StandardCharsets.UTF_8), numWrites, overwrite);
    }

    public int writeFile(Path hadoopPath, byte[] buffer, int numWrites, boolean overwrite) throws IOException {
        int numBytesWritten = -1;
        int totalBytesWritten = 0;
        long fileSystemBytesWritten = 0L;
        FileSystem.Statistics stats = FileSystem.getStatistics((String)this.ghfsFileSystemDescriptor.getScheme(), this.ghfs.getClass());
        if (stats != null) {
            fileSystemBytesWritten = stats.getBytesWritten();
        }
        try (FSDataOutputStream writeStream = this.ghfs.create(hadoopPath, FsPermission.getDefault(), overwrite, ((Integer)GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_BUFFER_SIZE.getDefault()).intValue(), (short)3, ((Long)GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault()).longValue(), null);){
            for (int i = 0; i < numWrites; ++i) {
                writeStream.write(buffer, 0, buffer.length);
                numBytesWritten = buffer.length;
                totalBytesWritten += numBytesWritten;
            }
        }
        stats = FileSystem.getStatistics((String)this.ghfsFileSystemDescriptor.getScheme(), this.ghfs.getClass());
        Truth.assertThat((Object)stats).isNotNull();
        long endFileSystemBytesWritten = stats.getBytesWritten();
        int bytesWrittenStats = (int)(endFileSystemBytesWritten - fileSystemBytesWritten);
        if (this.statistics == FileSystemStatistics.EXACT) {
            Truth.assertWithMessage((String)"FS statistics mismatch fetched from class '%s'", (Object[])new Object[]{this.ghfs.getClass()}).that(Integer.valueOf(bytesWrittenStats)).isEqualTo((Object)totalBytesWritten);
        } else if (this.statistics == FileSystemStatistics.GREATER_OR_EQUAL) {
            Truth.assertWithMessage((String)"Expected %d <= %d", (Object[])new Object[]{totalBytesWritten, bytesWrittenStats}).that(Boolean.valueOf(totalBytesWritten <= bytesWrittenStats)).isTrue();
        } else if (this.statistics == FileSystemStatistics.NONE || this.statistics == FileSystemStatistics.IGNORE) {
            // empty if block
        }
        return totalBytesWritten;
    }

    public URI getPath(String bucketName, String objectName, boolean allowEmpty) {
        return UriPaths.fromStringPathComponents((String)bucketName, (String)objectName, (boolean)allowEmpty);
    }

    public static enum FileSystemStatistics {
        NONE,
        EXACT,
        GREATER_OR_EQUAL,
        IGNORE;

    }
}

