/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemTestBase;
import com.google.cloud.hadoop.fs.gcs.HdfsBehavior;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HadoopFileSystemIntegrationTest
extends HadoopFileSystemTestBase {
    public static final String HDFS_ROOT = "HDFS_ROOT";
    static String hdfsRoot;
    @ClassRule
    public static TemporaryFolder folder;

    public void before() throws IOException, URISyntaxException {
        hdfsRoot = System.getenv(HDFS_ROOT);
        if (Strings.isNullOrEmpty((String)hdfsRoot)) {
            hdfsRoot = "file://" + folder.newFolder("hdfs_root").getAbsolutePath();
        }
        URI hdfsUri = null;
        try {
            hdfsUri = new URI(hdfsRoot);
        }
        catch (URISyntaxException e) {
            throw new AssertionError("Invalid HDFS path: " + hdfsRoot, e);
        }
        Configuration config = new Configuration();
        config.set("fs.default.name", hdfsRoot);
        this.ghfs = FileSystem.get((URI)hdfsUri, (Configuration)config);
        this.ghfsFileSystemDescriptor = new FileSystemDescriptor(){

            public Path getFileSystemRoot() {
                return new Path(hdfsRoot);
            }

            public String getScheme() {
                return this.getFileSystemRoot().toUri().getScheme();
            }
        };
        this.postCreateInit();
        this.ghfsHelper.setIgnoreStatistics();
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        this.deleteHelper(new HdfsBehavior());
    }

    @Override
    @Test
    public void testMkdirs() throws Exception {
        this.mkdirsHelper(new HdfsBehavior());
    }

    @Override
    @Test
    public void testRename() throws Exception {
        this.renameHelper(new HdfsBehavior());
    }

    static {
        folder = new TemporaryFolder();
    }
}

