/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.fs.gcs.HdfsBehavior;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationTest;
import com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public abstract class HadoopFileSystemTestBase
extends GoogleCloudStorageFileSystemIntegrationTest {
    FileSystem ghfs;
    FileSystemDescriptor ghfsFileSystemDescriptor;
    protected HadoopFileSystemIntegrationHelper ghfsHelper;

    public void postCreateInit() throws IOException {
        this.postCreateInit(new HadoopFileSystemIntegrationHelper(this.ghfs, this.ghfsFileSystemDescriptor));
    }

    public void postCreateInit(HadoopFileSystemIntegrationHelper helper) throws IOException {
        this.ghfsHelper = helper;
        this.ghfsHelper.ghfs.mkdirs(new Path(this.ghfsHelper.ghfsFileSystemDescriptor.getFileSystemRoot().toUri()));
        super.postCreateInit((GoogleCloudStorageFileSystemIntegrationHelper)this.ghfsHelper);
        this.gcsfs = null;
    }

    public void after() throws IOException {
        if (this.ghfs != null) {
            if (this.ghfs instanceof GoogleHadoopFileSystem) {
                this.gcs = ((GoogleHadoopFileSystem)this.ghfs).getGcsFs().getGcs();
            }
            super.after();
            try {
                this.ghfs.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
            this.ghfs = null;
        }
    }

    private void validateFileStatusInternal(String bucketName, String objectName, boolean expectedToExist, FileStatus fileStatus) throws IOException {
        Truth.assertWithMessage((String)"Existence of bucketName '%s', objectName '%s'", (Object[])new Object[]{bucketName, objectName}).that(Boolean.valueOf(fileStatus != null)).isEqualTo((Object)expectedToExist);
        if (fileStatus != null) {
            long expectedSize = this.ghfsHelper.getExpectedObjectSize(objectName, expectedToExist);
            if (expectedSize != Long.MIN_VALUE) {
                Truth.assertWithMessage((String)"%s", (Object[])new Object[]{fileStatus.getPath()}).that(Long.valueOf(fileStatus.getLen())).isEqualTo((Object)expectedSize);
            }
            boolean expectedToBeDir = Strings.isNullOrEmpty((String)objectName) || StringPaths.isDirectoryPath((String)objectName);
            Truth.assertWithMessage((String)"%s", (Object[])new Object[]{fileStatus.getPath()}).that(Boolean.valueOf(fileStatus.isDir())).isEqualTo((Object)expectedToBeDir);
            Instant currentTime = Instant.now();
            Instant modificationTime = Instant.ofEpochMilli(fileStatus.getModificationTime());
            if (!expectedToBeDir || fileStatus.getModificationTime() != 0L) {
                Truth.assertWithMessage((String)"Stale file? testStartTime: %s modificationTime: %s bucket: '%s' object: '%s'", (Object[])new Object[]{testStartTime, modificationTime, bucketName, objectName}).that((Comparable)modificationTime).isAtLeast((Comparable)testStartTime.minusMillis(1000L));
            }
            Truth.assertWithMessage((String)"Clock skew? currentTime: %s modificationTime: %s bucket: '%s' object: '%s'", (Object[])new Object[]{currentTime, modificationTime, bucketName, objectName}).that((Comparable)modificationTime).isAtMost((Comparable)currentTime);
        }
    }

    protected void validateGetFileInfo(String bucketName, String objectName, boolean expectedToExist) throws IOException {
        URI path = this.ghfsHelper.getPath(bucketName, objectName, true);
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        FileStatus fileStatus = null;
        try {
            fileStatus = this.ghfs.getFileStatus(hadoopPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fileStatus != null) {
            Truth.assertWithMessage((String)"Hadoop paths for URI: %s", (Object[])new Object[]{path}).that((Comparable)hadoopPath).isEqualTo((Object)fileStatus.getPath());
        }
        this.validateFileStatusInternal(bucketName, objectName, expectedToExist, fileStatus);
    }

    protected void validateListFileInfo(String bucketName, String objectNamePrefix, boolean expectedToExist, String ... expectedListedNames) throws IOException {
        Object[] fileStatus;
        boolean childPathsExpectedToExist = expectedToExist && expectedListedNames != null;
        boolean listRoot = bucketName == null;
        ArrayList<Path> expectedPaths = new ArrayList<Path>();
        HashMap<Path, String[]> pathToComponents = new HashMap<Path, String[]>();
        if (childPathsExpectedToExist) {
            for (String expectedListedName : expectedListedNames) {
                String[] pathComponents = new String[2];
                if (listRoot) {
                    pathComponents[0] = expectedListedName;
                    pathComponents[1] = null;
                } else {
                    pathComponents[0] = bucketName;
                    pathComponents[1] = expectedListedName;
                }
                Path expectedPath = this.ghfsHelper.castAsHadoopPath(this.ghfsHelper.getPath(pathComponents[0], pathComponents[1], true));
                expectedPaths.add(expectedPath);
                pathToComponents.put(expectedPath, pathComponents);
            }
        }
        URI path = this.ghfsHelper.getPath(bucketName, objectNamePrefix, true);
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        try {
            fileStatus = this.ghfsHelper.listStatus(hadoopPath);
        }
        catch (FileNotFoundException fnfe) {
            fileStatus = null;
            Truth.assertWithMessage((String)"Hadoop path %s expected to exist", (Object[])new Object[]{hadoopPath}).that(Boolean.valueOf(expectedToExist)).isFalse();
        }
        if (!this.ghfsFileSystemDescriptor.getScheme().equals("file")) {
            Truth.assertWithMessage((String)"Hadoop path %s", (Object[])new Object[]{hadoopPath}).that(Boolean.valueOf(fileStatus != null)).isEqualTo((Object)expectedToExist);
        } else if (!expectedToExist && fileStatus != null) {
            Truth.assertThat((Object[])fileStatus).isEmpty();
        }
        if (fileStatus != null) {
            HashSet<Path> actualPaths = new HashSet<Path>();
            for (Object status : fileStatus) {
                Path actualPath = status.getPath();
                if (status.isDir()) {
                    Truth.assertThat((String)status.getPath().getName()).isNotEmpty();
                }
                actualPaths.add(actualPath);
                String[] uriComponents = (String[])pathToComponents.get(actualPath);
                if (uriComponents == null) continue;
                this.validateFileStatusInternal(uriComponents[0], uriComponents[1], true, (FileStatus)status);
            }
            if (listRoot) {
                Truth.assertThat(actualPaths).containsAtLeastElementsIn(expectedPaths);
            } else {
                Truth.assertThat(actualPaths).containsExactlyElementsIn(expectedPaths);
            }
        }
    }

    @Test
    public void testReadInvalidArgs() throws IOException {
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        this.ghfsHelper.writeFile(hadoopPath, "file text", 1, true);
        FSDataInputStream readStream = this.ghfs.open(hadoopPath);
        byte[] buffer = new byte[1];
        int numBytesRead = readStream.read(buffer, 0, buffer.length);
        Truth.assertWithMessage((String)"Expected exactly 1 byte to be read").that(Integer.valueOf(numBytesRead)).isEqualTo((Object)1);
        this.testReadInvalidArgsHelper(readStream, null, 0, 1, NullPointerException.class);
        this.testReadInvalidArgsHelper(readStream, buffer, -1, 1, IndexOutOfBoundsException.class);
        this.testReadInvalidArgsHelper(readStream, buffer, 0, -1, IndexOutOfBoundsException.class);
        this.testReadInvalidArgsHelper(readStream, buffer, 0, 2, IndexOutOfBoundsException.class);
    }

    private void testReadInvalidArgsHelper(FSDataInputStream readStream, byte[] buffer, int offset, int length, Class<? extends Exception> exceptionClass) {
        Exception e = (Exception)Assert.assertThrows(Exception.class, () -> readStream.read(buffer, offset, length));
        Truth.assertThat((Throwable)e).isInstanceOf(exceptionClass);
    }

    @Test
    public void testWrite1Byte() throws IOException {
        String text = "Hello World!";
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        FSDataOutputStream writeStream = this.ghfs.create(hadoopPath);
        for (byte b : textBytes) {
            writeStream.write((int)b);
        }
        writeStream.close();
        String readText = this.ghfsHelper.readTextFile(hadoopPath, 0, textBytes.length, true);
        Truth.assertWithMessage((String)"testWrite1Byte: write-read mismatch").that(readText).isEqualTo((Object)text);
    }

    @Test
    public void testDelete() throws Exception {
        this.deleteHelper(new HdfsBehavior());
    }

    @Test
    public void testMkdirs() throws Exception {
        this.mkdirsHelper(new HdfsBehavior());
    }

    @Test
    public void testRename() throws Exception {
        this.renameHelper(new HdfsBehavior());
    }

    @Test
    public void testOverwrite() throws IOException {
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        Assert.assertThrows(FileNotFoundException.class, () -> this.ghfs.getFileStatus(hadoopPath));
        String text = "Hello World!";
        int numBytesWritten = this.ghfsHelper.writeFile(hadoopPath, text, 1, false);
        Truth.assertThat((Integer)numBytesWritten).isEqualTo((Object)text.getBytes(StandardCharsets.UTF_8).length);
        Assert.assertThrows(IOException.class, () -> this.ghfsHelper.writeFile(hadoopPath, text, 1, false));
        String textToOverwrite = "World Hello!";
        this.ghfsHelper.writeFile(hadoopPath, textToOverwrite, 1, true);
        String readText = this.ghfsHelper.readTextFile(hadoopPath);
        Truth.assertThat((String)readText).isEqualTo((Object)textToOverwrite);
    }

    @Test
    public void testConcurrentCreationWithoutOverwrite_onlyOneSucceeds() throws Exception {
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        Assert.assertThrows(FileNotFoundException.class, () -> this.ghfs.getFileStatus(hadoopPath));
        ImmutableList texts = ImmutableList.of((Object)"Hello World!", (Object)"World Hello! Long");
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        List futures = executorService.invokeAll(ImmutableList.of(() -> this.lambda$testConcurrentCreationWithoutOverwrite_onlyOneSucceeds$4(hadoopPath, (List)texts), () -> this.lambda$testConcurrentCreationWithoutOverwrite_onlyOneSucceeds$5(hadoopPath, (List)texts)));
        executorService.shutdown();
        Truth.assertThat((Boolean)executorService.awaitTermination(1L, TimeUnit.MINUTES)).isTrue();
        String readText = this.ghfsHelper.readTextFile(hadoopPath);
        Truth.assertThat((Iterable)ImmutableList.of((Object)readText)).containsAnyIn((Iterable)texts);
        for (int i = 0; i < futures.size(); ++i) {
            Future future = futures.get(i);
            String text = (String)texts.get(i);
            if (readText.equals(text)) {
                Truth.assertThat((Integer)((Integer)future.get())).isEqualTo((Object)text.length());
                continue;
            }
            Assert.assertThrows(ExecutionException.class, future::get);
        }
        String text = "World!";
        this.ghfsHelper.writeFile(hadoopPath, text, 1, true);
        Truth.assertThat((String)this.ghfsHelper.readTextFile(hadoopPath)).isEqualTo((Object)"World!");
    }

    @Test
    public void testAppend() throws IOException {
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        this.ghfsHelper.writeTextFile(path.getAuthority(), path.getPath(), "content");
        try (FSDataOutputStream fsos = this.ghfs.append(hadoopPath);){
            fsos.write("_appended".getBytes(StandardCharsets.UTF_8));
        }
        Truth.assertThat((String)this.ghfsHelper.readTextFile(hadoopPath)).isEqualTo((Object)"content_appended");
    }

    @Test
    public void testGetDefaultReplication() throws IOException {
        Truth.assertThat((Comparable)Short.valueOf(this.ghfs.getDefaultReplication())).isEqualTo((Object)3);
    }

    @Test
    public void testFilePosition() throws IOException {
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        String text = "Hello World!";
        int numBytesWritten = this.ghfsHelper.writeFile(hadoopPath, text, 1, false);
        try (FSDataInputStream readStream = this.ghfs.open(hadoopPath);){
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)0);
            Truth.assertThat((Integer)readStream.read()).isEqualTo((Object)Character.valueOf('H'));
            Truth.assertThat((Integer)readStream.read()).isEqualTo((Object)Character.valueOf('e'));
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)2);
            readStream.seek(2L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)2);
            readStream.seek(2L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)2);
            readStream.seek(6L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)6);
            Truth.assertThat((Integer)readStream.read()).isEqualTo((Object)Character.valueOf('W'));
            long posEOF = (long)numBytesWritten - 1L;
            readStream.seek(posEOF);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)posEOF);
            int val = readStream.read();
            Truth.assertThat((Integer)val).isNotEqualTo((Object)-1);
            val = readStream.read();
            Truth.assertThat((Integer)val).isEqualTo((Object)-1);
            readStream.seek(0L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)0);
            Assert.assertThrows(IOException.class, () -> readStream.seek((long)(numBytesWritten + 1)));
            if (this.ghfs instanceof GoogleHadoopFileSystemBase) {
                long someValidPosition = 2L;
                Truth.assertThat((Boolean)readStream.seekToNewSource(someValidPosition)).isFalse();
                Truth.assertThat((Boolean)readStream.markSupported()).isFalse();
            }
        }
    }

    @Test
    public void testFilePositionInDepthSeeks() throws IOException {
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        int bufferSize = 0x800000;
        byte[] testBytes = new byte[bufferSize * 3];
        for (int i = 0; i < testBytes.length; ++i) {
            testBytes[i] = (byte)(i * i);
        }
        int numBytesWritten = this.ghfsHelper.writeFile(hadoopPath, testBytes, 1, false);
        Truth.assertThat((Integer)numBytesWritten).isEqualTo((Object)testBytes.length);
        try (FSDataInputStream readStream = this.ghfs.open(hadoopPath, bufferSize);){
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)0);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[0]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)1);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[1]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)2);
            readStream.seek(0L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)0);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[0]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)1);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[1]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)2);
            readStream.seek(2L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)2);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[2]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)3);
            int midPos = bufferSize / 2;
            readStream.seek((long)midPos);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)midPos);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[midPos]);
            readStream.seek(42L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)42);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[42]);
            int edgePos = bufferSize - 1;
            readStream.seek((long)edgePos);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)edgePos);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[edgePos]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)(edgePos + 1));
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[edgePos + 1]);
            readStream.seek((long)edgePos);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)edgePos);
            readStream.seek((long)(edgePos + 1));
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)(edgePos + 1));
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[edgePos + 1]);
            int bufferTwoStart = bufferSize * 2;
            readStream.seek((long)bufferTwoStart);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)bufferTwoStart);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[bufferTwoStart]);
            readStream.seek((long)(bufferTwoStart + 42));
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)(bufferTwoStart + 42));
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[bufferTwoStart + 42]);
            readStream.seek((long)bufferTwoStart);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)bufferTwoStart);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[bufferTwoStart]);
            int bufferOneInternal = bufferSize + 42;
            readStream.seek((long)bufferOneInternal);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)bufferOneInternal);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[bufferOneInternal]);
            readStream.seek(0L);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)0);
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[0]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)1);
            readStream.seek((long)(testBytes.length - 1));
            Truth.assertThat((Comparable)Byte.valueOf((byte)readStream.read())).isEqualTo((Object)testBytes[testBytes.length - 1]);
            Truth.assertThat((Long)readStream.getPos()).isEqualTo((Object)testBytes.length);
        }
    }

    @Test
    public void testPreemptivelyEscapedPaths() throws IOException {
        URI parentUri = this.getTempFilePath();
        Path parentPath = this.ghfsHelper.castAsHadoopPath(parentUri);
        Path escapedPath = new Path(parentPath, new Path("foo%3Abar"));
        this.ghfsHelper.writeFile(escapedPath, "foo", 1, true);
        Truth.assertThat((Boolean)this.ghfs.exists(escapedPath)).isTrue();
        FileStatus status = this.ghfs.getFileStatus(escapedPath);
        Truth.assertThat((Comparable)status.getPath()).isEqualTo((Object)escapedPath);
        Truth.assertThat((Boolean)this.ghfs.delete(parentPath, true)).isTrue();
    }

    protected List<WorkingDirData> setUpWorkingDirectoryTest() throws Exception {
        String[] objectNames = new String[]{"f1", "d0/", "d1/f1", "d1/d11/f1"};
        this.ghfsHelper.clearBucket(this.sharedBucketName1);
        this.ghfsHelper.createObjectsWithSubdirs(this.sharedBucketName1, objectNames);
        ArrayList<WorkingDirData> wddList = new ArrayList<WorkingDirData>();
        Path rootPath = this.ghfsFileSystemDescriptor.getFileSystemRoot();
        wddList.add(WorkingDirData.any(rootPath, rootPath));
        wddList.add(WorkingDirData.absolute(this.ghfsHelper, "d0/", "d0/"));
        wddList.add(WorkingDirData.absolute(this.ghfsHelper, "d1/", "d1/"));
        wddList.add(WorkingDirData.absolute(this.ghfsHelper, "d1/d11/", "d1/d11/"));
        wddList.add(WorkingDirData.absolute(this.ghfsHelper, null, null));
        return wddList;
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        List<WorkingDirData> wddList = this.setUpWorkingDirectoryTest();
        for (WorkingDirData wdd : wddList) {
            Path path = wdd.path;
            Path expectedWorkingDir = wdd.expectedPath;
            Path currentWorkingDir = this.ghfs.getWorkingDirectory();
            this.ghfs.setWorkingDirectory(path);
            Path newWorkingDir = this.ghfs.getWorkingDirectory();
            if (expectedWorkingDir != null) {
                Truth.assertThat((Comparable)newWorkingDir).isEqualTo((Object)expectedWorkingDir);
                continue;
            }
            Truth.assertThat((Comparable)newWorkingDir).isEqualTo((Object)currentWorkingDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadToEOFAndRewind() throws IOException {
        URI path = this.getTempFilePath();
        Path hadoopPath = this.ghfsHelper.castAsHadoopPath(path);
        byte[] byteBuffer = new byte[1024];
        for (int i = 0; i < byteBuffer.length; ++i) {
            byteBuffer[i] = (byte)(i % 255);
        }
        this.ghfsHelper.writeFile(hadoopPath, byteBuffer, 1, false);
        try (FSDataInputStream input = this.ghfs.open(hadoopPath);){
            byte[] readBuffer1 = new byte[512];
            input.seek(511L);
            Truth.assertThat((Integer)input.read(readBuffer1, 0, 512)).isEqualTo((Object)512);
            input.seek(0L);
            input.seek(511L);
            Truth.assertThat((Integer)input.read(readBuffer1, 0, 512)).isEqualTo((Object)512);
        }
        finally {
            this.ghfs.delete(hadoopPath);
        }
    }

    public void testGetFileInfos() {
    }

    public void testFileCreationSetsAttributes() {
    }

    public void renameDirectoryShouldCopyMarkerFilesLast() {
    }

    public void testComposeSuccess() {
    }

    public void read_failure_ifObjectWasModifiedDuringRead() {
    }

    private /* synthetic */ Integer lambda$testConcurrentCreationWithoutOverwrite_onlyOneSucceeds$5(Path hadoopPath, List texts) throws Exception {
        return this.ghfsHelper.writeFile(hadoopPath, (String)texts.get(1), 1, false);
    }

    private /* synthetic */ Integer lambda$testConcurrentCreationWithoutOverwrite_onlyOneSucceeds$4(Path hadoopPath, List texts) throws Exception {
        return this.ghfsHelper.writeFile(hadoopPath, (String)texts.get(0), 1, false);
    }

    static class WorkingDirData {
        Path path;
        Path expectedPath;

        private WorkingDirData(Path path, Path expectedPath) {
            this.path = path;
            this.expectedPath = expectedPath;
        }

        static WorkingDirData absolute(HadoopFileSystemIntegrationHelper ghfsHelper, String objectName, String expectedObjectName) {
            return new WorkingDirData(ghfsHelper.createSchemeCompatibleHadoopPath(ghfsHelper.sharedBucketName1, objectName), ghfsHelper.createSchemeCompatibleHadoopPath(ghfsHelper.sharedBucketName1, expectedObjectName));
        }

        static WorkingDirData absolute(HadoopFileSystemIntegrationHelper ghfsHelper, String objectName) {
            return new WorkingDirData(ghfsHelper.createSchemeCompatibleHadoopPath(ghfsHelper.sharedBucketName1, objectName), null);
        }

        static WorkingDirData any(Path path, Path expectedPath) {
            return new WorkingDirData(path, expectedPath);
        }
    }
}

