/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.InMemoryGlobberFileSystem;
import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InMemoryGlobberFileSystemTest {
    @Test
    public void testGetFileStatus_shouldReturnExceptionForNotExistingFile() throws Exception {
        InMemoryGoogleHadoopFileSystem ghfs = new InMemoryGoogleHadoopFileSystem();
        FileSystem helperFileSystem = InMemoryGlobberFileSystem.createInstance((Configuration)new Configuration(), (Path)ghfs.getWorkingDirectory(), (Collection)ImmutableSet.of());
        FileNotFoundException e = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> helperFileSystem.getFileStatus(ghfs.getWorkingDirectory()));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith(String.format("Path '%s' (qualified: '%s') does not exist.", ghfs.getWorkingDirectory(), ghfs.getWorkingDirectory()));
    }
}

