/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;

public class InMemoryGoogleHadoopFileSystem
extends GoogleHadoopFileSystem {
    private static GoogleCloudStorageFileSystem inMemoryGcsFs = InMemoryGoogleHadoopFileSystem.createUnderlyingStorage();

    public InMemoryGoogleHadoopFileSystem() throws IOException {
        super(inMemoryGcsFs);
        this.initialize();
    }

    private static synchronized GoogleCloudStorageFileSystem createUnderlyingStorage() {
        if (inMemoryGcsFs != null) {
            return inMemoryGcsFs;
        }
        try {
            return new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).build());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create GoogleCloudStorageFileSystem", e);
        }
    }

    public static Configuration getSampleConfiguration() throws IOException {
        Configuration config = new Configuration();
        config.set("fs.gs.impl", InMemoryGoogleHadoopFileSystem.class.getName());
        return config;
    }

    private void initialize() throws IOException {
        URI initUri;
        try {
            initUri = new URI("gs://test_bucket/");
        }
        catch (URISyntaxException e) {
            this.close();
            throw new IllegalArgumentException(e);
        }
        this.initialize(initUri, InMemoryGoogleHadoopFileSystem.getSampleConfiguration());
    }
}

