/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStorageStatistics;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageStatistics;
import com.google.common.truth.Truth;
import org.apache.hadoop.fs.GlobalStorageStatistics;

class TestUtils {
    TestUtils() {
    }

    static void verifyDurationMetric(GhfsStorageStatistics stats, GhfsStatistic statistic, int expected) {
        String symbol = statistic.getSymbol();
        long minValue = stats.getMin(symbol);
        long maxValue = stats.getMax(symbol);
        long meanValue = Double.valueOf(stats.getMean(symbol)).longValue();
        Truth.assertThat((Long)stats.getLong(symbol)).isEqualTo((Object)expected);
        Truth.assertThat((Long)minValue).isLessThan((Comparable)Long.valueOf(maxValue + 1L));
        Truth.assertThat((Long)minValue).isLessThan((Comparable)Long.valueOf(meanValue + 1L));
        Truth.assertThat((Long)meanValue).isLessThan((Comparable)Long.valueOf(maxValue + 1L));
    }

    static GhfsStorageStatistics getStorageStatistics() {
        GhfsStorageStatistics stats = (GhfsStorageStatistics)GlobalStorageStatistics.INSTANCE.get("GhfsStorageStatistics");
        stats.reset();
        return stats;
    }

    static void verifyCounter(GhfsStorageStatistics stats, GhfsStatistic statName, int expected) {
        Truth.assertThat((Long)stats.getLong(statName.getSymbol())).isEqualTo((Object)expected);
    }

    static void verifyCounter(GhfsStorageStatistics stats, GoogleCloudStorageStatistics statName, int expected) {
        Truth.assertThat((Long)stats.getLong(statName.getSymbol())).isEqualTo((Object)expected);
    }

    static void verifyCounterNotZero(GhfsStorageStatistics stats, GoogleCloudStorageStatistics statName) {
        Truth.assertThat((Long)stats.getLong(statName.getSymbol())).isNotEqualTo((Object)0);
    }
}

