/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemTestBase;
import com.google.cloud.hadoop.fs.gcs.HdfsBehavior;
import com.google.cloud.hadoop.gcsio.MethodOutcome;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WebHdfsIntegrationTest
extends HadoopFileSystemTestBase {
    public static final String WEBHDFS_ROOT = "WEBHDFS_ROOT";
    static String hdfsRoot;

    public void before() throws IOException, URISyntaxException {
        hdfsRoot = System.getenv(WEBHDFS_ROOT);
        Truth.assertThat((String)hdfsRoot).isNotNull();
        URI hdfsUri = new URI(hdfsRoot);
        Configuration config = new Configuration();
        config.set("fs.default.name", hdfsRoot);
        this.ghfs = FileSystem.get((URI)hdfsUri, (Configuration)config);
        this.ghfsFileSystemDescriptor = new FileSystemDescriptor(){

            public Path getFileSystemRoot() {
                return new Path(hdfsRoot);
            }

            public String getScheme() {
                return this.getFileSystemRoot().toUri().getScheme();
            }
        };
        this.postCreateInit();
        this.ghfsHelper.setIgnoreStatistics();
    }

    @Override
    @Test
    public void testDelete() throws Exception {
        this.deleteHelper(new HdfsBehavior());
    }

    @Override
    @Test
    public void testMkdirs() throws Exception {
        this.mkdirsHelper(new HdfsBehavior());
    }

    @Override
    @Test
    public void testRename() throws Exception {
        this.renameHelper(new HdfsBehavior(){

            @Override
            public MethodOutcome renameRootOutcome() {
                return new MethodOutcome(MethodOutcome.Type.THROWS_EXCEPTION, IOException.class);
            }
        });
    }

    @Override
    @Test
    public void testGetDefaultReplication() throws IOException {
        Truth.assertWithMessage((String)"Expected default replication factor >= 1").that(Boolean.valueOf(this.ghfs.getDefaultReplication() >= 1)).isTrue();
    }

    @Test
    public void testOpenNonExistentObject() throws IOException {
        String bucketName = this.ghfsHelper.sharedBucketName1;
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.ghfsHelper.readTextFile(bucketName, this.objectName + "_open-non-existent", 0, 100, true));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Internal Server Error (error code=500)");
    }

    @Test
    public void testOpenInNonExistentBucket() throws IOException {
        String bucketName = this.ghfsHelper.getUniqueBucketName("open-non-existent");
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.ghfsHelper.readTextFile(bucketName, this.objectName, 0, 100, true));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Internal Server Error (error code=500)");
    }

    @Test
    public void testReadPartialObject() throws IOException {
    }

    @Override
    @Test
    public void testFilePosition() throws IOException {
    }
}

