/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.contract;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractContractConcatTest;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public abstract class AbstractGoogleContractConcatTest
extends AbstractContractConcatTest {
    @Test
    public void testConcatMultiple() throws Throwable {
        int numFiles = 48;
        Path testPath = this.path("test");
        byte[][] blocks = new byte[numFiles][0];
        Path[] srcs = new Path[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            Path srcFile = new Path(testPath, "" + i);
            blocks[i] = ContractTestUtils.dataset((int)1024, (int)i, (int)255);
            ContractTestUtils.createFile((FileSystem)this.getFileSystem(), (Path)srcFile, (boolean)true, (byte[])blocks[i]);
            srcs[i] = srcFile;
        }
        Path target = new Path(testPath, "target");
        ContractTestUtils.createFile((FileSystem)this.getFileSystem(), (Path)target, (boolean)false, (byte[])new byte[0]);
        this.getFileSystem().concat(target, srcs);
        ContractTestUtils.assertFileHasLength((FileSystem)this.getFileSystem(), (Path)target, (int)(1024 * numFiles));
        ContractTestUtils.validateFileContent((byte[])ContractTestUtils.readDataset((FileSystem)this.getFileSystem(), (Path)target, (int)(1024 * numFiles)), (byte[][])blocks);
    }
}

