/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.contract;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestHelper;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;

public class InMemoryGoogleContract
extends AbstractFSContract {
    public static final String CONTRACT_XML = "contract/gs.xml";
    public static final String FAKE_TEST_PATH = "gs://fake-in-memory-test-bucket/contract-test/";
    private FileSystem fs;

    public InMemoryGoogleContract(Configuration conf) {
        super(conf);
        conf.set("fs.contract.test.fs.gs", FAKE_TEST_PATH);
        this.addConfResource(CONTRACT_XML);
    }

    public void init() throws IOException {
        super.init();
        this.fs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
    }

    public FileSystem getTestFileSystem() throws IOException {
        return this.fs;
    }

    public String getScheme() {
        return "gs";
    }

    public Path getTestPath() {
        return new Path(FAKE_TEST_PATH);
    }
}

