/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.contract;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.contract.GoogleContract;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.AbstractContractCreateTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestGoogleContractCreate
extends AbstractContractCreateTest {
    private static final GoogleCloudStorageTestHelper.TestBucketHelper TEST_BUCKET_HELPER = new GoogleCloudStorageTestHelper.TestBucketHelper("ghfs-contract-test");
    private static final AtomicReference<GoogleHadoopFileSystem> fs = new AtomicReference();

    @Before
    public void before() {
        fs.compareAndSet(null, (GoogleHadoopFileSystem)this.getFileSystem());
    }

    @AfterClass
    public static void cleanup() throws Exception {
        TEST_BUCKET_HELPER.cleanup(fs.get().getGcsFs().getGcs());
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new GoogleContract(conf, TEST_BUCKET_HELPER);
    }

    public void testOverwriteEmptyDirectory() throws Throwable {
        ContractTestUtils.skip((String)"blobstores can't distinguish empty directories from files");
    }
}

