/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.hcfs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestHelper;
import com.google.common.truth.Truth;
import java.io.IOException;
import org.apache.hadoop.fs.FSMainOperationsBaseTest;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFSMainOperationsTest
extends FSMainOperationsBaseTest {
    private final FileSystemTestHelper helper = new FileSystemTestHelper();

    public FileSystem createFileSystem() throws Exception {
        return GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.helper.getTestRootPath(this.fSys, "test/hadoop");
        Truth.assertThat((Boolean)GoogleHadoopFSMainOperationsTest.exists((FileSystem)this.fSys, (Path)testDir)).isFalse();
        this.fSys.mkdirs(testDir);
        Truth.assertThat((Boolean)GoogleHadoopFSMainOperationsTest.exists((FileSystem)this.fSys, (Path)testDir)).isTrue();
        this.createFile(this.helper.getTestRootPath(this.fSys, "test/hadoop/file"));
        Path testSubDir = this.helper.getTestRootPath(this.fSys, "test/hadoop/file/subdir");
        Assert.assertThrows(IOException.class, () -> this.fSys.mkdirs(testSubDir));
        Truth.assertThat((Boolean)GoogleHadoopFSMainOperationsTest.exists((FileSystem)this.fSys, (Path)testSubDir)).isFalse();
        Path testDeepSubDir = this.helper.getTestRootPath(this.fSys, "test/hadoop/file/deep/sub/dir");
        Truth.assertThat((Boolean)GoogleHadoopFSMainOperationsTest.exists((FileSystem)this.fSys, (Path)testSubDir)).isFalse();
        Assert.assertThrows(IOException.class, () -> this.fSys.mkdirs(testDeepSubDir));
        Truth.assertThat((Boolean)GoogleHadoopFSMainOperationsTest.exists((FileSystem)this.fSys, (Path)testDeepSubDir)).isFalse();
    }

    public void testListStatusThrowsExceptionForUnreadableDir() {
    }

    @Test
    public void testGlobStatusThrowsExceptionForUnreadableDir() {
    }

    public void testCopyToLocalWithUseRawLocalFileSystemOption() {
    }
}

