/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Crc32cValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.WriteFlushStrategy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BidiWriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BidiWriteObjectResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ChecksummedData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ObjectChecksums;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GapicBidiUnbufferedWritableByteChannel<RequestFactoryT extends BidiWriteCtx.BidiWriteObjectRequestBuilderFactory>
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final SettableApiFuture<BidiWriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final BidiWriteCtx<RequestFactoryT> writeCtx;
    private final WriteFlushStrategy.BidiFlusher flusher;
    private boolean open = true;
    private boolean finished = false;

    GapicBidiUnbufferedWritableByteChannel(SettableApiFuture<BidiWriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, RequestFactoryT requestFactory, WriteFlushStrategy.BidiFlusherFactory flusherFactory) {
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        this.writeCtx = new BidiWriteCtx<RequestFactoryT>(requestFactory);
        this.flusher = flusherFactory.newFlusher(requestFactory.bucketName(), this.writeCtx.getConfirmedBytes()::set, resultFuture::set);
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength, false);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            BidiWriteObjectRequest message = this.finishMessage();
            try {
                this.flusher.close(message);
                this.finished = true;
            }
            catch (RuntimeException e) {
                this.resultFuture.setException(e);
                throw e;
            }
        } else {
            this.flusher.close(null);
        }
        this.open = false;
    }

    @VisibleForTesting
    BidiWriteCtx<RequestFactoryT> getWriteCtx() {
        return this.writeCtx;
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength, boolean finalize) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength);
        ArrayList<BidiWriteObjectRequest> messages = new ArrayList<BidiWriteObjectRequest>();
        int bytesConsumed = 0;
        for (ChunkSegmenter.ChunkSegment datum : data) {
            Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
            ByteString b = datum.getB();
            int contentSize = b.size();
            long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
            Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
            ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
            if (crc32c != null) {
                checksummedData.setCrc32C(crc32c.getValue());
            }
            BidiWriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder().setWriteOffset(offset).setChecksummedData(checksummedData.build());
            if (!datum.isOnlyFullBlocks()) {
                builder.setFinishWrite(true);
                if (cumulative != null) {
                    builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                }
                this.finished = true;
            }
            BidiWriteObjectRequest build = builder.build();
            messages.add(build);
            bytesConsumed += contentSize;
        }
        if (finalize && !this.finished) {
            messages.add(this.finishMessage());
            this.finished = true;
        }
        try {
            this.flusher.flush(messages);
        }
        catch (RuntimeException e) {
            this.resultFuture.setException(e);
            throw e;
        }
        return bytesConsumed;
    }

    private @NonNull BidiWriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        BidiWriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder().setFinishWrite(true).setWriteOffset(offset);
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        BidiWriteObjectRequest message = b.build();
        return message;
    }
}

