/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoBuilder_GoogleCloudStorageClientImpl_Builder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcDownscopingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcStatisticsInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.util.AccessBoundary;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@VisibleForTesting
public class GoogleCloudStorageClientImpl
extends ForwardingGoogleCloudStorage {
    private static final String USER_AGENT = "user-agent";
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GoogleCloudStorageOptions storageOptions;
    private final com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage storage;
    private static final ErrorTypeExtractor errorExtractor = GrpcErrorTypeExtractor.INSTANCE;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcsio-storage-client-write-channel-pool-%d").setDaemon(true).build());

    GoogleCloudStorageClientImpl(GoogleCloudStorageOptions options, @Nullable com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage clientLibraryStorage, @Nullable Credentials credentials, @Nullable Credential credential, @Nullable Storage apiaryClientStorage, @Nullable HttpRequestInitializer httpRequestInitializer, @Nullable ImmutableList<ClientInterceptor> gRPCInterceptors, @Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn, @Nullable ExecutorService pCUExecutorService) throws IOException {
        super(GoogleCloudStorageClientImpl.getDelegate(httpRequestInitializer, apiaryClientStorage, options, credentials, credential, downscopedAccessTokenFn));
        this.storageOptions = options;
        this.storage = clientLibraryStorage == null ? this.createStorage(credentials, options, gRPCInterceptors, pCUExecutorService, downscopedAccessTokenFn) : clientLibraryStorage;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", resourceId);
        Preconditions.checkArgument(resourceId.isStorageObject(), "Expected full StorageObject id, got %s", (Object)resourceId);
        StorageResourceId resourceIdWithGeneration = resourceId;
        if (!resourceId.hasGenerationId()) {
            resourceIdWithGeneration = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        }
        return new GoogleCloudStorageClientWriteChannel(this.storage, this.storageOptions, resourceIdWithGeneration, options);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        return this.open(resourceId, null, readOptions);
    }

    private SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return new GoogleCloudStorageClientReadChannel(this.storage, itemInfo == null ? this.getItemInfo(resourceId) : itemInfo, readOptions, errorExtractor, this.storageOptions);
    }

    @Override
    public void close() {
        try {
            try {
                this.storage.close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Error occurred while closing the storage client");
            }
            try {
                super.close();
            }
            finally {
                this.backgroundTasksThreadPool.shutdown();
            }
        }
        finally {
            this.backgroundTasksThreadPool = null;
        }
    }

    @Override
    public void renameHnFolder(URI src, URI dst) throws IOException {
        super.renameHnFolder(src, dst);
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState(generation != 0L, "Generation should not be 0 for an existing item");
            return generation;
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private static GoogleCloudStorage getDelegate(HttpRequestInitializer httpRequestInitializer, Storage storage, GoogleCloudStorageOptions storageOptions, Credentials credentials, Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        if (httpRequestInitializer != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding httpRequestInitializer. ALERT: Use this only for testing");
            return new GoogleCloudStorageImpl(storageOptions, httpRequestInitializer, downscopedAccessTokenFn);
        }
        if (storage != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding storage. ALERT: Use this only for testing");
            return new GoogleCloudStorageImpl(storageOptions, storage, credentials, downscopedAccessTokenFn);
        }
        return new GoogleCloudStorageImpl(storageOptions, credential, downscopedAccessTokenFn);
    }

    private com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage createStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions, List<ClientInterceptor> interceptors, ExecutorService pCUExecutorService, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        ImmutableMap<String, String> headers = GoogleCloudStorageClientImpl.getUpdatedHeadersWithUserAgent(storageOptions);
        return (com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage)StorageOptions.grpc().setAttemptDirectPath(storageOptions.isDirectPathPreferred()).setHeaderProvider(() -> headers).setGrpcInterceptorProvider(() -> {
            ArrayList<ClientInterceptor> list = new ArrayList<ClientInterceptor>();
            if (interceptors != null && !interceptors.isEmpty()) {
                list.addAll(interceptors.stream().filter(x -> x != null).collect(Collectors.toList()));
            }
            if (storageOptions.isTraceLogEnabled()) {
                list.add(new GoogleCloudStorageClientGrpcTracingInterceptor());
            }
            if (downscopedAccessTokenFn != null) {
                list.add(new GoogleCloudStorageClientGrpcDownscopingInterceptor(downscopedAccessTokenFn));
            }
            list.add(new GoogleCloudStorageClientGrpcStatisticsInterceptor());
            return ImmutableList.copyOf(list);
        }).setCredentials(credentials != null ? credentials : this.getNoCredentials(downscopedAccessTokenFn)).setBlobWriteSessionConfig(GoogleCloudStorageClientImpl.getSessionConfig(storageOptions.getWriteChannelOptions(), pCUExecutorService)).build().getService();
    }

    private static ImmutableMap<String, String> getUpdatedHeadersWithUserAgent(GoogleCloudStorageOptions storageOptions) {
        ImmutableMap<String, String> httpRequestHeaders = MoreObjects.firstNonNull(storageOptions.getHttpRequestHeaders(), ImmutableMap.of());
        String appName = storageOptions.getAppName();
        if (!httpRequestHeaders.containsKey(USER_AGENT) && !Strings.isNullOrEmpty(appName)) {
            ((GoogleLogger.Api)logger.atFiner()).log("Setting useragent %s", appName);
            return ImmutableMap.builder().putAll(httpRequestHeaders).put(USER_AGENT, appName).build();
        }
        return httpRequestHeaders;
    }

    private Credentials getNoCredentials(Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
        if (downscopedAccessTokenFn == null) {
            return null;
        }
        return GoogleCredentials.create(new AccessToken("", null));
    }

    private static BlobWriteSessionConfig getSessionConfig(AsyncWriteChannelOptions writeOptions, ExecutorService pCUExecutorService) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("Upload strategy in use: %s", (Object)writeOptions.getUploadType());
        switch (writeOptions.getUploadType()) {
            case CHUNK_UPLOAD: {
                return BlobWriteSessionConfigs.getDefault().withChunkSize(writeOptions.getUploadChunkSize());
            }
            case WRITE_TO_DISK_THEN_UPLOAD: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    return BlobWriteSessionConfigs.bufferToTempDirThenUpload();
                }
                return BlobWriteSessionConfigs.bufferToDiskThenUpload(writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet()));
            }
            case JOURNALING: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    GoogleCloudStorageEventBus.postOnException();
                    throw new IllegalArgumentException("Upload using `Journaling` requires the property:fs.gs.write.temporary.dirs to be set.");
                }
                return BlobWriteSessionConfigs.journaling(writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet()));
            }
            case PARALLEL_COMPOSITE_UPLOAD: {
                return BlobWriteSessionConfigs.parallelCompositeUpload().withBufferAllocationStrategy(ParallelCompositeUploadBlobWriteSessionConfig.BufferAllocationStrategy.fixedPool(writeOptions.getPCUBufferCount(), writeOptions.getPCUBufferCapacity())).withPartCleanupStrategy(GoogleCloudStorageClientImpl.getPartCleanupStrategy(writeOptions.getPartFileCleanupType())).withExecutorSupplier(GoogleCloudStorageClientImpl.getPCUExecutorSupplier(pCUExecutorService)).withPartNamingStrategy(GoogleCloudStorageClientImpl.getPartNamingStrategy(writeOptions.getPartFileNamePrefix()));
            }
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IllegalArgumentException(String.format("Upload type:%s is not supported.", new Object[]{writeOptions.getUploadType()}));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy getPartCleanupStrategy(AsyncWriteChannelOptions.PartFileCleanupType cleanupType) {
        switch (cleanupType) {
            case NEVER: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.never();
            }
            case ON_SUCCESS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.onlyOnSuccess();
            }
            case ALWAYS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.always();
            }
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IllegalArgumentException(String.format("Cleanup type:%s is not handled.", new Object[]{cleanupType}));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy getPartNamingStrategy(String partFilePrefix) {
        if (Strings.isNullOrEmpty(partFilePrefix)) {
            return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.useObjectNameAsPrefix();
        }
        return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.prefix(partFilePrefix);
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier getPCUExecutorSupplier(ExecutorService pCUExecutorService) {
        return pCUExecutorService == null ? ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.cachedPool() : ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.useExecutor(pCUExecutorService);
    }

    public static Builder builder() {
        return new AutoBuilder_GoogleCloudStorageClientImpl_Builder();
    }

    @AutoBuilder(ofClass=GoogleCloudStorageClientImpl.class)
    public static abstract class Builder {
        public abstract Builder setOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setCredentials(@Nullable Credentials var1);

        public abstract Builder setCredential(@Nullable Credential var1);

        public abstract Builder setApiaryClientStorage(@Nullable Storage var1);

        @VisibleForTesting
        public abstract Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer var1);

        public abstract Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> var1);

        public abstract Builder setGRPCInterceptors(@Nullable ImmutableList<ClientInterceptor> var1);

        @VisibleForTesting
        public abstract Builder setClientLibraryStorage(@Nullable com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage var1);

        @VisibleForTesting
        public abstract Builder setPCUExecutorService(@Nullable ExecutorService var1);

        public abstract GoogleCloudStorageClientImpl build() throws IOException;
    }
}

