/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.HadoopConfigurationProperty;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class GoogleHadoopFileSystemConfiguration {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String GCS_CONFIG_PREFIX = "fs.gs";
    public static final List<String> CONFIG_KEY_PREFIXES = ImmutableList.copyOf((Collection)HadoopCredentialConfiguration.getConfigKeyPrefixes((String[])new String[]{"fs.gs"}));
    public static final HadoopConfigurationProperty<String> GCS_ROOT_URL = new HadoopConfigurationProperty<String>("fs.gs.storage.root.url", "https://storage.googleapis.com/", new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_SERVICE_PATH = new HadoopConfigurationProperty<String>("fs.gs.storage.service.path", "storage/v1/", new String[0]);
    public static final HadoopConfigurationProperty<String> PERMISSIONS_TO_REPORT = new HadoopConfigurationProperty<String>("fs.gs.reported.permissions", "700", new String[0]);
    public static final HadoopConfigurationProperty<Long> BLOCK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.block.size", 0x4000000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_HIERARCHICAL_NAMESPACE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.hierarchical.namespace.folders.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<String> DELEGATION_TOKEN_BINDING_CLASS = new HadoopConfigurationProperty("fs.gs.delegation.token.binding");
    public static final HadoopConfigurationProperty<String> GCS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.project.id");
    public static final HadoopConfigurationProperty<String> GCS_WORKING_DIRECTORY = new HadoopConfigurationProperty<String>("fs.gs.working.dir", "/", new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCE_BUCKET_DELETE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.bucket.delete.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode> GCS_REQUESTER_PAYS_MODE = new HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode>("fs.gs.requester.pays.mode", RequesterPaysOptions.REQUESTER_PAYS_MODE_DEFAULT, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_REQUESTER_PAYS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.requester.pays.project.id");
    public static final HadoopConfigurationProperty<Collection<String>> GCS_REQUESTER_PAYS_BUCKETS = new HadoopConfigurationProperty<ImmutableList>("fs.gs.requester.pays.buckets", ImmutableList.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType> GCS_FILE_CHECKSUM_TYPE = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType>("fs.gs.checksum.type", GoogleHadoopFileSystemBase.GcsFileChecksumType.NONE, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_PERFORMANCE_CACHE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.performance.cache.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS = new HadoopConfigurationProperty<Long>("fs.gs.performance.cache.max.entry.age.ms", 5000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_STATUS_PARALLEL_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.status.parallel.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_LAZY_INITIALIZATION_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.lazy.init.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.implicit.dir.repair.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.create.items.conflict.check.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GlobAlgorithm> GCS_GLOB_ALGORITHM = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GlobAlgorithm>("fs.gs.glob.algorithm", GoogleHadoopFileSystemBase.GlobAlgorithm.CONCURRENT, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_MARKER_FILE_PATTERN = new HadoopConfigurationProperty("fs.gs.marker.file.pattern");
    public static final HadoopConfigurationProperty<Long> GCS_MAX_REQUESTS_PER_BATCH = new HadoopConfigurationProperty<Long>("fs.gs.max.requests.per.batch", 15L, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_BATCH_THREADS = new HadoopConfigurationProperty<Integer>("fs.gs.batch.threads", 15, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_COPY_WITH_REWRITE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.copy.with.rewrite.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_REWRITE_MAX_BYTES_PER_CALL = new HadoopConfigurationProperty<Long>("fs.gs.rewrite.max.bytes.per.call", 0x20000000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_MAX_LIST_ITEMS_PER_CALL = new HadoopConfigurationProperty<Long>("fs.gs.list.max.items.per.call", 5000L, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_MAX_RETRY = new HadoopConfigurationProperty<Integer>("fs.gs.http.max.retry", 10, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_CONNECT_TIMEOUT = new HadoopConfigurationProperty<Integer>("fs.gs.http.connect-timeout", 20000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_READ_TIMEOUT = new HadoopConfigurationProperty<Integer>("fs.gs.http.read-timeout", 20000, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_APPLICATION_NAME_SUFFIX = new HadoopConfigurationProperty<String>("fs.gs.application.name.suffix", "", new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE = new HadoopConfigurationProperty<Integer>("fs.gs.max.wait.for.empty.object.creation.ms", 3000, new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType> GCS_OUTPUT_STREAM_TYPE = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType>("fs.gs.outputstream.type", GoogleHadoopFileSystemBase.OutputStreamType.BASIC, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.buffer.size", 0x800000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.pipe.buffer.size", 0x100000, new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.PipeType> GCS_OUTPUT_STREAM_PIPE_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.PipeType>("fs.gs.outputstream.pipe.type", AsyncWriteChannelOptions.PipeType.IO_STREAM_PIPE, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.upload.chunk.size", 0x4000000, "fs.gs.io.buffersize.write");
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.upload.cache.size", 0, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.outputstream.direct.upload.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL_MS = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.sync.min.interval.ms", 0, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.fast.fail.on.not.found.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.support.gzip.encoding.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT = new HadoopConfigurationProperty<Long>("fs.gs.inputstream.inplace.seek.limit", 0x800000L, new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise> GCS_INPUT_STREAM_FADVISE = new HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise>("fs.gs.inputstream.fadvise", GoogleCloudStorageReadOptions.Fadvise.AUTO, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.inputstream.min.range.request.size", 0x200000, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_CHECKSUMS_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.checksums.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_GRPC_SERVER_ADDRESS = new HadoopConfigurationProperty<String>("fs.gs.grpc.server.address", GoogleCloudStorageOptions.DEFAULT_GCS_GRPC_SERVER_ADDRESS, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_CHECK_INTERVAL_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.checkinterval.timeout.ms", 1000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.timeout.ms", 3600000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_MESSAGE_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.message.timeout.ms", 3000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_READ_METADATA_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.read.metadata.timeout.ms", 60000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_READ_ZEROCOPY_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.read.zerocopy.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_UPLOAD_BUFFERED_REQUESTS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.buffered.requests", 20L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_WRITE_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.timeout.ms", 600000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_GRPC_WRITE_MESSAGE_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.grpc.write.message.timeout.ms", 3000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_DIRECTPATH_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.directpath.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_TRAFFICDIRECTOR_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.trafficdirector.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_COOPERATIVE_LOCKING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.cooperative.locking.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_COOPERATIVE_LOCKING_EXPIRATION_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.cooperative.locking.expiration.timeout.ms", CooperativeLockingOptions.LOCK_EXPIRATION_TIMEOUT_MS_DEFAULT, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_COOPERATIVE_LOCKING_MAX_CONCURRENT_OPERATIONS = new HadoopConfigurationProperty<Integer>("fs.gs.cooperative.locking.max.concurrent.operations", 20, new String[0]);
    public static final HadoopConfigurationProperty<Map<String, String>> GCS_HTTP_HEADERS = new HadoopConfigurationProperty<ImmutableMap>("fs.gs.storage.http.headers.", ImmutableMap.of(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_ENCRYPTION_ALGORITHM = new HadoopConfigurationProperty("fs.gs.encryption.algorithm");
    public static final HadoopConfigurationProperty<RedactedString> GCS_ENCRYPTION_KEY = new HadoopConfigurationProperty("fs.gs.encryption.key");
    public static final HadoopConfigurationProperty<RedactedString> GCS_ENCRYPTION_KEY_HASH = new HadoopConfigurationProperty("fs.gs.encryption.key.hash");
    public static final HadoopConfigurationProperty<Class<? extends AuthorizationHandler>> GCS_AUTHORIZATION_HANDLER_IMPL = new HadoopConfigurationProperty("fs.gs.authorization.handler.impl");
    public static final HadoopConfigurationProperty<Map<String, String>> GCS_AUTHORIZATION_HANDLER_PROPERTIES_PREFIX = new HadoopConfigurationProperty<ImmutableMap>("fs.gs.authorization.handler.properties.", ImmutableMap.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageOptions.MetricsSink> GCS_METRICS_SINK = new HadoopConfigurationProperty<GoogleCloudStorageOptions.MetricsSink>("fs.gs.metrics.sink", GoogleCloudStorageOptions.MetricsSink.NONE, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_OPERATION_TRACE_LOG_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.operation.tracelog.enable", GoogleCloudStorageOptions.DEFAULT.isTraceLogEnabled(), new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_TRACE_LOG_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.tracelog.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_TRACE_LOG_TIME_THRESHOLD_MS = new HadoopConfigurationProperty<Long>("fs.gs.tracelog.time.filter.threshold.ms", 0L, new String[0]);
    public static final HadoopConfigurationProperty<Collection<String>> GCS_TRACE_LOG_EXCLUDE_PROPERTIES = new HadoopConfigurationProperty<ImmutableList>("fs.gs.tracelog.exclude.properties", ImmutableList.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageFileSystemOptions.ClientType> GCS_CLIENT_TYPE = new HadoopConfigurationProperty<GoogleCloudStorageFileSystemOptions.ClientType>("fs.gs.client.type", GoogleCloudStorageFileSystemOptions.ClientType.HTTP_API_CLIENT, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_GRPC_WRITE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.grpc.write.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.UploadType> GCS_CLIENT_UPLOAD_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.UploadType>("fs.gs.client.upload.type", AsyncWriteChannelOptions.UploadType.CHUNK_UPLOAD, new String[0]);
    public static final HadoopConfigurationProperty<Collection<String>> GCS_WRITE_TEMPORARY_FILES_PATH = new HadoopConfigurationProperty<ImmutableSet>("fs.gs.write.temporary.dirs", ImmutableSet.of(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_PCU_BUFFER_COUNT = new HadoopConfigurationProperty<Integer>("fs.gs.write.parallel.composite.upload.buffer.count", AsyncWriteChannelOptions.DEFAULT.getPCUBufferCount(), new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_PCU_BUFFER_CAPACITY = new HadoopConfigurationProperty<Integer>("fs.gs.write.parallel.composite.upload.buffer.capacity", AsyncWriteChannelOptions.DEFAULT.getPCUBufferCapacity(), new String[0]);
    public static final HadoopConfigurationProperty<AsyncWriteChannelOptions.PartFileCleanupType> GCS_PCU_PART_FILE_CLEANUP_TYPE = new HadoopConfigurationProperty<AsyncWriteChannelOptions.PartFileCleanupType>("fs.gs.write.parallel.composite.upload.part.file.cleanup.type", AsyncWriteChannelOptions.DEFAULT.getPartFileCleanupType(), new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_PCU_PART_FILE_NAME_PREFIX = new HadoopConfigurationProperty<String>("fs.gs.write.parallel.composite.upload.part.file.name.prefix", AsyncWriteChannelOptions.DEFAULT.getPartFileNamePrefix(), new String[0]);

    static GoogleCloudStorageFileSystemOptions.Builder getGcsFsOptionsBuilder(Configuration config) {
        return GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder(config).build()).setClientType((GoogleCloudStorageFileSystemOptions.ClientType)GCS_CLIENT_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setBucketDeleteEnabled(((Boolean)GCE_BUCKET_DELETE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setCooperativeLockingEnabled(((Boolean)GCS_COOPERATIVE_LOCKING_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setEnsureNoConflictingItems(((Boolean)GCS_CREATE_ITEMS_CONFLICT_CHECK_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setMarkerFilePattern((String)GCS_MARKER_FILE_PATTERN.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setPerformanceCacheEnabled(((Boolean)GCS_PERFORMANCE_CACHE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setPerformanceCacheOptions(GoogleHadoopFileSystemConfiguration.getPerformanceCachingOptions(config)).setStatusParallelEnabled(((Boolean)GCS_STATUS_PARALLEL_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue());
    }

    @VisibleForTesting
    static GoogleCloudStorageOptions.Builder getGcsOptionsBuilder(Configuration config) {
        String projectId = (String)GCS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        return GoogleCloudStorageOptions.builder().setStorageRootUrl((String)GCS_ROOT_URL.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setGrpcWriteEnabled(((Boolean)GCS_GRPC_WRITE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setStorageServicePath((String)GCS_SERVICE_PATH.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setAutoRepairImplicitDirectoriesEnabled(((Boolean)GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setCopyWithRewriteEnabled(((Boolean)GCS_COPY_WITH_REWRITE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setMaxBytesRewrittenPerCall(((Long)GCS_REWRITE_MAX_BYTES_PER_CALL.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setTransportType((HttpTransportFactory.HttpTransportType)HadoopCredentialConfiguration.HTTP_TRANSPORT_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProxyAddress((String)HadoopCredentialConfiguration.PROXY_ADDRESS_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setProxyUsername(RedactedString.create((String)HadoopCredentialConfiguration.PROXY_USERNAME_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config))).setProxyPassword(RedactedString.create((String)HadoopCredentialConfiguration.PROXY_PASSWORD_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config))).setProjectId(projectId).setMaxListItemsPerCall(((Long)GCS_MAX_LIST_ITEMS_PER_CALL.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setMaxRequestsPerBatch(((Long)GCS_MAX_REQUESTS_PER_BATCH.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setBatchThreads(((Integer)GCS_BATCH_THREADS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setMaxHttpRequestRetries(((Integer)GCS_HTTP_MAX_RETRY.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setHttpRequestConnectTimeout(((Integer)GCS_HTTP_CONNECT_TIMEOUT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setHttpRequestReadTimeout(((Integer)GCS_HTTP_READ_TIMEOUT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setAppName(GoogleHadoopFileSystemConfiguration.getApplicationName(config)).setMaxWaitMillisForEmptyObjectCreation(((Integer)GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setReadChannelOptions(GoogleHadoopFileSystemConfiguration.getReadChannelOptions(config)).setWriteChannelOptions(GoogleHadoopFileSystemConfiguration.getWriteChannelOptions(config)).setRequesterPaysOptions(GoogleHadoopFileSystemConfiguration.getRequesterPaysOptions(config, projectId)).setCooperativeLockingOptions(GoogleHadoopFileSystemConfiguration.getCooperativeLockingOptions(config)).setHttpRequestHeaders(GCS_HTTP_HEADERS.getPropsWithPrefix(config)).setEncryptionAlgorithm((String)GCS_ENCRYPTION_ALGORITHM.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setEncryptionKey(RedactedString.create((String)GCS_ENCRYPTION_KEY.getPassword(config))).setEncryptionKeyHash(RedactedString.create((String)GCS_ENCRYPTION_KEY_HASH.getPassword(config))).setGrpcEnabled(((Boolean)GCS_GRPC_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setHnBucketRenameEnabled(((Boolean)GCS_HIERARCHICAL_NAMESPACE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setAuthorizationHandlerImplClass((Class)GCS_AUTHORIZATION_HANDLER_IMPL.get(config, (k, d) -> config.getClass(k, d, AuthorizationHandler.class))).setAuthorizationHandlerProperties(GCS_AUTHORIZATION_HANDLER_PROPERTIES_PREFIX.getPropsWithPrefix(config)).setGrpcServerAddress((String)GCS_GRPC_SERVER_ADDRESS.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setGrpcMessageTimeoutCheckInterval(((Long)GCS_GRPC_CHECK_INTERVAL_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setDirectPathPreferred(((Boolean)GCS_GRPC_DIRECTPATH_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setTrafficDirectorEnabled(((Boolean)GCS_GRPC_TRAFFICDIRECTOR_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setMetricsSink((GoogleCloudStorageOptions.MetricsSink)GCS_METRICS_SINK.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setTraceLogEnabled((Boolean)GCS_TRACE_LOG_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setOperationTraceLogEnabled((Boolean)GCS_OPERATION_TRACE_LOG_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setTraceLogTimeThreshold(((Long)GCS_TRACE_LOG_TIME_THRESHOLD_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setTraceLogExcludeProperties(ImmutableSet.copyOf((Collection)GCS_TRACE_LOG_EXCLUDE_PROPERTIES.getStringCollection(config)));
    }

    private static PerformanceCachingGoogleCloudStorageOptions getPerformanceCachingOptions(Configuration config) {
        return PerformanceCachingGoogleCloudStorageOptions.builder().setMaxEntryAgeMillis(((Long)GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).build();
    }

    private static String getApplicationName(Configuration config) {
        String appNameSuffix = Strings.nullToEmpty((String)((String)GCS_APPLICATION_NAME_SUFFIX.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))));
        String applicationName = GoogleHadoopFileSystem.GHFS_ID + appNameSuffix;
        ((GoogleLogger.Api)logger.atFiner()).log("getApplicationName(config: %s): %s", (Object)config, (Object)applicationName);
        return applicationName;
    }

    private static GoogleCloudStorageReadOptions getReadChannelOptions(Configuration config) {
        return GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(((Boolean)GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setSupportGzipEncoding(((Boolean)GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setInplaceSeekLimit(((Long)GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setFadvise((GoogleCloudStorageReadOptions.Fadvise)GCS_INPUT_STREAM_FADVISE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setMinRangeRequestSize(((Integer)GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setGrpcChecksumsEnabled(((Boolean)GCS_GRPC_CHECKSUMS_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setGrpcReadTimeoutMillis(((Long)GCS_GRPC_READ_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setGrpcReadMessageTimeoutMillis(((Long)GCS_GRPC_READ_MESSAGE_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setGrpcReadMetadataTimeoutMillis(((Long)GCS_GRPC_READ_METADATA_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setGrpcReadZeroCopyEnabled(((Boolean)GCS_GRPC_READ_ZEROCOPY_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setTraceLogEnabled(((Boolean)GCS_TRACE_LOG_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setTraceLogTimeThreshold(((Long)GCS_TRACE_LOG_TIME_THRESHOLD_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setTraceLogExcludeProperties(ImmutableSet.copyOf((Collection)GCS_TRACE_LOG_EXCLUDE_PROPERTIES.getStringCollection(config))).build();
    }

    private static AsyncWriteChannelOptions getWriteChannelOptions(Configuration config) {
        return AsyncWriteChannelOptions.builder().setBufferSize(((Integer)GCS_OUTPUT_STREAM_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setPipeBufferSize(((Integer)GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setPipeType((AsyncWriteChannelOptions.PipeType)GCS_OUTPUT_STREAM_PIPE_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setUploadChunkSize(((Integer)GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setUploadCacheSize(((Integer)GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setDirectUploadEnabled(((Boolean)GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setGrpcChecksumsEnabled(((Boolean)GCS_GRPC_CHECKSUMS_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()).setGrpcWriteTimeout(((Long)GCS_GRPC_WRITE_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setGrpcWriteMessageTimeoutMillis(((Long)GCS_GRPC_WRITE_MESSAGE_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setNumberOfBufferedRequests(((Long)GCS_GRPC_UPLOAD_BUFFERED_REQUESTS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setUploadType((AsyncWriteChannelOptions.UploadType)GCS_CLIENT_UPLOAD_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setTemporaryPaths(ImmutableSet.copyOf((Collection)GCS_WRITE_TEMPORARY_FILES_PATH.getStringCollection(config))).setPCUBufferCount(((Integer)GCS_PCU_BUFFER_COUNT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setPCUBufferCapacity(((Integer)GCS_PCU_BUFFER_CAPACITY.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).setPartFileCleanupType((AsyncWriteChannelOptions.PartFileCleanupType)GCS_PCU_PART_FILE_CLEANUP_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setPartFileNamePrefix((String)GCS_PCU_PART_FILE_NAME_PREFIX.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).build();
    }

    private static RequesterPaysOptions getRequesterPaysOptions(Configuration config, String projectId) {
        String requesterPaysProjectId = (String)GCS_REQUESTER_PAYS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        return RequesterPaysOptions.builder().setMode((RequesterPaysOptions.RequesterPaysMode)GCS_REQUESTER_PAYS_MODE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProjectId(requesterPaysProjectId == null ? projectId : requesterPaysProjectId).setBuckets(GCS_REQUESTER_PAYS_BUCKETS.getStringCollection(config)).build();
    }

    private static CooperativeLockingOptions getCooperativeLockingOptions(Configuration config) {
        return CooperativeLockingOptions.builder().setLockExpirationTimeoutMilli(((Long)GCS_COOPERATIVE_LOCKING_EXPIRATION_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).longValue()).setMaxConcurrentOperations(((Integer)GCS_COOPERATIVE_LOCKING_MAX_CONCURRENT_OPERATIONS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).intValue()).build();
    }
}

