/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.BetaApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.NoCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ServiceDefaults;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ServiceOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GrpcStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageRetryStrategy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.StorageRpcFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class StorageOptions
extends ServiceOptions<Storage, StorageOptions> {
    private static final long serialVersionUID = -7295846567928013233L;
    private static final String VERSION;

    StorageOptions(Builder builder, StorageDefaults serviceDefaults) {
        super(StorageFactory.class, StorageRpcFactory.class, builder, serviceDefaults);
    }

    @Deprecated
    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpStorageOptions.defaults().getDefaultTransportOptions();
    }

    @Override
    protected boolean projectIdRequired() {
        return false;
    }

    @Override
    public String getLibraryVersion() {
        return VERSION;
    }

    @InternalApi
    public static String version() {
        return VERSION;
    }

    @Override
    public abstract Builder toBuilder();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static StorageOptions getDefaultInstance() {
        return HttpStorageOptions.newBuilder().build();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static StorageOptions getUnauthenticatedInstance() {
        return HttpStorageOptions.newBuilder().setCredentials(NoCredentials.getInstance()).build();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static Builder newBuilder() {
        return StorageOptions.http();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static HttpStorageOptions.Builder http() {
        return HttpStorageOptions.newBuilder();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
    public static GrpcStorageOptions.Builder grpc() {
        return GrpcStorageOptions.newBuilder();
    }

    static {
        String tmp = "unresolved";
        Properties props = new Properties();
        try {
            String resourcePath = String.format("/META-INF/maven/%s/%s/pom.properties", "com.google.cloud.hadoop.repackaged.gcs.com.google.cloud", "google-cloud-storage");
            InputStream resourceAsStream = StorageOptions.class.getResourceAsStream(resourcePath);
            if (resourceAsStream == null) {
                resourceAsStream = StorageOptions.class.getResourceAsStream(resourcePath.substring(1));
            }
            if (resourceAsStream != null) {
                props.load(resourceAsStream);
                resourceAsStream.close();
                tmp = props.getProperty("version", "unknown-version");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VERSION = tmp;
    }

    public static abstract class Builder
    extends ServiceOptions.Builder<Storage, StorageOptions, Builder> {
        Builder() {
        }

        Builder(StorageOptions options) {
            super(options);
        }

        public abstract Builder setStorageRetryStrategy(StorageRetryStrategy var1);

        @BetaApi
        public abstract Builder setBlobWriteSessionConfig(@NonNull BlobWriteSessionConfig var1);

        public abstract StorageOptions build();
    }

    static abstract class StorageDefaults
    implements ServiceDefaults<Storage, StorageOptions> {
        StorageDefaults() {
        }
    }

    @Deprecated
    public static class DefaultStorageRpcFactory
    extends HttpStorageOptions.HttpStorageRpcFactory {
        private static final long serialVersionUID = -7856840922014956661L;

        @Deprecated
        public DefaultStorageRpcFactory() {
        }
    }

    @Deprecated
    public static class DefaultStorageFactory
    extends HttpStorageOptions.HttpStorageFactory {
        private static final long serialVersionUID = -7856840922014956661L;

        @Deprecated
        public DefaultStorageFactory() {
        }
    }
}

