/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Bucket;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BucketInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Utils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Predicates;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.hash.HashCode;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.hash.Hashing;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.com.google.iam.v1.GetIamPolicyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.FieldMask;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BidiWriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CommonObjectRequestParams;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ComposeObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CreateBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CreateHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.DeleteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.GetObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListBucketsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListHmacKeysRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ListObjectsRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.RestoreObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.RewriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StartResumableWriteRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.UpdateBucketRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.UpdateHmacKeyRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.UpdateObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import java.io.Serializable;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class UnifiedOpts {
    UnifiedOpts() {
    }

    static Crc32cMatch crc32cMatch(int i) {
        return new Crc32cMatch(i);
    }

    static Crc32cMatch crc32cMatch(@NonNull String crc32c) {
        Objects.requireNonNull(crc32c, "crc32c must be non null");
        return new Crc32cMatch((Integer)Utils.crc32cCodec.decode(crc32c));
    }

    static Delimiter currentDirectory() {
        return new Delimiter("/");
    }

    static DecryptionKey decryptionKey(@NonNull String decryptionKey) {
        Objects.requireNonNull(decryptionKey, "decryptionKey must be non null");
        return new DecryptionKey(new SecretKeySpec(BaseEncoding.base64().decode(decryptionKey), "AES256"));
    }

    @RequiresNonNull(value={"decryptionKey", "#1.getEncoded()", "#1.getAlgorithm()"})
    static DecryptionKey decryptionKey(@NonNull Key decryptionKey) {
        Objects.requireNonNull(decryptionKey, "decryptionKey must be non null");
        Objects.requireNonNull(decryptionKey.getEncoded(), "decryptionKey.getEncoded() must be non null");
        Objects.requireNonNull(decryptionKey.getAlgorithm(), "decryptionKey.getAlgorithm() must be non null");
        return new DecryptionKey(decryptionKey);
    }

    static Delimiter delimiter(@NonNull String delimiter) {
        Objects.requireNonNull(delimiter, "delimiter must be non null");
        return new Delimiter(delimiter);
    }

    static IncludeFoldersAsPrefixes includeFoldersAsPrefixes(boolean includeFoldersAsPrefixes) {
        return new IncludeFoldersAsPrefixes(includeFoldersAsPrefixes);
    }

    @Deprecated
    static DetectContentType detectContentType() {
        return DetectContentType.INSTANCE;
    }

    static DisableGzipContent disableGzipContent() {
        return new DisableGzipContent(true);
    }

    static GenerationMatch doesNotExist() {
        return new GenerationMatch(0L);
    }

    static EncryptionKey encryptionKey(@NonNull String encryptionKey) {
        Objects.requireNonNull(encryptionKey, "encryptionKey must be non null");
        return new EncryptionKey(new SecretKeySpec(BaseEncoding.base64().decode(encryptionKey), "AES256"));
    }

    static EncryptionKey encryptionKey(@NonNull Key encryptionKey) {
        Objects.requireNonNull(encryptionKey, "encryptionKey must be non null");
        return new EncryptionKey(encryptionKey);
    }

    static EndOffset endOffset(@NonNull String endOffset) {
        Objects.requireNonNull(endOffset, "endOffset must be non null");
        return new EndOffset(endOffset);
    }

    static Fields fields(@NonNull ImmutableSet<NamedField> fields) {
        Objects.requireNonNull(fields, "fields must be non null");
        return new Fields(fields);
    }

    static GenerationMatch generationMatch(long l) {
        return new GenerationMatch(l);
    }

    static GenerationNotMatch generationNotMatch(long l) {
        return new GenerationNotMatch(l);
    }

    static KmsKeyName kmsKeyName(@NonNull String kmsKeyName) {
        Objects.requireNonNull(kmsKeyName, "kmsKeyName must be non null");
        return new KmsKeyName(kmsKeyName);
    }

    static MatchGlob matchGlob(@NonNull String glob) {
        Objects.requireNonNull(glob, "glob must be non null");
        return new MatchGlob(glob);
    }

    static Md5Match md5Match(@NonNull String md5) {
        Objects.requireNonNull(md5, "md5 must be non null");
        return new Md5Match(md5);
    }

    static MetagenerationMatch metagenerationMatch(long l) {
        return new MetagenerationMatch(l);
    }

    static MetagenerationNotMatch metagenerationNotMatch(long l) {
        return new MetagenerationNotMatch(l);
    }

    static PageSize pageSize(long l) {
        return new PageSize(l);
    }

    static PageToken pageToken(@NonNull String pageToken) {
        Objects.requireNonNull(pageToken, "pageToken must be non null");
        return new PageToken(pageToken);
    }

    static PredefinedAcl predefinedAcl( @NonNull Storage.PredefinedAcl predefinedAcl) {
        Objects.requireNonNull(predefinedAcl, "predefinedAcl must be non null");
        return new PredefinedAcl(predefinedAcl.getEntry());
    }

    static PredefinedDefaultObjectAcl predefinedDefaultObjectAcl( @NonNull Storage.PredefinedAcl predefinedAcl) {
        Objects.requireNonNull(predefinedAcl, "predefinedAcl must be non null");
        return new PredefinedDefaultObjectAcl(predefinedAcl.getEntry());
    }

    static EnableObjectRetention enableObjectRetention(boolean enable) {
        return new EnableObjectRetention(enable);
    }

    static OverrideUnlockedRetention overrideUnlockedRetention(boolean overrideUnlockedRetention) {
        return new OverrideUnlockedRetention(overrideUnlockedRetention);
    }

    static Prefix prefix(@NonNull String prefix) {
        Objects.requireNonNull(prefix, "prefix must be non null");
        return new Prefix(prefix);
    }

    static ProjectId projectId(@NonNull String projectId) {
        Objects.requireNonNull(projectId, "projectId must be non null");
        return new ProjectId(projectId);
    }

    static Projection projection(@NonNull String projection) {
        Objects.requireNonNull(projection, "projection must be non null");
        return new Projection(projection);
    }

    static ResumableUploadExpectedObjectSize resumableUploadExpectedObjectSize(long expectedObjectSize) {
        Preconditions.checkArgument(expectedObjectSize >= 0L, "expectedObjectSize >= 0 (%s >= 0)", expectedObjectSize);
        return new ResumableUploadExpectedObjectSize(expectedObjectSize);
    }

    static SoftDeleted softDeleted(boolean softDeleted) {
        return new SoftDeleted(softDeleted);
    }

    static CopySourceAcl copySourceAcl(boolean copySourceAcl) {
        return new CopySourceAcl(copySourceAcl);
    }

    static RequestedPolicyVersion requestedPolicyVersion(long l) {
        return new RequestedPolicyVersion(l);
    }

    static ReturnRawInputStream returnRawInputStream(boolean b) {
        return new ReturnRawInputStream(b);
    }

    @RequiresNonNull(value={"serviceAccount", "#1.getEmail()"})
    static ServiceAccount serviceAccount(@NonNull com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ServiceAccount serviceAccount) {
        Objects.requireNonNull(serviceAccount, "serviceAccount must be non null");
        Objects.requireNonNull(serviceAccount.getEmail(), "serviceAccount.getEmail() must be non null");
        return new ServiceAccount(serviceAccount.getEmail());
    }

    @VisibleForTesting
    static SetContentType setContentType(@NonNull String s) {
        Objects.requireNonNull(s, "s must be non null");
        return new SetContentType(s);
    }

    static ShowDeletedKeys showDeletedKeys(boolean b) {
        return new ShowDeletedKeys(b);
    }

    static StartOffset startOffset(@NonNull String startOffset) {
        Objects.requireNonNull(startOffset, "startOffset must be non null");
        return new StartOffset(startOffset);
    }

    static UserProject userProject(@NonNull String userProject) {
        Objects.requireNonNull(userProject, "userProject must be non null");
        return new UserProject(userProject);
    }

    static VersionsFilter versionsFilter(boolean b) {
        return new VersionsFilter(b);
    }

    @Deprecated
    static GenerationMatchExtractor generationMatchExtractor() {
        return GenerationMatchExtractor.INSTANCE;
    }

    @Deprecated
    static GenerationNotMatchExtractor generationNotMatchExtractor() {
        return GenerationNotMatchExtractor.INSTANCE;
    }

    @Deprecated
    static MetagenerationMatchExtractor metagenerationMatchExtractor() {
        return MetagenerationMatchExtractor.INSTANCE;
    }

    @Deprecated
    static MetagenerationNotMatchExtractor metagenerationNotMatchExtractor() {
        return MetagenerationNotMatchExtractor.INSTANCE;
    }

    @Deprecated
    static Crc32cMatchExtractor crc32cMatchExtractor() {
        return Crc32cMatchExtractor.INSTANCE;
    }

    @Deprecated
    static Md5MatchExtractor md5MatchExtractor() {
        return Md5MatchExtractor.INSTANCE;
    }

    private static CommonObjectRequestParams.Builder customerSuppliedKey(CommonObjectRequestParams.Builder b, Key key) {
        HashCode keySha256 = Hashing.sha256().hashBytes(key.getEncoded());
        return b.setEncryptionAlgorithm(key.getAlgorithm()).setEncryptionKeyBytes(ByteString.copyFrom(key.getEncoded())).setEncryptionKeySha256Bytes(ByteString.copyFrom(keySha256.asBytes()));
    }

    static final class Crc32cMatch
    implements ObjectTargetOpt {
        private static final long serialVersionUID = 8172282701777561769L;
        private final int val;

        private Crc32cMatch(int val) {
            this.val = val;
        }

        @Override
        public Mapper<BlobInfo.Builder> blobInfo() {
            return b -> b.setCrc32c((String)Utils.crc32cCodec.encode(this.val));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Crc32cMatch)) {
                return false;
            }
            Crc32cMatch that = (Crc32cMatch)o;
            return Objects.equals(this.val, that.val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getObjectChecksumsBuilder().setCrc32C(this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getObjectChecksumsBuilder().setCrc32C(this.val);
                return b;
            };
        }

        public int hashCode() {
            return Objects.hash(this.val);
        }

        public String toString() {
            return "Crc32cMatch{val='" + this.val + "'}";
        }
    }

    static final class Delimiter
    extends RpcOptVal<String>
    implements ObjectListOpt {
        private static final long serialVersionUID = -3789556789947615714L;

        private Delimiter(String val) {
            super(StorageRpc.Option.DELIMITER, val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setDelimiter((String)this.val);
        }
    }

    static final class DecryptionKey
    extends RpcOptVal<Key>
    implements ObjectSourceOpt {
        private static final long serialVersionUID = -2198422155991275316L;

        private DecryptionKey(Key val) {
            super(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, val);
        }

        @Override
        public Mapper<ImmutableMap.Builder<StorageRpc.Option, Object>> mapper() {
            return b -> b.put(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, BaseEncoding.base64().encode(((Key)this.val).getEncoded()));
        }

        @Override
        public Mapper<ReadObjectRequest.Builder> readObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }

        @Override
        public Mapper<GetObjectRequest.Builder> getObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> {
                CommonObjectRequestParams.Builder builder = UnifiedOpts.customerSuppliedKey(CommonObjectRequestParams.newBuilder(), (Key)this.val);
                return b.setCopySourceEncryptionAlgorithm(builder.getEncryptionAlgorithm()).setCopySourceEncryptionKeyBytes(builder.getEncryptionKeyBytes()).setCopySourceEncryptionKeySha256Bytes(builder.getEncryptionKeySha256Bytes());
            };
        }
    }

    static final class IncludeFoldersAsPrefixes
    extends RpcOptVal<Boolean>
    implements ObjectListOpt {
        private static final long serialVersionUID = 321916692864878282L;

        private IncludeFoldersAsPrefixes(boolean val) {
            super(StorageRpc.Option.INCLUDE_FOLDERS_AS_PREFIXES, val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setIncludeFoldersAsPrefixes((Boolean)this.val);
        }
    }

    @Deprecated
    static final class DetectContentType
    implements ObjectOptExtractor<ObjectTargetOpt> {
        @Deprecated
        private static final DetectContentType INSTANCE = new DetectContentType();
        private static final FileNameMap FILE_NAME_MAP = URLConnection.getFileNameMap();
        private static final long serialVersionUID = -1089120180148634090L;

        @Deprecated
        private DetectContentType() {
        }

        @Override
        public ObjectTargetOpt extractFromBlobInfo(BlobInfo info) {
            String contentType = info.getContentType();
            if (contentType != null && !contentType.isEmpty()) {
                return NoOpObjectTargetOpt.INSTANCE;
            }
            return this.detectForName(info.getName());
        }

        @Override
        public ObjectTargetOpt extractFromBlobId(BlobId id) {
            return this.detectForName(id.getName());
        }

        private ObjectTargetOpt detectForName(String name) {
            String nameLower;
            String contentTypeFor;
            if (name != null && (contentTypeFor = FILE_NAME_MAP.getContentTypeFor(nameLower = name.toLowerCase(Locale.ENGLISH))) != null) {
                return new SetContentType(contentTypeFor);
            }
            return new SetContentType("application/octet-stream");
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class DisableGzipContent
    extends RpcOptVal<Boolean>
    implements ObjectTargetOpt {
        private static final long serialVersionUID = 7445066765944965549L;

        private DisableGzipContent(boolean val) {
            super(StorageRpc.Option.IF_DISABLE_GZIP_CONTENT, val);
        }
    }

    static final class GenerationMatch
    extends RpcOptVal<Long>
    implements ObjectSourceOpt,
    ObjectTargetOpt,
    ProjectAsSource<SourceGenerationMatch> {
        private static final long serialVersionUID = 2645517179434741007L;

        private GenerationMatch(long val) {
            super(StorageRpc.Option.IF_GENERATION_MATCH, val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfGenerationMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfGenerationMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<ReadObjectRequest.Builder> readObject() {
            return b -> b.setIfGenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<GetObjectRequest.Builder> getObject() {
            return b -> b.setIfGenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<RestoreObjectRequest.Builder> restoreObject() {
            return b -> b.setIfGenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> b.setIfGenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<DeleteObjectRequest.Builder> deleteObject() {
            return b -> b.setIfGenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<ComposeObjectRequest.Builder> composeObject() {
            return b -> b.setIfGenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfGenerationMatch((Long)this.val);
        }

        @Override
        public SourceGenerationMatch asSource() {
            return new SourceGenerationMatch((Long)this.val);
        }
    }

    static final class EncryptionKey
    extends RpcOptVal<Key>
    implements ObjectTargetOpt,
    ProjectAsSource<DecryptionKey> {
        private static final long serialVersionUID = -7335988656032764620L;

        private EncryptionKey(Key val) {
            super(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, val);
        }

        @Override
        public DecryptionKey asSource() {
            return new DecryptionKey((Key)this.val);
        }

        @Override
        public Mapper<ImmutableMap.Builder<StorageRpc.Option, Object>> mapper() {
            return b -> b.put(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, BaseEncoding.base64().encode(((Key)this.val).getEncoded()));
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }

        @Override
        public Mapper<DeleteObjectRequest.Builder> deleteObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }

        @Override
        public Mapper<ComposeObjectRequest.Builder> composeObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> {
                UnifiedOpts.customerSuppliedKey(b.getCommonObjectRequestParamsBuilder(), (Key)this.val);
                return b;
            };
        }
    }

    static final class EndOffset
    extends RpcOptVal<String>
    implements ObjectListOpt {
        private static final long serialVersionUID = 7446382028145458833L;

        private EndOffset(String val) {
            super(StorageRpc.Option.END_OFF_SET, val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setLexicographicEnd((String)this.val);
        }
    }

    static final class Fields
    extends RpcOptVal<ImmutableSet<NamedField>>
    implements ObjectSourceOpt,
    ObjectListOpt,
    ObjectTargetOpt,
    BucketSourceOpt,
    BucketTargetOpt,
    BucketListOpt {
        private static final ImmutableSet<String> grpcExcludedFields = ImmutableSet.of("nextPageToken", "prefixes", "selfLink", "mediaLink", "kind", "id", new String[0]);
        private static final long serialVersionUID = 3286889410148272195L;
        private static final ImmutableMap<String, Mapper<BlobInfo.Builder>> blobInfoFieldClearers = ImmutableMap.builder().put(Storage.BlobField.ACL.getGrpcName(), BlobInfo.Builder::clearAcl).put(Storage.BlobField.CACHE_CONTROL.getGrpcName(), BlobInfo.Builder::clearCacheControl).put(Storage.BlobField.COMPONENT_COUNT.getGrpcName(), BlobInfo.Builder::clearComponentCount).put(Storage.BlobField.CONTENT_DISPOSITION.getGrpcName(), BlobInfo.Builder::clearContentDisposition).put(Storage.BlobField.CONTENT_ENCODING.getGrpcName(), BlobInfo.Builder::clearContentEncoding).put(Storage.BlobField.CONTENT_LANGUAGE.getGrpcName(), BlobInfo.Builder::clearContentLanguage).put(Storage.BlobField.CONTENT_TYPE.getGrpcName(), BlobInfo.Builder::clearContentType).put(Storage.BlobField.CRC32C.getGrpcName(), BlobInfo.Builder::clearCrc32c).put(Storage.BlobField.CUSTOMER_ENCRYPTION.getGrpcName(), BlobInfo.Builder::clearCustomerEncryption).put(Storage.BlobField.CUSTOM_TIME.getGrpcName(), BlobInfo.Builder::clearCustomTime).put(Storage.BlobField.ETAG.getGrpcName(), BlobInfo.Builder::clearEtag).put(Storage.BlobField.EVENT_BASED_HOLD.getGrpcName(), BlobInfo.Builder::clearEventBasedHold).put(Storage.BlobField.GENERATION.getGrpcName(), b -> {
            BlobId current = b.getBlobId();
            return b.setBlobId(BlobId.of(current.getBucket(), current.getName()));
        }).put(Storage.BlobField.ID.getGrpcName(), BlobInfo.Builder::clearGeneratedId).put(Storage.BlobField.KMS_KEY_NAME.getGrpcName(), BlobInfo.Builder::clearKmsKeyName).put(Storage.BlobField.MD5HASH.getGrpcName(), BlobInfo.Builder::clearMd5).put(Storage.BlobField.MEDIA_LINK.getGrpcName(), BlobInfo.Builder::clearMediaLink).put(Storage.BlobField.METADATA.getGrpcName(), BlobInfo.Builder::clearMetadata).put(Storage.BlobField.METAGENERATION.getGrpcName(), BlobInfo.Builder::clearMetageneration).put(Storage.BlobField.OWNER.getGrpcName(), BlobInfo.Builder::clearOwner).put(Storage.BlobField.RETENTION_EXPIRATION_TIME.getGrpcName(), BlobInfo.Builder::clearRetentionExpirationTime).put(Storage.BlobField.SELF_LINK.getGrpcName(), BlobInfo.Builder::clearSelfLink).put(Storage.BlobField.SIZE.getGrpcName(), BlobInfo.Builder::clearSize).put(Storage.BlobField.STORAGE_CLASS.getGrpcName(), BlobInfo.Builder::clearStorageClass).put(Storage.BlobField.TEMPORARY_HOLD.getGrpcName(), BlobInfo.Builder::clearTemporaryHold).put(Storage.BlobField.TIME_CREATED.getGrpcName(), BlobInfo.Builder::clearCreateTime).put(Storage.BlobField.TIME_DELETED.getGrpcName(), BlobInfo.Builder::clearDeleteTime).put(Storage.BlobField.TIME_STORAGE_CLASS_UPDATED.getGrpcName(), BlobInfo.Builder::clearTimeStorageClassUpdated).put(Storage.BlobField.UPDATED.getGrpcName(), BlobInfo.Builder::clearUpdateTime).build();
        private static final ImmutableMap<String, Mapper<BucketInfo.Builder>> bucketInfoFieldClearers = ImmutableMap.builder().put(Storage.BucketField.ACL.getGrpcName(), BucketInfo.Builder::clearAcl).put(Storage.BucketField.BILLING.getGrpcName(), BucketInfo.Builder::clearRequesterPays).put(Storage.BucketField.CORS.getGrpcName(), BucketInfo.Builder::clearCors).put(Storage.BucketField.CUSTOM_PLACEMENT_CONFIG.getGrpcName(), BucketInfo.Builder::clearCustomPlacementConfig).put(Storage.BucketField.DEFAULT_EVENT_BASED_HOLD.getGrpcName(), BucketInfo.Builder::clearDefaultEventBasedHold).put(Storage.BucketField.DEFAULT_OBJECT_ACL.getGrpcName(), BucketInfo.Builder::clearDefaultAcl).put(Storage.BucketField.ENCRYPTION.getGrpcName(), BucketInfo.Builder::clearDefaultKmsKeyName).put(Storage.BucketField.ETAG.getGrpcName(), BucketInfo.Builder::clearEtag).put(Storage.BucketField.IAMCONFIGURATION.getGrpcName(), BucketInfo.Builder::clearIamConfiguration).put(Storage.BucketField.ID.getGrpcName(), BucketInfo.Builder::clearGeneratedId).put(Storage.BucketField.LABELS.getGrpcName(), BucketInfo.Builder::clearLabels).put(Storage.BucketField.LIFECYCLE.getGrpcName(), BucketInfo.Builder::clearLifecycleRules).put(Storage.BucketField.LOCATION.getGrpcName(), BucketInfo.Builder::clearLocation).put(Storage.BucketField.LOCATION_TYPE.getGrpcName(), BucketInfo.Builder::clearLocationType).put(Storage.BucketField.LOGGING.getGrpcName(), BucketInfo.Builder::clearLogging).put(Storage.BucketField.METAGENERATION.getGrpcName(), BucketInfo.Builder::clearMetageneration).put(Storage.BucketField.NAME.getGrpcName(), BucketInfo.Builder::clearName).put(Storage.BucketField.OWNER.getGrpcName(), BucketInfo.Builder::clearOwner).put(Storage.BucketField.RETENTION_POLICY.getGrpcName(), b -> b.clearRetentionEffectiveTime().clearRetentionPolicyIsLocked().clearRetentionPeriod()).put(Storage.BucketField.RPO.getGrpcName(), BucketInfo.Builder::clearRpo).put(Storage.BucketField.STORAGE_CLASS.getGrpcName(), BucketInfo.Builder::clearStorageClass).put(Storage.BucketField.TIME_CREATED.getGrpcName(), BucketInfo.Builder::clearCreateTime).put(Storage.BucketField.UPDATED.getGrpcName(), BucketInfo.Builder::clearUpdateTime).put(Storage.BucketField.VERSIONING.getGrpcName(), BucketInfo.Builder::clearVersioningEnabled).put(Storage.BucketField.WEBSITE.getGrpcName(), b -> b.clearIndexPage().clearNotFoundPage()).put("project", BucketInfo.Builder::clearProject).build();

        private Fields(ImmutableSet<NamedField> val) {
            super(StorageRpc.Option.FIELDS, val);
        }

        @Override
        public Mapper<ImmutableMap.Builder<StorageRpc.Option, Object>> mapper() {
            return b -> {
                String collect = ((ImmutableSet)this.val).stream().map(NamedField::getApiaryName).collect(Collectors.joining(","));
                return b.put(StorageRpc.Option.FIELDS, collect);
            };
        }

        @Override
        public Mapper<GetBucketRequest.Builder> getBucket() {
            return b -> b.setReadMask(FieldMask.newBuilder().addAllPaths(this.getPaths()).build());
        }

        @Override
        public Mapper<ListBucketsRequest.Builder> listBuckets() {
            return b -> b.setReadMask(FieldMask.newBuilder().addAllPaths(this.getPaths()).build());
        }

        @Override
        public Mapper<UpdateBucketRequest.Builder> updateBucket() {
            return b -> b.setUpdateMask(FieldMask.newBuilder().addAllPaths(this.getPaths()).build());
        }

        @Override
        public Mapper<GetObjectRequest.Builder> getObject() {
            return b -> b.setReadMask(FieldMask.newBuilder().addAllPaths(this.getPaths()).build());
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setReadMask(FieldMask.newBuilder().addAllPaths(this.getPaths()).build());
        }

        @Override
        public Mapper<ReadObjectRequest.Builder> readObject() {
            return b -> b.setReadMask(FieldMask.newBuilder().addAllPaths(this.getPaths()).build());
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> b.setUpdateMask(FieldMask.newBuilder().addAllPaths(this.getPaths()).build());
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return Mapper.identity();
        }

        Conversions.Decoder<BlobInfo, BlobInfo> clearUnselectedBlobFields() {
            return b -> {
                if (((ImmutableSet)this.val).isEmpty()) {
                    return b;
                }
                Set<String> names = this.getPaths();
                BlobInfo.Builder bldr = b.toBuilder();
                blobInfoFieldClearers.entrySet().stream().filter(e -> !names.contains(e.getKey())).map(Map.Entry::getValue).forEach(m -> m.apply(bldr));
                return bldr.build();
            };
        }

        Conversions.Decoder<Bucket, Bucket> clearUnselectedBucketFields() {
            return b -> {
                if (((ImmutableSet)this.val).isEmpty()) {
                    return b;
                }
                Set<String> names = this.getPaths();
                Bucket.Builder bldr = b.toBuilder();
                bucketInfoFieldClearers.entrySet().stream().filter(e -> !names.contains(e.getKey())).map(Map.Entry::getValue).forEach(m -> m.apply(bldr));
                return bldr.build();
            };
        }

        private Set<String> getPaths() {
            return ((ImmutableSet)this.val).stream().map(NamedField::stripPrefix).map(NamedField::getGrpcName).filter(Predicates.not(grpcExcludedFields::contains)).collect(Collectors.toSet());
        }
    }

    static final class GenerationNotMatch
    extends RpcOptVal<Long>
    implements ObjectSourceOpt,
    ObjectTargetOpt,
    ProjectAsSource<SourceGenerationNotMatch> {
        private static final long serialVersionUID = 156505623580743531L;

        private GenerationNotMatch(long val) {
            super(StorageRpc.Option.IF_GENERATION_NOT_MATCH, val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfGenerationNotMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfGenerationNotMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<ReadObjectRequest.Builder> readObject() {
            return b -> b.setIfGenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<GetObjectRequest.Builder> getObject() {
            return b -> b.setIfGenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<RestoreObjectRequest.Builder> restoreObject() {
            return b -> b.setIfGenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> b.setIfGenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<DeleteObjectRequest.Builder> deleteObject() {
            return b -> b.setIfGenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfGenerationNotMatch((Long)this.val);
        }

        @Override
        public SourceGenerationNotMatch asSource() {
            return new SourceGenerationNotMatch((Long)this.val);
        }
    }

    static final class KmsKeyName
    extends RpcOptVal<String>
    implements ObjectTargetOpt {
        private static final long serialVersionUID = -3053839109272566113L;

        private KmsKeyName(String val) {
            super(StorageRpc.Option.KMS_KEY_NAME, val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().getResourceBuilder().setKmsKey((String)this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().getResourceBuilder().setKmsKey((String)this.val);
                return b;
            };
        }

        @Override
        public Mapper<ComposeObjectRequest.Builder> composeObject() {
            return b -> b.setKmsKey((String)this.val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setDestinationKmsKey((String)this.val);
        }
    }

    static final class MatchGlob
    extends RpcOptVal<String>
    implements ObjectListOpt {
        private static final long serialVersionUID = 8819855597395473178L;

        private MatchGlob(String val) {
            super(StorageRpc.Option.MATCH_GLOB, val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setMatchGlobBytes(ByteString.copyFromUtf8((String)this.val));
        }
    }

    @Deprecated
    static final class Md5Match
    implements ObjectTargetOpt {
        private static final long serialVersionUID = 5237207911268363887L;
        private final String val;

        private Md5Match(String val) {
            this.val = val;
        }

        @Override
        public Mapper<BlobInfo.Builder> blobInfo() {
            return b -> b.setMd5(this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Md5Match)) {
                return false;
            }
            Md5Match md5Match = (Md5Match)o;
            return Objects.equals(this.val, md5Match.val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getObjectChecksumsBuilder().setMd5Hash(ByteString.copyFrom(BaseEncoding.base64().decode(this.val)));
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getObjectChecksumsBuilder().setMd5Hash(ByteString.copyFrom(BaseEncoding.base64().decode(this.val)));
                return b;
            };
        }

        public int hashCode() {
            return Objects.hash(this.val);
        }

        public String toString() {
            return "Md5Match{val='" + this.val + "'}";
        }
    }

    static final class MetagenerationMatch
    extends RpcOptVal<Long>
    implements BucketSourceOpt,
    BucketTargetOpt,
    ObjectSourceOpt,
    ObjectTargetOpt,
    ProjectAsSource<SourceMetagenerationMatch> {
        private static final long serialVersionUID = 49086960234390739L;

        private MetagenerationMatch(long val) {
            super(StorageRpc.Option.IF_METAGENERATION_MATCH, val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfMetagenerationMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfMetagenerationMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<ReadObjectRequest.Builder> readObject() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<GetObjectRequest.Builder> getObject() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<RestoreObjectRequest.Builder> restoreObject() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<DeleteObjectRequest.Builder> deleteObject() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<ComposeObjectRequest.Builder> composeObject() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<UpdateBucketRequest.Builder> updateBucket() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<DeleteBucketRequest.Builder> deleteBucket() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<GetBucketRequest.Builder> getBucket() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public Mapper<LockBucketRetentionPolicyRequest.Builder> lockBucketRetentionPolicy() {
            return b -> b.setIfMetagenerationMatch((Long)this.val);
        }

        @Override
        public SourceMetagenerationMatch asSource() {
            return new SourceMetagenerationMatch((Long)this.val);
        }
    }

    static final class MetagenerationNotMatch
    extends RpcOptVal<Long>
    implements BucketSourceOpt,
    BucketTargetOpt,
    ObjectSourceOpt,
    ObjectTargetOpt,
    ProjectAsSource<SourceMetagenerationNotMatch> {
        private static final long serialVersionUID = -1795350187419586248L;

        private MetagenerationNotMatch(long val) {
            super(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfMetagenerationNotMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setIfMetagenerationNotMatch((Long)this.val);
                return b;
            };
        }

        @Override
        public Mapper<ReadObjectRequest.Builder> readObject() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<GetObjectRequest.Builder> getObject() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<RestoreObjectRequest.Builder> restoreObject() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<DeleteObjectRequest.Builder> deleteObject() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<UpdateBucketRequest.Builder> updateBucket() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<DeleteBucketRequest.Builder> deleteBucket() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public Mapper<GetBucketRequest.Builder> getBucket() {
            return b -> b.setIfMetagenerationNotMatch((Long)this.val);
        }

        @Override
        public SourceMetagenerationNotMatch asSource() {
            return new SourceMetagenerationNotMatch((Long)this.val);
        }
    }

    static final class PageSize
    extends RpcOptVal<Long>
    implements BucketListOpt,
    ObjectListOpt,
    HmacKeyListOpt {
        private static final long serialVersionUID = -8184518840397826601L;

        private PageSize(long val) {
            super(StorageRpc.Option.MAX_RESULTS, val);
        }

        @Override
        public Mapper<ListHmacKeysRequest.Builder> listHmacKeys() {
            return b -> b.setPageSize(Math.toIntExact((Long)this.val));
        }

        @Override
        public Mapper<ListBucketsRequest.Builder> listBuckets() {
            return b -> b.setPageSize(Math.toIntExact((Long)this.val));
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setPageSize(Math.toIntExact((Long)this.val));
        }
    }

    static final class PageToken
    extends RpcOptVal<String>
    implements BucketListOpt,
    ObjectListOpt,
    HmacKeyListOpt {
        private static final long serialVersionUID = -1370658416509499177L;

        private PageToken(String val) {
            super(StorageRpc.Option.PAGE_TOKEN, val);
        }

        @Override
        public Mapper<ListHmacKeysRequest.Builder> listHmacKeys() {
            return b -> b.setPageToken((String)this.val);
        }

        @Override
        public Mapper<ListBucketsRequest.Builder> listBuckets() {
            return b -> b.setPageToken((String)this.val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setPageToken((String)this.val);
        }
    }

    static final class PredefinedAcl
    extends RpcOptVal<String>
    implements BucketTargetOpt,
    ObjectTargetOpt {
        private static final long serialVersionUID = -1743736785228368741L;

        private PredefinedAcl(String val) {
            super(StorageRpc.Option.PREDEFINED_ACL, val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setPredefinedAcl((String)this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().setPredefinedAcl((String)this.val);
                return b;
            };
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> b.setPredefinedAcl((String)this.val);
        }

        @Override
        public Mapper<ComposeObjectRequest.Builder> composeObject() {
            return b -> b.setDestinationPredefinedAcl((String)this.val);
        }

        @Override
        public Mapper<UpdateBucketRequest.Builder> updateBucket() {
            return b -> b.setPredefinedAcl((String)this.val);
        }

        @Override
        public Mapper<CreateBucketRequest.Builder> createBucket() {
            return b -> b.setPredefinedAcl((String)this.val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setDestinationPredefinedAcl((String)this.val);
        }
    }

    static final class PredefinedDefaultObjectAcl
    extends RpcOptVal<String>
    implements BucketTargetOpt {
        private static final long serialVersionUID = -1771832790114963130L;

        private PredefinedDefaultObjectAcl(String val) {
            super(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL, val);
        }

        @Override
        public Mapper<CreateBucketRequest.Builder> createBucket() {
            return b -> b.setPredefinedDefaultObjectAcl((String)this.val);
        }

        @Override
        public Mapper<UpdateBucketRequest.Builder> updateBucket() {
            return b -> b.setPredefinedDefaultObjectAcl((String)this.val);
        }
    }

    static final class EnableObjectRetention
    extends RpcOptVal<Boolean>
    implements BucketTargetOpt {
        private static final long serialVersionUID = -2581147719605551578L;

        private EnableObjectRetention(boolean val) {
            super(StorageRpc.Option.ENABLE_OBJECT_RETENTION, val);
        }

        @Override
        public Mapper<UpdateBucketRequest.Builder> updateBucket() {
            return (Mapper)CrossTransportUtils.throwHttpJsonOnly(Storage.BucketTargetOption.class, "enableObjectRetention(boolean)");
        }
    }

    static final class OverrideUnlockedRetention
    extends RpcOptVal<Boolean>
    implements ObjectTargetOpt {
        private static final long serialVersionUID = -7764590745622588287L;

        private OverrideUnlockedRetention(boolean val) {
            super(StorageRpc.Option.OVERRIDE_UNLOCKED_RETENTION, val);
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return (Mapper)CrossTransportUtils.throwHttpJsonOnly(Storage.BlobTargetOption.class, "overrideUnlockedRetention(boolean)");
        }
    }

    static final class Prefix
    extends RpcOptVal<String>
    implements BucketListOpt,
    ObjectListOpt {
        private static final long serialVersionUID = -3973478772547687371L;

        private Prefix(String val) {
            super(StorageRpc.Option.PREFIX, val);
        }

        @Override
        public Mapper<ListBucketsRequest.Builder> listBuckets() {
            return b -> b.setPrefix((String)this.val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setPrefix((String)this.val);
        }
    }

    @Deprecated
    static final class ProjectId
    extends RpcOptVal<String>
    implements HmacKeySourceOpt,
    HmacKeyTargetOpt,
    HmacKeyListOpt,
    BucketListOpt {
        private static final long serialVersionUID = 6273807286378420321L;

        private ProjectId(String val) {
            super(StorageRpc.Option.PROJECT_ID, val);
        }

        @Override
        public Mapper<ListHmacKeysRequest.Builder> listHmacKeys() {
            return b -> b.setProject((String)Utils.projectNameCodec.encode((String)this.val));
        }

        @Override
        public Mapper<GetHmacKeyRequest.Builder> getHmacKey() {
            return b -> b.setProject((String)Utils.projectNameCodec.encode((String)this.val));
        }

        @Override
        public Mapper<CreateHmacKeyRequest.Builder> createHmacKey() {
            return b -> b.setProject((String)Utils.projectNameCodec.encode((String)this.val));
        }

        @Override
        public Mapper<ListBucketsRequest.Builder> listBuckets() {
            return b -> b.setParent((String)Utils.projectNameCodec.encode((String)this.val));
        }
    }

    static final class Projection
    extends RpcOptVal<String>
    implements BucketTargetOpt {
        private static final long serialVersionUID = -7394684784418942133L;

        private Projection(String val) {
            super(StorageRpc.Option.PROJECTION, val);
        }
    }

    static final class ResumableUploadExpectedObjectSize
    extends RpcOptVal<Long>
    implements ObjectTargetOpt {
        private static final long serialVersionUID = 3640126281492196357L;

        private ResumableUploadExpectedObjectSize(@NonNull Long val) {
            super(StorageRpc.Option.X_UPLOAD_CONTENT_LENGTH, val);
        }

        @Override
        public Mapper<StartResumableWriteRequest.Builder> startResumableWrite() {
            return b -> {
                if ((Long)this.val > 0L) {
                    b.getWriteObjectSpecBuilder().setObjectSize((Long)this.val);
                }
                return b;
            };
        }
    }

    static final class SoftDeleted
    extends RpcOptVal<Boolean>
    implements ObjectListOpt,
    ObjectSourceOpt {
        private static final long serialVersionUID = -8526951678111463350L;

        private SoftDeleted(boolean val) {
            super(StorageRpc.Option.SOFT_DELETED, val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setSoftDeleted((Boolean)this.val);
        }

        @Override
        public Mapper<GetObjectRequest.Builder> getObject() {
            return b -> b.setSoftDeleted((Boolean)this.val);
        }
    }

    static final class CopySourceAcl
    extends RpcOptVal<Boolean>
    implements ObjectSourceOpt {
        private static final long serialVersionUID = 2033755749149128119L;

        private CopySourceAcl(boolean val) {
            super(StorageRpc.Option.COPY_SOURCE_ACL, val);
        }

        @Override
        public Mapper<RestoreObjectRequest.Builder> restoreObject() {
            return b -> b.setCopySourceAcl((Boolean)this.val);
        }
    }

    static final class RequestedPolicyVersion
    extends RpcOptVal<Long>
    implements BucketSourceOpt {
        private static final long serialVersionUID = -3606062322328656218L;

        private RequestedPolicyVersion(Long val) {
            super(StorageRpc.Option.REQUESTED_POLICY_VERSION, val);
        }

        @Override
        public Mapper<GetIamPolicyRequest.Builder> getIamPolicy() {
            return b -> {
                b.getOptionsBuilder().setRequestedPolicyVersion(Math.toIntExact((Long)this.val));
                return b;
            };
        }
    }

    @Deprecated
    static final class ReturnRawInputStream
    extends RpcOptVal<Boolean>
    implements ObjectSourceOpt {
        private static final long serialVersionUID = -5741791424843430584L;

        private ReturnRawInputStream(boolean val) {
            super(StorageRpc.Option.RETURN_RAW_INPUT_STREAM, val);
        }
    }

    static final class ServiceAccount
    extends RpcOptVal<String>
    implements HmacKeyListOpt {
        private static final long serialVersionUID = 5617709092359745482L;

        private ServiceAccount(String val) {
            super(StorageRpc.Option.SERVICE_ACCOUNT_EMAIL, val);
        }

        @Override
        public Mapper<ListHmacKeysRequest.Builder> listHmacKeys() {
            return b -> b.setServiceAccountEmail((String)this.val);
        }
    }

    static final class SetContentType
    implements ObjectTargetOpt {
        private static final long serialVersionUID = -5715260463246857009L;
        private final String val;

        private SetContentType(String val) {
            this.val = val;
        }

        @Override
        public Mapper<BlobInfo.Builder> blobInfo() {
            return b -> b.setContentType(this.val);
        }

        @Override
        public Mapper<WriteObjectRequest.Builder> writeObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().getResourceBuilder().setContentType(this.val);
                return b;
            };
        }

        @Override
        public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return b -> {
                b.getWriteObjectSpecBuilder().getResourceBuilder().setContentType(this.val);
                return b;
            };
        }

        @Override
        public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return b -> {
                b.getObjectBuilder().setContentType(this.val);
                return b;
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetContentType)) {
                return false;
            }
            SetContentType that = (SetContentType)o;
            return Objects.equals(this.val, that.val);
        }

        public int hashCode() {
            return Objects.hash(this.val);
        }

        public String toString() {
            return "SetContentType{val='" + this.val + "'}";
        }
    }

    static final class ShowDeletedKeys
    extends RpcOptVal<Boolean>
    implements HmacKeyListOpt {
        private static final long serialVersionUID = -6604176744362903487L;

        private ShowDeletedKeys(boolean val) {
            super(StorageRpc.Option.SHOW_DELETED_KEYS, val);
        }

        @Override
        public Mapper<ListHmacKeysRequest.Builder> listHmacKeys() {
            return b -> b.setShowDeletedKeys((Boolean)this.val);
        }
    }

    static final class StartOffset
    extends RpcOptVal<String>
    implements ObjectListOpt {
        private static final long serialVersionUID = -1459727336598737833L;

        private StartOffset(String val) {
            super(StorageRpc.Option.START_OFF_SET, val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setLexicographicStart((String)this.val);
        }
    }

    static final class UserProject
    extends RpcOptVal<String>
    implements BucketSourceOpt,
    BucketTargetOpt,
    BucketListOpt,
    ObjectSourceOpt,
    ObjectTargetOpt,
    ObjectListOpt,
    HmacKeySourceOpt,
    HmacKeyTargetOpt,
    HmacKeyListOpt {
        private static final long serialVersionUID = 3962499996741180460L;

        private UserProject(String val) {
            super(StorageRpc.Option.USER_PROJECT, val);
        }

        @Override
        public Mapper<GrpcCallContext> getGrpcMetadataMapper() {
            return ctx -> ctx.withExtraHeaders(ImmutableMap.of("X-Goog-User-Project", ImmutableList.of((String)this.val)));
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return Mapper.identity();
        }
    }

    static final class VersionsFilter
    extends RpcOptVal<Boolean>
    implements ObjectListOpt {
        private VersionsFilter(boolean val) {
            super(StorageRpc.Option.VERSIONS, val);
        }

        @Override
        public Mapper<ListObjectsRequest.Builder> listObjects() {
            return b -> b.setVersions((Boolean)this.val);
        }
    }

    @Deprecated
    static final class GenerationMatchExtractor
    implements ObjectOptExtractor<GenerationMatch> {
        private static final GenerationMatchExtractor INSTANCE = new GenerationMatchExtractor();
        private static final long serialVersionUID = -7211192249703566097L;

        @Deprecated
        private GenerationMatchExtractor() {
        }

        @Override
        public GenerationMatch extractFromBlobInfo(BlobInfo info) {
            Long generation = info.getGeneration();
            Preconditions.checkArgument(generation != null, "Option ifGenerationMatch is missing a value");
            return UnifiedOpts.generationMatch(generation);
        }

        @Override
        public GenerationMatch extractFromBlobId(BlobId id) {
            Long generation = id.getGeneration();
            Preconditions.checkArgument(generation != null, "Option ifGenerationMatch is missing a value");
            return UnifiedOpts.generationMatch(generation);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    @Deprecated
    static final class GenerationNotMatchExtractor
    implements ObjectOptExtractor<GenerationNotMatch> {
        private static final GenerationNotMatchExtractor INSTANCE = new GenerationNotMatchExtractor();
        private static final long serialVersionUID = -107520114846569713L;

        @Deprecated
        private GenerationNotMatchExtractor() {
        }

        @Override
        public GenerationNotMatch extractFromBlobInfo(BlobInfo info) {
            Long generation = info.getGeneration();
            Preconditions.checkArgument(generation != null, "Option ifGenerationNotMatch is missing a value");
            return UnifiedOpts.generationNotMatch(generation);
        }

        @Override
        public GenerationNotMatch extractFromBlobId(BlobId id) {
            Long generation = id.getGeneration();
            Preconditions.checkArgument(generation != null, "Option ifGenerationNotMatch is missing a value");
            return UnifiedOpts.generationNotMatch(generation);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    @Deprecated
    static final class MetagenerationMatchExtractor
    implements ObjectOptExtractor<ObjectTargetOpt>,
    BucketOptExtractor<MetagenerationMatch> {
        private static final MetagenerationMatchExtractor INSTANCE = new MetagenerationMatchExtractor();
        private static final long serialVersionUID = -4165372534008844973L;

        @Deprecated
        private MetagenerationMatchExtractor() {
        }

        @Override
        public MetagenerationMatch extractFromBlobInfo(BlobInfo info) {
            Long metageneration = info.getMetageneration();
            Preconditions.checkArgument(metageneration != null, "Option ifMetagenerationMatch is missing a value");
            return UnifiedOpts.metagenerationMatch(metageneration);
        }

        @Override
        public ObjectTargetOpt extractFromBlobId(BlobId id) {
            return NoOpObjectTargetOpt.INSTANCE;
        }

        @Override
        public MetagenerationMatch extractFromBucketInfo(BucketInfo info) {
            Long metageneration = info.getMetageneration();
            Preconditions.checkArgument(metageneration != null, "Option ifMetagenerationMatch is missing a value");
            return UnifiedOpts.metagenerationMatch(metageneration);
        }

        @Override
        public Mapper<GrpcCallContext> getGrpcMetadataMapper() {
            return Mapper.identity();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    @Deprecated
    static final class MetagenerationNotMatchExtractor
    implements ObjectOptExtractor<ObjectTargetOpt>,
    BucketOptExtractor<MetagenerationNotMatch> {
        private static final MetagenerationNotMatchExtractor INSTANCE = new MetagenerationNotMatchExtractor();
        private static final long serialVersionUID = 6544628474151482319L;

        @Deprecated
        private MetagenerationNotMatchExtractor() {
        }

        @Override
        public MetagenerationNotMatch extractFromBlobInfo(BlobInfo info) {
            Long metageneration = info.getMetageneration();
            Preconditions.checkArgument(metageneration != null, "Option ifMetagenerationNotMatch is missing a value");
            return UnifiedOpts.metagenerationNotMatch(metageneration);
        }

        @Override
        public ObjectTargetOpt extractFromBlobId(BlobId id) {
            return NoOpObjectTargetOpt.INSTANCE;
        }

        @Override
        public MetagenerationNotMatch extractFromBucketInfo(BucketInfo info) {
            Long metageneration = info.getMetageneration();
            Preconditions.checkArgument(metageneration != null, "Option ifMetagenerationNotMatch is missing a value");
            return UnifiedOpts.metagenerationNotMatch(metageneration);
        }

        @Override
        public Mapper<GrpcCallContext> getGrpcMetadataMapper() {
            return Mapper.identity();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    @Deprecated
    static final class Crc32cMatchExtractor
    implements ObjectOptExtractor<ObjectTargetOpt> {
        private static final Crc32cMatchExtractor INSTANCE = new Crc32cMatchExtractor();
        private static final long serialVersionUID = 7045998436157555676L;

        @Deprecated
        private Crc32cMatchExtractor() {
        }

        @Override
        public ObjectTargetOpt extractFromBlobInfo(BlobInfo info) {
            String crc32c = info.getCrc32c();
            if (crc32c != null) {
                return UnifiedOpts.crc32cMatch(crc32c);
            }
            return NoOpObjectTargetOpt.INSTANCE;
        }

        @Override
        public ObjectTargetOpt extractFromBlobId(BlobId id) {
            return NoOpObjectTargetOpt.INSTANCE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    @Deprecated
    static final class Md5MatchExtractor
    implements ObjectOptExtractor<ObjectTargetOpt> {
        private static final Md5MatchExtractor INSTANCE = new Md5MatchExtractor();
        private static final long serialVersionUID = 8375506989224962531L;

        @Deprecated
        private Md5MatchExtractor() {
        }

        @Override
        public ObjectTargetOpt extractFromBlobInfo(BlobInfo info) {
            String md5 = info.getMd5();
            if (md5 != null) {
                return UnifiedOpts.md5Match(md5);
            }
            return NoOpObjectTargetOpt.INSTANCE;
        }

        @Override
        public ObjectTargetOpt extractFromBlobId(BlobId id) {
            return NoOpObjectTargetOpt.INSTANCE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class NestedNamedField
    implements NamedField {
        private static long serialVersionUID = -7623005572810688221L;
        private final NamedField parent;
        private final NamedField child;

        private NestedNamedField(NamedField parent, NamedField child) {
            this.parent = parent;
            this.child = child;
        }

        @Override
        public String getApiaryName() {
            return this.parent.getApiaryName() + "." + this.child.getApiaryName();
        }

        @Override
        public String getGrpcName() {
            return this.parent.getGrpcName() + "." + this.child.getGrpcName();
        }

        NamedField getParent() {
            return this.parent;
        }

        NamedField getChild() {
            return this.child;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NestedNamedField)) {
                return false;
            }
            NestedNamedField that = (NestedNamedField)o;
            return Objects.equals(this.parent, that.parent) && Objects.equals(this.child, that.child);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.child);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("parent", this.parent).add("child", this.child).toString();
        }
    }

    private static final class LiteralNamedField
    implements NamedField {
        private static long serialVersionUID = 1422947423774466409L;
        private final String name;

        private LiteralNamedField(String name) {
            this.name = name;
        }

        @Override
        public String getApiaryName() {
            return this.name;
        }

        @Override
        public String getGrpcName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LiteralNamedField)) {
                return false;
            }
            LiteralNamedField that = (LiteralNamedField)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).toString();
        }
    }

    private static final class PrefixedNamedField
    implements NamedField {
        private static long serialVersionUID = -4899304145424680141L;
        private final String prefix;
        private final NamedField delegate;

        private PrefixedNamedField(String prefix, NamedField delegate) {
            this.prefix = prefix;
            this.delegate = delegate;
        }

        @Override
        public String getApiaryName() {
            return this.prefix + this.delegate.getApiaryName();
        }

        @Override
        public String getGrpcName() {
            return this.prefix + this.delegate.getGrpcName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrefixedNamedField)) {
                return false;
            }
            PrefixedNamedField that = (PrefixedNamedField)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.delegate);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("prefix", this.prefix).add("delegate", this.delegate).toString();
        }
    }

    static interface NamedField
    extends Serializable {
        public String getApiaryName();

        public String getGrpcName();

        default public NamedField stripPrefix() {
            if (this instanceof PrefixedNamedField) {
                PrefixedNamedField pnf = (PrefixedNamedField)this;
                return pnf.delegate;
            }
            return this;
        }

        public static NamedField prefixed(String prefix, NamedField delegate) {
            return new PrefixedNamedField(prefix, delegate);
        }

        public static NamedField literal(String name) {
            return new LiteralNamedField(name);
        }

        public static NamedField nested(NamedField parent, NamedField child) {
            return new NestedNamedField(parent, child);
        }
    }

    static final class Opts<T extends Opt> {
        private final ImmutableList<T> opts;

        private Opts(ImmutableList<T> opts) {
            this.opts = opts;
        }

        Opts<T> resolveFrom(BlobInfo info) {
            ImmutableList resolvedOpts = this.opts.stream().map(o -> {
                if (o instanceof ObjectOptExtractor) {
                    ObjectOptExtractor ex = (ObjectOptExtractor)o;
                    return ex.extractFromBlobInfo(info);
                }
                return o;
            }).collect(ImmutableList.toImmutableList());
            return new Opts(resolvedOpts);
        }

        Opts<T> resolveFrom(BlobId id) {
            ImmutableList resolvedOpts = this.opts.stream().map(o -> {
                if (o instanceof ObjectOptExtractor) {
                    ObjectOptExtractor ex = (ObjectOptExtractor)o;
                    return ex.extractFromBlobId(id);
                }
                return o;
            }).collect(ImmutableList.toImmutableList());
            return new Opts(resolvedOpts);
        }

        Opts<T> resolveFrom(BucketInfo info) {
            ImmutableList resolvedOpts = this.opts.stream().map(o -> {
                if (o instanceof BucketOptExtractor) {
                    BucketOptExtractor ex = (BucketOptExtractor)o;
                    return ex.extractFromBucketInfo(info);
                }
                return o;
            }).collect(ImmutableList.toImmutableList());
            return new Opts(resolvedOpts);
        }

        Opts<T> projectAsSource() {
            ImmutableList projectedOpts = this.opts.stream().map(o -> {
                if (o instanceof ProjectAsSource) {
                    ProjectAsSource p = (ProjectAsSource)((Object)o);
                    return p.asSource();
                }
                return o;
            }).collect(ImmutableList.toImmutableList());
            return new Opts(projectedOpts);
        }

        ImmutableMap<StorageRpc.Option, ?> getRpcOptions() {
            ImmutableMap.Builder builder = this.rpcOptionMapper().apply(ImmutableMap.builder());
            return Utils.mapBuild(builder);
        }

        Mapper<GrpcCallContext> grpcMetadataMapper() {
            return this.fuseMappers(GrpcMetadataMapper.class, GrpcMetadataMapper::getGrpcMetadataMapper);
        }

        Mapper<CreateBucketRequest.Builder> createBucketsRequest() {
            return this.fuseMappers(BucketTargetOpt.class, BucketTargetOpt::createBucket);
        }

        Mapper<GetBucketRequest.Builder> getBucketsRequest() {
            return this.fuseMappers(BucketSourceOpt.class, BucketSourceOpt::getBucket);
        }

        Mapper<ListBucketsRequest.Builder> listBucketsRequest() {
            return this.fuseMappers(BucketListOpt.class, BucketListOpt::listBuckets);
        }

        Mapper<UpdateBucketRequest.Builder> updateBucketsRequest() {
            return this.fuseMappers(BucketTargetOpt.class, BucketTargetOpt::updateBucket);
        }

        Mapper<DeleteBucketRequest.Builder> deleteBucketsRequest() {
            return this.fuseMappers(BucketTargetOpt.class, BucketTargetOpt::deleteBucket);
        }

        Mapper<LockBucketRetentionPolicyRequest.Builder> lockBucketRetentionPolicyRequest() {
            return this.fuseMappers(BucketTargetOpt.class, BucketTargetOpt::lockBucketRetentionPolicy);
        }

        Mapper<WriteObjectRequest.Builder> writeObjectRequest() {
            return this.fuseMappers(ObjectTargetOpt.class, ObjectTargetOpt::writeObject);
        }

        Mapper<BidiWriteObjectRequest.Builder> bidiWriteObjectRequest() {
            return this.fuseMappers(ObjectTargetOpt.class, ObjectTargetOpt::bidiWriteObject);
        }

        Mapper<StartResumableWriteRequest.Builder> startResumableWriteRequest() {
            return this.fuseMappers(ObjectTargetOpt.class, ObjectTargetOpt::startResumableWrite);
        }

        Mapper<GetObjectRequest.Builder> getObjectsRequest() {
            return this.fuseMappers(ObjectSourceOpt.class, ObjectSourceOpt::getObject);
        }

        Mapper<RestoreObjectRequest.Builder> restoreObjectRequest() {
            return this.fuseMappers(ObjectSourceOpt.class, ObjectSourceOpt::restoreObject);
        }

        Mapper<ReadObjectRequest.Builder> readObjectRequest() {
            return this.fuseMappers(ObjectSourceOpt.class, ObjectSourceOpt::readObject);
        }

        Mapper<ListObjectsRequest.Builder> listObjectsRequest() {
            return this.fuseMappers(ObjectListOpt.class, ObjectListOpt::listObjects);
        }

        Mapper<UpdateObjectRequest.Builder> updateObjectsRequest() {
            return this.fuseMappers(ObjectTargetOpt.class, ObjectTargetOpt::updateObject);
        }

        Mapper<DeleteObjectRequest.Builder> deleteObjectsRequest() {
            return this.fuseMappers(ObjectTargetOpt.class, ObjectTargetOpt::deleteObject);
        }

        Mapper<ComposeObjectRequest.Builder> composeObjectsRequest() {
            return this.fuseMappers(ObjectTargetOpt.class, ObjectTargetOpt::composeObject);
        }

        Mapper<RewriteObjectRequest.Builder> rewriteObjectsRequest() {
            return this.opts.stream().filter(Opts.isInstanceOf(ObjectTargetOpt.class).or(Opts.isInstanceOf(ObjectSourceOpt.class))).map(o -> {
                if (o instanceof ObjectTargetOpt) {
                    ObjectTargetOpt oto = (ObjectTargetOpt)o;
                    return oto.rewriteObject();
                }
                if (o instanceof ObjectSourceOpt) {
                    ObjectSourceOpt oso = (ObjectSourceOpt)o;
                    return oso.rewriteObject();
                }
                throw new IllegalStateException("Unexpected type: %s" + o.getClass());
            }).reduce(Mapper.identity(), Mapper::andThen);
        }

        Mapper<CreateHmacKeyRequest.Builder> createHmacKeysRequest() {
            return this.fuseMappers(HmacKeyTargetOpt.class, HmacKeyTargetOpt::createHmacKey);
        }

        Mapper<GetHmacKeyRequest.Builder> getHmacKeysRequest() {
            return this.fuseMappers(HmacKeySourceOpt.class, HmacKeySourceOpt::getHmacKey);
        }

        Mapper<ListHmacKeysRequest.Builder> listHmacKeysRequest() {
            return this.fuseMappers(HmacKeyListOpt.class, HmacKeyListOpt::listHmacKeys);
        }

        Mapper<UpdateHmacKeyRequest.Builder> updateHmacKeysRequest() {
            return this.fuseMappers(HmacKeyTargetOpt.class, HmacKeyTargetOpt::updateHmacKey);
        }

        Mapper<DeleteHmacKeyRequest.Builder> deleteHmacKeysRequest() {
            return this.fuseMappers(HmacKeyTargetOpt.class, HmacKeyTargetOpt::deleteHmacKey);
        }

        Mapper<GetIamPolicyRequest.Builder> getIamPolicyRequest() {
            return this.fuseMappers(BucketSourceOpt.class, BucketSourceOpt::getIamPolicy);
        }

        Mapper<BlobInfo.Builder> blobInfoMapper() {
            return this.fuseMappers(ObjectTargetOpt.class, ObjectTargetOpt::blobInfo);
        }

        @Deprecated
        boolean autoGzipDecompression() {
            return this.filterTo(ReturnRawInputStream.class).findFirst().map(r -> (Boolean)r.val).orElse(true);
        }

        Conversions.Decoder<BlobInfo, BlobInfo> clearBlobFields() {
            return this.filterTo(Fields.class).findFirst().map(Fields::clearUnselectedBlobFields).orElse(Conversions.Decoder.identity());
        }

        Conversions.Decoder<Bucket, Bucket> clearBucketFields() {
            return this.filterTo(Fields.class).findFirst().map(Fields::clearUnselectedBucketFields).orElse(Conversions.Decoder.identity());
        }

        Opts<T> prepend(Opts<? extends T> toPrepend) {
            Set existingOptTypes = this.opts.stream().map(Object::getClass).collect(Collectors.toSet());
            ImmutableList list = Stream.of(toPrepend.opts.stream().filter((? super T o) -> !existingOptTypes.contains(o.getClass())), this.opts.stream()).flatMap(x -> x).collect(ImmutableList.toImmutableList());
            return new Opts(list);
        }

        <R extends Opt> Opts<R> constrainTo(Class<R> c) {
            return new Opts(this.filterTo(c).collect(ImmutableList.toImmutableList()));
        }

        Opts<T> filter(Predicate<T> p) {
            return new Opts(this.opts.stream().filter(p).collect(ImmutableList.toImmutableList()));
        }

        <R extends Opt> Opts<R> transformTo(Class<R> c) {
            return new Opts(this.opts.stream().map(o -> {
                ProjectAsSource projectAsSource;
                Object asSource;
                if (o instanceof ProjectAsSource && c.isAssignableFrom((asSource = (projectAsSource = (ProjectAsSource)((Object)o)).asSource()).getClass())) {
                    return (Opt)c.cast(asSource);
                }
                if (c.isAssignableFrom(o.getClass())) {
                    return (Opt)c.cast(o);
                }
                return null;
            }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Opts)) {
                return false;
            }
            Opts opts1 = (Opts)o;
            return Objects.equals(this.opts, opts1.opts);
        }

        public int hashCode() {
            return Objects.hash(this.opts);
        }

        private Mapper<ImmutableMap.Builder<StorageRpc.Option, Object>> rpcOptionMapper() {
            return this.fuseMappers(RpcOptVal.class, RpcOptVal::mapper);
        }

        private <R extends Opt, O> Mapper<O> fuseMappers(Class<R> c, Function<R, Mapper<O>> f) {
            return this.filterTo(c).map(f).reduce(Mapper.identity(), Mapper::andThen);
        }

        private <R extends Opt> Stream<R> filterTo(Class<R> c) {
            return this.opts.stream().filter(Opts.isInstanceOf(c)).map(x -> x);
        }

        static <T extends Opt> Opts<T> from(T t) {
            return new Opts<T>(ImmutableList.of(t));
        }

        static <T extends Opt> Opts<T> from(T ... ts) {
            return new Opts<T>(ImmutableList.copyOf(ts));
        }

        static <O extends Opt> Opts<O> empty() {
            return new Opts(ImmutableList.of());
        }

        static <O extends Opt, T extends OptionShim<O>> Opts<O> unwrap(T[] ts) {
            ImmutableList collect = Arrays.stream(ts).map(OptionShim::getOpt).collect(ImmutableList.toImmutableList());
            return new Opts(collect);
        }

        static <O extends Opt, T extends OptionShim<O>> Opts<O> unwrap(Collection<T> ts) {
            ImmutableList collect = ts.stream().map(OptionShim::getOpt).collect(ImmutableList.toImmutableList());
            return new Opts(collect);
        }

        private static <T extends Opt, O extends Opt> Predicate<T> isInstanceOf(Class<O> c) {
            return t -> c.isAssignableFrom(t.getClass());
        }
    }

    private static abstract class RpcOptVal<T>
    implements Opt {
        private static final long serialVersionUID = 9170283346051824148L;
        protected final StorageRpc.Option key;
        protected final T val;

        private RpcOptVal(StorageRpc.Option key, T val) {
            this.key = Objects.requireNonNull(key, "key must be non null");
            this.val = Objects.requireNonNull(val, "val must be non null");
        }

        public Mapper<ImmutableMap.Builder<StorageRpc.Option, Object>> mapper() {
            return b -> b.put(this.key, this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RpcOptVal)) {
                return false;
            }
            RpcOptVal rpcOptVal = (RpcOptVal)o;
            return Objects.equals((Object)this.key, (Object)rpcOptVal.key) && Objects.equals(this.val, rpcOptVal.val);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.val});
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{key=" + (Object)((Object)this.key) + ", val=" + this.val + '}';
        }
    }

    @Deprecated
    static abstract class OptionShim<O extends Opt>
    implements Serializable {
        private static final long serialVersionUID = 3410752214075057852L;
        private final O opt;

        OptionShim(O opt) {
            this.opt = opt;
        }

        O getOpt() {
            return this.opt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OptionShim)) {
                return false;
            }
            OptionShim that = (OptionShim)o;
            return Objects.equals(this.opt, that.opt);
        }

        public int hashCode() {
            return Objects.hash(this.opt);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{opt=" + this.opt + '}';
        }
    }

    @VisibleForTesting
    static final class NoOpObjectTargetOpt
    implements ObjectTargetOpt {
        @VisibleForTesting
        static final NoOpObjectTargetOpt INSTANCE = new NoOpObjectTargetOpt();
        private static final long serialVersionUID = -5356245440686012545L;

        private NoOpObjectTargetOpt() {
        }

        @Override
        public Mapper<GrpcCallContext> getGrpcMetadataMapper() {
            return Mapper.identity();
        }

        @Override
        public Mapper<BlobInfo.Builder> blobInfo() {
            return Mapper.identity();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class SourceMetagenerationNotMatch
    extends RpcOptVal<Long>
    implements BucketSourceOpt,
    BucketTargetOpt,
    ObjectSourceOpt,
    ObjectTargetOpt {
        private static final long serialVersionUID = 2679308305890468285L;

        private SourceMetagenerationNotMatch(@NonNull Long val) {
            super(StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH, val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfSourceMetagenerationNotMatch((Long)this.val);
        }
    }

    static final class SourceMetagenerationMatch
    extends RpcOptVal<Long>
    implements BucketSourceOpt,
    BucketTargetOpt,
    ObjectSourceOpt,
    ObjectTargetOpt {
        private static final long serialVersionUID = 5223360761780436495L;

        private SourceMetagenerationMatch(@NonNull Long val) {
            super(StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH, val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfSourceMetagenerationMatch((Long)this.val);
        }
    }

    static final class SourceGenerationNotMatch
    extends RpcOptVal<Long>
    implements ObjectSourceOpt,
    ObjectTargetOpt {
        private static final long serialVersionUID = -5232032184462880657L;

        private SourceGenerationNotMatch(@NonNull Long val) {
            super(StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH, val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfSourceGenerationNotMatch((Long)this.val);
        }
    }

    static final class SourceGenerationMatch
    extends RpcOptVal<Long>
    implements ObjectSourceOpt,
    ObjectTargetOpt {
        private static final long serialVersionUID = -4074703368515265616L;

        private SourceGenerationMatch(@NonNull Long val) {
            super(StorageRpc.Option.IF_SOURCE_GENERATION_MATCH, val);
        }

        @Override
        public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return b -> b.setIfSourceGenerationMatch((Long)this.val);
        }
    }

    static interface BucketOptExtractor<O extends Opt>
    extends Opt,
    BucketSourceOpt,
    BucketTargetOpt {
        public O extractFromBucketInfo(BucketInfo var1);

        @Override
        default public Mapper<GrpcCallContext> getGrpcMetadataMapper() {
            return Mapper.identity();
        }
    }

    static interface ObjectOptExtractor<O extends Opt>
    extends Opt,
    ObjectSourceOpt,
    ObjectTargetOpt {
        public O extractFromBlobInfo(BlobInfo var1);

        public O extractFromBlobId(BlobId var1);

        @Override
        default public Mapper<GrpcCallContext> getGrpcMetadataMapper() {
            return Mapper.identity();
        }

        @Override
        default public Mapper<GetObjectRequest.Builder> getObject() {
            return Mapper.identity();
        }

        @Override
        default public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return Mapper.identity();
        }
    }

    static interface ProjectAsSource<O extends Opt> {
        public O asSource();
    }

    static interface HmacKeyTargetOpt
    extends GrpcMetadataMapper,
    TargetOpt,
    ApplicableHmacKey {
        default public Mapper<CreateHmacKeyRequest.Builder> createHmacKey() {
            return Mapper.identity();
        }

        default public Mapper<UpdateHmacKeyRequest.Builder> updateHmacKey() {
            return Mapper.identity();
        }

        default public Mapper<DeleteHmacKeyRequest.Builder> deleteHmacKey() {
            return Mapper.identity();
        }
    }

    static interface HmacKeySourceOpt
    extends GrpcMetadataMapper,
    SourceOpt,
    ApplicableHmacKey {
        default public Mapper<GetHmacKeyRequest.Builder> getHmacKey() {
            return Mapper.identity();
        }
    }

    static interface HmacKeyListOpt
    extends GrpcMetadataMapper,
    ListOpt,
    ApplicableHmacKey {
        default public Mapper<ListHmacKeysRequest.Builder> listHmacKeys() {
            return Mapper.identity();
        }
    }

    static interface BucketTargetOpt
    extends GrpcMetadataMapper,
    TargetOpt,
    ApplicableBucket {
        default public Mapper<CreateBucketRequest.Builder> createBucket() {
            return Mapper.identity();
        }

        default public Mapper<UpdateBucketRequest.Builder> updateBucket() {
            return Mapper.identity();
        }

        default public Mapper<DeleteBucketRequest.Builder> deleteBucket() {
            return Mapper.identity();
        }

        default public Mapper<LockBucketRetentionPolicyRequest.Builder> lockBucketRetentionPolicy() {
            return Mapper.identity();
        }
    }

    static interface BucketSourceOpt
    extends GrpcMetadataMapper,
    SourceOpt,
    ApplicableBucket {
        default public Mapper<GetBucketRequest.Builder> getBucket() {
            return Mapper.identity();
        }

        default public Mapper<GetIamPolicyRequest.Builder> getIamPolicy() {
            return Mapper.identity();
        }
    }

    static interface BucketListOpt
    extends GrpcMetadataMapper,
    ListOpt,
    ApplicableBucket {
        default public Mapper<ListBucketsRequest.Builder> listBuckets() {
            return Mapper.identity();
        }
    }

    static interface ObjectTargetOpt
    extends GrpcMetadataMapper,
    TargetOpt,
    ApplicableObject {
        default public Mapper<BlobInfo.Builder> blobInfo() {
            return Mapper.identity();
        }

        default public Mapper<WriteObjectRequest.Builder> writeObject() {
            return Mapper.identity();
        }

        default public Mapper<BidiWriteObjectRequest.Builder> bidiWriteObject() {
            return Mapper.identity();
        }

        default public Mapper<UpdateObjectRequest.Builder> updateObject() {
            return Mapper.identity();
        }

        default public Mapper<DeleteObjectRequest.Builder> deleteObject() {
            return Mapper.identity();
        }

        default public Mapper<ComposeObjectRequest.Builder> composeObject() {
            return Mapper.identity();
        }

        default public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return Mapper.identity();
        }

        default public Mapper<StartResumableWriteRequest.Builder> startResumableWrite() {
            return Mapper.identity();
        }
    }

    static interface ObjectSourceOpt
    extends GrpcMetadataMapper,
    SourceOpt,
    ApplicableObject {
        default public Mapper<ReadObjectRequest.Builder> readObject() {
            return Mapper.identity();
        }

        default public Mapper<GetObjectRequest.Builder> getObject() {
            return Mapper.identity();
        }

        default public Mapper<RewriteObjectRequest.Builder> rewriteObject() {
            return Mapper.identity();
        }

        default public Mapper<RestoreObjectRequest.Builder> restoreObject() {
            return Mapper.identity();
        }
    }

    static interface ObjectListOpt
    extends GrpcMetadataMapper,
    ListOpt,
    ApplicableObject {
        default public Mapper<ListObjectsRequest.Builder> listObjects() {
            return Mapper.identity();
        }
    }

    private static interface GrpcMetadataMapper
    extends Opt {
        default public Mapper<GrpcCallContext> getGrpcMetadataMapper() {
            return Mapper.identity();
        }
    }

    private static interface ApplicableHmacKey {
    }

    private static interface ApplicableObject {
    }

    private static interface ApplicableBucket {
    }

    private static interface ListOpt
    extends Opt {
    }

    private static interface TargetOpt
    extends Opt {
    }

    private static interface SourceOpt
    extends Opt {
    }

    @FunctionalInterface
    static interface Mapper<T> {
        public T apply(T var1);

        default public Mapper<T> andThen(Mapper<T> then) {
            return t -> then.apply(this.apply(t));
        }

        public static <T> Mapper<T> identity() {
            return t -> t;
        }
    }

    static interface Opt
    extends Serializable {
    }
}

