/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsChannelCrypter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsHandshakerClient;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsHandshakerOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsInternalContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsTsiFrameProtector;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.HandshakerServiceGrpc;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiFrameProtector;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiHandshaker;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.TsiPeer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;

public final class AltsTsiHandshaker
implements TsiHandshaker {
    private final ChannelLogger logger;
    public static final String TSI_SERVICE_ACCOUNT_PEER_PROPERTY = "service_account";
    private final boolean isClient;
    private final AltsHandshakerClient handshaker;
    private ByteBuffer outputFrame;

    private AltsTsiHandshaker(boolean isClient, HandshakerServiceGrpc.HandshakerServiceStub stub, AltsHandshakerOptions options, ChannelLogger logger) {
        this.isClient = isClient;
        this.logger = logger;
        this.handshaker = new AltsHandshakerClient(stub, options, logger);
    }

    @VisibleForTesting
    AltsTsiHandshaker(boolean isClient, AltsHandshakerClient handshaker, ChannelLogger logger) {
        this.isClient = isClient;
        this.handshaker = handshaker;
        this.logger = logger;
    }

    @Override
    public boolean processBytesFromPeer(ByteBuffer bytes) throws GeneralSecurityException {
        if (this.outputFrame == null && this.isClient) {
            return true;
        }
        if (this.outputFrame != null && this.outputFrame.hasRemaining()) {
            return true;
        }
        int remaining = bytes.remaining();
        if (this.outputFrame == null) {
            Preconditions.checkState(!this.isClient, "Client handshaker should not process any frame at the beginning.");
            this.outputFrame = this.handshaker.startServerHandshake(bytes);
        } else {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Receive ALTS handshake from downstream");
            this.outputFrame = this.handshaker.next(bytes);
        }
        if (this.handshaker.isFinished() || this.outputFrame.hasRemaining()) {
            return true;
        }
        if (!bytes.hasRemaining()) {
            return false;
        }
        Preconditions.checkState(bytes.remaining() < remaining, "Handshaker did not consume any bytes.");
        return this.processBytesFromPeer(bytes);
    }

    @Override
    public TsiPeer extractPeer() throws GeneralSecurityException {
        Preconditions.checkState(!this.isInProgress(), "Handshake is not complete.");
        ArrayList peerProperties = new ArrayList();
        peerProperties.add(new TsiPeer.StringProperty(TSI_SERVICE_ACCOUNT_PEER_PROPERTY, this.handshaker.getResult().getPeerIdentity().getServiceAccount()));
        return new TsiPeer(peerProperties);
    }

    @Override
    public Object extractPeerObject() throws GeneralSecurityException {
        Preconditions.checkState(!this.isInProgress(), "Handshake is not complete.");
        return new AltsInternalContext(this.handshaker.getResult());
    }

    public static TsiHandshaker newClient(HandshakerServiceGrpc.HandshakerServiceStub stub, AltsHandshakerOptions options, ChannelLogger logger) {
        return new AltsTsiHandshaker(true, stub, options, logger);
    }

    public static TsiHandshaker newServer(HandshakerServiceGrpc.HandshakerServiceStub stub, AltsHandshakerOptions options, ChannelLogger logger) {
        return new AltsTsiHandshaker(false, stub, options, logger);
    }

    @Override
    public void getBytesToSendToPeer(ByteBuffer bytes) throws GeneralSecurityException {
        if (this.outputFrame == null) {
            if (this.isClient) {
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Initial ALTS handshake to downstream");
                this.outputFrame = this.handshaker.startClientHandshake();
            } else {
                return;
            }
        }
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Send ALTS request to downstream");
        ByteBuffer outputFrameAlias = this.outputFrame;
        if (this.outputFrame.remaining() > bytes.remaining()) {
            outputFrameAlias = this.outputFrame.duplicate();
            ((Buffer)outputFrameAlias).limit(outputFrameAlias.position() + bytes.remaining());
        }
        bytes.put(outputFrameAlias);
        ((Buffer)this.outputFrame).position(outputFrameAlias.position());
    }

    @Override
    public boolean isInProgress() {
        return !this.handshaker.isFinished() || this.outputFrame.hasRemaining();
    }

    @Override
    public TsiFrameProtector createFrameProtector(int maxFrameSize, ByteBufAllocator alloc) {
        Preconditions.checkState(!this.isInProgress(), "Handshake is not complete.");
        byte[] key = this.handshaker.getKey();
        Preconditions.checkState(key.length == AltsChannelCrypter.getKeyLength(), "Bad key length.");
        int peerMaxFrameSize = this.handshaker.getResult().getMaxFrameSize();
        if (peerMaxFrameSize != 0) {
            maxFrameSize = Math.min(peerMaxFrameSize, AltsTsiFrameProtector.getMaxFrameSize());
            maxFrameSize = Math.max(AltsTsiFrameProtector.getMinFrameSize(), maxFrameSize);
        }
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "Maximum frame size value is {0}.", maxFrameSize);
        return new AltsTsiFrameProtector(maxFrameSize, new AltsChannelCrypter(key, this.isClient), alloc);
    }

    @Override
    public TsiFrameProtector createFrameProtector(ByteBufAllocator alloc) {
        return this.createFrameProtector(AltsTsiFrameProtector.getMinFrameSize(), alloc);
    }

    @Override
    public void close() {
        this.handshaker.close();
    }
}

