/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.internal;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class GlobUtil {
    private GlobUtil() {
    }

    public static Predicate<String> toGlobPatternPredicate(String globPattern) {
        if (globPattern.equals("*")) {
            return unused -> true;
        }
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c != '*' && c != '?') continue;
            Pattern pattern = GlobUtil.toRegexPattern(globPattern);
            return string -> pattern.matcher((CharSequence)string).matches();
        }
        return globPattern::equalsIgnoreCase;
    }

    private static Pattern toRegexPattern(String globPattern) {
        int tokenStart = -1;
        StringBuilder patternBuilder = new StringBuilder();
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c == '*' || c == '?') {
                if (tokenStart != -1) {
                    patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart, i)));
                    tokenStart = -1;
                }
                if (c == '*') {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append(".");
                continue;
            }
            if (tokenStart != -1) continue;
            tokenStart = i;
        }
        if (tokenStart != -1) {
            patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart)));
        }
        return Pattern.compile(patternBuilder.toString());
    }
}

