/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.webtoken;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Preconditions;
import java.math.BigInteger;
import java.util.Arrays;

public class DerEncoder {
    private static byte DER_TAG_SIGNATURE_OBJECT = (byte)48;
    private static byte DER_TAG_ASN1_INTEGER = (byte)2;

    static byte[] encode(byte[] signature) {
        Preconditions.checkState(signature.length == 64);
        byte[] int1 = new BigInteger(1, Arrays.copyOfRange(signature, 0, 32)).toByteArray();
        byte[] int2 = new BigInteger(1, Arrays.copyOfRange(signature, 32, 64)).toByteArray();
        byte[] der = new byte[6 + int1.length + int2.length];
        der[0] = DER_TAG_SIGNATURE_OBJECT;
        der[1] = (byte)(der.length - 2);
        der[2] = DER_TAG_ASN1_INTEGER;
        der[3] = (byte)int1.length;
        System.arraycopy(int1, 0, der, 4, int1.length);
        int offset = int1.length + 4;
        der[offset] = DER_TAG_ASN1_INTEGER;
        der[offset + 1] = (byte)int2.length;
        System.arraycopy(int2, 0, der, offset + 2, int2.length);
        return der;
    }
}

