/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class GoogleCloudStorageOptions {
    public static final boolean ENABLE_GRPC_DEFAULT = false;
    public static final boolean ENABLE_TRAFFIC_DIRECTOR_DEFAULT = true;
    public static final boolean DIRECT_PATH_PREFERRED_DEFAULT = true;
    public static final String STORAGE_ROOT_URL_DEFAULT = "https://storage.googleapis.com/";
    public static final String STORAGE_SERVICE_PATH_DEFAULT = "storage/v1/";
    public static final boolean AUTO_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final int MAX_WAIT_MILLIS_FOR_EMPTY_OBJECT_CREATION = 3000;
    public static final long MAX_LIST_ITEMS_PER_CALL_DEFAULT = 5000L;
    public static final long MAX_REQUESTS_PER_BATCH_DEFAULT = 30L;
    public static final int BATCH_THREADS_DEFAULT = 0;
    public static final int MAX_HTTP_REQUEST_RETRIES = 10;
    public static final int HTTP_REQUEST_CONNECT_TIMEOUT = 20000;
    public static final int HTTP_REQUEST_READ_TIMEOUT = 20000;
    public static final boolean COPY_WITH_REWRITE_DEFAULT = false;
    public static final boolean GRPC_WRITE_DEFAULT = false;
    public static final int MAX_BYTES_REWRITTEN_PER_CALL_DEFAULT = 0;
    public static final long GRPC_MESSAGE_TIMEOUT_CHECK_INTERVAL = 1000L;
    public static final ImmutableMap<String, String> HTTP_REQUEST_HEADERS_DEFAULT = ImmutableMap.of();
    private static final boolean SET_HN_BUCKET_CREATE_ENABLED_DEFAULT = false;
    public static final Class<? extends AuthorizationHandler> AUTHORIZATION_HANDLER_IMPL_CLASS_DEFAULT = null;
    public static final Map<String, String> AUTHORIZATION_HANDLER_PROPERTIES_DEFAULT = ImmutableMap.of();
    public static final GoogleCloudStorageOptions DEFAULT = GoogleCloudStorageOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_GoogleCloudStorageOptions.Builder().setGrpcEnabled(false).setTrafficDirectorEnabled(true).setDirectPathPreferred(true).setStorageRootUrl(STORAGE_ROOT_URL_DEFAULT).setStorageServicePath(STORAGE_SERVICE_PATH_DEFAULT).setAutoRepairImplicitDirectoriesEnabled(true).setMaxWaitMillisForEmptyObjectCreation(3000).setMaxListItemsPerCall(5000L).setMaxRequestsPerBatch(30L).setBatchThreads(0).setMaxHttpRequestRetries(10).setHttpRequestConnectTimeout(20000).setHttpRequestReadTimeout(20000).setTransportType(HttpTransportFactory.DEFAULT_TRANSPORT_TYPE).setCopyWithRewriteEnabled(false).setMaxBytesRewrittenPerCall(0L).setReadChannelOptions(GoogleCloudStorageReadOptions.DEFAULT).setWriteChannelOptions(AsyncWriteChannelOptions.DEFAULT).setRequesterPaysOptions(RequesterPaysOptions.DEFAULT).setCooperativeLockingOptions(CooperativeLockingOptions.DEFAULT).setHttpRequestHeaders(HTTP_REQUEST_HEADERS_DEFAULT).setGrpcMessageTimeoutCheckInterval(1000L).setAuthorizationHandlerImplClass(AUTHORIZATION_HANDLER_IMPL_CLASS_DEFAULT).setAuthorizationHandlerProperties(AUTHORIZATION_HANDLER_PROPERTIES_DEFAULT).setMetricsSink(MetricsSink.NONE).setTraceLogEnabled(false).setOperationTraceLogEnabled(false).setTraceLogTimeThreshold(0L).setTraceLogExcludeProperties(ImmutableSet.of()).setHnBucketRenameEnabled(false).setGrpcWriteEnabled(false).setMoveOperationEnabled(false);
    }

    public abstract Builder toBuilder();

    public abstract boolean isGrpcEnabled();

    public abstract boolean isHnBucketRenameEnabled();

    public abstract boolean isTrafficDirectorEnabled();

    public abstract boolean isDirectPathPreferred();

    public abstract String getStorageRootUrl();

    public abstract String getStorageServicePath();

    public abstract boolean isGrpcWriteEnabled();

    @Nullable
    public abstract String getProjectId();

    @Nullable
    public abstract String getAppName();

    public abstract boolean isAutoRepairImplicitDirectoriesEnabled();

    public abstract int getMaxWaitMillisForEmptyObjectCreation();

    public abstract long getMaxListItemsPerCall();

    public abstract long getMaxRequestsPerBatch();

    public abstract int getBatchThreads();

    public abstract int getMaxHttpRequestRetries();

    public abstract int getHttpRequestConnectTimeout();

    public abstract int getHttpRequestReadTimeout();

    public abstract HttpTransportFactory.HttpTransportType getTransportType();

    @Nullable
    public abstract String getProxyAddress();

    @Nullable
    public abstract RedactedString getProxyUsername();

    @Nullable
    public abstract RedactedString getProxyPassword();

    public abstract boolean isCopyWithRewriteEnabled();

    public abstract long getMaxBytesRewrittenPerCall();

    public abstract GoogleCloudStorageReadOptions getReadChannelOptions();

    public abstract AsyncWriteChannelOptions getWriteChannelOptions();

    public abstract RequesterPaysOptions getRequesterPaysOptions();

    public abstract CooperativeLockingOptions getCooperativeLockingOptions();

    public abstract ImmutableMap<String, String> getHttpRequestHeaders();

    @Nullable
    public abstract String getEncryptionAlgorithm();

    @Nullable
    public abstract RedactedString getEncryptionKey();

    @Nullable
    public abstract RedactedString getEncryptionKeyHash();

    public abstract long getGrpcMessageTimeoutCheckInterval();

    public abstract MetricsSink getMetricsSink();

    public abstract boolean isTraceLogEnabled();

    public abstract boolean isOperationTraceLogEnabled();

    public abstract long getTraceLogTimeThreshold();

    public abstract ImmutableSet<String> getTraceLogExcludeProperties();

    public abstract boolean isMoveOperationEnabled();

    public RetryHttpInitializerOptions toRetryHttpInitializerOptions() {
        return RetryHttpInitializerOptions.builder().setDefaultUserAgent(this.getAppName()).setHttpHeaders(this.getHttpRequestHeaders()).setMaxRequestRetries(this.getMaxHttpRequestRetries()).setConnectTimeout(Duration.ofMillis(this.getHttpRequestConnectTimeout())).setReadTimeout(Duration.ofMillis(this.getHttpRequestReadTimeout())).build();
    }

    @Nullable
    public abstract Class<? extends AuthorizationHandler> getAuthorizationHandlerImplClass();

    public abstract Map<String, String> getAuthorizationHandlerProperties();

    public void throwIfNotValid() {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(this.getAppName()), "appName must not be null or empty");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setGrpcEnabled(boolean var1);

        public abstract Builder setTrafficDirectorEnabled(boolean var1);

        public abstract Builder setDirectPathPreferred(boolean var1);

        public abstract Builder setStorageRootUrl(String var1);

        public abstract Builder setStorageServicePath(String var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setAppName(String var1);

        public abstract Builder setAutoRepairImplicitDirectoriesEnabled(boolean var1);

        public abstract Builder setMaxWaitMillisForEmptyObjectCreation(int var1);

        public abstract Builder setMaxListItemsPerCall(long var1);

        public abstract Builder setMaxRequestsPerBatch(long var1);

        public abstract Builder setBatchThreads(int var1);

        public abstract Builder setMaxHttpRequestRetries(int var1);

        public abstract Builder setHttpRequestConnectTimeout(int var1);

        public abstract Builder setHttpRequestReadTimeout(int var1);

        public abstract Builder setTransportType(HttpTransportFactory.HttpTransportType var1);

        public abstract Builder setProxyAddress(String var1);

        public abstract Builder setProxyUsername(RedactedString var1);

        public abstract Builder setProxyPassword(RedactedString var1);

        public abstract Builder setCopyWithRewriteEnabled(boolean var1);

        public abstract Builder setMaxBytesRewrittenPerCall(long var1);

        public abstract Builder setReadChannelOptions(GoogleCloudStorageReadOptions var1);

        public abstract Builder setWriteChannelOptions(AsyncWriteChannelOptions var1);

        public abstract Builder setRequesterPaysOptions(RequesterPaysOptions var1);

        public abstract Builder setCooperativeLockingOptions(CooperativeLockingOptions var1);

        public abstract Builder setHttpRequestHeaders(Map<String, String> var1);

        public abstract Builder setEncryptionAlgorithm(String var1);

        public abstract Builder setEncryptionKey(RedactedString var1);

        public abstract Builder setEncryptionKeyHash(RedactedString var1);

        public abstract Builder setAuthorizationHandlerImplClass(Class<? extends AuthorizationHandler> var1);

        public abstract Builder setAuthorizationHandlerProperties(Map<String, String> var1);

        public abstract Builder setGrpcMessageTimeoutCheckInterval(long var1);

        public abstract Builder setMetricsSink(MetricsSink var1);

        public abstract Builder setTraceLogEnabled(Boolean var1);

        public abstract Builder setOperationTraceLogEnabled(Boolean var1);

        public abstract Builder setTraceLogTimeThreshold(long var1);

        public abstract Builder setHnBucketRenameEnabled(boolean var1);

        public abstract Builder setTraceLogExcludeProperties(ImmutableSet<String> var1);

        public abstract Builder setGrpcWriteEnabled(boolean var1);

        public abstract Builder setMoveOperationEnabled(boolean var1);

        abstract GoogleCloudStorageOptions autoBuild();

        public GoogleCloudStorageOptions build() {
            GoogleCloudStorageOptions instance = this.autoBuild();
            Preconditions.checkArgument(instance.getMaxBytesRewrittenPerCall() <= 0L || instance.getMaxBytesRewrittenPerCall() % 0x100000L == 0L, "maxBytesRewrittenPerCall must be an integral multiple of 1 MiB (1048576), but was: %s", instance.getMaxBytesRewrittenPerCall());
            Preconditions.checkArgument(instance.getProxyAddress() != null || instance.getProxyUsername() == null && instance.getProxyPassword() == null, "if proxyAddress is null then proxyUsername and proxyPassword should be null too");
            Preconditions.checkArgument(instance.getProxyUsername() == null == (instance.getProxyPassword() == null), "both proxyUsername and proxyPassword should be null or not null together");
            Preconditions.checkArgument(this.isAllEncryptionOptionsSetOrUnset(instance), "encryptionAlgorithm, encryptionKey and encryptionKeyHash should be null or not null together");
            return instance;
        }

        private boolean isAllEncryptionOptionsSetOrUnset(GoogleCloudStorageOptions instance) {
            return instance.getEncryptionAlgorithm() != null && instance.getEncryptionKey() != null && instance.getEncryptionKeyHash() != null || instance.getEncryptionAlgorithm() == null && instance.getEncryptionKey() == null && instance.getEncryptionKeyHash() == null;
        }
    }

    public static enum MetricsSink {
        NONE,
        CLOUD_MONITORING;

    }
}

