/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.detection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class GCPMetadataConfig {
    static final GCPMetadataConfig DEFAULT_INSTANCE = new GCPMetadataConfig();
    private static final String DEFAULT_URL = "http://metadata.google.internal/computeMetadata/v1/";
    private final String url;
    private final Map<String, String> cachedAttributes = new ConcurrentHashMap<String, String>();

    private GCPMetadataConfig() {
        this.url = DEFAULT_URL;
    }

    GCPMetadataConfig(String url) {
        this.url = url;
    }

    String getProjectId() {
        return this.getAttribute("project/project-id");
    }

    String getZone() {
        String zone = this.getAttribute("instance/zone");
        if (zone != null && zone.contains("/")) {
            zone = zone.substring(zone.lastIndexOf(47) + 1);
        }
        return zone;
    }

    String getRegion() {
        String region = this.getAttribute("instance/region");
        if (region != null && region.contains("/")) {
            region = region.substring(region.lastIndexOf(47) + 1);
        }
        return region;
    }

    String getRegionFromZone() {
        String[] splitArr;
        String region = null;
        String zone = this.getZone();
        if (zone != null && !zone.isEmpty() && (splitArr = zone.split("-")).length > 2) {
            region = String.join((CharSequence)"-", splitArr[0], splitArr[1]);
        }
        return region;
    }

    String getMachineType() {
        String machineType = this.getAttribute("instance/machine-type");
        if (machineType != null && machineType.contains("/")) {
            machineType = machineType.substring(machineType.lastIndexOf(47) + 1);
        }
        return machineType;
    }

    String getInstanceId() {
        return this.getAttribute("instance/id");
    }

    String getClusterName() {
        return this.getAttribute("instance/attributes/cluster-name");
    }

    String getClusterLocation() {
        return this.getAttribute("instance/attributes/cluster-location");
    }

    String getInstanceHostName() {
        return this.getAttribute("instance/hostname");
    }

    String getInstanceName() {
        return this.getAttribute("instance/name");
    }

    private String getAttribute(String attributeName) {
        return this.cachedAttributes.computeIfAbsent(attributeName, this::fetchAttribute);
    }

    private String fetchAttribute(String attributeName) {
        block7: {
            String string;
            URL url = new URL(this.url + attributeName);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Metadata-Flavor", "Google");
            if (connection.getResponseCode() != 200 || !"Google".equals(connection.getHeaderField("Metadata-Flavor"))) break block7;
            InputStream input = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            try {
                string = reader.readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            reader.close();
            return string;
        }
        return null;
    }
}

