/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.InternalMetricExporter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.opentelemetry.metric.NoopMetricExporter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Suppliers;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.common.CompletableResultCode;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.data.MetricData;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCloudMetricExporter
implements MetricExporter {
    private static final Logger logger = LoggerFactory.getLogger(GoogleCloudMetricExporter.class);
    private final Supplier<MetricExporter> internalMetricExporterSupplier = Suppliers.memoize(() -> {
        try {
            return InternalMetricExporter.createWithConfiguration(configuration);
        }
        catch (IOException e) {
            logger.warn("Unable to initialize GoogleCloudMetricExporter. Export operation failed, switching to NoopMetricExporter.", (Throwable)e);
            return new NoopMetricExporter();
        }
    });

    private GoogleCloudMetricExporter(MetricConfiguration configuration) {
    }

    public static MetricExporter createWithDefaultConfiguration() {
        return new GoogleCloudMetricExporter(MetricConfiguration.builder().build());
    }

    public static MetricExporter createWithConfiguration(MetricConfiguration configuration) {
        return new GoogleCloudMetricExporter(configuration);
    }

    @Override
    public CompletableResultCode export(@Nonnull Collection<MetricData> metrics) {
        return this.internalMetricExporterSupplier.get().export(metrics);
    }

    @Override
    public CompletableResultCode flush() {
        return this.internalMetricExporterSupplier.get().flush();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.internalMetricExporterSupplier.get().shutdown();
    }

    @Override
    public AggregationTemporality getAggregationTemporality(@Nonnull InstrumentType instrumentType) {
        return this.internalMetricExporterSupplier.get().getAggregationTemporality(instrumentType);
    }
}

