/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.DateTime;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.MapDifference;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Maps;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.primitives.Ints;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.BucketName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ProjectName;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
final class Utils {
    private static final Function<ImmutableMap.Builder<?, ?>, ImmutableMap<?, ?>> mapBuild;
    static final DateTimeFormatter RFC_3339_DATE_TIME_FORMATTER;
    static final Conversions.Codec<Duration, Long> durationSecondsCodec;
    @VisibleForTesting
    static final Conversions.Codec<OffsetDateTime, DateTime> dateTimeCodec;
    static final Conversions.Codec<OffsetDateTime, DateTime> nullableDateTimeCodec;
    static final Conversions.Codec<String, String> bucketNameCodec;
    static final Conversions.Codec<String, String> projectNameCodec;
    static final Conversions.Codec<Integer, String> crc32cCodec;

    private Utils() {
    }

    @InternalApi
    static <T> void ifNonNull(@Nullable T t, Consumer<T> c) {
        if (t != null) {
            c.accept(t);
        }
    }

    @InternalApi
    static <T1, T2> void ifNonNull(@Nullable T1 t, Function<T1, T2> map, Consumer<T2> c) {
        T2 apply;
        if (t != null && (apply = map.apply(t)) != null) {
            c.accept(apply);
        }
    }

    @InternalApi
    static <T1, T2> Function<T1, T2> lift(Function<T1, T2> f) {
        return f;
    }

    @SafeVarargs
    static <T> @NonNull T firstNonNull(Supplier<T> ... ss) {
        for (Supplier<T> s : ss) {
            T t = s.get();
            if (t == null) continue;
            return t;
        }
        throw new IllegalStateException("Unable to resolve non-null value");
    }

    static void diffMaps(UnifiedOpts.NamedField parent, Map<String, String> left, Map<String, String> right, Consumer<UnifiedOpts.NamedField> sink) {
        Stream<Object> keys;
        if (left != null && right == null) {
            keys = left.keySet().stream();
        } else if (left == null && right != null) {
            keys = right.keySet().stream();
        } else if (left != null && right != null) {
            MapDifference<String, String> difference = Maps.difference(left, right);
            keys = Stream.of(difference.entriesDiffering().keySet().stream(), right.isEmpty() ? difference.entriesOnlyOnLeft().keySet().stream() : Stream.empty(), difference.entriesOnlyOnRight().keySet().stream()).flatMap(x -> x);
        } else {
            keys = Stream.empty();
        }
        keys.map(UnifiedOpts.NamedField::literal).map(k -> UnifiedOpts.NamedField.nested(parent, k)).forEach(sink);
    }

    static <T> T[] subArray(T[] ts, int offset, int length) {
        if (offset == 0 && length == ts.length) {
            return ts;
        }
        return Arrays.copyOfRange(ts, offset, length);
    }

    private static int crc32cDecode(String from) {
        byte[] decodeCrc32c = BaseEncoding.base64().decode(from);
        return Ints.fromByteArray(decodeCrc32c);
    }

    private static String crc32cEncode(int from) {
        return BaseEncoding.base64().encode(Ints.toByteArray(from));
    }

    static @NonNull GrpcCallContext merge(@NonNull GrpcCallContext l, @NonNull GrpcCallContext r) {
        return (GrpcCallContext)l.merge(r);
    }

    static <T> ImmutableList<T> nullSafeList(@Nullable T t) {
        if (t == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(t);
    }

    static <K, V> ImmutableMap<K, V> mapBuild(ImmutableMap.Builder<K, V> b) {
        return mapBuild.apply(b);
    }

    static {
        Function<ImmutableMap.Builder, ImmutableMap> tmp;
        try {
            ImmutableMap.builder().buildOrThrow();
            tmp = ImmutableMap.Builder::buildOrThrow;
        }
        catch (NoSuchMethodError e) {
            tmp = ImmutableMap.Builder::build;
        }
        mapBuild = tmp;
        RFC_3339_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        durationSecondsCodec = Conversions.Codec.of(Duration::getSeconds, Duration::ofSeconds);
        dateTimeCodec = Conversions.Codec.of(odt -> {
            ZoneOffset offset = odt.getOffset();
            int i = Math.toIntExact(TimeUnit.SECONDS.toMinutes(offset.getTotalSeconds()));
            return new DateTime(odt.toInstant().toEpochMilli(), i);
        }, dt -> {
            long milli = dt.getValue();
            int timeZoneShiftMinutes = dt.getTimeZoneShift();
            Duration timeZoneShift = Duration.of(timeZoneShiftMinutes, ChronoUnit.MINUTES);
            int hours = Math.toIntExact(timeZoneShift.toHours());
            int minutes = Math.toIntExact(timeZoneShift.minusHours(timeZoneShift.toHours()).getSeconds() / 60L);
            ZoneOffset offset = ZoneOffset.ofHoursMinutes(hours, minutes);
            return Instant.ofEpochMilli(milli).atOffset(offset);
        });
        nullableDateTimeCodec = dateTimeCodec.nullable();
        bucketNameCodec = Conversions.Codec.of(bucket -> {
            Objects.requireNonNull(bucket, "bucket must be non null");
            if (bucket.startsWith("projects/")) {
                if (bucket.startsWith("projects/_")) {
                    return bucket;
                }
                throw new IllegalArgumentException("Project scoped buckets are not supported by this version of the library. (bucket = " + bucket + ")");
            }
            return "projects/_/buckets/" + bucket;
        }, resourceName -> {
            Objects.requireNonNull(resourceName, "resourceName must be non null");
            if (BucketName.isParsableFrom(resourceName)) {
                BucketName parse = BucketName.parse(resourceName);
                return parse.getBucket();
            }
            return resourceName;
        });
        projectNameCodec = Conversions.Codec.of(project -> {
            Objects.requireNonNull(project, "project must be non null");
            if (project.startsWith("projects/")) {
                return project;
            }
            return "projects/" + project;
        }, resourceName -> {
            Objects.requireNonNull(resourceName, "resourceName must be non null");
            if (ProjectName.isParsableFrom(resourceName)) {
                ProjectName parse = ProjectName.parse(resourceName);
                return parse.getProject();
            }
            return resourceName;
        });
        crc32cCodec = Conversions.Codec.of(Utils::crc32cEncode, Utils::crc32cDecode);
    }
}

