/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.opentelemetry;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCallListener;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.opentelemetry.MetadataGetter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.opentelemetry.MetadataSetter;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.OpenTelemetry;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.AttributesBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.trace.Span;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.trace.StatusCode;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.trace.Tracer;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.context.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.context.propagation.ContextPropagators;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class OpenTelemetryTracingModule {
    private static final Logger logger;
    @VisibleForTesting
    static final String OTEL_TRACING_SCOPE_NAME = "grpc-java";
    @Nullable
    private static final AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> callEndedUpdater;
    @Nullable
    private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater;
    private final Tracer otelTracer;
    private final ContextPropagators contextPropagators;
    private final MetadataGetter metadataGetter = MetadataGetter.getInstance();
    private final MetadataSetter metadataSetter = MetadataSetter.getInstance();
    private final TracingClientInterceptor clientInterceptor = new TracingClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();

    OpenTelemetryTracingModule(OpenTelemetry openTelemetry) {
        this.otelTracer = Preconditions.checkNotNull(openTelemetry.getTracer(OTEL_TRACING_SCOPE_NAME), "otelTracer");
        this.contextPropagators = Preconditions.checkNotNull(openTelemetry.getPropagators(), "contextPropagators");
    }

    @VisibleForTesting
    CallAttemptsTracerFactory newClientCallTracer(Span clientSpan, MethodDescriptor<?, ?> method) {
        return new CallAttemptsTracerFactory(clientSpan, method);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    private void recordOutboundMessageSentEvent(Span span, int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        AttributesBuilder attributesBuilder = com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes.builder();
        attributesBuilder.put("sequence-number", (long)seqNo);
        if (optionalUncompressedSize != -1L) {
            attributesBuilder.put("message-size", optionalUncompressedSize);
        }
        if (optionalWireSize != -1L && optionalWireSize != optionalUncompressedSize) {
            attributesBuilder.put("message-size-compressed", optionalWireSize);
        }
        span.addEvent("Outbound message sent", attributesBuilder.build());
    }

    private void recordInboundCompressedMessage(Span span, int seqNo, long optionalWireSize) {
        AttributesBuilder attributesBuilder = com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes.builder();
        attributesBuilder.put("sequence-number", (long)seqNo);
        attributesBuilder.put("message-size-compressed", optionalWireSize);
        span.addEvent("Inbound compressed message", attributesBuilder.build());
    }

    private void recordInboundMessageSize(Span span, int seqNo, long bytes) {
        AttributesBuilder attributesBuilder = com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.common.Attributes.builder();
        attributesBuilder.put("sequence-number", (long)seqNo);
        attributesBuilder.put("message-size", bytes);
        span.addEvent("Inbound message received", attributesBuilder.build());
    }

    private String generateErrorStatusDescription(Status status) {
        if (status.getDescription() != null) {
            return (Object)((Object)status.getCode()) + ": " + status.getDescription();
        }
        return status.getCode().toString();
    }

    private void endSpanWithStatus(Span span, Status status) {
        if (status.isOk()) {
            span.setStatus(StatusCode.OK);
        } else {
            span.setStatus(StatusCode.ERROR, this.generateErrorStatusDescription(status));
        }
        span.end();
    }

    @VisibleForTesting
    static String generateTraceSpanName(boolean isServer, String fullMethodName) {
        String prefix = isServer ? "Recv" : "Sent";
        return prefix + "." + fullMethodName.replace('/', '.');
    }

    static {
        AtomicIntegerFieldUpdater<ServerTracer> tmpStreamClosedUpdater;
        AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> tmpCallEndedUpdater;
        logger = Logger.getLogger(OpenTelemetryTracingModule.class.getName());
        try {
            tmpCallEndedUpdater = AtomicIntegerFieldUpdater.newUpdater(CallAttemptsTracerFactory.class, "callEnded");
            tmpStreamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
            tmpCallEndedUpdater = null;
            tmpStreamClosedUpdater = null;
        }
        callEndedUpdater = tmpCallEndedUpdater;
        streamClosedUpdater = tmpStreamClosedUpdater;
    }

    @VisibleForTesting
    final class TracingClientInterceptor
    implements ClientInterceptor {
        TracingClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            Span clientSpan = OpenTelemetryTracingModule.this.otelTracer.spanBuilder(OpenTelemetryTracingModule.generateTraceSpanName(false, method.getFullMethodName())).startSpan();
            final CallAttemptsTracerFactory tracerFactory = OpenTelemetryTracingModule.this.newClientCallTracer(clientSpan, method);
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            Context context = OpenTelemetryTracingModule.this.contextPropagators.getTextMapPropagator().extract(Context.current(), headers, OpenTelemetryTracingModule.this.metadataGetter);
            Span remoteSpan = Span.fromContext(context);
            if (remoteSpan == Span.getInvalid()) {
                remoteSpan = null;
            }
            return new ServerTracer(fullMethodName, remoteSpan);
        }
    }

    private final class ServerTracer
    extends ServerStreamTracer {
        private final Span span;
        volatile int streamClosed;
        private int seqNo;

        ServerTracer(@Nullable String fullMethodName, Span remoteSpan) {
            Preconditions.checkNotNull(fullMethodName, "fullMethodName");
            this.span = OpenTelemetryTracingModule.this.otelTracer.spanBuilder(OpenTelemetryTracingModule.generateTraceSpanName(true, fullMethodName)).setParent(remoteSpan == null ? null : Context.current().with(remoteSpan)).startSpan();
        }

        @Override
        public void streamClosed(Status status) {
            if (streamClosedUpdater != null) {
                if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.streamClosed != 0) {
                    return;
                }
                this.streamClosed = 1;
            }
            OpenTelemetryTracingModule.this.endSpanWithStatus(this.span, status);
        }

        @Override
        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            OpenTelemetryTracingModule.this.recordOutboundMessageSentEvent(this.span, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        @Override
        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (optionalWireSize != optionalUncompressedSize) {
                OpenTelemetryTracingModule.this.recordInboundCompressedMessage(this.span, seqNo, optionalWireSize);
            }
        }

        @Override
        public void inboundMessage(int seqNo) {
            this.seqNo = seqNo;
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            OpenTelemetryTracingModule.this.recordInboundMessageSize(this.span, this.seqNo, bytes);
        }
    }

    private final class ClientTracer
    extends ClientStreamTracer {
        private final Span span;
        private final Span parentSpan;
        volatile int seqNo;
        boolean isPendingStream;

        ClientTracer(Span span, Span parentSpan) {
            this.span = Preconditions.checkNotNull(span, "span");
            this.parentSpan = Preconditions.checkNotNull(parentSpan, "parent span");
        }

        @Override
        public void streamCreated(Attributes transportAtts, Metadata headers) {
            OpenTelemetryTracingModule.this.contextPropagators.getTextMapPropagator().inject(Context.current().with(this.span), headers, OpenTelemetryTracingModule.this.metadataSetter);
            if (this.isPendingStream) {
                this.span.addEvent("Delayed LB pick complete");
            }
        }

        @Override
        public void createPendingStream() {
            this.isPendingStream = true;
        }

        @Override
        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            OpenTelemetryTracingModule.this.recordOutboundMessageSentEvent(this.span, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        @Override
        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            if (optionalWireSize != optionalUncompressedSize) {
                OpenTelemetryTracingModule.this.recordInboundCompressedMessage(this.span, seqNo, optionalWireSize);
            }
        }

        @Override
        public void inboundMessage(int seqNo) {
            this.seqNo = seqNo;
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            OpenTelemetryTracingModule.this.recordInboundMessageSize(this.parentSpan, this.seqNo, bytes);
        }

        @Override
        public void streamClosed(Status status) {
            OpenTelemetryTracingModule.this.endSpanWithStatus(this.span, status);
        }
    }

    @VisibleForTesting
    final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        volatile int callEnded;
        private final Span clientSpan;
        private final String fullMethodName;

        CallAttemptsTracerFactory(Span clientSpan, MethodDescriptor<?, ?> method) {
            Preconditions.checkNotNull(method, "method");
            this.fullMethodName = Preconditions.checkNotNull(method.getFullMethodName(), "fullMethodName");
            this.clientSpan = Preconditions.checkNotNull(clientSpan, "clientSpan");
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            Span attemptSpan = OpenTelemetryTracingModule.this.otelTracer.spanBuilder("Attempt." + this.fullMethodName.replace('/', '.')).setParent(Context.current().with(this.clientSpan)).startSpan();
            attemptSpan.setAttribute("previous-rpc-attempts", (long)info.getPreviousAttempts());
            attemptSpan.setAttribute("transparent-retry", info.isTransparentRetry());
            if (info.getCallOptions().getOption(ClientStreamTracer.NAME_RESOLUTION_DELAYED) != null) {
                this.clientSpan.addEvent("Delayed name resolution complete");
            }
            return new ClientTracer(attemptSpan, this.clientSpan);
        }

        void callEnded(Status status) {
            if (callEndedUpdater != null) {
                if (callEndedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.callEnded != 0) {
                    return;
                }
                this.callEnded = 1;
            }
            OpenTelemetryTracingModule.this.endSpanWithStatus(this.clientSpan, status);
        }
    }
}

