/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.GenericUrl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.GenericJson;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonObjectParser;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.AccessToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.OAuth2Utils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class IdentityPoolCredentials
extends ExternalAccountCredentials {
    private final IdentityPoolCredentialSource identityPoolCredentialSource;
    @Nullable
    private String workforcePoolUserProject;

    IdentityPoolCredentials(Builder builder) {
        super(builder.transportFactory, builder.audience, builder.subjectTokenType, builder.tokenUrl, builder.credentialSource, builder.tokenInfoUrl, builder.serviceAccountImpersonationUrl, builder.quotaProjectId, builder.clientId, builder.clientSecret, builder.scopes, builder.environmentProvider);
        this.identityPoolCredentialSource = (IdentityPoolCredentialSource)builder.credentialSource;
        this.workforcePoolUserProject = builder.workforcePoolUserProject;
        if (this.workforcePoolUserProject != null && !this.isWorkforcePoolConfiguration()) {
            throw new IllegalArgumentException("The workforce_pool_user_project parameter should only be provided for a Workforce Pool configuration.");
        }
    }

    @Nullable
    public String getWorkforcePoolUserProject() {
        return this.workforcePoolUserProject;
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        String credential = this.retrieveSubjectToken();
        StsTokenExchangeRequest.Builder stsTokenExchangeRequest = StsTokenExchangeRequest.newBuilder(credential, this.getSubjectTokenType()).setAudience(this.getAudience());
        Collection<String> scopes = this.getScopes();
        if (scopes != null && !scopes.isEmpty()) {
            stsTokenExchangeRequest.setScopes(new ArrayList<String>(scopes));
        }
        if (this.isWorkforcePoolConfiguration()) {
            GenericJson options = new GenericJson();
            options.setFactory(OAuth2Utils.JSON_FACTORY);
            options.put("userProject", (Object)this.workforcePoolUserProject);
            stsTokenExchangeRequest.setInternalOptions(options.toString());
        }
        return this.exchangeExternalCredentialForAccessToken(stsTokenExchangeRequest.build());
    }

    @Override
    public String retrieveSubjectToken() throws IOException {
        if (this.identityPoolCredentialSource.credentialSourceType == IdentityPoolCredentialSource.IdentityPoolCredentialSourceType.FILE) {
            return this.retrieveSubjectTokenFromCredentialFile();
        }
        return this.getSubjectTokenFromMetadataServer();
    }

    private String retrieveSubjectTokenFromCredentialFile() throws IOException {
        String credentialFilePath = this.identityPoolCredentialSource.credentialLocation;
        if (!Files.exists(Paths.get(credentialFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new IOException(String.format("Invalid credential location. The file at %s does not exist.", credentialFilePath));
        }
        try {
            return this.parseToken(new FileInputStream(new File(credentialFilePath)));
        }
        catch (IOException e) {
            throw new IOException("Error when attempting to read the subject token from the credential file.", e);
        }
    }

    private String parseToken(InputStream inputStream) throws IOException {
        if (this.identityPoolCredentialSource.credentialFormatType == IdentityPoolCredentialSource.CredentialFormatType.TEXT) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return CharStreams.toString(reader);
        }
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        GenericJson fileContents = parser.parseAndClose(inputStream, StandardCharsets.UTF_8, GenericJson.class);
        if (!fileContents.containsKey(this.identityPoolCredentialSource.subjectTokenFieldName)) {
            throw new IOException("Invalid subject token field name. No subject token was found.");
        }
        return (String)fileContents.get(this.identityPoolCredentialSource.subjectTokenFieldName);
    }

    private String getSubjectTokenFromMetadataServer() throws IOException {
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(new GenericUrl(this.identityPoolCredentialSource.credentialLocation));
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.identityPoolCredentialSource.hasHeaders()) {
            HttpHeaders headers = new HttpHeaders();
            headers.putAll(this.identityPoolCredentialSource.headers);
            request.setHeaders(headers);
        }
        try {
            HttpResponse response = request.execute();
            return this.parseToken(response.getContent());
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting subject token from metadata server: %s", e.getMessage()), e);
        }
    }

    public boolean isWorkforcePoolConfiguration() {
        Pattern workforceAudiencePattern = Pattern.compile("^//iam.googleapis.com/locations/.+/workforcePools/.+/providers/.+$");
        return this.workforcePoolUserProject != null && workforceAudiencePattern.matcher(this.getAudience()).matches();
    }

    @Override
    public IdentityPoolCredentials createScoped(Collection<String> newScopes) {
        return new IdentityPoolCredentials((Builder)IdentityPoolCredentials.newBuilder(this).setScopes(newScopes));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(IdentityPoolCredentials identityPoolCredentials) {
        return new Builder(identityPoolCredentials);
    }

    public static class Builder
    extends ExternalAccountCredentials.Builder {
        @Nullable
        private String workforcePoolUserProject;

        Builder() {
        }

        Builder(IdentityPoolCredentials credentials) {
            super(credentials);
            this.setWorkforcePoolUserProject(credentials.getWorkforcePoolUserProject());
        }

        public Builder setWorkforcePoolUserProject(String workforcePoolUserProject) {
            this.workforcePoolUserProject = workforcePoolUserProject;
            return this;
        }

        @Override
        public IdentityPoolCredentials build() {
            return new IdentityPoolCredentials(this);
        }
    }

    static class IdentityPoolCredentialSource
    extends ExternalAccountCredentials.CredentialSource {
        private IdentityPoolCredentialSourceType credentialSourceType;
        private CredentialFormatType credentialFormatType;
        private String credentialLocation;
        @Nullable
        private String subjectTokenFieldName;
        @Nullable
        private Map<String, String> headers;

        IdentityPoolCredentialSource(Map<String, Object> credentialSourceMap) {
            super(credentialSourceMap);
            if (credentialSourceMap.containsKey("file") && credentialSourceMap.containsKey("url")) {
                throw new IllegalArgumentException("Only one credential source type can be set, either file or url.");
            }
            if (credentialSourceMap.containsKey("file")) {
                this.credentialLocation = (String)credentialSourceMap.get("file");
                this.credentialSourceType = IdentityPoolCredentialSourceType.FILE;
            } else if (credentialSourceMap.containsKey("url")) {
                this.credentialLocation = (String)credentialSourceMap.get("url");
                this.credentialSourceType = IdentityPoolCredentialSourceType.URL;
            } else {
                throw new IllegalArgumentException("Missing credential source file location or URL. At least one must be specified.");
            }
            Map headersMap = (Map)credentialSourceMap.get("headers");
            if (headersMap != null && !headersMap.isEmpty()) {
                this.headers = new HashMap<String, String>();
                this.headers.putAll(headersMap);
            }
            this.credentialFormatType = CredentialFormatType.TEXT;
            Map formatMap = (Map)credentialSourceMap.get("format");
            if (formatMap != null && formatMap.containsKey("type")) {
                String type = (String)formatMap.get("type");
                if (!"text".equals(type) && !"json".equals(type)) {
                    throw new IllegalArgumentException(String.format("Invalid credential source format type: %s.", type));
                }
                CredentialFormatType credentialFormatType = this.credentialFormatType = type.equals("text") ? CredentialFormatType.TEXT : CredentialFormatType.JSON;
                if (!formatMap.containsKey("subject_token_field_name")) {
                    throw new IllegalArgumentException("When specifying a JSON credential type, the subject_token_field_name must be set.");
                }
                this.subjectTokenFieldName = (String)formatMap.get("subject_token_field_name");
            }
        }

        private boolean hasHeaders() {
            return this.headers != null && !this.headers.isEmpty();
        }

        static enum CredentialFormatType {
            TEXT,
            JSON;

        }

        static enum IdentityPoolCredentialSourceType {
            FILE,
            URL;

        }
    }
}

