/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GrpcChannelUtils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.Watchdog;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.hash.Hasher;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.hash.Hashing;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.ByteStreams;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util.Timestamps;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ChecksummedData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.CommonRequestParams;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ObjectChecksums;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.QueryWriteStatusRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.QueryWriteStatusResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ServiceConstants;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StartResumableWriteRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StartResumableWriteResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StorageGrpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectSpec;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.ClientCallStreamObserver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.ClientCalls;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.ClientResponseObserver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.StreamObserver;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class GoogleCloudStorageGrpcWriteChannel
extends BaseAbstractGoogleAsyncWriteChannel<WriteObjectResponse>
implements GoogleCloudStorageItemInfo.Provider {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Duration START_RESUMABLE_WRITE_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration QUERY_WRITE_STATUS_TIMEOUT = Duration.ofMinutes(1L);
    private static final ImmutableSet<Status.Code> TRANSIENT_ERRORS = ImmutableSet.of(Status.Code.DEADLINE_EXCEEDED, Status.Code.INTERNAL, Status.Code.RESOURCE_EXHAUSTED, Status.Code.UNAVAILABLE);
    private volatile StorageGrpc.StorageStub stub;
    private final StorageStubProvider stubProvider;
    private final StorageResourceId resourceId;
    private final CreateObjectOptions createOptions;
    private final ObjectWriteConditions writeConditions;
    private final String requesterPaysProject;
    private final GoogleCloudStorageImpl.BackOffFactory backOffFactory;
    private final Watchdog watchdog;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    GoogleCloudStorageGrpcWriteChannel(StorageStubProvider stubProvider, ExecutorService threadPool, AsyncWriteChannelOptions channelOptions, StorageResourceId resourceId, CreateObjectOptions createOptions, Watchdog watchdog, ObjectWriteConditions writeConditions, String requesterPaysProject, GoogleCloudStorageImpl.BackOffFactory backOffFactory) {
        super(threadPool, channelOptions);
        this.stubProvider = stubProvider;
        this.stub = stubProvider.newAsyncStub();
        this.resourceId = resourceId;
        this.createOptions = createOptions;
        this.writeConditions = writeConditions;
        this.requesterPaysProject = requesterPaysProject;
        this.backOffFactory = backOffFactory;
        this.watchdog = watchdog;
    }

    @Override
    protected String getResourceString() {
        return this.resourceId.toString();
    }

    @Override
    public void handleResponse(WriteObjectResponse response) {
        Object resource = response.getResource();
        Map<String, byte[]> metadata = resource.getMetadataMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> BaseEncoding.base64().decode((CharSequence)entry.getValue())));
        byte[] md5Hash = null;
        byte[] crc32c = null;
        if (resource.hasChecksums()) {
            md5Hash = !resource.getChecksums().getMd5Hash().isEmpty() ? resource.getChecksums().getMd5Hash().toByteArray() : null;
            crc32c = resource.getChecksums().hasCrc32C() ? ByteBuffer.allocate(4).putInt(resource.getChecksums().getCrc32C()).array() : null;
        }
        this.completedItemInfo = GoogleCloudStorageItemInfo.createObject(this.resourceId, Timestamps.toMillis(resource.getCreateTime()), Timestamps.toMillis(resource.getUpdateTime()), resource.getSize(), resource.getContentType(), resource.getContentEncoding(), metadata, resource.getGeneration(), resource.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    @Override
    public void startUpload(InputStream pipeSource) {
        try {
            this.uploadOperation = this.threadPool.submit(new UploadOperation(pipeSource));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to start upload for '%s'", this.resourceId), e);
        }
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }

    private class UploadOperation
    implements Callable<WriteObjectResponse> {
        private final BufferedInputStream pipeSource;
        private final int MAX_BYTES_PER_MESSAGE = ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber();
        private Hasher objectHasher;
        private String uploadId;
        private long writeOffset = 0L;
        private InsertChunkResponseObserver responseObserver;
        private final TreeMap<Long, WriteObjectRequest> requestChunkMap = new TreeMap();

        UploadOperation(InputStream pipeSource) {
            this.pipeSource = new BufferedInputStream(pipeSource, this.MAX_BYTES_PER_MESSAGE);
            if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                this.objectHasher = Hashing.crc32c().newHasher();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public WriteObjectResponse call() throws IOException {
            try (BufferedInputStream ignore = this.pipeSource;){
                this.uploadId = this.startResumableUploadWithRetries();
                WriteObjectResponse writeObjectResponse = ResilientOperation.retry(this::doResumableUpload, GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), this::isRetriableError, IOException.class);
                return writeObjectResponse;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
        }

        boolean isRetriableError(Throwable throwable) {
            if (throwable instanceof OutOfBufferedDataException) {
                return false;
            }
            Throwable cause = throwable.getCause();
            if (cause == null) {
                return true;
            }
            return this.isRetriableError(cause);
        }

        private WriteObjectResponse doResumableUpload() throws IOException {
            if (this.writeOffset > 0L) {
                this.writeOffset = this.getCommittedWriteSizeWithRetries(this.uploadId);
            }
            StorageGrpc.StorageStub storageStub = (StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(GoogleCloudStorageGrpcWriteChannel.this.channelOptions.getGrpcWriteTimeout(), TimeUnit.MILLISECONDS);
            InsertChunkResponseObserver responseObserver = new InsertChunkResponseObserver(this.uploadId, this.writeOffset);
            ClientCall<WriteObjectRequest, WriteObjectResponse> call = storageStub.getChannel().newCall(StorageGrpc.getWriteObjectMethod(), GoogleCloudStorageGrpcWriteChannel.this.stub.getCallOptions());
            StreamObserver<WriteObjectRequest> writeObjectRequestStreamObserver = ClientCalls.asyncClientStreamingCall(call, responseObserver);
            StreamObserver<WriteObjectRequest> requestStreamObserver = GoogleCloudStorageGrpcWriteChannel.this.watchdog.watch(call, writeObjectRequestStreamObserver, Duration.ofSeconds(GoogleCloudStorageGrpcWriteChannel.this.channelOptions.getGrpcWriteMessageTimeoutMillis()));
            try {
                responseObserver.ready.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted while awaiting ready on responseObserver for '%s' with UploadID '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId, responseObserver.uploadId));
            }
            boolean objectFinalized = false;
            while (!objectFinalized) {
                WriteObjectRequest insertRequest = null;
                if (this.requestChunkMap.size() > 0 && this.requestChunkMap.lastKey() >= this.writeOffset) {
                    insertRequest = this.getCachedRequest(this.requestChunkMap, this.writeOffset);
                    this.writeOffset += (long)insertRequest.getChecksummedData().getContent().size();
                } else if ((long)this.requestChunkMap.size() >= GoogleCloudStorageGrpcWriteChannel.this.channelOptions.getNumberOfBufferedRequests()) {
                    this.freeUpCommittedRequests(this.requestChunkMap, this.writeOffset);
                } else {
                    ByteString data = ByteString.readFrom(ByteStreams.limit(this.pipeSource, this.MAX_BYTES_PER_MESSAGE), this.MAX_BYTES_PER_MESSAGE);
                    insertRequest = this.buildInsertRequest(this.writeOffset, data, false);
                    this.requestChunkMap.put(this.writeOffset, insertRequest);
                    this.writeOffset += (long)data.size();
                }
                if (insertRequest != null) {
                    requestStreamObserver.onNext(insertRequest);
                    objectFinalized = insertRequest.getFinishWrite();
                }
                if (responseObserver.hasTransientError() || responseObserver.hasNonTransientError()) {
                    requestStreamObserver.onError(responseObserver.hasTransientError() ? responseObserver.transientError : responseObserver.nonTransientError);
                    break;
                }
                if (!objectFinalized) continue;
                requestStreamObserver.onCompleted();
            }
            try {
                responseObserver.done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted while awaiting response during upload of '%s' with UploadID '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId, responseObserver.uploadId));
            }
            if (responseObserver.hasTransientError()) {
                throw new IOException(String.format("Got transient error for UploadID '%s'", responseObserver.uploadId), responseObserver.transientError);
            }
            return responseObserver.getResponseOrThrow();
        }

        private WriteObjectRequest buildInsertRequest(long writeOffset, ByteString dataChunk, boolean resumeFromFailedInsert) {
            WriteObjectRequest.Builder requestBuilder = WriteObjectRequest.newBuilder().setUploadId(this.uploadId).setWriteOffset(writeOffset);
            if (dataChunk.size() > 0) {
                ChecksummedData.Builder requestDataBuilder = ChecksummedData.newBuilder().setContent(dataChunk);
                if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                    if (!resumeFromFailedInsert) {
                        this.updateObjectHash(dataChunk);
                    }
                    requestDataBuilder.setCrc32C(this.getChunkHash(dataChunk));
                }
                requestBuilder.setChecksummedData(requestDataBuilder);
            }
            if (dataChunk.size() < this.MAX_BYTES_PER_MESSAGE) {
                requestBuilder.setFinishWrite(true);
                if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                    requestBuilder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(this.objectHasher.hash().asInt()));
                }
            }
            return requestBuilder.build();
        }

        private int getChunkHash(ByteString dataChunk) {
            Hasher chunkHasher = Hashing.crc32c().newHasher();
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                chunkHasher.putBytes(buffer);
            }
            return chunkHasher.hash().asInt();
        }

        private void updateObjectHash(ByteString dataChunk) {
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                this.objectHasher.putBytes(buffer);
            }
        }

        private WriteObjectRequest getCachedRequest(TreeMap<Long, WriteObjectRequest> requestChunkMap, long writeOffset) {
            WriteObjectRequest request = null;
            if (requestChunkMap.size() > 0 && requestChunkMap.firstKey() <= writeOffset) {
                for (Map.Entry<Long, WriteObjectRequest> entry : requestChunkMap.entrySet()) {
                    if (entry.getKey() + (long)entry.getValue().getChecksummedData().getContent().size() <= writeOffset && entry.getKey() != writeOffset) continue;
                    Long writeOffsetToResume = entry.getKey();
                    request = entry.getValue();
                    break;
                }
            }
            return Preconditions.checkNotNull(request, "Request chunk not found for '%s'", (java.lang.Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
        }

        private void freeUpCommittedRequests(TreeMap<Long, WriteObjectRequest> requestChunkMap, long writeOffset) throws IOException {
            long committedWriteOffset = this.getCommittedWriteSizeWithRetries(this.uploadId);
            ((GoogleLogger.Api)logger.atFinest()).log("Fetched committedWriteOffset: size:%d, numBuffers:%d, writeOffset:%d, committedWriteOffset:%d", requestChunkMap.size(), GoogleCloudStorageGrpcWriteChannel.this.channelOptions.getNumberOfBufferedRequests(), writeOffset, committedWriteOffset);
            while (requestChunkMap.size() > 0 && requestChunkMap.firstKey() < committedWriteOffset) {
                ((GoogleLogger.Api)logger.atFinest()).log("clearing dataChunkMap one buffer at a time, size: %d, firstKey:%d, committedwriteOffset:%d", requestChunkMap.size(), requestChunkMap.firstKey(), committedWriteOffset);
                requestChunkMap.remove(requestChunkMap.firstKey());
            }
        }

        private String startResumableUploadWithRetries() throws IOException {
            try {
                WriteObjectSpec.Builder insertObjectSpecBuilder = WriteObjectSpec.newBuilder().setResource(Object.newBuilder().setBucket(GrpcChannelUtils.toV2BucketName(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getBucketName())).setName(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getObjectName()).setContentType(GoogleCloudStorageGrpcWriteChannel.this.createOptions.getContentType()).putAllMetadata(GoogleCloudStorageImpl.encodeMetadata(GoogleCloudStorageGrpcWriteChannel.this.createOptions.getMetadata())).build());
                if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasContentGenerationMatch()) {
                    insertObjectSpecBuilder.setIfGenerationMatch(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getContentGenerationMatch());
                }
                if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasMetaGenerationMatch()) {
                    insertObjectSpecBuilder.setIfMetagenerationMatch(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getMetaGenerationMatch());
                }
                CommonRequestParams.Builder commonRequestParamsBuilder = null;
                if (GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject != null) {
                    commonRequestParamsBuilder = CommonRequestParams.newBuilder().setUserProject(GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject);
                }
                StartResumableWriteRequest.Builder startResumableWriteRequestBuilder = StartResumableWriteRequest.newBuilder().setWriteObjectSpec(insertObjectSpecBuilder);
                if (commonRequestParamsBuilder != null) {
                    startResumableWriteRequestBuilder.setCommonRequestParams(commonRequestParamsBuilder);
                }
                StartResumableWriteRequest request = startResumableWriteRequestBuilder.build();
                return ResilientOperation.retry(() -> this.startResumableUpload(request), GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Failed to start resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
        }

        private String startResumableUpload(StartResumableWriteRequest request) throws IOException {
            SimpleResponseObserver<StartResumableWriteResponse> responseObserver = new SimpleResponseObserver<StartResumableWriteResponse>();
            ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(START_RESUMABLE_WRITE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).startResumableWrite(request, responseObserver);
            try {
                responseObserver.done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            if (responseObserver.hasError()) {
                throw new IOException(responseObserver.getError());
            }
            return responseObserver.getResponse().getUploadId();
        }

        private long getCommittedWriteSizeWithRetries(String uploadId) throws IOException {
            QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
            try {
                return ResilientOperation.retry(() -> this.getCommittedWriteSize(request), GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Failed to get committed write size for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
        }

        private long getCommittedWriteSize(QueryWriteStatusRequest request) throws IOException {
            SimpleResponseObserver<QueryWriteStatusResponse> responseObserver = new SimpleResponseObserver<QueryWriteStatusResponse>();
            ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(QUERY_WRITE_STATUS_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).queryWriteStatus(request, responseObserver);
            try {
                responseObserver.done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            if (responseObserver.hasError()) {
                throw new IOException(responseObserver.getError());
            }
            return responseObserver.getResponse().getPersistedSize();
        }

        private class SimpleResponseObserver<T>
        implements StreamObserver<T> {
            private T response;
            private Throwable error;
            final CountDownLatch done = new CountDownLatch(1);

            private SimpleResponseObserver() {
            }

            public T getResponse() {
                return Preconditions.checkNotNull(this.response, "Response not present for '%s'", (java.lang.Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasError() {
                return this.error != null || this.response == null;
            }

            public Throwable getError() {
                return Preconditions.checkNotNull(this.error, "Error not present for '%s'", (java.lang.Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            @Override
            public void onNext(T response) {
                this.response = response;
            }

            @Override
            public void onError(Throwable t) {
                this.error = new IOException(String.format("Caught exception for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), t);
                this.done.countDown();
            }

            @Override
            public void onCompleted() {
                this.done.countDown();
            }
        }

        private class InsertChunkResponseObserver
        implements ClientResponseObserver<WriteObjectRequest, WriteObjectResponse> {
            private final long writeOffset;
            private final String uploadId;
            private WriteObjectResponse response;
            public Throwable transientError = null;
            public Throwable nonTransientError = null;
            final CountDownLatch done = new CountDownLatch(1);
            final CountDownLatch ready = new CountDownLatch(1);

            InsertChunkResponseObserver(String uploadId, long writeOffset) {
                this.uploadId = uploadId;
                this.writeOffset = writeOffset;
            }

            public WriteObjectResponse getResponseOrThrow() throws IOException {
                if (this.hasNonTransientError()) {
                    throw new IOException(String.format("Resumable upload failed for '%s' , uploadId : %s ", GoogleCloudStorageGrpcWriteChannel.this.resourceId, this.uploadId), this.nonTransientError);
                }
                return Preconditions.checkNotNull(this.response, "Response not present for '%s'", (java.lang.Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasTransientError() {
                return this.transientError != null;
            }

            boolean hasNonTransientError() {
                return this.response == null && this.nonTransientError != null;
            }

            @Override
            public void onNext(WriteObjectResponse response) {
                this.response = response;
            }

            @Override
            public void onError(Throwable t) {
                Status status = Status.fromThrowable(t);
                Status.Code statusCode = status.getCode();
                if (TRANSIENT_ERRORS.contains((java.lang.Object)statusCode)) {
                    this.transientError = t;
                }
                if (this.transientError == null) {
                    this.nonTransientError = new IOException(String.format("Caught exception for '%s', while uploading to uploadId %s at writeOffset %d. Status: %s", GoogleCloudStorageGrpcWriteChannel.this.resourceId, this.uploadId, this.writeOffset, status.getDescription()), t);
                }
                this.done.countDown();
            }

            @Override
            public void onCompleted() {
                this.done.countDown();
            }

            @Override
            public void beforeStart(ClientCallStreamObserver<WriteObjectRequest> clientCallStreamObserver) {
                clientCallStreamObserver.setOnReadyHandler(this.ready::countDown);
            }
        }

        class OutOfBufferedDataException
        extends IOException {
            public OutOfBufferedDataException(String message) {
                super(message);
            }
        }
    }
}

