/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Sets;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityState;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityStateInfo;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.EquivalentAddressGroup;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.InternalLogId;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.SynchronizationContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.InternalXdsAttributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsLogger;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsNameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XdsSubchannelPickers;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.XxHash64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class RingHashLoadBalancer
extends LoadBalancer {
    private static final Attributes.Key<Ref<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create("state-info");
    private static final Status RPC_HASH_NOT_FOUND = Status.INTERNAL.withDescription("RPC hash not found. Probably a bug because xds resolver config selector always generates a hash.");
    private static final XxHash64 hashFunc = XxHash64.INSTANCE;
    private final XdsLogger logger;
    private final SynchronizationContext syncContext;
    private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
    private final LoadBalancer.Helper helper;
    private List<RingEntry> ring;
    private ConnectivityState currentState;

    RingHashLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("ring_hash_lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        List<EquivalentAddressGroup> addrList = resolvedAddresses.getAddresses();
        if (addrList.isEmpty()) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("Ring hash lb error: EDS resolution was successful, but returned server addresses are empty."));
            return;
        }
        Map<EquivalentAddressGroup, EquivalentAddressGroup> latestAddrs = RingHashLoadBalancer.stripAttrs(addrList);
        HashSet<EquivalentAddressGroup> removedAddrs = Sets.newHashSet(Sets.difference(this.subchannels.keySet(), latestAddrs.keySet()));
        RingHashConfig config = (RingHashConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<EquivalentAddressGroup, Long> serverWeights = new HashMap<EquivalentAddressGroup, Long>();
        long totalWeight = 0L;
        for (EquivalentAddressGroup eag : addrList) {
            Long weight = eag.getAttributes().get(InternalXdsAttributes.ATTR_SERVER_WEIGHT);
            if (weight == null) {
                weight = 1L;
            }
            totalWeight += weight.longValue();
            EquivalentAddressGroup addrKey = RingHashLoadBalancer.stripAttrs(eag);
            if (serverWeights.containsKey(addrKey)) {
                serverWeights.put(addrKey, (Long)serverWeights.get(addrKey) + weight);
            } else {
                serverWeights.put(addrKey, weight);
            }
            LoadBalancer.Subchannel existingSubchannel = this.subchannels.get(addrKey);
            if (existingSubchannel != null) {
                existingSubchannel.updateAddresses(Collections.singletonList(eag));
                continue;
            }
            Attributes attr = Attributes.newBuilder().set(STATE_INFO, new Ref<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE))).build();
            final LoadBalancer.Subchannel subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(eag).setAttributes(attr).build());
            subchannel.start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    RingHashLoadBalancer.this.processSubchannelState(subchannel, newState);
                }
            });
            this.subchannels.put(addrKey, subchannel);
        }
        long minWeight = (Long)Collections.min(serverWeights.values());
        double normalizedMinWeight = (double)minWeight / (double)totalWeight;
        double scale = Math.min(Math.ceil(normalizedMinWeight * (double)config.minRingSize) / normalizedMinWeight, (double)config.maxRingSize);
        this.ring = RingHashLoadBalancer.buildRing(serverWeights, totalWeight, scale);
        ArrayList<LoadBalancer.Subchannel> removedSubchannels = new ArrayList<LoadBalancer.Subchannel>();
        for (EquivalentAddressGroup addr : removedAddrs) {
            removedSubchannels.add(this.subchannels.remove(addr));
        }
        this.updateBalancingState();
        for (LoadBalancer.Subchannel subchann : removedSubchannels) {
            RingHashLoadBalancer.shutdownSubchannel(subchann);
        }
    }

    private static List<RingEntry> buildRing(Map<EquivalentAddressGroup, Long> serverWeights, long totalWeight, double scale) {
        ArrayList<RingEntry> ring = new ArrayList<RingEntry>();
        double currentHashes = 0.0;
        double targetHashes = 0.0;
        for (Map.Entry<EquivalentAddressGroup, Long> entry : serverWeights.entrySet()) {
            EquivalentAddressGroup addrKey = entry.getKey();
            double normalizedWeight = (double)entry.getValue().longValue() / (double)totalWeight;
            StringBuilder sb = new StringBuilder(addrKey.getAddresses().toString());
            sb.append('_');
            targetHashes += scale * normalizedWeight;
            long i = 0L;
            while (currentHashes < targetHashes) {
                sb.append(i);
                long hash = hashFunc.hashAsciiString(sb.toString());
                ring.add(new RingEntry(hash, addrKey));
                ++i;
                currentHashes += 1.0;
                sb.setLength(sb.length() - 1);
            }
        }
        Collections.sort(ring);
        return Collections.unmodifiableList(ring);
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.currentState != ConnectivityState.READY) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            RingHashLoadBalancer.shutdownSubchannel(subchannel);
        }
        this.subchannels.clear();
    }

    private void updateBalancingState() {
        Preconditions.checkState(!this.subchannels.isEmpty(), "no subchannel has been created");
        int failureCount = 0;
        boolean hasConnecting = false;
        LoadBalancer.Subchannel idleSubchannel = null;
        ConnectivityState overallState = null;
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            ConnectivityState state = ((ConnectivityStateInfo)RingHashLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value).getState();
            if (state == ConnectivityState.READY) {
                overallState = ConnectivityState.READY;
                break;
            }
            if (state == ConnectivityState.TRANSIENT_FAILURE) {
                ++failureCount;
                continue;
            }
            if (state == ConnectivityState.CONNECTING) {
                hasConnecting = true;
                continue;
            }
            if (state != ConnectivityState.IDLE || idleSubchannel != null) continue;
            idleSubchannel = subchannel;
        }
        if (overallState == null) {
            if (failureCount >= 2) {
                if (!hasConnecting && idleSubchannel != null) {
                    idleSubchannel.requestConnection();
                }
                overallState = ConnectivityState.TRANSIENT_FAILURE;
            } else {
                overallState = hasConnecting ? ConnectivityState.CONNECTING : (idleSubchannel != null ? ConnectivityState.IDLE : ConnectivityState.TRANSIENT_FAILURE);
            }
        }
        RingHashPicker picker = new RingHashPicker(this.syncContext, this.ring, this.subchannels);
        this.helper.updateBalancingState(overallState, picker);
        this.currentState = overallState;
    }

    private void processSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        if (this.subchannels.get(RingHashLoadBalancer.stripAttrs(subchannel.getAddresses())) != subchannel) {
            return;
        }
        if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE || stateInfo.getState() == ConnectivityState.IDLE) {
            this.helper.refreshNameResolution();
        }
        Ref<ConnectivityStateInfo> subchannelStateRef = RingHashLoadBalancer.getSubchannelStateInfoRef(subchannel);
        if (((ConnectivityStateInfo)subchannelStateRef.value).getState() == ConnectivityState.TRANSIENT_FAILURE && (stateInfo.getState() == ConnectivityState.CONNECTING || stateInfo.getState() == ConnectivityState.IDLE)) {
            return;
        }
        subchannelStateRef.value = stateInfo;
        this.updateBalancingState();
    }

    private static void shutdownSubchannel(LoadBalancer.Subchannel subchannel) {
        subchannel.shutdown();
        RingHashLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value = ConnectivityStateInfo.forNonError(ConnectivityState.SHUTDOWN);
    }

    private static Map<EquivalentAddressGroup, EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> groupList) {
        HashMap<EquivalentAddressGroup, EquivalentAddressGroup> addrs = new HashMap<EquivalentAddressGroup, EquivalentAddressGroup>(groupList.size() * 2);
        for (EquivalentAddressGroup group : groupList) {
            addrs.put(RingHashLoadBalancer.stripAttrs(group), group);
        }
        return addrs;
    }

    private static EquivalentAddressGroup stripAttrs(EquivalentAddressGroup eag) {
        return new EquivalentAddressGroup(eag.getAddresses());
    }

    private static Ref<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer.Subchannel subchannel) {
        return Preconditions.checkNotNull(subchannel.getAttributes().get(STATE_INFO), "STATE_INFO");
    }

    static final class RingHashConfig {
        final long minRingSize;
        final long maxRingSize;

        RingHashConfig(long minRingSize, long maxRingSize) {
            Preconditions.checkArgument(minRingSize > 0L, "minRingSize <= 0");
            Preconditions.checkArgument(maxRingSize > 0L, "maxRingSize <= 0");
            Preconditions.checkArgument(minRingSize <= maxRingSize, "minRingSize > maxRingSize");
            this.minRingSize = minRingSize;
            this.maxRingSize = maxRingSize;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("minRingSize", this.minRingSize).add("maxRingSize", this.maxRingSize).toString();
        }
    }

    private static final class Ref<T> {
        T value;

        Ref(T value) {
            this.value = value;
        }
    }

    private static final class RingEntry
    implements Comparable<RingEntry> {
        private final long hash;
        private final EquivalentAddressGroup addrKey;

        private RingEntry(long hash, EquivalentAddressGroup addrKey) {
            this.hash = hash;
            this.addrKey = addrKey;
        }

        @Override
        public int compareTo(RingEntry entry) {
            return Long.compare(this.hash, entry.hash);
        }
    }

    private static final class SubchannelView {
        private final LoadBalancer.Subchannel subchannel;
        private final ConnectivityStateInfo stateInfo;

        private SubchannelView(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.subchannel = subchannel;
            this.stateInfo = stateInfo;
        }
    }

    private static final class RingHashPicker
    extends LoadBalancer.SubchannelPicker {
        private final SynchronizationContext syncContext;
        private final List<RingEntry> ring;
        private final Map<EquivalentAddressGroup, SubchannelView> pickableSubchannels;

        private RingHashPicker(SynchronizationContext syncContext, List<RingEntry> ring, Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels) {
            this.syncContext = syncContext;
            this.ring = ring;
            this.pickableSubchannels = new HashMap<EquivalentAddressGroup, SubchannelView>(subchannels.size());
            for (Map.Entry<EquivalentAddressGroup, LoadBalancer.Subchannel> entry : subchannels.entrySet()) {
                LoadBalancer.Subchannel subchannel = entry.getValue();
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((Ref)subchannel.getAttributes().get(STATE_INFO)).value;
                this.pickableSubchannels.put(entry.getKey(), new SubchannelView(subchannel, stateInfo));
            }
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            int mid;
            block14: {
                Long requestHash = args.getCallOptions().getOption(XdsNameResolver.RPC_HASH_KEY);
                if (requestHash == null) {
                    return LoadBalancer.PickResult.withError(RPC_HASH_NOT_FOUND);
                }
                int low = 0;
                int high = this.ring.size();
                do {
                    long midValL;
                    if ((mid = (low + high) / 2) == this.ring.size()) {
                        mid = 0;
                        break block14;
                    }
                    long midVal = this.ring.get(mid).hash;
                    long l = midValL = mid == 0 ? 0L : this.ring.get(mid - 1).hash;
                    if (requestHash <= midVal && requestHash > midValL) break block14;
                    if (midVal < requestHash) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid - 1;
                } while (low <= high);
                mid = 0;
            }
            boolean hasPending = false;
            boolean canBuffer = true;
            LoadBalancer.Subchannel firstSubchannel = null;
            LoadBalancer.Subchannel secondSubchannel = null;
            for (int i = 0; i < this.ring.size(); ++i) {
                int index = (mid + i) % this.ring.size();
                EquivalentAddressGroup addrKey = this.ring.get(index).addrKey;
                SubchannelView subchannel = this.pickableSubchannels.get(addrKey);
                if (subchannel.stateInfo.getState() == ConnectivityState.READY) {
                    return LoadBalancer.PickResult.withSubchannel(subchannel.subchannel);
                }
                if (firstSubchannel == null) {
                    firstSubchannel = subchannel.subchannel;
                } else if (subchannel.subchannel != firstSubchannel) {
                    if (secondSubchannel == null) {
                        secondSubchannel = subchannel.subchannel;
                    } else if (subchannel.subchannel != secondSubchannel) {
                        canBuffer = false;
                    }
                }
                if (subchannel.stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE || hasPending) continue;
                if (subchannel.stateInfo.getState() == ConnectivityState.IDLE) {
                    final LoadBalancer.Subchannel finalSubchannel = subchannel.subchannel;
                    this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            finalSubchannel.requestConnection();
                        }
                    });
                }
                if (canBuffer) {
                    return LoadBalancer.PickResult.withNoResult();
                }
                hasPending = true;
            }
            SubchannelView originalSubchannel = this.pickableSubchannels.get(this.ring.get(mid).addrKey);
            return LoadBalancer.PickResult.withError(originalSubchannel.stateInfo.getStatus());
        }
    }
}

