/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Longs;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfo {
    private static final Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    public static final FileInfo ROOT_INFO = new FileInfo(GoogleCloudStorageItemInfo.ROOT_INFO);
    public static final String FILE_MODIFICATION_TIMESTAMP_KEY = "system.gcsfs_mts";
    private final URI path;
    private final GoogleCloudStorageItemInfo itemInfo;
    private final Map<String, byte[]> attributes;

    private FileInfo(GoogleCloudStorageItemInfo itemInfo) {
        this.itemInfo = itemInfo;
        this.path = GoogleCloudStorageFileSystem.getPath(itemInfo.getBucketName(), itemInfo.getObjectName(), true);
        Preconditions.checkArgument((itemInfo.getMetadata() != null ? 1 : 0) != 0);
        this.attributes = itemInfo.getMetadata();
    }

    public URI getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return FileInfo.isDirectory(this.itemInfo);
    }

    static boolean isDirectory(GoogleCloudStorageItemInfo itemInfo) {
        return FileInfo.isGlobalRoot(itemInfo) || itemInfo.isBucket() || FileInfo.objectHasDirectoryPath(itemInfo.getObjectName());
    }

    public boolean isGlobalRoot() {
        return FileInfo.isGlobalRoot(this.itemInfo);
    }

    static boolean isGlobalRoot(GoogleCloudStorageItemInfo itemInfo) {
        return itemInfo.isRoot() && itemInfo.exists();
    }

    public long getCreationTime() {
        return this.itemInfo.getCreationTime();
    }

    public long getSize() {
        return this.itemInfo.getSize();
    }

    public long getModificationTime() {
        if (this.attributes.containsKey(FILE_MODIFICATION_TIMESTAMP_KEY) && this.attributes.get(FILE_MODIFICATION_TIMESTAMP_KEY) != null) {
            try {
                return Longs.fromByteArray((byte[])this.attributes.get(FILE_MODIFICATION_TIMESTAMP_KEY));
            }
            catch (IllegalArgumentException iae) {
                LOG.debug("Failed to parse modification time '{}' millis for object {}", (Object)this.attributes.get(FILE_MODIFICATION_TIMESTAMP_KEY), (Object)this.itemInfo.getObjectName());
            }
        }
        return this.getCreationTime();
    }

    public Map<String, byte[]> getAttributes() {
        return this.attributes;
    }

    public boolean exists() {
        return this.itemInfo.exists();
    }

    public String toString() {
        if (this.exists()) {
            return String.format("%s: created on: %s", this.getPath(), new Date(this.getCreationTime()).toString());
        }
        return String.format("%s: exists: no", this.getPath());
    }

    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.itemInfo;
    }

    static boolean objectHasDirectoryPath(String objectName) {
        return StorageResourceId.objectHasDirectoryPath(objectName);
    }

    static String convertToDirectoryPath(String objectName) {
        return StorageResourceId.convertToDirectoryPath(objectName);
    }

    public static void addModificationTimeToAttributes(Map<String, byte[]> attributes, Clock clock) {
        attributes.put(FILE_MODIFICATION_TIMESTAMP_KEY, Longs.toByteArray((long)clock.currentTimeMillis()));
    }

    public static String convertToFilePath(String objectName) {
        if (!Strings.isNullOrEmpty((String)objectName) && FileInfo.objectHasDirectoryPath(objectName)) {
            objectName = objectName.substring(0, objectName.length() - 1);
        }
        return objectName;
    }

    public static FileInfo fromItemInfo(GoogleCloudStorageItemInfo itemInfo) {
        if (itemInfo.isRoot()) {
            return ROOT_INFO;
        }
        return new FileInfo(itemInfo);
    }

    public static List<FileInfo> fromItemInfos(List<GoogleCloudStorageItemInfo> itemInfos) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (GoogleCloudStorageItemInfo itemInfo : itemInfos) {
            fileInfos.add(FileInfo.fromItemInfo(itemInfo));
        }
        return fileInfos;
    }

    public static boolean isDirectoryPath(URI path) {
        return path != null && path.toString().endsWith("/");
    }

    public static StorageResourceId convertToDirectoryPath(StorageResourceId resourceId) {
        if (resourceId.isStorageObject() && !FileInfo.objectHasDirectoryPath(resourceId.getObjectName())) {
            resourceId = new StorageResourceId(resourceId.getBucketName(), FileInfo.convertToDirectoryPath(resourceId.getObjectName()));
        }
        return resourceId;
    }

    public static URI convertToDirectoryPath(URI path) {
        StorageResourceId resourceId = GoogleCloudStorageFileSystem.validatePathAndGetId(path, true);
        if (resourceId.isStorageObject() && !FileInfo.objectHasDirectoryPath(resourceId.getObjectName())) {
            resourceId = FileInfo.convertToDirectoryPath(resourceId);
            path = GoogleCloudStorageFileSystem.getPath(resourceId.getBucketName(), resourceId.getObjectName());
        }
        return path;
    }
}

