/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Data;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.BatchHelper;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageWriteChannel;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCloudStorageImpl
implements GoogleCloudStorage {
    public static final String PATH_DELIMITER = "/";
    public static final int BUCKET_EMPTY_MAX_RETRIES = 20;
    public static final int BUCKET_EMPTY_WAIT_TIME_MS = 500;
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCloudStorage.class);
    private static final int MAXIMUM_PRECONDITION_FAILURES_IN_DELETE = 4;
    private static final Function<byte[], String> ENCODE_METADATA_VALUES = new Function<byte[], String>(){

        public String apply(byte[] bytes) {
            if (bytes == null) {
                return Data.NULL_STRING;
            }
            return BaseEncoding.base64().encode(bytes);
        }
    };
    private static final Function<String, byte[]> DECODE_METADATA_VALUES = new Function<String, byte[]>(){

        public byte[] apply(String value) {
            try {
                return BaseEncoding.base64().decode((CharSequence)value);
            }
            catch (IllegalArgumentException iae) {
                LOG.error("Failed to parse base64 encoded attribute value {} - {}", (Object)value, (Object)iae);
                return null;
            }
        }
    };
    private Storage gcs;
    private ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcs-async-channel-pool-%d").setDaemon(true).build());
    private ExecutorService manualBatchingThreadPool = new ThreadPoolExecutor(10, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("gcs-manual-batching-pool-%d").setDaemon(true).build());
    private ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
    private ClientRequestHelper<StorageObject> clientRequestHelper = new ClientRequestHelper();
    private BatchHelper.Factory batchFactory = new BatchHelper.Factory();
    private HttpRequestInitializer httpRequestInitializer;
    private final GoogleCloudStorageOptions storageOptions;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private BackOffFactory backOffFactory = BackOffFactory.DEFAULT;
    private RetryDeterminer<IOException> rateLimitedRetryDeterminer = RetryDeterminer.createRateLimitedRetryDeterminer((ApiErrorExtractor)this.errorExtractor);

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Credential credential) throws IOException {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options must not be null");
        LOG.debug("GCS({})", (Object)options.getAppName());
        options.throwIfNotValid();
        this.storageOptions = options;
        Preconditions.checkArgument((credential != null ? 1 : 0) != 0, (Object)"credential must not be null");
        this.httpRequestInitializer = new RetryHttpInitializer(credential, options.getAppName());
        HttpTransport httpTransport = HttpTransportFactory.createHttpTransport((HttpTransportFactory.HttpTransportType)options.getTransportType(), (String)options.getProxyAddress());
        this.gcs = new Storage.Builder(httpTransport, JSON_FACTORY, this.httpRequestInitializer).setApplicationName(options.getAppName()).build();
    }

    public GoogleCloudStorageImpl(GoogleCloudStorageOptions options, Storage gcs) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options must not be null");
        LOG.debug("GCS({})", (Object)options.getAppName());
        options.throwIfNotValid();
        this.storageOptions = options;
        Preconditions.checkArgument((gcs != null ? 1 : 0) != 0, (Object)"gcs must not be null");
        this.gcs = gcs;
        this.httpRequestInitializer = null;
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.storageOptions;
    }

    @VisibleForTesting
    protected GoogleCloudStorageImpl() {
        this.storageOptions = GoogleCloudStorageOptions.newBuilder().build();
    }

    @VisibleForTesting
    void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @VisibleForTesting
    void setManualBatchingThreadPool(ExecutorService manualBatchingThreadPool) {
        this.manualBatchingThreadPool = manualBatchingThreadPool;
    }

    @VisibleForTesting
    void setErrorExtractor(ApiErrorExtractor errorExtractor) {
        this.errorExtractor = errorExtractor;
        this.rateLimitedRetryDeterminer = RetryDeterminer.createRateLimitedRetryDeterminer((ApiErrorExtractor)errorExtractor);
    }

    @VisibleForTesting
    void setClientRequestHelper(ClientRequestHelper<StorageObject> clientRequestHelper) {
        this.clientRequestHelper = clientRequestHelper;
    }

    @VisibleForTesting
    void setBatchFactory(BatchHelper.Factory batchFactory) {
        this.batchFactory = batchFactory;
    }

    @VisibleForTesting
    GoogleCloudStorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    @VisibleForTesting
    void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    @VisibleForTesting
    void setBackOffFactory(BackOffFactory factory) {
        this.backOffFactory = factory;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        LOG.debug("create({})", (Object)resourceId);
        String string = String.valueOf(resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + String.valueOf(string).length()).append("Expected full StorageObject id, got ").append(string).toString());
        Optional overwriteGeneration = Optional.absent();
        long backOffSleep = 0L;
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (this.storageOptions.isMarkerFileCreationEnabled()) {
            BackOff backOff = this.backOffFactory.newBackOff();
            do {
                if (backOffSleep != 0L) {
                    try {
                        this.sleeper.sleep(backOffSleep);
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(String.format("Interrupted while sleeping for backoff in create of %s", resourceId));
                    }
                    info = this.getItemInfo(resourceId);
                }
                backOffSleep = backOff.nextBackOffMillis();
                Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
                if (!info.exists()) {
                    insertObject.setIfGenerationMatch(Long.valueOf(0L));
                } else if (info.exists() && options.overwriteExisting()) {
                    long generation = info.getContentGeneration();
                    Preconditions.checkState((generation != 0L ? 1 : 0) != 0, (Object)"Generation should not be 0 for an existing item");
                    insertObject.setIfGenerationMatch(Long.valueOf(generation));
                } else {
                    throw new IOException(String.format("Object %s already exists", resourceId.toString()));
                }
                try {
                    StorageObject result = (StorageObject)insertObject.execute();
                    overwriteGeneration = Optional.of((Object)result.getGeneration());
                }
                catch (IOException ioe) {
                    if (this.errorExtractor.preconditionNotMet(ioe)) {
                        LOG.info("Retrying marker file creation. Retrying according to backoff policy, %s - %s", (Object)resourceId, (Object)ioe);
                        continue;
                    }
                    throw ioe;
                }
            } while (!overwriteGeneration.isPresent() && backOffSleep != -1L);
            if (backOffSleep == -1L) {
                throw new IOException(String.format("Retries exhausted while attempting to create marker file for %s", resourceId));
            }
        } else {
            if (!info.exists()) {
                overwriteGeneration = Optional.of((Object)0L);
            } else if (info.exists() && options.overwriteExisting()) {
                long generation = info.getContentGeneration();
                Preconditions.checkState((generation != 0L ? 1 : 0) != 0, (Object)"Generation should not be 0 for an existing item");
                overwriteGeneration = Optional.of((Object)generation);
            } else {
                throw new IOException(String.format("Object %s already exists.", resourceId.toString()));
            }
            Preconditions.checkState((boolean)overwriteGeneration.isPresent(), (Object)"Marker file creation is disabled, we should have a generation to overwrite.");
        }
        ObjectWriteConditions writeConditions = new ObjectWriteConditions((Optional<Long>)overwriteGeneration, (Optional<Long>)Optional.absent());
        Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(options.getMetadata());
        GoogleCloudStorageWriteChannel channel = new GoogleCloudStorageWriteChannel(this.threadPool, this.gcs, this.clientRequestHelper, resourceId.getBucketName(), resourceId.getObjectName(), this.storageOptions.getWriteChannelOptions(), writeConditions, rewrittenMetadata, options.getContentType());
        channel.initialize();
        return channel;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        LOG.debug("create({})", (Object)resourceId);
        String string = String.valueOf(resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + String.valueOf(string).length()).append("Expected full StorageObject id, got ").append(string).toString());
        return this.create(resourceId, CreateObjectOptions.DEFAULT);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        String string = String.valueOf(resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + String.valueOf(string).length()).append("Expected full StorageObject id, got ").append(string).toString());
        Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
        try {
            insertObject.execute();
        }
        catch (IOException ioe) {
            if (this.canIgnoreExceptionForEmptyObject(ioe, resourceId, options)) {
                LOG.info("Ignoring exception; verified object already exists with desired state.", (Throwable)ioe);
            }
            throw ioe;
        }
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        LOG.debug("createEmptyObject({})", (Object)resourceId);
        String string = String.valueOf(resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + String.valueOf(string).length()).append("Expected full StorageObject id, got ").append(string).toString());
        this.createEmptyObject(resourceId, CreateObjectOptions.DEFAULT);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, final CreateObjectOptions options) throws IOException {
        LOG.debug("createEmptyObjects({})", resourceIds);
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject names only, got: '%s'", (Object[])new Object[]{resourceId});
        }
        final List<IOException> innerExceptions = Collections.synchronizedList(new ArrayList());
        final CountDownLatch latch = new CountDownLatch(resourceIds.size());
        for (final StorageResourceId resourceId : resourceIds) {
            final Storage.Objects.Insert insertObject = this.prepareEmptyInsert(resourceId, options);
            this.manualBatchingThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        insertObject.execute();
                        LOG.debug("Successfully inserted {}", (Object)resourceId.toString());
                    }
                    catch (IOException ioe) {
                        boolean canIgnoreException = false;
                        try {
                            canIgnoreException = GoogleCloudStorageImpl.this.canIgnoreExceptionForEmptyObject(ioe, resourceId, options);
                        }
                        catch (Throwable t) {
                            IOException toWrap = t instanceof IOException ? (IOException)t : new IOException(t);
                            innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(toWrap, "Error re-fetching after rate-limit error", resourceId.getBucketName(), resourceId.getObjectName()));
                        }
                        if (canIgnoreException) {
                            LOG.info("Ignoring exception; verified object already exists with desired state.", (Throwable)ioe);
                        } else {
                            innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(ioe, "Error inserting", resourceId.getBucketName(), resourceId.getObjectName()));
                        }
                    }
                    catch (Throwable t) {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(t), "Error inserting", resourceId.getBucketName(), resourceId.getObjectName()));
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        if (!innerExceptions.isEmpty()) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.createEmptyObjects(resourceIds, CreateObjectOptions.DEFAULT);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        LOG.debug("open({})", (Object)resourceId);
        String string = String.valueOf(resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + String.valueOf(string).length()).append("Expected full StorageObject id, got ").append(string).toString());
        if (!this.getItemInfo(resourceId).exists()) {
            throw GoogleCloudStorageExceptions.getFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName());
        }
        return new GoogleCloudStorageReadChannel(this.gcs, resourceId.getBucketName(), resourceId.getObjectName(), this.errorExtractor, this.clientRequestHelper);
    }

    @Override
    public void create(String bucketName) throws IOException {
        this.create(bucketName, CreateBucketOptions.DEFAULT);
    }

    @Override
    public void create(String bucketName, CreateBucketOptions options) throws IOException {
        LOG.debug("create({})", (Object)bucketName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null");
        Bucket bucket = new Bucket();
        bucket.setName(bucketName);
        bucket.setLocation(options.getLocation());
        bucket.setStorageClass(options.getStorageClass());
        Storage.Buckets.Insert insertBucket = this.gcs.buckets().insert(this.storageOptions.getProjectId(), bucket);
        try {
            ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)insertBucket), (BackOff)this.backOffFactory.newBackOff(), this.rateLimitedRetryDeterminer, IOException.class, (Sleeper)this.sleeper);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        LOG.debug("deleteBuckets({})", (Object)bucketNames.toString());
        for (String bucketName : bucketNames) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        for (String bucketName : bucketNames) {
            Storage.Buckets.Delete deleteBucket = this.gcs.buckets().delete(bucketName);
            try {
                ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)deleteBucket), (BackOff)this.backOffFactory.newBackOff(), this.rateLimitedRetryDeterminer, IOException.class, (Sleeper)this.sleeper);
            }
            catch (IOException ioe) {
                if (this.errorExtractor.itemNotFound(ioe)) {
                    LOG.debug("delete({}) : not found", (Object)bucketName);
                    innerExceptions.add(GoogleCloudStorageExceptions.getFileNotFoundException(bucketName, null));
                    continue;
                }
                innerExceptions.add(this.wrapException(new IOException(ioe.toString()), "Error deleting", bucketName, null));
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        LOG.debug("deleteObjects({})", (Object)fullObjectNames.toString());
        for (StorageResourceId fullObjectName : fullObjectNames) {
            String string = String.valueOf(fullObjectName.toString());
            Preconditions.checkArgument((boolean)fullObjectName.isStorageObject(), (Object)(string.length() != 0 ? "Expected full StorageObject names only, got: ".concat(string) : new String("Expected full StorageObject names only, got: ")));
        }
        ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (StorageResourceId fullObjectName : fullObjectNames) {
            this.queueSingleObjectDelete(fullObjectName, innerExceptions, batchHelper, 1);
        }
        do {
            batchHelper.flush();
        } while (!batchHelper.isEmpty());
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private void queueSingleObjectDelete(final StorageResourceId fullObjectName, final List<IOException> innerExceptions, final BatchHelper batchHelper, final int attempt) throws IOException {
        final String bucketName = fullObjectName.getBucketName();
        final String objectName = fullObjectName.getObjectName();
        Storage.Objects.Get getObject = this.gcs.objects().get(bucketName, objectName);
        batchHelper.queue(getObject, new JsonBatchCallback<StorageObject>(){

            public void onSuccess(StorageObject storageObject, HttpHeaders httpHeaders) throws IOException {
                final Long generation = storageObject.getGeneration();
                Storage.Objects.Delete deleteObject = GoogleCloudStorageImpl.this.gcs.objects().delete(bucketName, objectName).setIfGenerationMatch(generation);
                batchHelper.queue(deleteObject, new JsonBatchCallback<Void>(){

                    public void onSuccess(Void obj, HttpHeaders responseHeaders) {
                        LOG.debug("Successfully deleted {} at generation {}", (Object)fullObjectName.toString(), (Object)generation);
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
                        if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                            LOG.debug("deleteObjects({}) : delete not found", (Object)fullObjectName.toString());
                        } else if (GoogleCloudStorageImpl.this.errorExtractor.preconditionNotMet(e) && attempt <= 4) {
                            LOG.info("Precondition not met while deleting {} at generation {}. Attempt {}. Retrying.", new Object[]{fullObjectName.toString(), generation, attempt});
                            GoogleCloudStorageImpl.this.queueSingleObjectDelete(fullObjectName, innerExceptions, batchHelper, attempt + 1);
                        } else {
                            innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), String.format("Error deleting, stage 2 with generation %s", generation), bucketName, objectName));
                        }
                    }
                });
            }

            public void onFailure(GoogleJsonError googleJsonError, HttpHeaders httpHeaders) throws IOException {
                if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(googleJsonError)) {
                    LOG.debug("deleteObjects({}) : get not found", (Object)fullObjectName.toString());
                } else {
                    innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(googleJsonError.toString()), "Error deleting, stage 1", bucketName, objectName));
                }
            }
        });
    }

    static void validateCopyArguments(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames, GoogleCloudStorage gcsImpl) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)srcBucketName) ? 1 : 0) != 0, (Object)"srcBucketName must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dstBucketName) ? 1 : 0) != 0, (Object)"dstBucketName must not be null or empty");
        Preconditions.checkArgument((srcObjectNames != null ? 1 : 0) != 0, (Object)"srcObjectNames must not be null");
        Preconditions.checkArgument((dstObjectNames != null ? 1 : 0) != 0, (Object)"dstObjectNames must not be null");
        Preconditions.checkArgument((srcObjectNames.size() == dstObjectNames.size() ? 1 : 0) != 0, (Object)"Must supply same number of elements in srcObjectNames and dstObjectNames");
        if (!srcBucketName.equals(dstBucketName)) {
            GoogleCloudStorageItemInfo srcBucketInfo = gcsImpl.getItemInfo(new StorageResourceId(srcBucketName));
            if (!srcBucketInfo.exists()) {
                String string = String.valueOf(srcBucketName);
                throw new FileNotFoundException(string.length() != 0 ? "Bucket not found: ".concat(string) : new String("Bucket not found: "));
            }
            GoogleCloudStorageItemInfo dstBucketInfo = gcsImpl.getItemInfo(new StorageResourceId(dstBucketName));
            if (!dstBucketInfo.exists()) {
                String string = String.valueOf(dstBucketName);
                throw new FileNotFoundException(string.length() != 0 ? "Bucket not found: ".concat(string) : new String("Bucket not found: "));
            }
            if (!srcBucketInfo.getLocation().equals(dstBucketInfo.getLocation())) {
                throw new UnsupportedOperationException("This operation is not supported across two different storage locations.");
            }
            if (!srcBucketInfo.getStorageClass().equals(dstBucketInfo.getStorageClass())) {
                throw new UnsupportedOperationException("This operation is not supported across two different storage classes.");
            }
        }
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)srcObjectNames.get(i)) ? 1 : 0) != 0, (Object)"srcObjectName must not be null or empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dstObjectNames.get(i)) ? 1 : 0) != 0, (Object)"dstObjectName must not be null or empty");
            if (!srcBucketName.equals(dstBucketName) || !srcObjectNames.get(i).equals(dstObjectNames.get(i))) continue;
            throw new IllegalArgumentException(String.format("Copy destination must be different from source for %s.", StorageResourceId.createReadableString(srcBucketName, srcObjectNames.get(i))));
        }
    }

    @Override
    public void copy(final String srcBucketName, List<String> srcObjectNames, final String dstBucketName, List<String> dstObjectNames) throws IOException {
        GoogleCloudStorageImpl.validateCopyArguments(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames, this);
        final ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (int i = 0; i < srcObjectNames.size(); ++i) {
            final String srcObjectName = srcObjectNames.get(i);
            final String dstObjectName = dstObjectNames.get(i);
            Storage.Objects.Copy copyObject = this.gcs.objects().copy(srcBucketName, srcObjectName, dstBucketName, dstObjectName, null);
            batchHelper.queue(copyObject, new JsonBatchCallback<StorageObject>(){

                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    LOG.debug("Successfully copied {} to {}", (Object)StorageResourceId.createReadableString(srcBucketName, srcObjectName), (Object)StorageResourceId.createReadableString(dstBucketName, dstObjectName));
                }

                public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                        LOG.debug("copy({}) : not found", (Object)StorageResourceId.createReadableString(srcBucketName, srcObjectName));
                        innerExceptions.add(GoogleCloudStorageExceptions.getFileNotFoundException(srcBucketName, srcObjectName));
                    } else {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error copying", srcBucketName, srcObjectName));
                    }
                }
            });
        }
        batchHelper.flush();
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
    }

    private List<Bucket> listBucketsInternal() throws IOException {
        Buckets items;
        LOG.debug("listBucketsInternal()");
        ArrayList<Bucket> allBuckets = new ArrayList<Bucket>();
        Storage.Buckets.List listBucket = this.gcs.buckets().list(this.storageOptions.getProjectId());
        listBucket.setMaxResults(Long.valueOf(this.storageOptions.getMaxListItemsPerCall()));
        String pageToken = null;
        do {
            List buckets;
            if (pageToken != null) {
                LOG.debug("listBucketsInternal: next page {}", pageToken);
                listBucket.setPageToken(pageToken);
            }
            if ((buckets = (items = (Buckets)listBucket.execute()).getItems()) == null) continue;
            LOG.debug("listed {} items", (Object)buckets.size());
            allBuckets.addAll(buckets);
        } while ((pageToken = items.getNextPageToken()) != null);
        return allBuckets;
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        LOG.debug("listBucketNames()");
        ArrayList<String> bucketNames = new ArrayList<String>();
        List<Bucket> allBuckets = this.listBucketsInternal();
        for (Bucket bucket : allBuckets) {
            bucketNames.add(bucket.getName());
        }
        return bucketNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        LOG.debug("listBucketInfo()");
        ArrayList<GoogleCloudStorageItemInfo> bucketInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        List<Bucket> allBuckets = this.listBucketsInternal();
        for (Bucket bucket : allBuckets) {
            bucketInfos.add(new GoogleCloudStorageItemInfo(new StorageResourceId(bucket.getName()), bucket.getTimeCreated().getValue(), 0L, bucket.getLocation(), bucket.getStorageClass()));
        }
        return bucketInfos;
    }

    private Storage.Objects.Insert prepareEmptyInsert(StorageResourceId resourceId, CreateObjectOptions createObjectOptions) throws IOException {
        StorageObject object = new StorageObject();
        object.setName(resourceId.getObjectName());
        Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(createObjectOptions.getMetadata());
        object.setMetadata(rewrittenMetadata);
        ByteArrayContent emptyContent = new ByteArrayContent(createObjectOptions.getContentType(), new byte[0]);
        Storage.Objects.Insert insertObject = this.gcs.objects().insert(resourceId.getBucketName(), object, (AbstractInputStreamContent)emptyContent);
        insertObject.setDisableGZipContent(true);
        this.clientRequestHelper.setDirectUploadEnabled((AbstractGoogleClientRequest)insertObject, true);
        if (!createObjectOptions.overwriteExisting()) {
            insertObject.setIfGenerationMatch(Long.valueOf(0L));
        }
        return insertObject;
    }

    private void listStorageObjectsAndPrefixes(String bucketName, String objectNamePrefix, String delimiter, long maxResults, List<StorageObject> listedObjects, List<String> listedPrefixes) throws IOException {
        Objects items;
        LOG.debug("listStorageObjectsAndPrefixes({}, {}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Preconditions.checkArgument((listedObjects != null ? 1 : 0) != 0, (Object)"Must provide a non-null container for listedObjects.");
        Preconditions.checkArgument((listedPrefixes != null ? 1 : 0) != 0, (Object)"Must provide a non-null container for listedPrefixes.");
        Preconditions.checkArgument((listedObjects.size() == 0 ? 1 : 0) != 0, (Object)"Must provide an empty container for listedObjects.");
        Preconditions.checkArgument((listedPrefixes.size() == 0 ? 1 : 0) != 0, (Object)"Must provide an empty container for listedPrefixes.");
        Storage.Objects.List listObject = this.gcs.objects().list(bucketName);
        if (delimiter != null) {
            listObject.setDelimiter(delimiter);
        }
        if (maxResults <= 0L || maxResults + 1L >= this.storageOptions.getMaxListItemsPerCall()) {
            listObject.setMaxResults(Long.valueOf(this.storageOptions.getMaxListItemsPerCall()));
        } else {
            listObject.setMaxResults(Long.valueOf(maxResults + 1L));
        }
        if (!Strings.isNullOrEmpty((String)objectNamePrefix)) {
            listObject.setPrefix(objectNamePrefix);
        }
        String pageToken = null;
        long numResults = listedObjects.size() + listedPrefixes.size();
        long maxRemainingResults = maxResults - numResults;
        do {
            if (pageToken != null) {
                LOG.debug("listStorageObjectsAndPrefixes: next page {}", pageToken);
                listObject.setPageToken(pageToken);
            }
            try {
                items = (Objects)listObject.execute();
            }
            catch (IOException e) {
                if (this.errorExtractor.itemNotFound(e)) {
                    LOG.debug("listStorageObjectsAndPrefixes({}, {}, {}, {}): item not found", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
                    break;
                }
                throw this.wrapException(e, "Error listing", bucketName, objectNamePrefix);
            }
            List prefixes = items.getPrefixes();
            if (prefixes != null) {
                LOG.debug("listed {} prefixes", (Object)prefixes.size());
                numResults = listedObjects.size() + listedPrefixes.size();
                maxRemainingResults = maxResults - numResults;
                if (maxResults <= 0L || maxRemainingResults >= (long)prefixes.size()) {
                    listedPrefixes.addAll(prefixes);
                } else {
                    int ii = 0;
                    while ((long)ii < maxRemainingResults) {
                        listedPrefixes.add((String)prefixes.get(ii));
                        ++ii;
                    }
                }
            }
            numResults = listedObjects.size() + listedPrefixes.size();
            maxRemainingResults = maxResults - numResults;
            if (maxResults > 0L && maxRemainingResults <= 0L) break;
            List objects = items.getItems();
            if (objects != null) {
                LOG.debug("listed {} objects", (Object)objects.size());
                boolean objectPrefixEndsWithDelimiter = !Strings.isNullOrEmpty((String)objectNamePrefix) && objectNamePrefix.endsWith(PATH_DELIMITER);
                for (StorageObject object : objects) {
                    String objectName = object.getName();
                    if (objectPrefixEndsWithDelimiter && (!objectPrefixEndsWithDelimiter || objectName.equals(objectNamePrefix))) continue;
                    if (maxResults > 0L && maxRemainingResults <= 0L) break;
                    listedObjects.add(object);
                    --maxRemainingResults;
                }
            }
            numResults = listedObjects.size() + listedPrefixes.size();
            maxRemainingResults = maxResults - numResults;
        } while ((maxResults <= 0L || maxRemainingResults > 0L) && (pageToken = items.getNextPageToken()) != null);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectNames(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        LOG.debug("listObjectNames({}, {}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
        ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
        ArrayList<String> listedPrefixes = new ArrayList<String>();
        this.listStorageObjectsAndPrefixes(bucketName, objectNamePrefix, delimiter, maxResults, listedObjects, listedPrefixes);
        ArrayList<String> objectNames = listedPrefixes;
        for (StorageObject obj : listedObjects) {
            objectNames.add(obj.getName());
        }
        return objectNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> objectInfos;
        block16: {
            LOG.debug("listObjectInfo({}, {}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
            ArrayList<StorageObject> listedObjects = new ArrayList<StorageObject>();
            ArrayList<String> listedPrefixes = new ArrayList<String>();
            this.listStorageObjectsAndPrefixes(bucketName, objectNamePrefix, delimiter, maxResults, listedObjects, listedPrefixes);
            objectInfos = new ArrayList<GoogleCloudStorageItemInfo>();
            for (StorageObject storageObject : listedObjects) {
                objectInfos.add(GoogleCloudStorageImpl.createItemInfoForStorageObject(new StorageResourceId(bucketName, storageObject.getName()), storageObject));
            }
            if (listedPrefixes.size() > 0) {
                ArrayList<StorageResourceId> resourceIdsForPrefixes = new ArrayList<StorageResourceId>();
                for (String prefix : listedPrefixes) {
                    resourceIdsForPrefixes.add(new StorageResourceId(bucketName, prefix));
                }
                List<GoogleCloudStorageItemInfo> list = this.getItemInfos(resourceIdsForPrefixes);
                ArrayList<StorageResourceId> repairList = new ArrayList<StorageResourceId>();
                for (GoogleCloudStorageItemInfo prefixInfo : list) {
                    if (prefixInfo.exists()) {
                        objectInfos.add(prefixInfo);
                        continue;
                    }
                    String errorBase = String.format("Error retrieving object for a retrieved prefix with resourceId '%s'. ", prefixInfo.getResourceId());
                    if (this.storageOptions.isAutoRepairImplicitDirectoriesEnabled()) {
                        LOG.debug(String.valueOf(errorBase).concat("Attempting to repair missing directory."));
                        repairList.add(prefixInfo.getResourceId());
                        continue;
                    }
                    if (this.storageOptions.isInferImplicitDirectoriesEnabled()) {
                        objectInfos.add(GoogleCloudStorageImpl.createItemInfoForInferredDirectory(prefixInfo.getResourceId()));
                        continue;
                    }
                    LOG.error(String.valueOf(errorBase).concat("Giving up on retrieving missing directory."));
                }
                if (this.storageOptions.isAutoRepairImplicitDirectoriesEnabled() && !repairList.isEmpty()) {
                    try {
                        LOG.warn("Repairing batch of {} missing directories.", (Object)repairList.size());
                        if (repairList.size() == 1) {
                            this.createEmptyObject((StorageResourceId)repairList.get(0));
                        } else {
                            this.createEmptyObjects(repairList);
                        }
                        List<GoogleCloudStorageItemInfo> repairedInfos = this.getItemInfos(repairList);
                        int numRepaired = 0;
                        for (GoogleCloudStorageItemInfo repairedInfo : repairedInfos) {
                            if (repairedInfo.exists()) {
                                objectInfos.add(repairedInfo);
                                ++numRepaired;
                                continue;
                            }
                            LOG.warn("Somehow the repair for '{}' failed quietly", (Object)repairedInfo.getResourceId());
                            if (!this.storageOptions.isInferImplicitDirectoriesEnabled()) continue;
                            objectInfos.add(GoogleCloudStorageImpl.createItemInfoForInferredDirectory(repairedInfo.getResourceId()));
                        }
                        LOG.warn("Successfully repaired {}/{} implicit directories.", (Object)numRepaired, (Object)repairList.size());
                    }
                    catch (IOException ioe) {
                        LOG.error("Failed to repair some missing directories.", (Throwable)ioe);
                        if (!this.storageOptions.isInferImplicitDirectoriesEnabled()) break block16;
                        List<GoogleCloudStorageItemInfo> repairedInfos = this.getItemInfos(repairList);
                        int numRepaired = 0;
                        for (GoogleCloudStorageItemInfo repairedInfo : repairedInfos) {
                            if (repairedInfo.exists()) {
                                objectInfos.add(repairedInfo);
                                ++numRepaired;
                                continue;
                            }
                            LOG.info("Repair for '{}' failed, using inferred directory", (Object)repairedInfo.getResourceId());
                            objectInfos.add(GoogleCloudStorageImpl.createItemInfoForInferredDirectory(repairedInfo.getResourceId()));
                        }
                        if (numRepaired <= 0) break block16;
                        LOG.info("Successfully repaired {}/{} implicit directories.", (Object)numRepaired, (Object)repairList.size());
                    }
                }
            }
        }
        return objectInfos;
    }

    @VisibleForTesting
    static GoogleCloudStorageItemInfo createItemInfoForBucket(StorageResourceId resourceId, Bucket bucket) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        Preconditions.checkArgument((bucket != null ? 1 : 0) != 0, (Object)"bucket must not be null");
        Preconditions.checkArgument((boolean)resourceId.isBucket(), (Object)String.format("resourceId must be a Bucket. resourceId: %s", resourceId));
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(bucket.getName()), (Object)String.format("resourceId.getBucketName() must equal bucket.getName(): '%s' vs '%s'", resourceId.getBucketName(), bucket.getName()));
        return new GoogleCloudStorageItemInfo(resourceId, bucket.getTimeCreated().getValue(), 0L, bucket.getLocation(), bucket.getStorageClass());
    }

    @VisibleForTesting
    static GoogleCloudStorageItemInfo createItemInfoForStorageObject(StorageResourceId resourceId, StorageObject object) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object must not be null");
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)String.format("resourceId must be a StorageObject. resourceId: %s", resourceId));
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(object.getBucket()), (Object)String.format("resourceId.getBucketName() must equal object.getBucket(): '%s' vs '%s'", resourceId.getBucketName(), object.getBucket()));
        Preconditions.checkArgument((boolean)resourceId.getObjectName().equals(object.getName()), (Object)String.format("resourceId.getObjectName() must equal object.getName(): '%s' vs '%s'", resourceId.getObjectName(), object.getName()));
        Map<String, byte[]> decodedMetadata = object.getMetadata() == null ? null : GoogleCloudStorageImpl.decodeMetadata(object.getMetadata());
        return new GoogleCloudStorageItemInfo(resourceId, object.getUpdated().getValue(), object.getSize().longValue(), null, null, object.getContentType(), decodedMetadata, object.getGeneration(), object.getMetageneration());
    }

    @VisibleForTesting
    static Map<String, String> encodeMetadata(Map<String, byte[]> metadata) {
        return Maps.transformValues(metadata, ENCODE_METADATA_VALUES);
    }

    @VisibleForTesting
    static Map<String, byte[]> decodeMetadata(Map<String, String> metadata) {
        return Maps.transformValues(metadata, DECODE_METADATA_VALUES);
    }

    protected static GoogleCloudStorageItemInfo createItemInfoForInferredDirectory(StorageResourceId resourceId) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        return new GoogleCloudStorageItemInfo(resourceId, 0L, 0L, null, null);
    }

    protected static GoogleCloudStorageItemInfo createItemInfoForNotFound(StorageResourceId resourceId) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"resourceId must not be null");
        return new GoogleCloudStorageItemInfo(resourceId, 0L, -1L, null, null);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        LOG.debug("getItemInfos({})", (Object)resourceIds.toString());
        final HashMap<StorageResourceId, GoogleCloudStorageItemInfo> itemInfos = new HashMap<StorageResourceId, GoogleCloudStorageItemInfo>();
        final ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (final StorageResourceId resourceId : resourceIds) {
            if (resourceId.isRoot()) {
                itemInfos.put(resourceId, GoogleCloudStorageItemInfo.ROOT_INFO);
                continue;
            }
            if (resourceId.isBucket()) {
                batchHelper.queue(this.gcs.buckets().get(resourceId.getBucketName()), new JsonBatchCallback<Bucket>(){

                    public void onSuccess(Bucket bucket, HttpHeaders responseHeaders) {
                        LOG.debug("getItemInfos: Successfully fetched bucket: {} for resourceId: {}", (Object)bucket, (Object)resourceId);
                        itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket));
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                        if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                            LOG.debug("getItemInfos: bucket not found: {}", (Object)resourceId.getBucketName());
                            itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId));
                        } else {
                            innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error getting Bucket: ", resourceId.getBucketName(), null));
                        }
                    }
                });
                continue;
            }
            final String bucketName = resourceId.getBucketName();
            final String objectName = resourceId.getObjectName();
            batchHelper.queue(this.gcs.objects().get(bucketName, objectName), new JsonBatchCallback<StorageObject>(){

                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    LOG.debug("getItemInfos: Successfully fetched object '{}' for resourceId '{}'", (Object)obj, (Object)resourceId);
                    itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                        LOG.debug("getItemInfos: object not found: {}", (Object)resourceId);
                        itemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId));
                    } else {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error getting StorageObject: ", bucketName, objectName));
                    }
                }
            });
        }
        batchHelper.flush();
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            Preconditions.checkState((boolean)itemInfos.containsKey(resourceId), (Object)String.format("Somehow missing resourceId '%s' from map: %s", resourceId, itemInfos));
            sortedItemInfos.add((GoogleCloudStorageItemInfo)itemInfos.get(resourceId));
        }
        Preconditions.checkState((sortedItemInfos.size() == resourceIds.size() ? 1 : 0) != 0, (Object)String.format("sortedItemInfos.size() (%d) != resourceIds.size() (%d). infos: %s, ids: %s", sortedItemInfos.size(), resourceIds.size(), sortedItemInfos, resourceIds));
        return sortedItemInfos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        LOG.debug("updateItems({})", (Object)itemInfoList.toString());
        final HashMap resultItemInfos = new HashMap();
        final ArrayList<IOException> innerExceptions = new ArrayList<IOException>();
        BatchHelper batchHelper = this.batchFactory.newBatchHelper(this.httpRequestInitializer, this.gcs, this.storageOptions.getMaxRequestsPerBatch());
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkArgument((!itemInfo.getStorageResourceId().isBucket() && !itemInfo.getStorageResourceId().isRoot() ? 1 : 0) != 0, (Object)"Buckets and GCS Root resources are not supported for updateItems");
        }
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            final StorageResourceId resourceId = itemInfo.getStorageResourceId();
            final String bucketName = resourceId.getBucketName();
            final String objectName = resourceId.getObjectName();
            Map<String, byte[]> originalMetadata = itemInfo.getMetadata();
            Map<String, String> rewrittenMetadata = GoogleCloudStorageImpl.encodeMetadata(originalMetadata);
            Storage.Objects.Patch patch = this.gcs.objects().patch(bucketName, objectName, new StorageObject().setMetadata(rewrittenMetadata));
            batchHelper.queue(patch, new JsonBatchCallback<StorageObject>(){

                public void onSuccess(StorageObject obj, HttpHeaders responseHeaders) {
                    LOG.debug("updateItems: Successfully updated object '{}' for resourceId '{}'", (Object)obj, (Object)resourceId);
                    resultItemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, obj));
                }

                public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                    if (GoogleCloudStorageImpl.this.errorExtractor.itemNotFound(e)) {
                        LOG.debug("updateItems: object not found: {}", (Object)resourceId);
                        resultItemInfos.put(resourceId, GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId));
                    } else {
                        innerExceptions.add(GoogleCloudStorageImpl.this.wrapException(new IOException(e.toString()), "Error getting StorageObject: ", bucketName, objectName));
                    }
                }
            });
        }
        batchHelper.flush();
        if (innerExceptions.size() > 0) {
            throw GoogleCloudStorageExceptions.createCompositeException(innerExceptions);
        }
        ArrayList<GoogleCloudStorageItemInfo> sortedItemInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (UpdatableItemInfo itemInfo : itemInfoList) {
            Preconditions.checkState((boolean)resultItemInfos.containsKey(itemInfo.getStorageResourceId()), (Object)String.format("Missing resourceId '%s' from map: %s", itemInfo.getStorageResourceId(), resultItemInfos));
            sortedItemInfos.add((GoogleCloudStorageItemInfo)resultItemInfos.get(itemInfo.getStorageResourceId()));
        }
        Preconditions.checkState((sortedItemInfos.size() == itemInfoList.size() ? 1 : 0) != 0, (Object)String.format("sortedItemInfos.size() (%d) != resourceIds.size() (%d). infos: %s, updateItemInfos: %s", sortedItemInfos.size(), itemInfoList.size(), sortedItemInfos, itemInfoList));
        return sortedItemInfos;
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        LOG.debug("getItemInfo({})", (Object)resourceId);
        if (resourceId.isRoot()) {
            return GoogleCloudStorageItemInfo.ROOT_INFO;
        }
        GoogleCloudStorageItemInfo itemInfo = null;
        if (resourceId.isBucket()) {
            Bucket bucket = this.getBucket(resourceId.getBucketName());
            if (bucket != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForBucket(resourceId, bucket);
            }
        } else {
            StorageObject object = this.getObject(resourceId);
            if (object != null) {
                itemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(resourceId, object);
            }
        }
        if (itemInfo == null) {
            itemInfo = GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId);
        }
        LOG.debug("getItemInfo: {}", (Object)itemInfo);
        return itemInfo;
    }

    @Override
    public void close() {
        LOG.debug("close()");
        this.threadPool.shutdown();
        this.manualBatchingThreadPool.shutdown();
    }

    private Bucket getBucket(String bucketName) throws IOException {
        LOG.debug("getBucket({})", (Object)bucketName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        Bucket bucket = null;
        Storage.Buckets.Get getBucket = this.gcs.buckets().get(bucketName);
        try {
            bucket = (Bucket)getBucket.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                LOG.debug("getBucket({}) : not found", (Object)bucketName);
            }
            LOG.debug(String.format("getBucket({}) threw exception: ", bucketName), (Throwable)e);
            throw this.wrapException(e, "Error accessing", bucketName, null);
        }
        return bucket;
    }

    @VisibleForTesting
    IOException wrapException(IOException e, String message, String bucketName, String objectName) {
        String name;
        String string = String.valueOf(bucketName);
        String string2 = name = string.length() != 0 ? "bucket: ".concat(string) : new String("bucket: ");
        if (!Strings.isNullOrEmpty((String)objectName)) {
            String string3 = String.valueOf(name);
            name = new StringBuilder(10 + String.valueOf(string3).length() + String.valueOf(objectName).length()).append(string3).append(", object: ").append(objectName).toString();
        }
        String fullMessage = String.format("%s: %s", message, name);
        return new IOException(fullMessage, e);
    }

    private StorageObject getObject(StorageResourceId resourceId) throws IOException {
        LOG.debug("getObject({})", (Object)resourceId);
        String string = String.valueOf(resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (Object)new StringBuilder(36 + String.valueOf(string).length()).append("Expected full StorageObject id, got ").append(string).toString());
        String bucketName = resourceId.getBucketName();
        String objectName = resourceId.getObjectName();
        StorageObject object = null;
        Storage.Objects.Get getObject = this.gcs.objects().get(bucketName, objectName);
        try {
            object = (StorageObject)getObject.execute();
        }
        catch (IOException e) {
            if (this.errorExtractor.itemNotFound(e)) {
                LOG.debug("getObject({}) : not found", (Object)resourceId);
            }
            LOG.debug(String.format("getObject({}) threw exception: ", resourceId), (Throwable)e);
            throw this.wrapException(e, "Error accessing", bucketName, objectName);
        }
        return object;
    }

    private boolean canIgnoreExceptionForEmptyObject(IOException exceptionOnCreate, StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        GoogleCloudStorageItemInfo existingInfo;
        if (this.errorExtractor.rateLimited((Throwable)exceptionOnCreate) && (existingInfo = this.getItemInfo(resourceId)).exists() && existingInfo.getSize() == 0L) {
            if (!options.getRequireMetadataMatchForEmptyObjects()) {
                return true;
            }
            if (existingInfo.metadataEquals(options.getMetadata())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void waitForBucketEmpty(String bucketName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        int maxRetries = 20;
        int waitTime = 500;
        for (int i = 0; i < maxRetries; ++i) {
            List<String> objectNames = this.listObjectNames(bucketName, null, PATH_DELIMITER, 1L);
            if (objectNames.size() == 0) {
                return;
            }
            try {
                this.sleeper.sleep((long)waitTime);
                continue;
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        String string = String.valueOf(bucketName);
        throw new IOException(string.length() != 0 ? "Internal error: bucket not empty: ".concat(string) : new String("Internal error: bucket not empty: "));
    }

    public static interface BackOffFactory {
        public static final BackOffFactory DEFAULT = new BackOffFactory(){

            @Override
            public BackOff newBackOff() {
                return new ExponentialBackOff();
            }
        };

        public BackOff newBackOff();
    }
}

