/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CacheEntry;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.InMemoryDirectoryListCache;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataReadOnlyGoogleCloudStorage
implements GoogleCloudStorage {
    public static final Logger LOG = LoggerFactory.getLogger(MetadataReadOnlyGoogleCloudStorage.class);
    private final DirectoryListCache resourceCache = new InMemoryDirectoryListCache();
    private GoogleCloudStorageOptions options;
    private static final Function<GoogleCloudStorageItemInfo, String> ITEM_INFO_TO_NAME = new Function<GoogleCloudStorageItemInfo, String>(){

        public String apply(GoogleCloudStorageItemInfo itemInfo) {
            return itemInfo.getObjectName();
        }
    };

    public MetadataReadOnlyGoogleCloudStorage(Collection<GoogleCloudStorageItemInfo> itemInfos) throws IOException {
        this.resourceCache.getMutableConfig().setMaxEntryAgeMillis(Long.MAX_VALUE);
        this.resourceCache.getMutableConfig().setMaxInfoAgeMillis(Long.MAX_VALUE);
        LOG.debug("Populating cache with {} entries.", (Object)itemInfos.size());
        for (GoogleCloudStorageItemInfo itemInfo : itemInfos) {
            this.resourceCache.putResourceId(itemInfo.getResourceId()).setItemInfo(itemInfo);
        }
        this.options = GoogleCloudStorageOptions.newBuilder().build();
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.options;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void create(String bucketName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void create(String bucketName, CreateBucketOptions options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectNames(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        LOG.debug("listObjectNames({}, {}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
        return Lists.transform(this.listObjectInfo(bucketName, objectNamePrefix, delimiter, maxResults), ITEM_INFO_TO_NAME);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        LOG.debug("listObjectInfo({}, {}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
        ArrayList<GoogleCloudStorageItemInfo> allObjectInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        HashSet<String> retrievedNames = new HashSet<String>();
        HashSet<String> prefixes = new HashSet<String>();
        List<CacheEntry> cachedObjects = this.resourceCache.getObjectList(bucketName, objectNamePrefix, delimiter, prefixes);
        if (cachedObjects != null) {
            for (CacheEntry entry : cachedObjects) {
                GoogleCloudStorageItemInfo info = entry.getItemInfo();
                Preconditions.checkState((info != null ? 1 : 0) != 0, (String)"Cache entry missing info for name '%s'!", (Object[])new Object[]{entry.getResourceId()});
                allObjectInfos.add(info);
                retrievedNames.add(entry.getResourceId().getObjectName());
            }
            for (String prefix : prefixes) {
                if (retrievedNames.contains(prefix)) continue;
                LOG.debug("Found implicit directory '{}'. Adding fake entry for it.", (Object)prefix);
                GoogleCloudStorageItemInfo fakeInfo = new GoogleCloudStorageItemInfo(new StorageResourceId(bucketName, prefix), 0L, 0L, null, null);
                allObjectInfos.add(fakeInfo);
                retrievedNames.add(prefix);
                this.resourceCache.putResourceId(fakeInfo.getResourceId()).setItemInfo(fakeInfo);
            }
        }
        return allObjectInfos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        LOG.debug("getItemInfos({})", (Object)resourceIds.toString());
        ArrayList<GoogleCloudStorageItemInfo> infos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (StorageResourceId resourceId : resourceIds) {
            infos.add(this.getItemInfo(resourceId));
        }
        return infos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        LOG.debug("getItemInfo({})", (Object)resourceId);
        CacheEntry entry = this.resourceCache.getCacheEntry(resourceId);
        if (entry == null) {
            return GoogleCloudStorageImpl.createItemInfoForNotFound(resourceId);
        }
        GoogleCloudStorageItemInfo info = entry.getItemInfo();
        Preconditions.checkState((info != null ? 1 : 0) != 0, (String)"Cache entry missing info for name '%s'!", (Object[])new Object[]{entry.getResourceId()});
        return info;
    }

    @Override
    public void close() {
        LOG.debug("close()");
    }

    @Override
    public void waitForBucketEmpty(String bucketName) throws IOException {
        throw new UnsupportedOperationException();
    }
}

