/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public class GoogleCloudStorageFileSystemOptions {
    private final GoogleCloudStorageOptions cloudStorageOptions;
    private final boolean metadataCacheEnabled;
    private final DirectoryListCache.Type cacheType;
    private final String cacheBasePath;
    private final Predicate<String> shouldIncludeInTimestampUpdatesPredicate;
    private final long cacheMaxEntryAgeMillis;
    private final long cacheMaxInfoAgeMillis;
    private final PathCodec pathCodec;

    public static Builder newBuilder() {
        return new Builder();
    }

    public GoogleCloudStorageFileSystemOptions(GoogleCloudStorageOptions cloudStorageOptions, boolean metadataCacheEnabled, DirectoryListCache.Type cacheType, String cacheBasePath, Predicate<String> shouldIncludeInTimestampUpdatesPredicate, long cacheMaxEntryAgeMillis, long cacheMaxInfoAgeMillis, PathCodec pathCodec) {
        this.cloudStorageOptions = cloudStorageOptions;
        this.metadataCacheEnabled = metadataCacheEnabled;
        this.cacheType = cacheType;
        this.cacheBasePath = cacheBasePath;
        this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
        this.cacheMaxEntryAgeMillis = cacheMaxEntryAgeMillis;
        this.cacheMaxInfoAgeMillis = cacheMaxInfoAgeMillis;
        this.pathCodec = pathCodec;
    }

    public GoogleCloudStorageOptions getCloudStorageOptions() {
        return this.cloudStorageOptions;
    }

    public boolean isMetadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    public DirectoryListCache.Type getCacheType() {
        return this.cacheType;
    }

    public String getCacheBasePath() {
        return this.cacheBasePath;
    }

    public Predicate<String> getShouldIncludeInTimestampUpdatesPredicate() {
        return this.shouldIncludeInTimestampUpdatesPredicate;
    }

    public long getCacheMaxEntryAgeMillis() {
        return this.cacheMaxEntryAgeMillis;
    }

    public long getCacheMaxInfoAgeMillis() {
        return this.cacheMaxInfoAgeMillis;
    }

    public PathCodec getPathCodec() {
        return this.pathCodec;
    }

    public void throwIfNotValid() {
        Preconditions.checkArgument((this.shouldIncludeInTimestampUpdatesPredicate != null ? 1 : 0) != 0, (Object)"Predicate for ignored directory updates should not be null. Consider Predicates.alwasyTrue");
        this.cloudStorageOptions.throwIfNotValid();
    }

    public static class Builder {
        protected boolean metadataCacheEnabled = true;
        protected DirectoryListCache.Type cacheType = DirectoryListCache.Type.IN_MEMORY;
        protected String cacheBasePath = null;
        protected Predicate<String> shouldIncludeInTimestampUpdatesPredicate = Predicates.alwaysTrue();
        protected long cacheMaxEntryAgeMillis = 14400000L;
        protected long cacheMaxInfoAgeMillis = 10000L;
        private GoogleCloudStorageOptions.Builder cloudStorageOptionsBuilder = new GoogleCloudStorageOptions.Builder();
        private GoogleCloudStorageOptions immutableCloudStorageOptions = null;
        private PathCodec pathCodec = GoogleCloudStorageFileSystem.LEGACY_PATH_CODEC;

        public GoogleCloudStorageOptions.Builder getCloudStorageOptionsBuilder() {
            return this.cloudStorageOptionsBuilder;
        }

        public Builder setCloudStorageOptionsBuilder(GoogleCloudStorageOptions.Builder cloudStorageOptionsBuilder) {
            this.cloudStorageOptionsBuilder = cloudStorageOptionsBuilder;
            this.immutableCloudStorageOptions = null;
            return this;
        }

        public Builder setImmutableCloudStorageOptions(GoogleCloudStorageOptions immutableCloudStorageOptions) {
            this.immutableCloudStorageOptions = immutableCloudStorageOptions;
            this.cloudStorageOptionsBuilder = new GoogleCloudStorageOptions.Builder();
            return this;
        }

        public Builder setIsMetadataCacheEnabled(boolean isMetadataCacheEnabled) {
            this.metadataCacheEnabled = isMetadataCacheEnabled;
            return this;
        }

        public Builder setCacheType(DirectoryListCache.Type cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setCacheBasePath(String cacheBasePath) {
            this.cacheBasePath = cacheBasePath;
            return this;
        }

        public Builder setShouldIncludeInTimestampUpdatesPredicate(Predicate<String> shouldIncludeInTimestampUpdatesPredicate) {
            this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
            return this;
        }

        public Builder setCacheMaxEntryAgeMillis(long cacheMaxEntryAgeMillis) {
            this.cacheMaxEntryAgeMillis = cacheMaxEntryAgeMillis;
            return this;
        }

        public Builder setCacheMaxInfoAgeMillis(long cacheMaxInfoAgeMillis) {
            this.cacheMaxInfoAgeMillis = cacheMaxInfoAgeMillis;
            return this;
        }

        public Builder setPathCodec(PathCodec pathCodec) {
            this.pathCodec = pathCodec;
            return this;
        }

        public GoogleCloudStorageFileSystemOptions build() {
            return new GoogleCloudStorageFileSystemOptions(this.immutableCloudStorageOptions != null ? this.immutableCloudStorageOptions : this.cloudStorageOptionsBuilder.build(), this.metadataCacheEnabled, this.cacheType, this.cacheBasePath, this.shouldIncludeInTimestampUpdatesPredicate, this.cacheMaxEntryAgeMillis, this.cacheMaxInfoAgeMillis, this.pathCodec);
        }
    }
}

