/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.AbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.util.LoggingMediaHttpUploaderProgressListener;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class GoogleCloudStorageWriteChannel
extends AbstractGoogleAsyncWriteChannel<Storage.Objects.Insert, StorageObject>
implements GoogleCloudStorageItemInfo.Provider {
    private final Storage gcs;
    private final String bucketName;
    private final String objectName;
    private final ObjectWriteConditions writeConditions;
    private final Map<String, String> metadata;
    private static final long MIN_LOGGING_INTERVAL_MS = 60000L;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    public GoogleCloudStorageWriteChannel(ExecutorService threadPool, Storage gcs, ClientRequestHelper<StorageObject> requestHelper, String bucketName, String objectName, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Map<String, String> objectMetadata) {
        super(threadPool, options);
        this.setClientRequestHelper(requestHelper);
        this.gcs = gcs;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.writeConditions = writeConditions;
        this.metadata = objectMetadata;
    }

    public GoogleCloudStorageWriteChannel(ExecutorService threadPool, Storage gcs, ClientRequestHelper<StorageObject> requestHelper, String bucketName, String objectName, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Map<String, String> objectMetadata, String contentType) {
        this(threadPool, gcs, requestHelper, bucketName, objectName, options, writeConditions, objectMetadata);
        this.setContentType(contentType);
    }

    public Storage.Objects.Insert createRequest(InputStreamContent inputStream) throws IOException {
        StorageObject object = new StorageObject().setMetadata(this.metadata).setName(this.objectName);
        Storage.Objects.Insert insert = this.gcs.objects().insert(this.bucketName, object, (AbstractInputStreamContent)inputStream);
        this.writeConditions.apply(insert);
        if (insert.getMediaHttpUploader() != null) {
            insert.getMediaHttpUploader().setDirectUploadEnabled(this.isDirectUploadEnabled());
            insert.getMediaHttpUploader().setProgressListener((MediaHttpUploaderProgressListener)new LoggingMediaHttpUploaderProgressListener(this.objectName, 60000L));
        }
        insert.setName(this.objectName);
        return insert;
    }

    public void handleResponse(StorageObject response) {
        this.completedItemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(new StorageResourceId(this.bucketName, this.objectName), response);
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }
}

