/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

public class GoogleCloudStorageOptions {
    public static final long MAX_LIST_ITEMS_PER_CALL_DEFAULT = 1024L;
    public static final boolean AUTO_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final boolean INFER_IMPLICIT_DIRECTORIES_DEFAULT = true;
    @Deprecated
    private static final boolean LIST_DIRECTORY_OBJECTS_DEFAULT = true;
    public static final long MAX_REQUESTS_PER_BATCH_DEFAULT = 30L;
    public static final int BATCH_THREADS_DEFAULT = 0;
    public static final int MAX_HTTP_REQUEST_RETRIES = 10;
    public static final int HTTP_REQUEST_CONNECT_TIMEOUT = 20000;
    public static final int HTTP_REQUEST_READ_TIMEOUT = 20000;
    public static final boolean CREATE_EMPTY_MARKER_OBJECT_DEFAULT = false;
    public static final int MAX_WAIT_MILLIS_FOR_EMPTY_OBJECT_CREATION = 3000;
    public static final RequesterPaysOptions DEFAULT_REQUESTER_PAYS_OPTIONS = RequesterPaysOptions.DEFAULT;
    public static final boolean COPY_WITH_REWRITE_DEFAULT = false;
    public static final long MAX_BYTES_REWRITTEN_PER_CALL_DEFAULT = 0x20000000L;
    public static final long COPY_MAX_REQUESTS_PER_BATCH_DEFAULT = 30L;
    public static final int COPY_BATCH_THREADS_DEFAULT = 0;
    private final boolean autoRepairImplicitDirectoriesEnabled;
    private final boolean inferImplicitDirectoriesEnabled;
    @Deprecated
    private final boolean listDirectoryObjects;
    private final String projectId;
    private final String appName;
    private final HttpTransportFactory.HttpTransportType transportType;
    private final String proxyAddress;
    private final AsyncWriteChannelOptions writeChannelOptions;
    private final long maxListItemsPerCall;
    private final long maxRequestsPerBatch;
    private final int batchThreads;
    private final int maxHttpRequestRetries;
    private final int httpRequestConnectTimeout;
    private final int httpRequestReadTimeout;
    private final boolean createMarkerFile;
    private final int maxWaitMillisForEmptyObjectCreation;
    private final RequesterPaysOptions requesterPaysOptions;
    private final boolean copyWithRewriteEnabled;
    private final long maxBytesRewrittenPerCall;
    private final long copyMaxRequestsPerBatch;
    private final int copyBatchThreads;

    public static Builder newBuilder() {
        return new Builder();
    }

    protected GoogleCloudStorageOptions(Builder builder) {
        this.autoRepairImplicitDirectoriesEnabled = builder.autoRepairImplicitDirectoriesEnabled;
        this.inferImplicitDirectoriesEnabled = builder.inferImplicitDirectoriesEnabled;
        this.listDirectoryObjects = builder.listDirectoryObjects;
        this.projectId = builder.projectId;
        this.appName = builder.appName;
        this.writeChannelOptions = builder.getWriteChannelOptionsBuilder().build();
        this.maxListItemsPerCall = builder.maxListItemsPerCall;
        this.maxRequestsPerBatch = builder.maxRequestsPerBatch;
        this.batchThreads = builder.batchThreads;
        this.maxHttpRequestRetries = builder.maxHttpRequestRetries;
        this.httpRequestConnectTimeout = builder.httpRequestConnectTimeout;
        this.httpRequestReadTimeout = builder.httpRequestReadTimeout;
        this.createMarkerFile = builder.createMarkerObjects;
        this.transportType = builder.transportType;
        this.proxyAddress = builder.proxyAddress;
        this.maxWaitMillisForEmptyObjectCreation = builder.maxWaitMillisForEmptyObjectCreation;
        this.requesterPaysOptions = (RequesterPaysOptions)Preconditions.checkNotNull((Object)builder.requesterPaysOptions, (Object)"requesterPaysOptions could not be null");
        this.copyWithRewriteEnabled = builder.copyWithRewriteEnabled;
        this.maxBytesRewrittenPerCall = builder.maxBytesRewrittenPerCall;
        this.copyMaxRequestsPerBatch = builder.copyMaxRequestsPerBatch;
        this.copyBatchThreads = builder.copyBatchThreads;
    }

    public GoogleCloudStorageOptions(boolean autoRepairImplicitDirectoriesEnabled, boolean inferImplicitDirectoriesEnabled, String projectId, String appName, long maxListItemsPerCall, long maxRequestsPerBatch, boolean createMarkerFile, HttpTransportFactory.HttpTransportType transportType, String proxyAddress, AsyncWriteChannelOptions writeChannelOptions) {
        this(new Builder().setProjectId(projectId).setAppName(appName).setWriteChannelOptionsBuilder(new AsyncWriteChannelOptions.Builder().setUploadBufferSize(writeChannelOptions.getUploadBufferSize()).setDirectUploadEnabled(writeChannelOptions.isDirectUploadEnabled())).setAutoRepairImplicitDirectoriesEnabled(autoRepairImplicitDirectoriesEnabled).setInferImplicitDirectoriesEnabled(inferImplicitDirectoriesEnabled).setMaxListItemsPerCall(maxListItemsPerCall).setMaxRequestsPerBatch(maxRequestsPerBatch).setTransportType(transportType).setCreateMarkerObjects(createMarkerFile).setProxyAddress(proxyAddress));
    }

    public boolean isAutoRepairImplicitDirectoriesEnabled() {
        return this.autoRepairImplicitDirectoriesEnabled;
    }

    public boolean isInferImplicitDirectoriesEnabled() {
        return this.inferImplicitDirectoriesEnabled;
    }

    @Deprecated
    boolean isListDirectoryObjects() {
        return this.listDirectoryObjects;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    public String getAppName() {
        return this.appName;
    }

    public HttpTransportFactory.HttpTransportType getTransportType() {
        return this.transportType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public long getMaxListItemsPerCall() {
        return this.maxListItemsPerCall;
    }

    public AsyncWriteChannelOptions getWriteChannelOptions() {
        return this.writeChannelOptions;
    }

    public long getMaxRequestsPerBatch() {
        return this.maxRequestsPerBatch;
    }

    public int getBatchThreads() {
        return this.batchThreads;
    }

    public int getMaxHttpRequestRetries() {
        return this.maxHttpRequestRetries;
    }

    public int getHttpRequestConnectTimeout() {
        return this.httpRequestConnectTimeout;
    }

    public int getHttpRequestReadTimeout() {
        return this.httpRequestReadTimeout;
    }

    public boolean isMarkerFileCreationEnabled() {
        return this.createMarkerFile;
    }

    public int getMaxWaitMillisForEmptyObjectCreation() {
        return this.maxWaitMillisForEmptyObjectCreation;
    }

    public RequesterPaysOptions getRequesterPaysOptions() {
        return this.requesterPaysOptions;
    }

    public boolean isCopyWithRewriteEnabled() {
        return this.copyWithRewriteEnabled;
    }

    public long getMaxBytesRewrittenPerCall() {
        return this.maxBytesRewrittenPerCall;
    }

    public long getCopyMaxRequestsPerBatch() {
        return this.copyMaxRequestsPerBatch;
    }

    public int getCopyBatchThreads() {
        return this.copyBatchThreads;
    }

    public void throwIfNotValid() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.appName) ? 1 : 0) != 0, (Object)"appName must not be null or empty");
        Preconditions.checkArgument((this.maxBytesRewrittenPerCall <= 0L || this.maxBytesRewrittenPerCall % 0x100000L == 0L ? 1 : 0) != 0, (String)"maxBytesRewrittenPerCall must be an integral multiple of 1 MiB (1048576), but was: %s", (Object[])new Object[]{this.maxBytesRewrittenPerCall});
    }

    public static class Builder {
        private boolean autoRepairImplicitDirectoriesEnabled = true;
        private boolean inferImplicitDirectoriesEnabled = true;
        @Deprecated
        private boolean listDirectoryObjects = true;
        private String projectId = null;
        private String appName = null;
        private HttpTransportFactory.HttpTransportType transportType = HttpTransportFactory.DEFAULT_TRANSPORT_TYPE;
        private String proxyAddress = null;
        private long maxListItemsPerCall = 1024L;
        private boolean createMarkerObjects = false;
        private int maxWaitMillisForEmptyObjectCreation = 3000;
        private long maxRequestsPerBatch = 30L;
        private int batchThreads = 0;
        private int maxHttpRequestRetries = 10;
        private int httpRequestConnectTimeout = 20000;
        private int httpRequestReadTimeout = 20000;
        private AsyncWriteChannelOptions.Builder writeChannelOptionsBuilder = new AsyncWriteChannelOptions.Builder();
        private RequesterPaysOptions requesterPaysOptions = DEFAULT_REQUESTER_PAYS_OPTIONS;
        private boolean copyWithRewriteEnabled = false;
        private long maxBytesRewrittenPerCall = 0x20000000L;
        private long copyMaxRequestsPerBatch = 30L;
        private int copyBatchThreads = 0;

        public Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
            this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
            return this;
        }

        public Builder setInferImplicitDirectoriesEnabled(boolean inferImplicitDirectoriesEnabled) {
            this.inferImplicitDirectoriesEnabled = inferImplicitDirectoriesEnabled;
            return this;
        }

        @Deprecated
        public Builder setListDirectoryObjects(boolean listDirectoryObjects) {
            this.listDirectoryObjects = listDirectoryObjects;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
            this.maxListItemsPerCall = maxListItemsPerCall;
            return this;
        }

        public Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
            this.maxRequestsPerBatch = maxRequestsPerBatch;
            return this;
        }

        public Builder setBatchThreads(int batchThreads) {
            this.batchThreads = batchThreads;
            return this;
        }

        public Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
            this.maxHttpRequestRetries = maxHttpRequestRetries;
            return this;
        }

        public Builder setHttpRequestConnectTimeout(int httpRequestConnectTimeout) {
            this.httpRequestConnectTimeout = httpRequestConnectTimeout;
            return this;
        }

        public Builder setHttpRequestReadTimeout(int httpRequestReadTimeout) {
            this.httpRequestReadTimeout = httpRequestReadTimeout;
            return this;
        }

        public Builder setCreateMarkerObjects(boolean createMarkerObjects) {
            this.createMarkerObjects = createMarkerObjects;
            return this;
        }

        public Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
            this.transportType = transportType;
            return this;
        }

        public Builder setProxyAddress(String proxyAddress) {
            this.proxyAddress = proxyAddress;
            return this;
        }

        public Builder setWriteChannelOptionsBuilder(AsyncWriteChannelOptions.Builder builder) {
            this.writeChannelOptionsBuilder = builder;
            return this;
        }

        public AsyncWriteChannelOptions.Builder getWriteChannelOptionsBuilder() {
            return this.writeChannelOptionsBuilder;
        }

        public Builder setMaxWaitMillisForEmptyObjectCreation(int maxWaitMillisForEmptyObjectCreation) {
            this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
            return this;
        }

        public Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
            this.requesterPaysOptions = requesterPaysOptions;
            return this;
        }

        public Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
            this.copyWithRewriteEnabled = copyWithRewriteEnabled;
            return this;
        }

        public Builder setMaxBytesRewrittenPerCall(long maxBytesRewrittenPerCall) {
            this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
            return this;
        }

        public Builder setCopyMaxRequestsPerBatch(long copyMaxRequestsPerBatch) {
            this.copyMaxRequestsPerBatch = copyMaxRequestsPerBatch;
            return this;
        }

        public Builder setCopyBatchThreads(int copyBatchThreads) {
            this.copyBatchThreads = copyBatchThreads;
            return this;
        }

        public GoogleCloudStorageOptions build() {
            return new GoogleCloudStorageOptions(this);
        }
    }
}

